/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class Equalizer
extends AudioEffect {
    public static final int PARAM_BAND_FREQ_RANGE = 4;
    public static final int PARAM_BAND_LEVEL = 2;
    public static final int PARAM_CENTER_FREQ = 3;
    public static final int PARAM_CURRENT_PRESET = 6;
    public static final int PARAM_GET_BAND = 5;
    public static final int PARAM_GET_NUM_OF_PRESETS = 7;
    public static final int PARAM_GET_PRESET_NAME = 8;
    public static final int PARAM_LEVEL_RANGE = 1;
    public static final int PARAM_NUM_BANDS = 0;
    private static final int PARAM_PROPERTIES = 9;
    public static final int PARAM_STRING_SIZE_MAX = 32;
    private static final String TAG = "Equalizer";
    private BaseParameterListener mBaseParamListener = null;
    private short mNumBands = 0;
    private int mNumPresets;
    private OnParameterChangeListener mParamListener = null;
    private final Object mParamListenerLock = new Object();
    private String[] mPresetNames;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Equalizer(int n, int n2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_EQUALIZER, EFFECT_TYPE_NULL, n, n2);
        if (n2 == 0) {
            Log.w(TAG, "WARNING: attaching an Equalizer to global output mix is deprecated!");
        }
        this.getNumberOfBands();
        this.mNumPresets = this.getNumberOfPresets();
        if (this.mNumPresets != 0) {
            this.mPresetNames = new String[this.mNumPresets];
            byte[] byArray = new byte[32];
            int[] nArray = new int[2];
            nArray[0] = 8;
            for (int i = 0; i < this.mNumPresets; ++i) {
                nArray[1] = i;
                this.checkStatus(this.getParameter(nArray, byArray));
                int n3 = 0;
                while (byArray[n3] != 0) {
                    ++n3;
                }
                try {
                    this.mPresetNames[i] = new String(byArray, 0, n3, "ISO-8859-1");
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.e(TAG, "preset name decode error");
                }
            }
        }
    }

    public short getBand(int n) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[2];
        short[] sArray = new short[1];
        nArray[0] = 5;
        nArray[1] = n;
        this.checkStatus(this.getParameter(nArray, sArray));
        return sArray[0];
    }

    public int[] getBandFreqRange(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        nArray[0] = 4;
        nArray[1] = s;
        this.checkStatus(this.getParameter(nArray, nArray2));
        return nArray2;
    }

    public short getBandLevel(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[2];
        short[] sArray = new short[1];
        nArray[0] = 2;
        nArray[1] = s;
        this.checkStatus(this.getParameter(nArray, sArray));
        return sArray[0];
    }

    public short[] getBandLevelRange() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] sArray = new short[2];
        this.checkStatus(this.getParameter(1, sArray));
        return sArray;
    }

    public int getCenterFreq(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[2];
        int[] nArray2 = new int[1];
        nArray[0] = 3;
        nArray[1] = s;
        this.checkStatus(this.getParameter(nArray, nArray2));
        return nArray2[0];
    }

    public short getCurrentPreset() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] sArray = new short[1];
        this.checkStatus(this.getParameter(6, sArray));
        return sArray[0];
    }

    public short getNumberOfBands() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (this.mNumBands != 0) {
            return this.mNumBands;
        }
        int[] nArray = new int[]{0};
        short[] sArray = new short[1];
        this.checkStatus(this.getParameter(nArray, sArray));
        this.mNumBands = sArray[0];
        return this.mNumBands;
    }

    public short getNumberOfPresets() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] sArray = new short[1];
        this.checkStatus(this.getParameter(7, sArray));
        return sArray[0];
    }

    public String getPresetName(short s) {
        if (s >= 0 && s < this.mNumPresets) {
            return this.mPresetNames[s];
        }
        return "";
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] byArray = new byte[4 + 2 * this.mNumBands];
        this.checkStatus(this.getParameter(9, byArray));
        Settings settings = new Settings();
        settings.curPreset = Equalizer.byteArrayToShort(byArray, 0);
        settings.numBands = Equalizer.byteArrayToShort(byArray, 2);
        settings.bandLevels = new short[this.mNumBands];
        for (int i = 0; i < this.mNumBands; ++i) {
            settings.bandLevels[i] = Equalizer.byteArrayToShort(byArray, 4 + i * 2);
        }
        return settings;
    }

    public void setBandLevel(short s, short s2) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int[] nArray = new int[2];
        short[] sArray = new short[1];
        nArray[0] = 2;
        nArray[1] = s;
        sArray[0] = s2;
        this.checkStatus(this.setParameter(nArray, sArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mParamListener = onParameterChangeListener;
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
            return;
        }
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (settings.numBands != settings.bandLevels.length || settings.numBands != this.mNumBands) {
            throw new IllegalArgumentException("settings invalid band count: " + settings.numBands);
        }
        byte[][] byArrayArray = new byte[][]{Equalizer.shortToByteArray(settings.curPreset), Equalizer.shortToByteArray(this.mNumBands)};
        byte[] byArray = Equalizer.concatArrays(byArrayArray);
        for (int i = 0; i < this.mNumBands; ++i) {
            byte[][] byArrayArray2 = new byte[][]{byArray, Equalizer.shortToByteArray(settings.bandLevels[i])};
            byArray = Equalizer.concatArrays(byArrayArray2);
        }
        this.checkStatus(this.setParameter(9, byArray));
    }

    public void usePreset(short s) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(6, s));
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onParameterChange(AudioEffect audioEffect, int n, byte[] byArray, byte[] byArray2) {
            Object object = Equalizer.this.mParamListenerLock;
            // MONITORENTER : object
            OnParameterChangeListener onParameterChangeListener = Equalizer.this.mParamListener;
            OnParameterChangeListener onParameterChangeListener2 = null;
            if (onParameterChangeListener != null) {
                onParameterChangeListener2 = Equalizer.this.mParamListener;
            }
            // MONITOREXIT : object
            if (onParameterChangeListener2 == null) return;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            if (byArray.length >= 4) {
                n2 = AudioEffect.byteArrayToInt(byArray, 0);
                if (byArray.length >= 8) {
                    n3 = AudioEffect.byteArrayToInt(byArray, 4);
                }
            }
            if (byArray2.length == 2) {
                n4 = AudioEffect.byteArrayToShort(byArray2, 0);
            } else if (byArray2.length == 4) {
                n4 = AudioEffect.byteArrayToInt(byArray2, 0);
            }
            if (n2 == -1) return;
            if (n4 == -1) return;
            onParameterChangeListener2.onParameterChange(Equalizer.this, n, n2, n3, n4);
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(Equalizer var1, int var2, int var3, int var4, int var5);
    }

    public static class Settings {
        public short[] bandLevels = null;
        public short curPreset;
        public short numBands = 0;

        public Settings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Settings(String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=;");
            stringTokenizer.countTokens();
            if (stringTokenizer.countTokens() < 5) {
                throw new IllegalArgumentException("settings: " + string2);
            }
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(Equalizer.TAG)) {
                throw new IllegalArgumentException("invalid settings for Equalizer: " + string3);
            }
            try {
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("curPreset")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid value for key: " + string3);
            }
            {
                this.curPreset = Short.parseShort(stringTokenizer.nextToken());
                string3 = stringTokenizer.nextToken();
                if (!string3.equals("numBands")) {
                    throw new IllegalArgumentException("invalid key name: " + string3);
                }
                this.numBands = Short.parseShort(stringTokenizer.nextToken());
                if (stringTokenizer.countTokens() != 2 * this.numBands) {
                    throw new IllegalArgumentException("settings: " + string2);
                }
                this.bandLevels = new short[this.numBands];
                int n = 0;
                while (n < this.numBands) {
                    string3 = stringTokenizer.nextToken();
                    if (!string3.equals("band" + (n + 1) + "Level")) {
                        throw new IllegalArgumentException("invalid key name: " + string3);
                    }
                    this.bandLevels[n] = Short.parseShort(stringTokenizer.nextToken());
                    ++n;
                }
                return;
            }
        }

        public String toString() {
            String string2 = new String("Equalizer;curPreset=" + Short.toString(this.curPreset) + ";numBands=" + Short.toString(this.numBands));
            for (int i = 0; i < this.numBands; ++i) {
                string2 = string2.concat(";band" + (i + 1) + "Level=" + Short.toString(this.bandLevels[i]));
            }
            return string2;
        }
    }
}

