/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.util.Log;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

class Utils {
    private static final String TAG = "Utils";

    Utils() {
    }

    static Range<Integer> alignRange(Range<Integer> range, int n) {
        return range.intersect(n * Utils.divUp(range.getLower(), n), n * (range.getUpper() / n));
    }

    public static <T extends Comparable<? super T>> int binarySearchDistinctRanges(Range<T>[] rangeArray, T t) {
        return Arrays.binarySearch(rangeArray, Range.create(t, t), new Comparator<Range<T>>(){

            @Override
            public int compare(Range<T> range, Range<T> range2) {
                if (range.getUpper().compareTo(range2.getLower()) < 0) {
                    return -1;
                }
                if (range.getLower().compareTo(range2.getUpper()) > 0) {
                    return 1;
                }
                return 0;
            }
        });
    }

    static int divUp(int n, int n2) {
        return (-1 + (n + n2)) / n2;
    }

    private static long divUp(long l, long l2) {
        return (l + l2 - 1L) / l2;
    }

    static Range<Integer> factorRange(Range<Integer> range, int n) {
        if (n == 1) {
            return range;
        }
        return Range.create(Utils.divUp(range.getLower(), n), range.getUpper() / n);
    }

    static Range<Long> factorRange(Range<Long> range, long l) {
        if (l == 1L) {
            return range;
        }
        return Range.create(Utils.divUp(range.getLower(), l), range.getUpper() / l);
    }

    static int gcd(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return 1;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n < 0) {
            n = -n;
        }
        while (n != 0) {
            int n3 = n2 % n;
            n2 = n;
            n = n3;
        }
        return n2;
    }

    static Range<Integer> intRangeFor(double d) {
        return Range.create((int)d, (int)Math.ceil(d));
    }

    public static <T extends Comparable<? super T>> Range<T>[] intersectSortedDistinctRanges(Range<T>[] rangeArray, Range<T>[] rangeArray2) {
        int n = 0;
        Vector<Range<T>> vector = new Vector<Range<T>>();
        int n2 = rangeArray2.length;
        int n3 = 0;
        while (true) {
            Range<T> range;
            block8: {
                block7: {
                    if (n3 >= n2) break block7;
                    range = rangeArray2[n3];
                    while (n < rangeArray.length && rangeArray[n].getUpper().compareTo(range.getLower()) < 0) {
                        ++n;
                    }
                    while (n < rangeArray.length && rangeArray[n].getUpper().compareTo(range.getUpper()) < 0) {
                        vector.add(range.intersect(rangeArray[n]));
                        ++n;
                    }
                    if (n != rangeArray.length) break block8;
                }
                return vector.toArray(new Range[vector.size()]);
            }
            if (rangeArray[n].getLower().compareTo(range.getUpper()) <= 0) {
                vector.add(range.intersect(rangeArray[n]));
            }
            ++n3;
        }
    }

    private static long lcm(int n, int n2) {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("lce is not defined for zero arguments");
        }
        return (long)n * (long)n2 / (long)Utils.gcd(n, n2);
    }

    static Range<Long> longRangeFor(double d) {
        return Range.create((long)d, (long)Math.ceil(d));
    }

    /*
     * Unable to fully structure code
     */
    static Range<Integer> parseIntRange(Object var0, Range<Integer> var1_1) {
        var7_2 = (String)var0;
        var8_3 = var7_2.indexOf(45);
        if (var8_3 < 0) ** GOTO lbl7
        try {
            return Range.create(Integer.parseInt(var7_2.substring(0, var8_3), 10), Integer.parseInt(var7_2.substring(var8_3 + 1), 10));
lbl7:
            // 1 sources

            var9_4 = Integer.parseInt(var7_2);
            var10_5 = Range.create(var9_4, var9_4);
            return var10_5;
        }
        catch (NullPointerException var6_6) {
            return var1_1;
        }
        catch (IllegalArgumentException var5_7) lbl-1000:
        // 3 sources

        {
            while (true) {
                Log.w("Utils", "could not parse integer range '" + var0 + "'");
                return var1_1;
            }
        }
        catch (NumberFormatException var4_8) {
            ** GOTO lbl-1000
        }
        catch (ClassCastException var2_9) {
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    static int parseIntSafely(Object var0, int var1_1) {
        try {
            var6_2 = Integer.parseInt((String)var0);
            return var6_2;
        }
        catch (NullPointerException var5_3) {
            return var1_1;
        }
        catch (NumberFormatException var4_4) lbl-1000:
        // 2 sources

        {
            while (true) {
                Log.w("Utils", "could not parse integer '" + var0 + "'");
                return var1_1;
            }
        }
        catch (ClassCastException var2_5) {
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    static Range<Long> parseLongRange(Object var0, Range<Long> var1_1) {
        var7_2 = (String)var0;
        var8_3 = var7_2.indexOf(45);
        if (var8_3 < 0) ** GOTO lbl7
        try {
            return Range.create(Long.parseLong(var7_2.substring(0, var8_3), 10), Long.parseLong(var7_2.substring(var8_3 + 1), 10));
lbl7:
            // 1 sources

            var9_4 = Long.parseLong(var7_2);
            var11_5 = Range.create(var9_4, var9_4);
            return var11_5;
        }
        catch (NullPointerException var6_6) {
            return var1_1;
        }
        catch (IllegalArgumentException var5_7) lbl-1000:
        // 3 sources

        {
            while (true) {
                Log.w("Utils", "could not parse long range '" + var0 + "'");
                return var1_1;
            }
        }
        catch (NumberFormatException var4_8) {
            ** GOTO lbl-1000
        }
        catch (ClassCastException var2_9) {
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    static Range<Rational> parseRationalRange(Object var0, Range<Rational> var1_1) {
        var7_2 = (String)var0;
        var8_3 = var7_2.indexOf(45);
        if (var8_3 < 0) ** GOTO lbl7
        try {
            return Range.create(Rational.parseRational(var7_2.substring(0, var8_3)), Rational.parseRational(var7_2.substring(var8_3 + 1)));
lbl7:
            // 1 sources

            var9_4 = Rational.parseRational(var7_2);
            var10_5 = Range.create(var9_4, var9_4);
            return var10_5;
        }
        catch (NullPointerException var6_6) {
            return var1_1;
        }
        catch (IllegalArgumentException var5_7) lbl-1000:
        // 3 sources

        {
            while (true) {
                Log.w("Utils", "could not parse rational range '" + var0 + "'");
                return var1_1;
            }
        }
        catch (NumberFormatException var4_8) {
            ** GOTO lbl-1000
        }
        catch (ClassCastException var2_9) {
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    static Size parseSize(Object var0, Size var1_1) {
        try {
            var6_2 = Size.parseSize((String)var0);
            return var6_2;
        }
        catch (NullPointerException var5_3) {
            return var1_1;
        }
        catch (NumberFormatException var4_4) lbl-1000:
        // 2 sources

        {
            while (true) {
                Log.w("Utils", "could not parse size '" + var0 + "'");
                return var1_1;
            }
        }
        catch (ClassCastException var2_5) {
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    static Pair<Size, Size> parseSizeRange(Object var0) {
        var6_1 = (String)var0;
        var7_2 = var6_1.indexOf(45);
        if (var7_2 < 0) ** GOTO lbl7
        try {
            return Pair.create(Size.parseSize(var6_1.substring(0, var7_2)), Size.parseSize(var6_1.substring(var7_2 + 1)));
lbl7:
            // 1 sources

            var8_3 = Size.parseSize(var6_1);
            var9_4 = Pair.create(var8_3, var8_3);
            return var9_4;
        }
        catch (NullPointerException var5_5) {
            return null;
        }
        catch (IllegalArgumentException var4_6) lbl-1000:
        // 3 sources

        {
            while (true) {
                Log.w("Utils", "could not parse size range '" + var0 + "'");
                return null;
            }
        }
        catch (NumberFormatException var3_7) {
            ** GOTO lbl-1000
        }
        catch (ClassCastException var1_8) {
            ** continue;
        }
    }

    static Range<Rational> scaleRange(Range<Rational> range, int n, int n2) {
        if (n == n2) {
            return range;
        }
        return Range.create(Utils.scaleRatio(range.getLower(), n, n2), Utils.scaleRatio(range.getUpper(), n, n2));
    }

    private static Rational scaleRatio(Rational rational, int n, int n2) {
        int n3 = Utils.gcd(n, n2);
        int n4 = n / n3;
        int n5 = n2 / n3;
        return new Rational((int)((double)rational.getNumerator() * (double)n4), (int)((double)rational.getDenominator() * (double)n5));
    }

    public static <T extends Comparable<? super T>> void sortDistinctRanges(Range<T>[] rangeArray) {
        Arrays.sort(rangeArray, new Comparator<Range<T>>(){

            @Override
            public int compare(Range<T> range, Range<T> range2) {
                if (range.getUpper().compareTo(range2.getLower()) < 0) {
                    return -1;
                }
                if (range.getLower().compareTo(range2.getUpper()) > 0) {
                    return 1;
                }
                throw new IllegalArgumentException("sample rate ranges must be distinct (" + range + " and " + range2 + ")");
            }
        });
    }
}

