/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.media.MediaFile;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.FileInputStream;
import java.io.IOException;

public class ThumbnailUtils {
    private static final int MAX_NUM_PIXELS_MICRO_THUMBNAIL = 19200;
    private static final int MAX_NUM_PIXELS_THUMBNAIL = 196608;
    private static final int OPTIONS_NONE = 0;
    public static final int OPTIONS_RECYCLE_INPUT = 2;
    private static final int OPTIONS_SCALE_UP = 1;
    private static final String TAG = "ThumbnailUtils";
    public static final int TARGET_SIZE_MICRO_THUMBNAIL = 96;
    public static final int TARGET_SIZE_MINI_THUMBNAIL = 320;
    private static final int UNCONSTRAINED = -1;

    private static void closeSilently(ParcelFileDescriptor parcelFileDescriptor) {
        if (parcelFileDescriptor == null) {
            return;
        }
        try {
            parcelFileDescriptor.close();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int computeInitialSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3;
        block5: {
            int n4;
            block4: {
                double d = options.outWidth;
                double d2 = options.outHeight;
                n3 = n == -1 ? 128 : (int)Math.min(Math.floor(d / (double)n), Math.floor(d2 / (double)n));
                if (n3 < (n4 = n2 == -1 ? 1 : (int)Math.ceil(Math.sqrt(d * d2 / (double)n2)))) break block4;
                if (n2 == -1 && n == -1) {
                    return 1;
                }
                if (n != -1) break block5;
            }
            return n4;
        }
        return n3;
    }

    private static int computeSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3;
        int n4 = ThumbnailUtils.computeInitialSampleSize(options, n, n2);
        if (n4 <= 8) {
            for (n3 = 1; n3 < n4; n3 <<= 1) {
            }
        } else {
            n3 = 8 * ((n4 + 7) / 8);
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    public static Bitmap createImageThumbnail(String var0, int var1_1) {
        block33: {
            block34: {
                block36: {
                    block38: {
                        block37: {
                            if (var1_1 != 1) break block37;
                            var2_2 = true;
lbl3:
                            // 2 sources

                            while (var2_2) {
                                var3_3 = 320;
lbl5:
                                // 2 sources

                                while (var2_2) {
                                    var4_4 = 196608;
lbl7:
                                    // 2 sources

                                    while (true) {
                                        block35: {
                                            var5_5 = new SizedThumbnailBitmap();
                                            var6_6 = MediaFile.getFileType(var0);
                                            var7_7 = null;
                                            if (var6_6 != null) {
                                                var30_8 = var6_6.fileType;
                                                var7_7 = null;
                                                if (var30_8 == 31) {
                                                    ThumbnailUtils.createThumbnailFromEXIF(var0, var3_3, var4_4, var5_5);
                                                    var7_7 = var5_5.mBitmap;
                                                }
                                            }
                                            if (var7_7 != null) break block33;
                                            var8_9 = null;
                                            var9_10 = new FileInputStream(var0);
                                            var21_11 = var9_10.getFD();
                                            var22_12 = new BitmapFactory.Options();
                                            var22_12.inSampleSize = 1;
                                            var22_12.inJustDecodeBounds = true;
                                            BitmapFactory.decodeFileDescriptor(var21_11, null, var22_12);
                                            if (!var22_12.mCancel && var22_12.outWidth != -1 && (var26_13 = var22_12.outHeight) != -1) break block34;
                                            if (var9_10 == null) break block35;
                                            var9_10.close();
                                        }
                                        return null;
                                    }
                                }
                                break block36;
                            }
                            break block38;
                        }
                        var2_2 = false;
                        ** GOTO lbl3
                    }
                    var3_3 = 96;
                    ** GOTO lbl5
                }
                var4_4 = 19200;
                ** while (true)
                catch (IOException var24_14) {
                    Log.e("ThumbnailUtils", "", var24_14);
                    return null;
                }
            }
            var22_12.inSampleSize = ThumbnailUtils.computeSampleSize(var22_12, var3_3, var4_4);
            var22_12.inJustDecodeBounds = false;
            var22_12.inDither = false;
            var22_12.inPreferredConfig = Bitmap.Config.ARGB_8888;
            var7_7 = var27_15 = BitmapFactory.decodeFileDescriptor(var21_11, null, var22_12);
            if (var9_10 == null) break block33;
            try {
                var9_10.close();
            }
            catch (IOException var28_16) {
                Log.e("ThumbnailUtils", "", var28_16);
                ** GOTO lbl60
            }
        }
lbl60:
        // 7 sources

        while (true) {
            if (var1_1 == 3) {
                var7_7 = ThumbnailUtils.extractThumbnail(var7_7, 96, 96, 2);
            }
            return var7_7;
        }
        catch (IOException var10_17) lbl-1000:
        // 2 sources

        {
            while (true) {
                Log.e("ThumbnailUtils", "", (Throwable)var10_18);
                if (var8_9 == null) ** GOTO lbl60
                try {
                    var8_9.close();
                }
                catch (IOException var15_20) {
                    Log.e("ThumbnailUtils", "", var15_20);
                }
                ** GOTO lbl60
                break;
            }
        }
        catch (OutOfMemoryError var17_21) lbl-1000:
        // 2 sources

        {
            while (true) {
                Log.e("ThumbnailUtils", "Unable to decode file " + var0 + ". OutOfMemoryError.", (Throwable)var17_22);
                if (var8_9 == null) ** GOTO lbl60
                {
                    catch (Throwable var11_25) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var8_9 != null) {
                                var8_9.close();
                            }
lbl92:
                            // 4 sources

                            throw var11_26;
                            catch (IOException var12_28) {
                                Log.e("ThumbnailUtils", "", var12_28);
                                ** continue;
                            }
                            break;
                        }
                    }
                }
                try {
                    var8_9.close();
                }
                catch (IOException var19_24) {
                    Log.e("ThumbnailUtils", "", var19_24);
                }
                ** continue;
                break;
            }
        }
        catch (Throwable var11_27) {
            var8_9 = var9_10;
            ** continue;
        }
        catch (OutOfMemoryError var17_23) {
            var8_9 = var9_10;
            ** continue;
        }
        catch (IOException var10_19) {
            var8_9 = var9_10;
            ** continue;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createThumbnailFromEXIF(String string2, int n, int n2, SizedThumbnailBitmap sizedThumbnailBitmap) {
        BitmapFactory.Options options;
        block10: {
            int n3;
            int n4;
            byte[] byArray;
            block11: {
                block9: {
                    block8: {
                        ExifInterface exifInterface;
                        if (string2 == null) break block9;
                        try {
                            exifInterface = new ExifInterface(string2);
                        }
                        catch (IOException iOException) {}
                        try {
                            byte[] byArray2;
                            byArray = byArray2 = exifInterface.getThumbnail();
                            break block8;
                        }
                        catch (IOException iOException) {}
                        {
                            void var5_14;
                            Log.w(TAG, (Throwable)var5_14);
                            byArray = null;
                        }
                    }
                    options = new BitmapFactory.Options();
                    BitmapFactory.Options options2 = new BitmapFactory.Options();
                    int n5 = 0;
                    if (byArray != null) {
                        options2.inJustDecodeBounds = true;
                        BitmapFactory.decodeByteArray(byArray, 0, byArray.length, options2);
                        options2.inSampleSize = ThumbnailUtils.computeSampleSize(options2, n, n2);
                        n5 = options2.outWidth / options2.inSampleSize;
                    }
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeFile(string2, options);
                    options.inSampleSize = ThumbnailUtils.computeSampleSize(options, n, n2);
                    int n6 = options.outWidth / options.inSampleSize;
                    if (byArray == null || n5 < n6) break block10;
                    n4 = options2.outWidth;
                    n3 = options2.outHeight;
                    options2.inJustDecodeBounds = false;
                    sizedThumbnailBitmap.mBitmap = BitmapFactory.decodeByteArray(byArray, 0, byArray.length, options2);
                    if (sizedThumbnailBitmap.mBitmap != null) break block11;
                }
                return;
            }
            sizedThumbnailBitmap.mThumbnailData = byArray;
            sizedThumbnailBitmap.mThumbnailWidth = n4;
            sizedThumbnailBitmap.mThumbnailHeight = n3;
            return;
        }
        options.inJustDecodeBounds = false;
        sizedThumbnailBitmap.mBitmap = BitmapFactory.decodeFile(string2, options);
    }

    /*
     * Unable to fully structure code
     */
    public static Bitmap createVideoThumbnail(String var0, int var1_1) {
        block18: {
            var2_2 = new MediaMetadataRetriever();
            var2_2.setDataSource(var0);
            var7_4 = var14_3 = var2_2.getFrameAtTime(-1L);
            try {
                var2_2.release();
            }
            catch (RuntimeException var15_14) {
                ** continue;
            }
lbl7:
            // 6 sources

            while (true) {
                if (var7_4 == null) {
                    return null;
                }
                break block18;
                break;
            }
            catch (IllegalArgumentException var12_5) {
                try {
                    var2_2.release();
                    var7_4 = null;
                }
                catch (RuntimeException var13_6) {
                    var7_4 = null;
                }
            }
            catch (RuntimeException var5_7) {
                try {
                    var2_2.release();
                    var7_4 = null;
                }
                catch (RuntimeException var6_8) {
                    var7_4 = null;
                }
            }
            catch (Throwable var3_9) {
                var2_2.release();
lbl30:
                // 2 sources

                throw var3_9;
            }
        }
        if (var1_1 == 1) {
            var8_10 = var7_4.getWidth();
            var10_12 = Math.max(var8_10, var9_11 = var7_4.getHeight());
            if (var10_12 > 512) {
                var11_13 = 512.0f / (float)var10_12;
                var7_4 = Bitmap.createScaledBitmap(var7_4, Math.round(var11_13 * (float)var8_10), Math.round(var11_13 * (float)var9_11), true);
            }
lbl39:
            // 5 sources

            return var7_4;
        }
        if (var1_1 != 3) ** GOTO lbl39
        var7_4 = ThumbnailUtils.extractThumbnail(var7_4, 96, 96, 2);
        ** while (true)
        {
            catch (RuntimeException var4_15) {
                ** continue;
            }
        }
    }

    public static Bitmap extractThumbnail(Bitmap bitmap, int n, int n2) {
        return ThumbnailUtils.extractThumbnail(bitmap, n, n2, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap extractThumbnail(Bitmap bitmap, int n, int n2, int n3) {
        if (bitmap == null) {
            return null;
        }
        float f = bitmap.getWidth() < bitmap.getHeight() ? (float)n / (float)bitmap.getWidth() : (float)n2 / (float)bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.setScale(f, f);
        return ThumbnailUtils.transform(matrix, bitmap, n, n2, n3 | 1);
    }

    /*
     * Unable to fully structure code
     */
    private static Bitmap makeBitmap(int var0, int var1_1, Uri var2_2, ContentResolver var3_3, ParcelFileDescriptor var4_4, BitmapFactory.Options var5_5) {
        block9: {
            if (var4_4 == null) {
                var4_4 = var13_6 = ThumbnailUtils.makeInputStream(var2_2, var3_3);
            }
            if (var4_4 == null) {
                ThumbnailUtils.closeSilently(var4_4);
                return null;
            }
            if (var5_5 != null) ** GOTO lbl10
            var5_5 = new BitmapFactory.Options();
lbl10:
            // 2 sources

            var9_7 = var4_4.getFileDescriptor();
            var5_5.inSampleSize = 1;
            var5_5.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor(var9_7, null, var5_5);
            if (!var5_5.mCancel && var5_5.outWidth != -1 && (var11_8 = var5_5.outHeight) != -1) break block9;
            ThumbnailUtils.closeSilently(var4_4);
            return null;
        }
        try {
            var5_5.inSampleSize = ThumbnailUtils.computeSampleSize(var5_5, var0, var1_1);
            var5_5.inJustDecodeBounds = false;
            var5_5.inDither = false;
            var5_5.inPreferredConfig = Bitmap.Config.ARGB_8888;
            var12_9 = BitmapFactory.decodeFileDescriptor(var9_7, null, var5_5);
        }
        catch (OutOfMemoryError var7_10) {
            Log.e("ThumbnailUtils", "Got oom exception ", var7_10);
            return null;
        }
        finally {
            ThumbnailUtils.closeSilently(var4_4);
        }
        ThumbnailUtils.closeSilently(var4_4);
        return var12_9;
    }

    private static ParcelFileDescriptor makeInputStream(Uri uri, ContentResolver contentResolver) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(uri, "r");
            return parcelFileDescriptor;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Bitmap transform(Matrix matrix, Bitmap bitmap, int n, int n2, int n3) {
        int n4;
        int n5;
        float f;
        Bitmap bitmap2;
        boolean bl = (n3 & 1) != 0;
        boolean bl2 = (n3 & 2) != 0;
        int n6 = bitmap.getWidth() - n;
        int n7 = bitmap.getHeight() - n2;
        if (!(bl || n6 >= 0 && n7 >= 0)) {
            bitmap2 = Bitmap.createBitmap(n, n2, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap2);
            int n8 = Math.max(0, n6 / 2);
            int n9 = Math.max(0, n7 / 2);
            Rect rect = new Rect(n8, n9, n8 + Math.min(n, bitmap.getWidth()), n9 + Math.min(n2, bitmap.getHeight()));
            int n10 = (n - rect.width()) / 2;
            int n11 = (n2 - rect.height()) / 2;
            Rect rect2 = new Rect(n10, n11, n - n10, n2 - n11);
            canvas.drawBitmap(bitmap, rect, rect2, null);
            if (bl2) {
                bitmap.recycle();
            }
            canvas.setBitmap(null);
            return bitmap2;
        }
        float f2 = bitmap.getWidth();
        if (f2 / (f = (float)bitmap.getHeight()) > (float)n / (float)n2) {
            float f3 = (float)n2 / f;
            if (f3 < 0.9f || f3 > 1.0f) {
                matrix.setScale(f3, f3);
            } else {
                matrix = null;
            }
        } else {
            float f4 = (float)n / f2;
            if (f4 < 0.9f || f4 > 1.0f) {
                matrix.setScale(f4, f4);
            } else {
                matrix = null;
            }
        }
        Bitmap bitmap3 = matrix != null ? Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix, true) : bitmap;
        if (bl2 && bitmap3 != bitmap) {
            bitmap.recycle();
        }
        if ((bitmap2 = Bitmap.createBitmap(bitmap3, (n5 = Math.max(0, bitmap3.getWidth() - n)) / 2, (n4 = Math.max(0, bitmap3.getHeight() - n2)) / 2, n, n2)) == bitmap3 || !bl2 && bitmap3 == bitmap) return bitmap2;
        bitmap3.recycle();
        return bitmap2;
    }

    private static class SizedThumbnailBitmap {
        public Bitmap mBitmap;
        public byte[] mThumbnailData;
        public int mThumbnailHeight;
        public int mThumbnailWidth;

        private SizedThumbnailBitmap() {
        }
    }
}

