/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.SubtitleTrack;
import android.media.TextTrackCueSpan;
import android.media.TextTrackRegion;
import android.media.WebVttParser;
import java.util.Arrays;

class TextTrackCue
extends SubtitleTrack.Cue {
    static final int ALIGNMENT_END = 202;
    static final int ALIGNMENT_LEFT = 203;
    static final int ALIGNMENT_MIDDLE = 200;
    static final int ALIGNMENT_RIGHT = 204;
    static final int ALIGNMENT_START = 201;
    private static final String TAG = "TTCue";
    static final int WRITING_DIRECTION_HORIZONTAL = 100;
    static final int WRITING_DIRECTION_VERTICAL_LR = 102;
    static final int WRITING_DIRECTION_VERTICAL_RL = 101;
    int mAlignment = 200;
    boolean mAutoLinePosition;
    String mId = "";
    Integer mLinePosition = null;
    TextTrackCueSpan[][] mLines = null;
    boolean mPauseOnExit = false;
    TextTrackRegion mRegion = null;
    String mRegionId = "";
    int mSize = 100;
    boolean mSnapToLines = true;
    String[] mStrings;
    int mTextPosition = 50;
    int mWritingDirection = 100;

    TextTrackCue() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public StringBuilder appendLinesToBuilder(StringBuilder stringBuilder) {
        if (this.mLines == null) {
            stringBuilder.append("null");
            return stringBuilder;
        }
        stringBuilder.append("[");
        boolean bl = true;
        TextTrackCueSpan[][] textTrackCueSpanArray = this.mLines;
        int n = textTrackCueSpanArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                stringBuilder.append("]");
                return stringBuilder;
            }
            TextTrackCueSpan[] textTrackCueSpanArray2 = textTrackCueSpanArray[n2];
            if (!bl) {
                stringBuilder.append(", ");
            }
            if (textTrackCueSpanArray2 == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("\"");
                boolean bl2 = true;
                long l = -1L;
                for (TextTrackCueSpan textTrackCueSpan : textTrackCueSpanArray2) {
                    if (!bl2) {
                        stringBuilder.append(" ");
                    }
                    if (textTrackCueSpan.mTimestampMs != l) {
                        stringBuilder.append("<").append(WebVttParser.timeToString(textTrackCueSpan.mTimestampMs)).append(">");
                        l = textTrackCueSpan.mTimestampMs;
                    }
                    stringBuilder.append(textTrackCueSpan.mText);
                    bl2 = false;
                }
                stringBuilder.append("\"");
            }
            ++n2;
            bl = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public StringBuilder appendStringsToBuilder(StringBuilder stringBuilder) {
        if (this.mStrings == null) {
            stringBuilder.append("null");
            return stringBuilder;
        }
        stringBuilder.append("[");
        boolean bl = true;
        String[] stringArray = this.mStrings;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                stringBuilder.append("]");
                return stringBuilder;
            }
            String string2 = stringArray[n2];
            if (!bl) {
                stringBuilder.append(", ");
            }
            if (string2 == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("\"");
                stringBuilder.append(string2);
                stringBuilder.append("\"");
            }
            ++n2;
            bl = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        boolean bl;
        TextTrackCue textTrackCue;
        if (!(object instanceof TextTrackCue)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        try {
            textTrackCue = (TextTrackCue)object;
            if (!this.mId.equals(textTrackCue.mId)) return false;
            if (this.mPauseOnExit != textTrackCue.mPauseOnExit) return false;
            if (this.mWritingDirection != textTrackCue.mWritingDirection) return false;
            if (!this.mRegionId.equals(textTrackCue.mRegionId)) return false;
            if (this.mSnapToLines != textTrackCue.mSnapToLines) return false;
            if (this.mAutoLinePosition != textTrackCue.mAutoLinePosition) return false;
            if (!this.mAutoLinePosition) {
                if (this.mLinePosition != textTrackCue.mLinePosition) return false;
            }
            if (this.mTextPosition != textTrackCue.mTextPosition) return false;
            if (this.mSize != textTrackCue.mSize) return false;
            if (this.mAlignment != textTrackCue.mAlignment) return false;
            if (this.mLines.length != textTrackCue.mLines.length) return false;
            bl = true;
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            return false;
        }
        if (!bl) return bl;
        int n = 0;
        while (n < this.mLines.length) {
            boolean bl2 = Arrays.equals(this.mLines[n], textTrackCue.mLines[n]);
            if (!bl2) {
                return false;
            }
            ++n;
        }
        return bl;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onTime(long l) {
        TextTrackCueSpan[][] textTrackCueSpanArray = this.mLines;
        int n = textTrackCueSpanArray.length;
        int n2 = 0;
        while (n2 < n) {
            for (TextTrackCueSpan textTrackCueSpan : textTrackCueSpanArray[n2]) {
                boolean bl = l >= textTrackCueSpan.mTimestampMs;
                textTrackCueSpan.mEnabled = bl;
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append(WebVttParser.timeToString(this.mStartTimeMs)).append(" --> ").append(WebVttParser.timeToString(this.mEndTimeMs)).append(" {id:\"").append(this.mId).append("\", pauseOnExit:").append(this.mPauseOnExit).append(", direction:");
        String string2 = this.mWritingDirection == 100 ? "horizontal" : (this.mWritingDirection == 102 ? "vertical_lr" : (this.mWritingDirection == 101 ? "vertical_rl" : "INVALID"));
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(", regionId:\"").append(this.mRegionId).append("\", snapToLines:").append(this.mSnapToLines).append(", linePosition:");
        Object object = this.mAutoLinePosition ? "auto" : this.mLinePosition;
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", textPosition:").append(this.mTextPosition).append(", size:").append(this.mSize).append(", alignment:");
        String string3 = this.mAlignment == 202 ? "end" : (this.mAlignment == 203 ? "left" : (this.mAlignment == 200 ? "middle" : (this.mAlignment == 204 ? "right" : (this.mAlignment == 201 ? "start" : "INVALID"))));
        stringBuilder4.append(string3).append(", text:");
        this.appendStringsToBuilder(stringBuilder).append("}");
        return stringBuilder.toString();
    }
}

