/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.database.MergeCursor;
import android.media.Ringtone;
import android.net.Uri;
import android.os.Environment;
import android.os.SystemProperties;
import android.os.storage.StorageManager;
import android.provider.MediaStore;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.database.SortCursor;
import java.util.ArrayList;
import java.util.List;

public class RingtoneManager {
    public static final String ACTION_EXTERNAL_AUDIO_PICKER = "asus.intent.action.AUDIO_PICKER";
    public static final String ACTION_RINGTONE_PICKER = "android.intent.action.RINGTONE_PICKER";
    public static final String EXTRA_RINGTONE_DEFAULT_URI = "android.intent.extra.ringtone.DEFAULT_URI";
    public static final String EXTRA_RINGTONE_EXISTING_URI = "android.intent.extra.ringtone.EXISTING_URI";
    @Deprecated
    public static final String EXTRA_RINGTONE_INCLUDE_DRM = "android.intent.extra.ringtone.INCLUDE_DRM";
    public static final String EXTRA_RINGTONE_PICKED_URI = "android.intent.extra.ringtone.PICKED_URI";
    public static final String EXTRA_RINGTONE_SHOW_DEFAULT = "android.intent.extra.ringtone.SHOW_DEFAULT";
    public static final String EXTRA_RINGTONE_SHOW_SILENT = "android.intent.extra.ringtone.SHOW_SILENT";
    public static final String EXTRA_RINGTONE_TITLE = "android.intent.extra.ringtone.TITLE";
    public static final String EXTRA_RINGTONE_TYPE = "android.intent.extra.ringtone.TYPE";
    public static final int ID_COLUMN_INDEX = 0;
    private static final String[] INTERNAL_COLUMNS;
    private static final String[] MEDIA_COLUMNS;
    private static final String TAG = "RingtoneManager";
    public static final int TITLE_COLUMN_INDEX = 1;
    public static final int TYPE_ALARM = 4;
    public static final int TYPE_ALL = 7;
    public static final int TYPE_CALENDARALERT = 128;
    public static final int TYPE_EXTERNALMUSIC = 8;
    public static final int TYPE_NEWMAIL = 32;
    public static final int TYPE_NOTIFICATION = 2;
    public static final int TYPE_NOTIFICATION_2 = 512;
    public static final int TYPE_RINGTONE = 1;
    public static final int TYPE_RINGTONE_2 = 256;
    public static final int TYPE_SENTMAIL = 64;
    public static final int URI_COLUMN_INDEX = 2;
    private Activity mActivity;
    private Context mContext;
    private Cursor mCursor;
    private final List<String> mFilterColumns = new ArrayList<String>();
    private Ringtone mPreviousRingtone;
    private boolean mStopPreviousRingtone = true;
    private int mType = 1;

    static {
        String[] stringArray = new String[]{"_id", "title", "\"" + MediaStore.Audio.Media.INTERNAL_CONTENT_URI + "\"", "title_key"};
        INTERNAL_COLUMNS = stringArray;
        String[] stringArray2 = new String[]{"_id", "title", "\"" + MediaStore.Audio.Media.EXTERNAL_CONTENT_URI + "\"", "title_key"};
        MEDIA_COLUMNS = stringArray2;
    }

    public RingtoneManager(Activity activity) {
        this.mActivity = activity;
        this.mContext = activity;
        this.setType(this.mType);
    }

    public RingtoneManager(Context context) {
        this.mContext = context;
        this.setType(this.mType);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String addDefaultSystemSoundIntoDB(Context context, int n) {
        Cursor cursor;
        String string2 = "";
        String string3 = "";
        if ((n & 1) != 0) {
            String string4 = "/system/media/audio/" + "ringtones/";
            string2 = string4 + SystemProperties.get("ro.config." + "ringtone");
            string3 = "ringtone";
        } else {
            if ((n & 2) != 0) {
                String string5 = "/system/media/audio/" + "notifications/";
                String cfr_ignored_0 = string5 + SystemProperties.get("ro.config." + "notification_sound");
                return null;
            }
            if ((n & 4) != 0) {
                String string6 = "/system/media/audio/" + "alarms/";
                string2 = string6 + SystemProperties.get("ro.config." + "alarm_alert");
                string3 = "alarm_alert";
            } else if ((n & 0x100) != 0) {
                String string7 = "/system/media/audio/" + "ringtones/";
                string2 = string7 + SystemProperties.get("ro.config." + "ringtone_2");
                string3 = "ringtone_2";
            }
        }
        if ((cursor = RingtoneManager.getMediaIdByDataField(context, string2)) == null) {
            return null;
        }
        if (cursor.getCount() == 0) {
            cursor.close();
            return null;
        }
        cursor.moveToFirst();
        int n2 = cursor.getInt(0);
        String string8 = ContentUris.withAppendedId(MediaStore.Audio.Media.INTERNAL_CONTENT_URI, n2).toString();
        Log.d(TAG, "addDefaultSystemSoundIntoDB type: " + n + ", uri: " + string8);
        if ((n & 1) != 0) {
            RingtoneManager.setSetting(context, "default_ringtone", string8);
        } else if ((n & 0x100) != 0) {
            RingtoneManager.setSetting(context, "default_ringtone_2", string8);
        }
        if (!RingtoneManager.setSetting(context, string3, string8)) {
            string8 = null;
        }
        cursor.close();
        return string8;
    }

    private static String constructBooleanTrueWhereClause(List<String> list) {
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = -1 + list.size(); i >= 0; --i) {
            stringBuilder.append(list.get(i)).append("=1 or ");
        }
        if (list.size() > 0) {
            stringBuilder.setLength(-4 + stringBuilder.length());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Uri getActualDefaultRingtoneUri(Context context, int n) {
        String string2;
        block5: {
            block4: {
                String string3 = RingtoneManager.getSettingForType(n);
                if (string3 == null) break block4;
                string2 = Settings.System.getString(context.getContentResolver(), string3);
                if (!RingtoneManager.isFileExist(context, string2, n) && string2 != null) {
                    string2 = Settings.System.getString(context.getContentResolver(), RingtoneManager.getDefaultUriForType(n));
                }
                if (string2 != null) break block5;
            }
            return null;
        }
        return Uri.parse(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getDefaultType(Uri uri) {
        block11: {
            block10: {
                if (uri == null) break block10;
                if (uri.equals(Settings.System.DEFAULT_RINGTONE_URI)) {
                    return 1;
                }
                if (uri.equals(Settings.System.DEFAULT_NOTIFICATION_URI)) {
                    return 2;
                }
                if (uri.equals(Settings.System.DEFAULT_RINGTONE_URI_2)) {
                    return 256;
                }
                if (uri.equals(Settings.System.DEFAULT_NOTIFICATION_URI_2)) {
                    return 512;
                }
                if (uri.equals(Settings.System.DEFAULT_ALARM_ALERT_URI)) {
                    return 4;
                }
                if (uri.equals(Settings.System.DEFAULT_NEWMAIL_URI)) {
                    return 32;
                }
                if (uri.equals(Settings.System.DEFAULT_SENTMAIL_URI)) {
                    return 64;
                }
                if (uri.equals(Settings.System.DEFAULT_CALENDARALERT_URI)) break block11;
            }
            return -1;
        }
        return 128;
    }

    public static Uri getDefaultUri(int n) {
        if ((n & 1) != 0) {
            return Settings.System.DEFAULT_RINGTONE_URI;
        }
        if ((n & 2) != 0) {
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
        if ((n & 0x100) != 0) {
            return Settings.System.DEFAULT_RINGTONE_URI_2;
        }
        if ((n & 0x200) != 0) {
            return Settings.System.DEFAULT_NOTIFICATION_URI_2;
        }
        if ((n & 4) != 0) {
            return Settings.System.DEFAULT_ALARM_ALERT_URI;
        }
        if ((n & 0x20) != 0) {
            return Settings.System.DEFAULT_NEWMAIL_URI;
        }
        if ((n & 0x40) != 0) {
            return Settings.System.DEFAULT_SENTMAIL_URI;
        }
        if ((n & 0x80) != 0) {
            return Settings.System.DEFAULT_CALENDARALERT_URI;
        }
        return null;
    }

    private static String getDefaultUriForType(int n) {
        if ((n & 1) != 0) {
            return "default_ringtone";
        }
        if ((n & 2) != 0) {
            return "default_notification_sound";
        }
        if ((n & 0x100) != 0) {
            return "default_ringtone_2";
        }
        if ((n & 0x200) != 0) {
            return "default_notification_sound_2";
        }
        if ((n & 4) != 0) {
            return "default_alarm_alert";
        }
        if ((n & 0x20) != 0) {
            return "default_newmail_sound";
        }
        if ((n & 0x40) != 0) {
            return "default_sentmail_sound";
        }
        if ((n & 0x80) != 0) {
            return "default_calendaralert_sound";
        }
        return null;
    }

    private String[] getExternalStorage() {
        String[] stringArray = ((StorageManager)this.mContext.getSystemService("storage")).getVolumePaths();
        String[] stringArray2 = new String[-1 + stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(Environment.getExternalStorageDirectory().getPath().toString())) continue;
            stringArray2[n] = stringArray[i];
            ++n;
        }
        return stringArray2;
    }

    private Cursor getInternalRingtones() {
        return this.query(MediaStore.Audio.Media.INTERNAL_CONTENT_URI, INTERNAL_COLUMNS, RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns), null, "title_key");
    }

    private static Cursor getMediaIdByDataField(Context context, String string2) {
        return context.getContentResolver().query(MediaStore.Audio.Media.INTERNAL_CONTENT_URI, new String[]{"_id"}, "_data='" + string2 + "'", null, null);
    }

    private Cursor getMediaRingtones() {
        Cursor cursor;
        block3: {
            block2: {
                String string2 = Environment.getExternalStorageState();
                if (string2.equals("mounted")) break block2;
                boolean bl = string2.equals("mounted_ro");
                cursor = null;
                if (!bl) break block3;
            }
            cursor = this.query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, MEDIA_COLUMNS, RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns), null, "title_key");
        }
        return cursor;
    }

    public static Ringtone getRingtone(Context context, Uri uri) {
        return RingtoneManager.getRingtone(context, uri, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Ringtone getRingtone(Context context, Uri uri, int n) {
        try {
            Ringtone ringtone = new Ringtone(context, true);
            if (n >= 0) {
                ringtone.setStreamType(n);
            }
            ringtone.setUri(uri);
            return ringtone;
        }
        catch (Exception exception) {
            Log.e(TAG, "Failed to open ringtone " + uri + ": " + exception);
            return null;
        }
    }

    private static String getSettingForType(int n) {
        if ((n & 1) != 0) {
            return "ringtone";
        }
        if ((n & 2) != 0) {
            return "notification_sound";
        }
        if ((n & 0x100) != 0) {
            return "ringtone_2";
        }
        if ((n & 0x200) != 0) {
            return "notification_sound_2";
        }
        if ((n & 4) != 0) {
            return "alarm_alert";
        }
        if ((n & 0x20) != 0) {
            return "newmail_sound";
        }
        if ((n & 0x40) != 0) {
            return "sentmail_sound";
        }
        if ((n & 0x80) != 0) {
            return "calendaralert_sound";
        }
        return null;
    }

    private static Uri getUriFromCursor(Cursor cursor) {
        return ContentUris.withAppendedId(Uri.parse(cursor.getString(2)), cursor.getLong(0));
    }

    public static Uri getValidRingtoneUri(Context context) {
        RingtoneManager ringtoneManager = new RingtoneManager(context);
        Uri uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, ringtoneManager.getInternalRingtones());
        if (uri == null) {
            uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, ringtoneManager.getMediaRingtones());
        }
        return uri;
    }

    private static Uri getValidRingtoneUriFromCursorAndClose(Context context, Cursor cursor) {
        if (cursor != null) {
            boolean bl = cursor.moveToFirst();
            Uri uri = null;
            if (bl) {
                uri = RingtoneManager.getUriFromCursor(cursor);
            }
            cursor.close();
            return uri;
        }
        return null;
    }

    public static boolean isDefault(Uri uri) {
        return RingtoneManager.getDefaultType(uri) != -1;
    }

    private static boolean isFileExist(Context context, String string2, int n) {
        block4: {
            Cursor cursor;
            block5: {
                try {
                    cursor = context.getContentResolver().query(Uri.parse(string2), new String[]{"_data"}, null, null, null);
                    if (cursor == null) break block4;
                }
                catch (Exception exception) {
                    Log.e(TAG, "Exception in isRingtoneAccessable: " + exception);
                    return false;
                }
                if (cursor.moveToFirst()) break block5;
                cursor.close();
                return false;
            }
            cursor.close();
        }
        return true;
    }

    private static boolean isRingtoneAccessable(Context context, String string2) {
        boolean bl;
        block5: {
            Cursor cursor;
            block6: {
                if (string2 == null || string2.length() == 0) {
                    return false;
                }
                try {
                    cursor = context.getContentResolver().query(Uri.parse(string2), new String[]{"title"}, null, null, null);
                    bl = false;
                    if (cursor == null) break block5;
                }
                catch (Exception exception) {
                    Log.e(TAG, "Exception in isRingtoneAccessable: " + exception);
                    return false;
                }
                boolean bl2 = cursor.moveToFirst();
                bl = false;
                if (!bl2) break block6;
                bl = true;
            }
            cursor.close();
        }
        return bl;
    }

    private Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        if (this.mActivity != null) {
            return this.mActivity.getApplicationContext().getContentResolver().query(uri, stringArray, string2, stringArray2, string3);
        }
        return this.mContext.getContentResolver().query(uri, stringArray, string2, stringArray2, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setActualDefaultRingtoneUri(Context context, int n, Uri uri) {
        String string2 = RingtoneManager.getSettingForType(n);
        if (string2 == null) {
            return;
        }
        ContentResolver contentResolver = context.getContentResolver();
        String string3 = uri != null ? uri.toString() : null;
        Settings.System.putString(contentResolver, string2, string3);
    }

    private void setFilterColumnsList(int n) {
        List<String> list = this.mFilterColumns;
        list.clear();
        if ((n & 1) != 0 || (n & 0x100) != 0) {
            list.add("is_ringtone");
        }
        if ((n & 2) != 0 || (n & 0x200) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 0x80) != 0) {
            list.add("is_notification");
        }
        if ((n & 4) != 0) {
            list.add("is_alarm");
        }
        if ((n & 8) != 0) {
            list.add("is_music");
        }
    }

    private static boolean setSetting(Context context, String string2, String string3) {
        return Settings.System.putString(context.getContentResolver(), string2, string3);
    }

    public Uri getActualRingtoneUri() {
        String string2 = Settings.System.getString(this.mContext.getContentResolver(), "ringtone");
        if (string2 != null) {
            return Uri.parse(string2);
        }
        return null;
    }

    public Cursor getCursor() {
        if (this.mCursor != null && !this.mCursor.isClosed()) {
            return this.mCursor;
        }
        Cursor cursor = this.getInternalRingtones();
        Cursor cursor2 = this.getMediaRingtones();
        if ((8 & this.mType) != 0) {
            SortCursor sortCursor = new SortCursor(new Cursor[]{cursor2}, "title_key");
            this.mCursor = sortCursor;
            return sortCursor;
        }
        SortCursor sortCursor = new SortCursor(new Cursor[]{cursor, cursor2}, "title_key");
        this.mCursor = sortCursor;
        return sortCursor;
    }

    public Uri getDefaultRingtoneUri() {
        String string2 = Settings.System.getString(this.mContext.getContentResolver(), "default_ringtone");
        if (string2 != null) {
            return Uri.parse(string2);
        }
        return null;
    }

    @Deprecated
    public boolean getIncludeDrm() {
        return false;
    }

    public Ringtone getRingtone(int n) {
        if (this.mStopPreviousRingtone && this.mPreviousRingtone != null) {
            this.mPreviousRingtone.stop();
        }
        this.mPreviousRingtone = RingtoneManager.getRingtone(this.mContext, this.getRingtoneUri(n), this.inferStreamType());
        return this.mPreviousRingtone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRingtonePosition(Uri uri) {
        if (uri == null) {
            return -1;
        }
        Cursor cursor = this.getCursor();
        if (cursor == null) {
            return -1;
        }
        int n = cursor.getCount();
        if (!cursor.moveToFirst()) {
            return -1;
        }
        Uri uri2 = null;
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            String string3 = cursor.getString(2);
            if (uri2 == null || !string3.equals(string2)) {
                uri2 = Uri.parse(string3);
            }
            if (uri.equals(ContentUris.withAppendedId(uri2, cursor.getLong(0)))) return n2;
            cursor.move(1);
            string2 = string3;
            ++n2;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Uri getRingtoneUri(int n) {
        if (this.mCursor == null || this.mCursor.isClosed() || !this.mCursor.moveToPosition(n)) {
            return null;
        }
        return RingtoneManager.getUriFromCursor(this.mCursor);
    }

    public boolean getStopPreviousRingtone() {
        return this.mStopPreviousRingtone;
    }

    public int inferStreamType() {
        switch (this.mType) {
            default: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 2: 
            case 32: 
            case 64: 
            case 128: 
            case 512: 
        }
        return 5;
    }

    @Deprecated
    public void setIncludeDrm(boolean bl) {
        if (bl) {
            Log.w(TAG, "setIncludeDrm no longer supported");
        }
    }

    public void setStopPreviousRingtone(boolean bl) {
        this.mStopPreviousRingtone = bl;
    }

    public void setType(int n) {
        if (this.mCursor != null) {
            throw new IllegalStateException("Setting filter columns should be done before querying for ringtones.");
        }
        this.mType = n;
        this.setFilterColumnsList(n);
    }

    public void stopPreviousRingtone() {
        if (this.mPreviousRingtone != null) {
            this.mPreviousRingtone.stop();
        }
    }

    public Cursor updateCursor() {
        String string2 = RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns);
        StorageManager storageManager = (StorageManager)this.mContext.getSystemService("storage");
        StringBuilder stringBuilder = new StringBuilder(string2);
        String[] stringArray = this.getExternalStorage();
        for (int i = 0; i < stringArray.length; ++i) {
            if (storageManager.getVolumeState(stringArray[i]).equals("mounted")) continue;
            stringBuilder.append(" and ");
            stringBuilder.append("_data");
            stringBuilder.append(" not like ");
            stringBuilder.append(" '%");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("%'");
        }
        String string3 = stringBuilder.toString();
        Cursor cursor = this.query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, MEDIA_COLUMNS, string3, null, "title_key");
        if (this.mCursor != null && !this.mCursor.isClosed()) {
            this.mCursor.close();
        }
        if ((8 & this.mType) != 0) {
            SortCursor sortCursor = new SortCursor(new Cursor[]{cursor}, "title_key");
            this.mCursor = sortCursor;
            return sortCursor;
        }
        MergeCursor mergeCursor = new MergeCursor(new Cursor[]{this.getInternalRingtones(), cursor});
        this.mCursor = mergeCursor;
        return mergeCursor;
    }
}

