/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.IRingtonePlayer;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class Ringtone {
    private static final boolean LOGD = true;
    private static final String[] MEDIA_COLUMNS = new String[]{"_id", "_data", "title"};
    private static final String TAG = "Ringtone";
    private final boolean mAllowRemote;
    private AudioAttributes mAudioAttributes = new AudioAttributes.Builder().setUsage(6).setContentType(4).build();
    private final AudioManager mAudioManager;
    private final Context mContext;
    private MediaPlayer mLocalPlayer;
    private final IRingtonePlayer mRemotePlayer;
    private final Binder mRemoteToken;
    private String mTitle;
    private Uri mUri;

    /*
     * Enabled aggressive block sorting
     */
    public Ringtone(Context context, boolean bl) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mAllowRemote = bl;
        IRingtonePlayer iRingtonePlayer = bl ? this.mAudioManager.getRingtonePlayer() : null;
        this.mRemotePlayer = iRingtonePlayer;
        Binder binder = null;
        if (bl) {
            binder = new Binder();
        }
        this.mRemoteToken = binder;
    }

    private void destroyLocalPlayer() {
        if (this.mLocalPlayer != null) {
            this.mLocalPlayer.reset();
            this.mLocalPlayer.release();
            this.mLocalPlayer = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String getTitle(Context var0, Uri var1_1, boolean var2_2) {
        block17: {
            block20: {
                block19: {
                    var3_3 = var0.getContentResolver();
                    var4_4 = null;
                    if (var1_1 == null) break block19;
                    var6_5 = var1_1.getAuthority();
                    if (!"settings".equals(var6_5)) break block20;
                    var4_4 = null;
                    if (var2_2) {
                        var4_4 = var0.getString(17040548, new Object[]{Ringtone.getTitle(var0, RingtoneManager.getActualDefaultRingtoneUri(var0, RingtoneManager.getDefaultType(var1_1)), false)});
                    }
                }
lbl10:
                // 3 sources

                while (true) {
                    if (var4_4 == null && (var4_4 = var0.getString(17040551)) == null) {
                        var4_4 = "";
                    }
                    var5_6 = var4_4;
                    return var5_6;
                }
            }
            try {
                var13_7 = "media".equals(var6_5);
                var8_8 = null;
                if (!var13_7) break block17;
            }
            catch (SecurityException var7_13) {
                var8_8 = null;
                ** continue;
            }
            var8_8 = var14_9 = var3_3.query(var1_1, Ringtone.MEDIA_COLUMNS, null, null, null);
        }
lbl27:
        // 2 sources

        while (true) {
            block18: {
                if (var8_8 != null) {
                    if (var8_8.getCount() != 1) break block18;
                    var8_8.moveToFirst();
                    var5_6 = var12_10 = var8_8.getString(2);
                    if (var8_8 == null) ** continue;
                    var8_8.close();
                    return var5_6;
                }
            }
            try {
                var4_4 = var10_11 = var1_1.getLastPathSegment();
                if (var8_8 == null) ** GOTO lbl10
                var8_8.close();
                ** continue;
            }
            catch (Throwable var9_12) {
                if (var8_8 != null) {
                    var8_8.close();
                }
                throw var9_12;
            }
            break;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean playFallbackRingtone() {
        if (this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(this.mAudioAttributes)) == 0) return false;
        int n = RingtoneManager.getDefaultType(this.mUri);
        if (n != -1 && RingtoneManager.getActualDefaultRingtoneUri(this.mContext, n) == null) {
            Log.w(TAG, "not playing fallback for " + this.mUri);
            return false;
        }
        try {
            AssetFileDescriptor assetFileDescriptor = this.mContext.getResources().openRawResourceFd(0x1100005);
            if (assetFileDescriptor != null) {
                this.mLocalPlayer = new MediaPlayer();
                if (assetFileDescriptor.getDeclaredLength() < 0L) {
                    this.mLocalPlayer.setDataSource(assetFileDescriptor.getFileDescriptor());
                } else {
                    this.mLocalPlayer.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getDeclaredLength());
                }
                this.mLocalPlayer.setAudioAttributes(this.mAudioAttributes);
                this.mLocalPlayer.prepare();
                this.mLocalPlayer.start();
                assetFileDescriptor.close();
                return true;
            }
        }
        catch (IOException iOException) {
            this.destroyLocalPlayer();
            Log.e(TAG, "Failed to open fallback ringtone");
            return false;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.e(TAG, "Fallback ringtone does not exist");
            return false;
        }
        {
            Log.e(TAG, "Could not load fallback ringtone");
            return false;
        }
    }

    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributes;
    }

    @Deprecated
    public int getStreamType() {
        return AudioAttributes.toLegacyStreamType(this.mAudioAttributes);
    }

    public String getTitle(Context context) {
        String string2;
        if (this.mTitle != null) {
            return this.mTitle;
        }
        this.mTitle = string2 = Ringtone.getTitle(context, this.mUri, true);
        return string2;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public boolean isPlaying() {
        if (this.mLocalPlayer != null) {
            return this.mLocalPlayer.isPlaying();
        }
        if (this.mAllowRemote && this.mRemotePlayer != null) {
            try {
                boolean bl = this.mRemotePlayer.isPlaying(this.mRemoteToken);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Problem checking ringtone: " + remoteException);
                return false;
            }
        }
        Log.w(TAG, "Neither local nor remote playback available");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play() {
        if (this.mLocalPlayer != null) {
            if (this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(this.mAudioAttributes)) == 0) return;
            this.mLocalPlayer.start();
            return;
        }
        if (this.mAllowRemote && this.mRemotePlayer != null) {
            Uri uri = this.mUri.getCanonicalUri();
            try {
                this.mRemotePlayer.play(this.mRemoteToken, uri, this.mAudioAttributes);
                return;
            }
            catch (RemoteException remoteException) {
                if (this.playFallbackRingtone()) return;
                Log.w(TAG, "Problem playing ringtone: " + remoteException);
                return;
            }
        } else {
            if (this.playFallbackRingtone()) return;
            Log.w(TAG, "Neither local nor remote playback available");
            return;
        }
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
        if (audioAttributes == null) {
            throw new IllegalArgumentException("Invalid null AudioAttributes for Ringtone");
        }
        this.mAudioAttributes = audioAttributes;
        this.setUri(this.mUri);
    }

    @Deprecated
    public void setStreamType(int n) {
        this.setAudioAttributes(new AudioAttributes.Builder().setInternalLegacyStreamType(n).build());
    }

    void setTitle(String string2) {
        this.mTitle = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUri(Uri uri) {
        block6: {
            this.destroyLocalPlayer();
            this.mUri = uri;
            if (this.mUri == null) {
                return;
            }
            this.mLocalPlayer = new MediaPlayer();
            try {
                this.mLocalPlayer.setDataSource(this.mContext, this.mUri);
                this.mLocalPlayer.setAudioAttributes(this.mAudioAttributes);
                this.mLocalPlayer.prepare();
            }
            catch (SecurityException securityException) {
                this.destroyLocalPlayer();
                if (!this.mAllowRemote) {
                    Log.w(TAG, "Remote playback not allowed: " + securityException);
                }
            }
            catch (IOException iOException) {
                this.destroyLocalPlayer();
                if (this.mAllowRemote) break block6;
                Log.w(TAG, "Remote playback not allowed: " + iOException);
            }
        }
        if (this.mLocalPlayer != null) {
            Log.d(TAG, "Successfully created local player");
            return;
        }
        Log.d(TAG, "Problem opening; delegating to remote player");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        if (this.mLocalPlayer != null) {
            this.destroyLocalPlayer();
            return;
        } else {
            if (!this.mAllowRemote || this.mRemotePlayer == null) return;
            try {
                this.mRemotePlayer.stop(this.mRemoteToken);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Problem stopping ringtone: " + remoteException);
                return;
            }
        }
    }
}

