/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.io.IOException;
import java.io.InputStream;

public final class ResampleInputStream
extends InputStream {
    private static final String TAG = "ResampleInputStream";
    private static final int mFirLength = 29;
    private byte[] mBuf;
    private int mBufCount;
    private InputStream mInputStream;
    private final byte[] mOneByte = new byte[1];
    private final int mRateIn;
    private final int mRateOut;

    static {
        System.loadLibrary("media_jni");
    }

    public ResampleInputStream(InputStream inputStream, int n, int n2) {
        if (n != n2 * 2) {
            throw new IllegalArgumentException("only support 2:1 at the moment");
        }
        this.mInputStream = inputStream;
        this.mRateIn = 2;
        this.mRateOut = 1;
    }

    private static native void fir21(byte[] var0, int var1, byte[] var2, int var3, int var4);

    @Override
    public void close() throws IOException {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
            return;
        }
        finally {
            this.mInputStream = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mInputStream != null) {
            this.close();
            throw new IllegalStateException("someone forgot to close ResampleInputStream");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.mOneByte, 0, 1) == 1) {
            return 0xFF & this.mOneByte[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        if (this.mInputStream == null) {
            throw new IllegalStateException("not open");
        }
        int n4 = 2 * (29 + n2 / 2 * this.mRateIn / this.mRateOut);
        if (this.mBuf == null) {
            this.mBuf = new byte[n4];
        } else if (n4 > this.mBuf.length) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy((byte[])this.mBuf, (int)0, (byte[])byArray2, (int)0, (int)this.mBufCount);
            this.mBuf = byArray2;
        }
        while (true) {
            int n5;
            if ((n5 = 2 * ((-29 + this.mBufCount / 2) * this.mRateOut / this.mRateIn)) > 0) {
                int n6 = n5 < n2 ? n5 : 2 * (n2 / 2);
                ResampleInputStream.fir21(this.mBuf, 0, byArray, n, n6 / 2);
                int n7 = n6 * this.mRateIn / this.mRateOut;
                this.mBufCount -= n7;
                if (this.mBufCount <= 0) return n6;
                System.arraycopy((byte[])this.mBuf, (int)n7, (byte[])this.mBuf, (int)0, (int)this.mBufCount);
                return n6;
            }
            int n8 = this.mInputStream.read(this.mBuf, this.mBufCount, this.mBuf.length - this.mBufCount);
            if (n8 == n3) return n3;
            this.mBufCount = n8 + this.mBufCount;
        }
    }
}

