/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Hashtable;
import java.util.Iterator;

public class MiniThumbFile {
    public static final int BYTES_PER_MINTHUMB = 10000;
    private static final int HEADER_SIZE = 13;
    private static final int MINI_THUMB_DATA_FILE_VERSION = 3;
    private static final String TAG = "MiniThumbFile";
    private static final Hashtable<String, MiniThumbFile> sThumbFiles = new Hashtable();
    private ByteBuffer mBuffer;
    private FileChannel mChannel;
    private RandomAccessFile mMiniThumbFile;
    private Uri mUri;

    public MiniThumbFile(Uri uri) {
        this.mUri = uri;
        this.mBuffer = ByteBuffer.allocateDirect(10000);
    }

    public static MiniThumbFile instance(Uri uri) {
        synchronized (MiniThumbFile.class) {
            MiniThumbFile miniThumbFile;
            block5: {
                String string2 = uri.getPathSegments().get(1);
                miniThumbFile = sThumbFiles.get(string2);
                if (miniThumbFile != null) break block5;
                miniThumbFile = new MiniThumbFile(Uri.parse("content://media/external/" + string2 + "/media"));
                sThumbFiles.put(string2, miniThumbFile);
            }
            return miniThumbFile;
            finally {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RandomAccessFile miniThumbDataFile() {
        if (this.mMiniThumbFile == null) {
            this.removeOldFile();
            String string2 = this.randomAccessFilePath(3);
            File file = new File(string2).getParentFile();
            if (!file.isDirectory() && !file.mkdirs()) {
                Log.e(TAG, "Unable to create .thumbnails directory " + file.toString());
            }
            File file2 = new File(string2);
            try {
                this.mMiniThumbFile = new RandomAccessFile(file2, "rw");
            }
            catch (IOException iOException) {
                try {
                    this.mMiniThumbFile = new RandomAccessFile(file2, "r");
                }
                catch (IOException iOException2) {}
            }
            if (this.mMiniThumbFile != null) {
                this.mChannel = this.mMiniThumbFile.getChannel();
            }
        }
        return this.mMiniThumbFile;
    }

    private String randomAccessFilePath(int n) {
        String string2 = Environment.getExternalStorageDirectory().toString() + "/DCIM/.thumbnails";
        return string2 + "/.thumbdata" + n + "-" + this.mUri.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeOldFile() {
        File file = new File(this.randomAccessFilePath(2));
        if (!file.exists()) return;
        try {
            file.delete();
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void reset() {
        synchronized (MiniThumbFile.class) {
            Iterator<MiniThumbFile> iterator = sThumbFiles.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    sThumbFiles.clear();
                    return;
                }
                iterator.next().deactivate();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deactivate() {
        synchronized (this) {
            RandomAccessFile randomAccessFile = this.mMiniThumbFile;
            if (randomAccessFile != null) {
                try {
                    this.mMiniThumbFile.close();
                    this.mMiniThumbFile = null;
                }
                catch (IOException iOException) {}
            }
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMagic(long l) {
        synchronized (this) {
            long l2;
            block23: {
                RandomAccessFile randomAccessFile = this.miniThumbDataFile();
                if (randomAccessFile == null) return 0L;
                long l3 = l * 10000L;
                FileLock fileLock = null;
                this.mBuffer.clear();
                this.mBuffer.limit(9);
                fileLock = this.mChannel.lock(l3, 9L, true);
                if (this.mChannel.read(this.mBuffer, l3) == 9) {
                    this.mBuffer.position(0);
                    if (this.mBuffer.get() == 1) {
                        long l4;
                        l2 = l4 = this.mBuffer.getLong();
                        if (fileLock == null) return l2;
                        fileLock.release();
                    }
                }
                if (fileLock == null) return 0L;
                fileLock.release();
                return 0L;
                catch (IOException iOException) {
                    Log.v(TAG, "Got exception checking file magic: ", iOException);
                    return 0L;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        Log.e(TAG, "Got exception when reading magic, id = " + l + ", disk full or mount read-only? " + runtimeException.getClass());
                        return 0L;
                    }
                }
                catch (IOException iOException) {}
                {
                    break block23;
                }
                catch (IOException iOException) {}
                return 0L;
                finally {
                    if (fileLock == null) return 0L;
                    fileLock.release();
                }
                return 0L;
            }
            return l2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getMiniThumbFromFile(long l, byte[] byArray) {
        synchronized (this) {
            RandomAccessFile randomAccessFile = this.miniThumbDataFile();
            if (randomAccessFile == null) {
                return null;
            }
            long l2 = l * 10000L;
            FileLock fileLock = null;
            try {
                this.mBuffer.clear();
                fileLock = this.mChannel.lock(l2, 10000L, true);
                int n = this.mChannel.read(this.mBuffer, l2);
                if (n <= 13) return null;
                this.mBuffer.position(0);
                byte by = this.mBuffer.get();
                long l3 = this.mBuffer.getLong();
                int n2 = this.mBuffer.getInt();
                if (n < n2 + 13) return null;
                if (n2 == 0) return null;
                if (l3 == 0L) return null;
                if (by != 1) return null;
                if (byArray.length < n2) return null;
                this.mBuffer.get(byArray, 0, n2);
            }
            catch (IOException iOException) {
                Log.w(TAG, "got exception when reading thumbnail id=" + l + ", exception: " + iOException);
                return null;
            }
            catch (RuntimeException runtimeException) {
                Log.e(TAG, "Got exception when reading thumbnail, id = " + l + ", disk full or mount read-only? " + runtimeException.getClass());
                return null;
            }
            return byArray;
            finally {
                if (fileLock == null) return null;
                fileLock.release();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveMiniThumbToFile(byte[] var1_1, long var2_2, long var4_3) throws IOException {
        synchronized (this) {
            var7_4 = this.miniThumbDataFile();
            if (var7_4 == null) return;
            var8_5 = var2_2 * 10000L;
            var10_6 = null;
            if (var1_1 != null) {
                var19_7 = var1_1.length;
                if (var19_7 > 9987) return;
                this.mBuffer.clear();
                this.mBuffer.put((byte)1);
                this.mBuffer.putLong(var4_3);
                this.mBuffer.putInt(var1_1.length);
                this.mBuffer.put(var1_1);
                this.mBuffer.flip();
                var10_6 = this.mChannel.lock(var8_5, 10000L, false);
                this.mChannel.write(this.mBuffer, var8_5);
            }
            if (var10_6 == null) return;
            try {
                var10_6.release();
            }
            catch (IOException var11_9) {}
            ** GOTO lbl46
            catch (IOException var17_10) {
                Log.e("MiniThumbFile", "couldn't save mini thumbnail data for " + var2_2 + "; ", var17_10);
                throw var17_10;
                {
                    block19: {
                        catch (Throwable var15_11) {}
                        throw var15_11;
                        catch (RuntimeException var12_12) {}
                        {
                            Log.e("MiniThumbFile", "couldn't save mini thumbnail data for " + var2_2 + "; disk full or mount read-only? " + var12_12.getClass());
                            break block19;
                        }
                        finally {
                            if (var10_6 == null) return;
                            var10_6.release();
                        }
                    }
                    return;
                }
            }
        }
    }
}

