/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.DeniedByServerException;
import android.media.NotProvisionedException;
import android.media.ResourceBusyException;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public final class MediaDrm {
    public static final int CERTIFICATE_TYPE_NONE = 0;
    public static final int CERTIFICATE_TYPE_X509 = 1;
    private static final int DRM_EVENT = 200;
    public static final int EVENT_KEY_EXPIRED = 3;
    public static final int EVENT_KEY_REQUIRED = 2;
    public static final int EVENT_PROVISION_REQUIRED = 1;
    public static final int EVENT_VENDOR_DEFINED = 4;
    public static final int KEY_TYPE_OFFLINE = 2;
    public static final int KEY_TYPE_RELEASE = 3;
    public static final int KEY_TYPE_STREAMING = 1;
    private static final String PERMISSION = "android.permission.ACCESS_DRM_CERTIFICATES";
    public static final String PROPERTY_ALGORITHMS = "algorithms";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_DEVICE_UNIQUE_ID = "deviceUniqueId";
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_VERSION = "version";
    private static final String TAG = "MediaDrm";
    private EventHandler mEventHandler;
    private long mNativeContext;
    private OnEventListener mOnEventListener;

    static {
        System.loadLibrary("media_jni");
        MediaDrm.native_init();
    }

    /*
     * Enabled aggressive block sorting
     */
    public MediaDrm(UUID uUID) throws UnsupportedSchemeException {
        Looper looper;
        Looper looper2 = Looper.myLooper();
        this.mEventHandler = looper2 != null ? new EventHandler(this, looper2) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.native_setup(new WeakReference<MediaDrm>(this), MediaDrm.getByteArrayFromUUID(uUID));
    }

    private static final native byte[] decryptNative(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static final native byte[] encryptNative(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static final byte[] getByteArrayFromUUID(UUID uUID) {
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        byte[] byArray = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l >>> 8 * (7 - i));
            byArray[i + 8] = (byte)(l2 >>> 8 * (7 - i));
        }
        return byArray;
    }

    private native ProvisionRequest getProvisionRequestNative(int var1, String var2);

    public static final boolean isCryptoSchemeSupported(UUID uUID) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uUID), null);
    }

    public static final boolean isCryptoSchemeSupported(UUID uUID, String string2) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uUID), string2);
    }

    private static final native boolean isCryptoSchemeSupportedNative(byte[] var0, String var1);

    private final native void native_finalize();

    private static final native void native_init();

    private final native void native_setup(Object var1, byte[] var2);

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n, int n2, Object object2) {
        MediaDrm mediaDrm = (MediaDrm)((WeakReference)object).get();
        if (mediaDrm == null || mediaDrm.mEventHandler == null) {
            return;
        }
        Message message = mediaDrm.mEventHandler.obtainMessage(200, n, n2, object2);
        mediaDrm.mEventHandler.sendMessage(message);
    }

    private native Certificate provideProvisionResponseNative(byte[] var1) throws DeniedByServerException;

    private static final native void setCipherAlgorithmNative(MediaDrm var0, byte[] var1, String var2);

    private static final native void setMacAlgorithmNative(MediaDrm var0, byte[] var1, String var2);

    private static final native byte[] signNative(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3);

    private static final native byte[] signRSANative(MediaDrm var0, byte[] var1, String var2, byte[] var3, byte[] var4);

    private static final native boolean verifyNative(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public native void closeSession(byte[] var1);

    protected void finalize() {
        this.native_finalize();
    }

    public CertificateRequest getCertificateRequest(int n, String string2) {
        ProvisionRequest provisionRequest = this.getProvisionRequestNative(n, string2);
        return new CertificateRequest(provisionRequest.getData(), provisionRequest.getDefaultUrl());
    }

    public CryptoSession getCryptoSession(byte[] byArray, String string2, String string3) {
        return new CryptoSession(this, byArray, string2, string3);
    }

    public native KeyRequest getKeyRequest(byte[] var1, byte[] var2, String var3, int var4, HashMap<String, String> var5) throws NotProvisionedException;

    public native byte[] getPropertyByteArray(String var1);

    public native String getPropertyString(String var1);

    public ProvisionRequest getProvisionRequest() {
        return this.getProvisionRequestNative(0, "");
    }

    public native List<byte[]> getSecureStops();

    public native byte[] openSession() throws NotProvisionedException, ResourceBusyException;

    public Certificate provideCertificateResponse(byte[] byArray) throws DeniedByServerException {
        return this.provideProvisionResponseNative(byArray);
    }

    public native byte[] provideKeyResponse(byte[] var1, byte[] var2) throws NotProvisionedException, DeniedByServerException;

    public void provideProvisionResponse(byte[] byArray) throws DeniedByServerException {
        this.provideProvisionResponseNative(byArray);
    }

    public native HashMap<String, String> queryKeyStatus(byte[] var1);

    public final native void release();

    public native void releaseSecureStops(byte[] var1);

    public native void removeKeys(byte[] var1);

    public native void restoreKeys(byte[] var1, byte[] var2);

    public void setOnEventListener(OnEventListener onEventListener) {
        this.mOnEventListener = onEventListener;
    }

    public native void setPropertyByteArray(String var1, byte[] var2);

    public native void setPropertyString(String var1, String var2);

    public byte[] signRSA(byte[] byArray, String string2, byte[] byArray2, byte[] byArray3) {
        return MediaDrm.signRSANative(this, byArray, string2, byArray2, byArray3);
    }

    public native void unprovisionDevice();

    public static final class Certificate {
        private byte[] mCertificateData;
        private byte[] mWrappedKey;

        Certificate() {
        }

        public byte[] getContent() {
            return this.mCertificateData;
        }

        public byte[] getWrappedPrivateKey() {
            return this.mWrappedKey;
        }
    }

    public static final class CertificateRequest {
        private byte[] mData;
        private String mDefaultUrl;

        CertificateRequest(byte[] byArray, String string2) {
            this.mData = byArray;
            this.mDefaultUrl = string2;
        }

        public byte[] getData() {
            return this.mData;
        }

        public String getDefaultUrl() {
            return this.mDefaultUrl;
        }
    }

    public final class CryptoSession {
        private MediaDrm mDrm;
        private byte[] mSessionId;

        CryptoSession(MediaDrm mediaDrm2, byte[] byArray, String string2, String string3) {
            this.mSessionId = byArray;
            this.mDrm = mediaDrm2;
            MediaDrm.setCipherAlgorithmNative(mediaDrm2, byArray, string2);
            MediaDrm.setMacAlgorithmNative(mediaDrm2, byArray, string3);
        }

        public byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return MediaDrm.decryptNative(this.mDrm, this.mSessionId, byArray, byArray2, byArray3);
        }

        public byte[] encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return MediaDrm.encryptNative(this.mDrm, this.mSessionId, byArray, byArray2, byArray3);
        }

        public byte[] sign(byte[] byArray, byte[] byArray2) {
            return MediaDrm.signNative(this.mDrm, this.mSessionId, byArray, byArray2);
        }

        public boolean verify(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return MediaDrm.verifyNative(this.mDrm, this.mSessionId, byArray, byArray2, byArray3);
        }
    }

    private class EventHandler
    extends Handler {
        private MediaDrm mMediaDrm;

        public EventHandler(MediaDrm mediaDrm2, Looper looper) {
            super(looper);
            this.mMediaDrm = mediaDrm2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            if (this.mMediaDrm.mNativeContext == 0L) {
                Log.w(MediaDrm.TAG, "MediaDrm went away with unhandled events");
                return;
            } else {
                byte[] byArray;
                switch (message.what) {
                    default: {
                        Log.e(MediaDrm.TAG, "Unknown message type " + message.what);
                        return;
                    }
                    case 200: 
                }
                Log.i(MediaDrm.TAG, "Drm event (" + message.arg1 + "," + message.arg2 + ")");
                if (MediaDrm.this.mOnEventListener == null || message.obj == null || !(message.obj instanceof Parcel)) return;
                Parcel parcel = (Parcel)message.obj;
                byte[] byArray2 = parcel.createByteArray();
                if (byArray2.length == 0) {
                    byArray2 = null;
                }
                if ((byArray = parcel.createByteArray()).length == 0) {
                    byArray = null;
                }
                MediaDrm.this.mOnEventListener.onEvent(this.mMediaDrm, byArray2, message.arg1, message.arg2, byArray);
                return;
            }
        }
    }

    public static final class KeyRequest {
        private byte[] mData;
        private String mDefaultUrl;

        KeyRequest() {
        }

        public byte[] getData() {
            return this.mData;
        }

        public String getDefaultUrl() {
            return this.mDefaultUrl;
        }
    }

    public static final class MediaDrmStateException
    extends IllegalStateException {
        private final String mDiagnosticInfo;
        private final int mErrorCode;

        /*
         * Enabled aggressive block sorting
         */
        public MediaDrmStateException(int n, String string2) {
            super(string2);
            this.mErrorCode = n;
            String string3 = n < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaDrm.error_" + string3 + Math.abs(n);
        }

        public String getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }
    }

    public static interface OnEventListener {
        public void onEvent(MediaDrm var1, byte[] var2, int var3, int var4, byte[] var5);
    }

    public static final class ProvisionRequest {
        private byte[] mData;
        private String mDefaultUrl;

        ProvisionRequest() {
        }

        public byte[] getData() {
            return this.mData;
        }

        public String getDefaultUrl() {
            return this.mDefaultUrl;
        }
    }
}

