/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;

public interface IRingtonePlayer
extends IInterface {
    public boolean isPlaying(IBinder var1) throws RemoteException;

    public void play(IBinder var1, Uri var2, AudioAttributes var3) throws RemoteException;

    public void playAsync(Uri var1, UserHandle var2, boolean var3, AudioAttributes var4) throws RemoteException;

    public void stop(IBinder var1) throws RemoteException;

    public void stopAsync() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRingtonePlayer {
        private static final String DESCRIPTOR = "android.media.IRingtonePlayer";
        static final int TRANSACTION_isPlaying = 3;
        static final int TRANSACTION_play = 1;
        static final int TRANSACTION_playAsync = 4;
        static final int TRANSACTION_stop = 2;
        static final int TRANSACTION_stopAsync = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRingtonePlayer asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IRingtonePlayer) {
                return (IRingtonePlayer)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    Uri uri = parcel.readInt() != 0 ? Uri.CREATOR.createFromParcel(parcel) : null;
                    AudioAttributes audioAttributes = parcel.readInt() != 0 ? AudioAttributes.CREATOR.createFromParcel(parcel) : null;
                    this.play(iBinder, uri, audioAttributes);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.stop(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isPlaying(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    int n3 = 0;
                    if (bl) {
                        n3 = 1;
                    }
                    parcel2.writeInt(n3);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Uri uri = parcel.readInt() != 0 ? Uri.CREATOR.createFromParcel(parcel) : null;
                    UserHandle userHandle = parcel.readInt() != 0 ? UserHandle.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    AudioAttributes audioAttributes = parcel.readInt() != 0 ? AudioAttributes.CREATOR.createFromParcel(parcel) : null;
                    this.playAsync(uri, userHandle, bl, audioAttributes);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.stopAsync();
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements IRingtonePlayer {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public boolean isPlaying(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void play(IBinder iBinder, Uri uri, AudioAttributes audioAttributes) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (audioAttributes != null) {
                        parcel.writeInt(1);
                        audioAttributes.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void playAsync(Uri uri, UserHandle userHandle, boolean bl, AudioAttributes audioAttributes) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (userHandle != null) {
                        parcel.writeInt(1);
                        userHandle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                if (!bl) {
                    n = 0;
                }
                parcel.writeInt(n);
                if (audioAttributes != null) {
                    parcel.writeInt(1);
                    audioAttributes.writeToParcel(parcel, 0);
                } else {
                    parcel.writeInt(0);
                }
                this.mRemote.transact(4, parcel, parcel2, 0);
                parcel2.readException();
                parcel2.recycle();
                parcel.recycle();
            }

            @Override
            public void stop(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void stopAsync() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

