/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IAudioFocusDispatcher;
import android.media.MediaFocusControl;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.PrintWriter;
import java.util.NoSuchElementException;

class FocusRequester {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaFocusControl";
    private final int mCallingUid;
    private final String mClientId;
    private MediaFocusControl.AudioFocusDeathHandler mDeathHandler;
    private final IAudioFocusDispatcher mFocusDispatcher;
    private final int mFocusGainRequest;
    private int mFocusLossReceived;
    private final String mPackageName;
    private final IBinder mSourceRef;
    private final int mStreamType;

    FocusRequester(int n, int n2, IAudioFocusDispatcher iAudioFocusDispatcher, IBinder iBinder, String string2, MediaFocusControl.AudioFocusDeathHandler audioFocusDeathHandler, String string3, int n3) {
        this.mStreamType = n;
        this.mFocusDispatcher = iAudioFocusDispatcher;
        this.mSourceRef = iBinder;
        this.mClientId = string2;
        this.mDeathHandler = audioFocusDeathHandler;
        this.mPackageName = string3;
        this.mCallingUid = n3;
        this.mFocusGainRequest = n2;
        this.mFocusLossReceived = 0;
    }

    private static String focusChangeToString(int n) {
        switch (n) {
            default: {
                return "[invalid focus change" + n + "]";
            }
            case 0: {
                return "none";
            }
            case 1: {
                return "GAIN";
            }
            case 2: {
                return "GAIN_TRANSIENT";
            }
            case 3: {
                return "GAIN_TRANSIENT_MAY_DUCK";
            }
            case 4: {
                return "GAIN_TRANSIENT_EXCLUSIVE";
            }
            case -1: {
                return "LOSS";
            }
            case -2: {
                return "LOSS_TRANSIENT";
            }
            case -3: 
        }
        return "LOSS_TRANSIENT_CAN_DUCK";
    }

    private String focusGainToString() {
        return FocusRequester.focusChangeToString(this.mFocusGainRequest);
    }

    /*
     * Unable to fully structure code
     */
    private int focusLossForGainRequest(int var1_1) {
        var2_2 = -1;
        switch (var1_1) {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    Log.e("MediaFocusControl", "focusLossForGainRequest() for invalid focus request " + var1_1);
                    var2_2 = 0;
lbl8:
                    // 4 sources

                    return var2_2;
                }
            }
            case 1: {
                switch (this.mFocusLossReceived) {
                    case -3: 
                    case -2: 
                    case -1: 
                    case 0: {
                        ** GOTO lbl8
                    }
                }
            }
            case 2: 
            case 4: {
                switch (this.mFocusLossReceived) {
                    case -1: {
                        ** GOTO lbl8
                    }
                    case -3: 
                    case -2: 
                    case 0: {
                        return -2;
                    }
                }
            }
            case 3: 
        }
        switch (this.mFocusLossReceived) {
            case -1: {
                ** continue;
            }
            default: {
                ** continue;
            }
            case -3: 
            case 0: {
                return -3;
            }
            case -2: {
                return -2;
            }
        }
    }

    private String focusLossToString() {
        return FocusRequester.focusChangeToString(this.mFocusLossReceived);
    }

    void dump(PrintWriter printWriter) {
        printWriter.println("  source:" + this.mSourceRef + " -- pack: " + this.mPackageName + " -- client: " + this.mClientId + " -- gain: " + this.focusGainToString() + " -- loss: " + this.focusLossToString() + " -- uid: " + this.mCallingUid + " -- stream: " + this.mStreamType);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    int getGainRequest() {
        return this.mFocusGainRequest;
    }

    int getStreamType() {
        return this.mStreamType;
    }

    void handleExternalFocusGain(int n) {
        this.handleFocusLoss(this.focusLossForGainRequest(n));
    }

    void handleFocusGain(int n) {
        try {
            if (this.mFocusDispatcher != null) {
                this.mFocusDispatcher.dispatchAudioFocusChange(n, this.mClientId);
            }
            this.mFocusLossReceived = 0;
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failure to signal gain of audio focus due to: ", remoteException);
            return;
        }
    }

    void handleFocusLoss(int n) {
        try {
            if (n != this.mFocusLossReceived) {
                if (this.mFocusDispatcher != null) {
                    this.mFocusDispatcher.dispatchAudioFocusChange(n, this.mClientId);
                }
                this.mFocusLossReceived = n;
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failure to signal loss of audio focus due to:", remoteException);
            return;
        }
    }

    boolean hasSameBinder(IBinder iBinder) {
        return this.mSourceRef != null && this.mSourceRef.equals(iBinder);
    }

    boolean hasSameClient(String string2) {
        try {
            int n = this.mClientId.compareTo(string2);
            boolean bl = false;
            if (n == 0) {
                bl = true;
            }
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    boolean hasSamePackage(String string2) {
        try {
            int n = this.mPackageName.compareTo(string2);
            boolean bl = false;
            if (n == 0) {
                bl = true;
            }
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    boolean hasSameUid(int n) {
        return this.mCallingUid == n;
    }

    void release() {
        try {
            if (this.mSourceRef != null && this.mDeathHandler != null) {
                this.mSourceRef.unlinkToDeath(this.mDeathHandler, 0);
                this.mDeathHandler = null;
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            Log.e(TAG, "FocusRequester.release() hit ", noSuchElementException);
            return;
        }
    }
}

