/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioSystem;
import android.media.IAudioService;
import android.media.MediaRecorder;
import android.media.MediaSyncEvent;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.asus.cta.CtaChecker;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class AudioRecord {
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDCHANNELMASK = -17;
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDFORMAT = -18;
    private static final int AUDIORECORD_ERROR_SETUP_INVALIDSOURCE = -19;
    private static final int AUDIORECORD_ERROR_SETUP_NATIVEINITFAILED = -20;
    private static final int AUDIORECORD_ERROR_SETUP_ZEROFRAMECOUNT = -16;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -2;
    public static final int ERROR_INVALID_OPERATION = -3;
    private static final int NATIVE_EVENT_MARKER = 2;
    private static final int NATIVE_EVENT_NEW_POS = 3;
    public static final int RECORDSTATE_RECORDING = 3;
    public static final int RECORDSTATE_STOPPED = 1;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final String SUBMIX_FIXED_VOLUME = "fixedVolume";
    public static final int SUCCESS = 0;
    private static final String TAG = "android.media.AudioRecord";
    private AudioAttributes mAudioAttributes;
    private int mAudioFormat;
    private int mChannelCount;
    private int mChannelMask;
    private NativeEventHandler mEventHandler = null;
    private final IBinder mICallBack;
    private Looper mInitializationLooper = null;
    private boolean mIsSubmixFullVolume = false;
    private int mNativeBufferSizeInBytes = 0;
    private long mNativeCallbackCookie;
    private long mNativeRecorderInJavaObj;
    private OnRecordPositionUpdateListener mPositionListener = null;
    private final Object mPositionListenerLock;
    private int mRecordSource;
    private int mRecordingState = 1;
    private final Object mRecordingStateLock = new Object();
    private int mSampleRate;
    private int mSessionId = 0;
    private int mState = 0;

    public AudioRecord(int n, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setInternalCapturePreset(n).build(), new AudioFormat.Builder().setChannelMask(AudioRecord.getChannelMaskFromLegacyConfig(n3, true)).setEncoding(n4).setSampleRate(n2).build(), n5, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AudioRecord(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2) throws IllegalArgumentException {
        int n3;
        Looper looper;
        this.mPositionListenerLock = new Object();
        this.mICallBack = new Binder();
        if (audioAttributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        if (audioFormat == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        this.mInitializationLooper = looper = Looper.myLooper();
        if (looper == null) {
            this.mInitializationLooper = Looper.getMainLooper();
        }
        this.mAudioAttributes = audioAttributes;
        if (this.mAudioAttributes.getCapturePreset() == 8) {
            Iterator<String> iterator = this.mAudioAttributes.getTags().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equalsIgnoreCase(SUBMIX_FIXED_VOLUME)) continue;
                this.mIsSubmixFullVolume = true;
                Log.v(TAG, "Will record from REMOTE_SUBMIX at full fixed volume");
                break;
            }
        }
        if ((2 & audioFormat.getPropertySetMask()) != 0) {
            n3 = audioFormat.getSampleRate();
        } else {
            n3 = AudioSystem.getPrimaryOutputSamplingRate();
            if (n3 <= 0) {
                n3 = 44100;
            }
        }
        int n4 = 1;
        if ((1 & audioFormat.getPropertySetMask()) != 0) {
            n4 = audioFormat.getEncoding();
        }
        this.audioParamCheck(audioAttributes.getCapturePreset(), n3, n4);
        this.mChannelCount = AudioFormat.channelCountFromInChannelMask(audioFormat.getChannelMask());
        this.mChannelMask = AudioRecord.getChannelMaskFromLegacyConfig(audioFormat.getChannelMask(), false);
        this.audioBuffSizeCheck(n);
        int[] nArray = new int[]{n2};
        int n5 = this.native_setup(new WeakReference<AudioRecord>(this), this.mAudioAttributes, this.mSampleRate, this.mChannelMask, this.mAudioFormat, this.mNativeBufferSizeInBytes, nArray);
        if (n5 != 0) {
            AudioRecord.loge("Error code " + n5 + " when initializing native AudioRecord object.");
            return;
        }
        this.mSessionId = nArray[0];
        this.mState = 1;
    }

    private void audioBuffSizeCheck(int n) throws IllegalArgumentException {
        if (n % (this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat)) != 0 || n < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size.");
        }
        this.mNativeBufferSizeInBytes = n;
    }

    private void audioParamCheck(int n, int n2, int n3) throws IllegalArgumentException {
        if (n < 0 || n > MediaRecorder.getAudioSourceMax() && n != 1999) {
            throw new IllegalArgumentException("Invalid audio source.");
        }
        this.mRecordSource = n;
        if (n2 < 4000 || n2 > 48000) {
            throw new IllegalArgumentException(n2 + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = n2;
        switch (n3) {
            default: {
                throw new IllegalArgumentException("Unsupported sample encoding. Should be ENCODING_PCM_8BIT or ENCODING_PCM_16BIT.");
            }
            case 1: {
                this.mAudioFormat = 2;
                return;
            }
            case 2: 
            case 3: 
        }
        this.mAudioFormat = n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getChannelMaskFromLegacyConfig(int n, boolean bl) {
        int n2;
        switch (n) {
            default: {
                throw new IllegalArgumentException("Unsupported channel configuration.");
            }
            case 1: 
            case 2: 
            case 16: {
                n2 = 16;
                break;
            }
            case 3: 
            case 12: {
                n2 = 12;
                break;
            }
            case 48: {
                n2 = n;
            }
        }
        if (!(bl || n != 2 && n != 3)) {
            throw new IllegalArgumentException("Unsupported deprecated configuration.");
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getMinBufferSize(int n, int n2, int n3) {
        int n4;
        switch (n2) {
            default: {
                AudioRecord.loge("getMinBufferSize(): Invalid channel configuration.");
                return -2;
            }
            case 1: 
            case 2: 
            case 16: {
                n4 = 1;
                break;
            }
            case 3: 
            case 12: 
            case 48: {
                n4 = 2;
            }
        }
        if (n3 != 2) {
            AudioRecord.loge("getMinBufferSize(): Invalid audio format.");
            return -2;
        }
        int n5 = AudioRecord.native_get_min_buff_size(n, n4, n3);
        if (n5 == 0) {
            return -2;
        }
        if (n5 != -1) return n5;
        return -1;
    }

    private void handleFullVolumeRec(boolean bl) {
        if (!this.mIsSubmixFullVolume) {
            return;
        }
        IAudioService iAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
        try {
            iAudioService.forceRemoteSubmixFullVolume(bl, this.mICallBack);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error talking to AudioService when handling full submix volume", remoteException);
            return;
        }
    }

    private static void logd(String string2) {
        Log.d(TAG, string2);
    }

    private static void loge(String string2) {
        Log.e(TAG, string2);
    }

    private final native void native_finalize();

    private final native int native_get_marker_pos();

    private static final native int native_get_min_buff_size(int var0, int var1, int var2);

    private final native int native_get_pos_update_period();

    private final native int native_read_in_byte_array(byte[] var1, int var2, int var3);

    private final native int native_read_in_direct_buffer(Object var1, int var2);

    private final native int native_read_in_short_array(short[] var1, int var2, int var3);

    private final native void native_release();

    private final native int native_set_marker_pos(int var1);

    private final native int native_set_pos_update_period(int var1);

    private final native int native_setup(Object var1, Object var2, int var3, int var4, int var5, int var6, int[] var7);

    private final native int native_start(int var1, int var2);

    private final native void native_stop();

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        AudioRecord audioRecord = (AudioRecord)((WeakReference)object).get();
        if (audioRecord == null || audioRecord.mEventHandler == null) {
            return;
        }
        Message message = audioRecord.mEventHandler.obtainMessage(n, n2, n3, object2);
        audioRecord.mEventHandler.sendMessage(message);
    }

    protected void finalize() {
        this.release();
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }

    public int getAudioSessionId() {
        return this.mSessionId;
    }

    public int getAudioSource() {
        return this.mRecordSource;
    }

    public int getChannelConfiguration() {
        return this.mChannelMask;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    public int getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRecordingState() {
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            return this.mRecordingState;
        }
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getState() {
        return this.mState;
    }

    public int read(ByteBuffer byteBuffer, int n) {
        if (this.mState != 1) {
            return -3;
        }
        if (byteBuffer == null || n < 0) {
            return -2;
        }
        return this.native_read_in_direct_buffer(byteBuffer, n);
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.mState != 1) {
            return -3;
        }
        if (byArray == null || n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            return -2;
        }
        return this.native_read_in_byte_array(byArray, n, n2);
    }

    public int read(short[] sArray, int n, int n2) {
        if (this.mState != 1) {
            return -3;
        }
        if (sArray == null || n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > sArray.length) {
            return -2;
        }
        return this.native_read_in_short_array(sArray, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {}
        this.native_release();
        this.mState = 0;
    }

    public int setNotificationMarkerPosition(int n) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(n);
    }

    public int setPositionNotificationPeriod(int n) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(n);
    }

    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener onRecordPositionUpdateListener) {
        this.setRecordPositionUpdateListener(onRecordPositionUpdateListener, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener onRecordPositionUpdateListener, Handler handler) {
        Object object = this.mPositionListenerLock;
        synchronized (object) {
            this.mPositionListener = onRecordPositionUpdateListener;
            this.mEventHandler = onRecordPositionUpdateListener != null ? (handler != null ? new NativeEventHandler(this, handler.getLooper()) : new NativeEventHandler(this, this.mInitializationLooper)) : null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startRecording() throws IllegalStateException {
        if (Build.CTA && !new CtaChecker(null).checkPermission(12, ActivityThread.currentPackageName())) {
            return;
        }
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start(0, 0) == 0) {
                this.handleFullVolumeRec(true);
                this.mRecordingState = 3;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startRecording(MediaSyncEvent mediaSyncEvent) throws IllegalStateException {
        if (Build.CTA && !new CtaChecker(null).checkPermission(12, ActivityThread.currentPackageName())) {
            return;
        }
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start(mediaSyncEvent.getType(), mediaSyncEvent.getAudioSessionId()) == 0) {
                this.handleFullVolumeRec(true);
                this.mRecordingState = 3;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            this.handleFullVolumeRec(false);
            this.native_stop();
            this.mRecordingState = 1;
            return;
        }
    }

    private class NativeEventHandler
    extends Handler {
        private final AudioRecord mAudioRecord;

        NativeEventHandler(AudioRecord audioRecord2, Looper looper) {
            super(looper);
            this.mAudioRecord = audioRecord2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            OnRecordPositionUpdateListener onRecordPositionUpdateListener;
            Object object = AudioRecord.this.mPositionListenerLock;
            synchronized (object) {
                onRecordPositionUpdateListener = this.mAudioRecord.mPositionListener;
            }
            switch (message.what) {
                default: {
                    AudioRecord.loge("Unknown native event type: " + message.what);
                    return;
                }
                case 2: {
                    if (onRecordPositionUpdateListener == null) return;
                    onRecordPositionUpdateListener.onMarkerReached(this.mAudioRecord);
                    return;
                }
                case 3: {
                    if (onRecordPositionUpdateListener == null) return;
                    onRecordPositionUpdateListener.onPeriodicNotification(this.mAudioRecord);
                    return;
                }
            }
        }
    }

    public static interface OnRecordPositionUpdateListener {
        public void onMarkerReached(AudioRecord var1);

        public void onPeriodicNotification(AudioRecord var1);
    }
}

