/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioGain;
import android.media.AudioGainConfig;
import android.media.AudioHandle;
import android.media.AudioPortConfig;

public class AudioPort {
    public static final int ROLE_NONE = 0;
    public static final int ROLE_SINK = 2;
    public static final int ROLE_SOURCE = 1;
    public static final int TYPE_DEVICE = 1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_SESSION = 3;
    public static final int TYPE_SUBMIX = 2;
    private AudioPortConfig mActiveConfig;
    private final int[] mChannelMasks;
    private final int[] mFormats;
    private final AudioGain[] mGains;
    AudioHandle mHandle;
    private final int mRole;
    private final int[] mSamplingRates;

    AudioPort(AudioHandle audioHandle, int n, int[] nArray, int[] nArray2, int[] nArray3, AudioGain[] audioGainArray) {
        this.mHandle = audioHandle;
        this.mRole = n;
        this.mSamplingRates = nArray;
        this.mChannelMasks = nArray2;
        this.mFormats = nArray3;
        this.mGains = audioGainArray;
    }

    public AudioPortConfig activeConfig() {
        return this.mActiveConfig;
    }

    public AudioPortConfig buildConfig(int n, int n2, int n3, AudioGainConfig audioGainConfig) {
        return new AudioPortConfig(this, n, n2, n3, audioGainConfig);
    }

    public int[] channelMasks() {
        return this.mChannelMasks;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AudioPort)) {
            return false;
        }
        AudioPort audioPort = (AudioPort)object;
        return this.mHandle.equals(audioPort.handle());
    }

    public int[] formats() {
        return this.mFormats;
    }

    AudioGain gain(int n) {
        if (n < 0 || n >= this.mGains.length) {
            return null;
        }
        return this.mGains[n];
    }

    public AudioGain[] gains() {
        return this.mGains;
    }

    AudioHandle handle() {
        return this.mHandle;
    }

    public int hashCode() {
        return this.mHandle.hashCode();
    }

    public int role() {
        return this.mRole;
    }

    public int[] samplingRates() {
        return this.mSamplingRates;
    }

    public String toString() {
        return "{mHandle:" + this.mHandle + ", mRole:" + this.mRole + "}";
    }
}

