/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.PendingIntent;
import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.media.AudioDevicePort;
import android.media.AudioGainConfig;
import android.media.AudioPatch;
import android.media.AudioPort;
import android.media.AudioPortConfig;
import android.media.AudioPortEventHandler;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioService;
import android.media.IRemoteControlDisplay;
import android.media.IRingtonePlayer;
import android.media.IVolumeController;
import android.media.RemoteControlClient;
import android.media.RemoteController;
import android.media.audiopolicy.AudioPolicy;
import android.media.session.MediaSessionLegacyHelper;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;

public class AudioManager {
    public static final String ACTION_ANALOG_AUDIO_DOCK_PLUG = "android.media.action.ANALOG_AUDIO_DOCK_PLUG";
    public static final String ACTION_AUDIO_BECOMING_NOISY = "android.media.AUDIO_BECOMING_NOISY";
    public static final String ACTION_DIGITAL_AUDIO_DOCK_PLUG = "android.media.action.DIGITAL_AUDIO_DOCK_PLUG";
    public static final String ACTION_HDMI_AUDIO_PLUG = "android.media.action.HDMI_AUDIO_PLUG";
    public static final String ACTION_HEADSET_PLUG = "android.intent.action.HEADSET_PLUG";
    @Deprecated
    public static final String ACTION_SCO_AUDIO_STATE_CHANGED = "android.media.SCO_AUDIO_STATE_CHANGED";
    public static final String ACTION_SCO_AUDIO_STATE_UPDATED = "android.media.ACTION_SCO_AUDIO_STATE_UPDATED";
    public static final String ACTION_USB_AUDIO_ACCESSORY_PLUG = "android.media.action.USB_AUDIO_ACCESSORY_PLUG";
    public static final String ACTION_USB_AUDIO_DEVICE_PLUG = "android.media.action.USB_AUDIO_DEVICE_PLUG";
    public static final int ADJUST_LOWER = -1;
    public static final int ADJUST_RAISE = 1;
    public static final int ADJUST_SAME = 0;
    public static final int AUDIOFOCUS_GAIN = 1;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT = 2;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE = 4;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK = 3;
    public static final int AUDIOFOCUS_LOSS = -1;
    public static final int AUDIOFOCUS_LOSS_TRANSIENT = -2;
    public static final int AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK = -3;
    public static final int AUDIOFOCUS_NONE = 0;
    public static final int AUDIOFOCUS_REQUEST_FAILED = 0;
    public static final int AUDIOFOCUS_REQUEST_GRANTED = 1;
    static final int AUDIOPORT_GENERATION_INIT = 0;
    public static final int AUDIO_SESSION_ID_GENERATE = 0;
    public static final int[] DEFAULT_STREAM_VOLUME;
    public static final int DEVICE_IN_ANLG_DOCK_HEADSET = -2147483136;
    public static final int DEVICE_IN_BACK_MIC = -2147483520;
    public static final int DEVICE_IN_BLUETOOTH_SCO_HEADSET = -2147483640;
    public static final int DEVICE_IN_BUILTIN_MIC = -2147483644;
    public static final int DEVICE_IN_DGTL_DOCK_HEADSET = -2147482624;
    public static final int DEVICE_IN_FM_TUNER = -2147475456;
    public static final int DEVICE_IN_HDMI = -2147483616;
    public static final int DEVICE_IN_LINE = -2147450880;
    public static final int DEVICE_IN_LOOPBACK = -2147221504;
    public static final int DEVICE_IN_SPDIF = -2147418112;
    public static final int DEVICE_IN_TELEPHONY_RX = -2147483584;
    public static final int DEVICE_IN_TV_TUNER = -2147467264;
    public static final int DEVICE_IN_USB_ACCESSORY = -2147481600;
    public static final int DEVICE_IN_USB_DEVICE = -2147479552;
    public static final int DEVICE_IN_WIRED_HEADSET = -2147483632;
    public static final int DEVICE_NONE = 0;
    public static final int DEVICE_OUT_ANLG_DOCK_HEADSET = 2048;
    public static final int DEVICE_OUT_AUX_DIGITAL = 1024;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP = 128;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    public static final int DEVICE_OUT_BLUETOOTH_SCO = 16;
    public static final int DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    public static final int DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    public static final int DEVICE_OUT_DEFAULT = 0x40000000;
    public static final int DEVICE_OUT_DGTL_DOCK_HEADSET = 4096;
    public static final int DEVICE_OUT_EARPIECE = 1;
    public static final int DEVICE_OUT_FM = 0x100000;
    public static final int DEVICE_OUT_HDMI = 1024;
    public static final int DEVICE_OUT_HDMI_ARC = 262144;
    public static final int DEVICE_OUT_LINE = 131072;
    public static final int DEVICE_OUT_REMOTE_SUBMIX = 32768;
    public static final int DEVICE_OUT_SPDIF = 524288;
    public static final int DEVICE_OUT_SPEAKER = 2;
    public static final int DEVICE_OUT_TELEPHONY_TX = 65536;
    public static final int DEVICE_OUT_USB_ACCESSORY = 8192;
    public static final int DEVICE_OUT_USB_DEVICE = 16384;
    public static final int DEVICE_OUT_WIRED_HEADPHONE = 8;
    public static final int DEVICE_OUT_WIRED_HEADSET = 4;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -2;
    public static final int ERROR_DEAD_OBJECT = -6;
    public static final int ERROR_INVALID_OPERATION = -3;
    public static final int ERROR_NO_INIT = -5;
    public static final int ERROR_PERMISSION_DENIED = -4;
    public static final String EXTRA_AUDIO_PLUG_STATE = "android.media.extra.AUDIO_PLUG_STATE";
    public static final String EXTRA_ENCODINGS = "android.media.extra.ENCODINGS";
    public static final String EXTRA_MASTER_VOLUME_MUTED = "android.media.EXTRA_MASTER_VOLUME_MUTED";
    public static final String EXTRA_MASTER_VOLUME_VALUE = "android.media.EXTRA_MASTER_VOLUME_VALUE";
    public static final String EXTRA_MAX_CHANNEL_COUNT = "android.media.extra.MAX_CHANNEL_COUNT";
    public static final String EXTRA_PREV_MASTER_VOLUME_VALUE = "android.media.EXTRA_PREV_MASTER_VOLUME_VALUE";
    public static final String EXTRA_PREV_VOLUME_STREAM_VALUE = "android.media.EXTRA_PREV_VOLUME_STREAM_VALUE";
    public static final String EXTRA_RINGER_MODE = "android.media.EXTRA_RINGER_MODE";
    public static final String EXTRA_SCO_AUDIO_PREVIOUS_STATE = "android.media.extra.SCO_AUDIO_PREVIOUS_STATE";
    public static final String EXTRA_SCO_AUDIO_STATE = "android.media.extra.SCO_AUDIO_STATE";
    public static final String EXTRA_VIBRATE_SETTING = "android.media.EXTRA_VIBRATE_SETTING";
    public static final String EXTRA_VIBRATE_TYPE = "android.media.EXTRA_VIBRATE_TYPE";
    public static final String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    public static final String EXTRA_VOLUME_STREAM_VALUE = "android.media.EXTRA_VOLUME_STREAM_VALUE";
    public static final int FLAG_ACTIVE_MEDIA_ONLY = 512;
    public static final int FLAG_ALLOW_RINGER_MODES = 2;
    public static final int FLAG_BLUETOOTH_ABS_VOLUME = 64;
    public static final int FLAG_FIXED_VOLUME = 32;
    public static final int FLAG_HDMI_SYSTEM_AUDIO_VOLUME = 256;
    public static final int FLAG_PLAY_SOUND = 4;
    public static final int FLAG_REMOVE_SOUND_AND_VIBRATE = 8;
    public static final int FLAG_SHOW_SILENT_HINT = 128;
    public static final int FLAG_SHOW_UI = 1;
    public static final int FLAG_SHOW_UI_WARNINGS = 1024;
    public static final int FLAG_VIBRATE = 16;
    public static final int FX_FOCUS_NAVIGATION_DOWN = 2;
    public static final int FX_FOCUS_NAVIGATION_LEFT = 3;
    public static final int FX_FOCUS_NAVIGATION_RIGHT = 4;
    public static final int FX_FOCUS_NAVIGATION_UP = 1;
    public static final int FX_KEYPRESS_DELETE = 7;
    public static final int FX_KEYPRESS_INVALID = 9;
    public static final int FX_KEYPRESS_RETURN = 8;
    public static final int FX_KEYPRESS_SPACEBAR = 6;
    public static final int FX_KEYPRESS_STANDARD = 5;
    public static final int FX_KEY_CLICK = 0;
    public static final String MASTER_MUTE_CHANGED_ACTION = "android.media.MASTER_MUTE_CHANGED_ACTION";
    public static final String MASTER_VOLUME_CHANGED_ACTION = "android.media.MASTER_VOLUME_CHANGED_ACTION";
    public static final int MODE_CURRENT = -1;
    public static final int MODE_INVALID = -2;
    public static final int MODE_IN_CALL = 2;
    public static final int MODE_IN_COMMUNICATION = 3;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_RINGTONE = 1;
    public static final int NUM_SOUND_EFFECTS = 10;
    @Deprecated
    public static final int NUM_STREAMS = 5;
    public static final String PROPERTY_OUTPUT_FRAMES_PER_BUFFER = "android.media.property.OUTPUT_FRAMES_PER_BUFFER";
    public static final String PROPERTY_OUTPUT_SAMPLE_RATE = "android.media.property.OUTPUT_SAMPLE_RATE";
    public static final String RINGER_MODE_CHANGED_ACTION = "android.media.RINGER_MODE_CHANGED";
    private static final int RINGER_MODE_MAX = 2;
    public static final int RINGER_MODE_NORMAL = 2;
    public static final int RINGER_MODE_SILENT = 0;
    public static final int RINGER_MODE_VIBRATE = 1;
    @Deprecated
    public static final int ROUTE_ALL = -1;
    @Deprecated
    public static final int ROUTE_BLUETOOTH = 4;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_A2DP = 16;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_SCO = 4;
    @Deprecated
    public static final int ROUTE_EARPIECE = 1;
    @Deprecated
    public static final int ROUTE_HEADSET = 8;
    @Deprecated
    public static final int ROUTE_SPEAKER = 2;
    public static final int SCO_AUDIO_STATE_CONNECTED = 1;
    public static final int SCO_AUDIO_STATE_CONNECTING = 2;
    public static final int SCO_AUDIO_STATE_DISCONNECTED = 0;
    public static final int SCO_AUDIO_STATE_ERROR = -1;
    public static final int STREAM_ALARM = 4;
    public static final int STREAM_BLUETOOTH_SCO = 6;
    public static final int STREAM_DTMF = 8;
    public static final int STREAM_MUSIC = 3;
    public static final int STREAM_NOTIFICATION = 5;
    public static final int STREAM_RING = 2;
    public static final int STREAM_SYSTEM = 1;
    public static final int STREAM_SYSTEM_ENFORCED = 7;
    public static final int STREAM_TTS = 9;
    public static final int STREAM_VOICE_CALL = 0;
    public static final int SUCCESS = 0;
    private static String TAG;
    public static final int USE_DEFAULT_STREAM_TYPE = Integer.MIN_VALUE;
    public static final String VIBRATE_SETTING_CHANGED_ACTION = "android.media.VIBRATE_SETTING_CHANGED";
    public static final int VIBRATE_SETTING_OFF = 0;
    public static final int VIBRATE_SETTING_ON = 1;
    public static final int VIBRATE_SETTING_ONLY_SILENT = 2;
    public static final int VIBRATE_TYPE_NOTIFICATION = 1;
    public static final int VIBRATE_TYPE_RINGER = 0;
    public static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    private static IAudioService sService;
    private final IAudioFocusDispatcher mAudioFocusDispatcher;
    private final FocusEventHandlerDelegate mAudioFocusEventHandlerDelegate;
    private final HashMap<String, OnAudioFocusChangeListener> mAudioFocusIdListenerMap;
    ArrayList<AudioPatch> mAudioPatchesCached;
    AudioPortEventHandler mAudioPortEventHandler;
    Integer mAudioPortGeneration;
    ArrayList<AudioPort> mAudioPortsCached;
    private final Context mContext;
    private final Object mFocusListenerLock;
    private final IBinder mICallBack;
    private final Binder mToken = new Binder();
    private final boolean mUseFixedVolume;
    private final boolean mUseMasterVolume;
    private final boolean mUseVolumeKeySounds;
    private long mVolumeKeyUpTime;

    static {
        TAG = "AudioManager";
        DEFAULT_STREAM_VOLUME = new int[]{4, 7, 5, 11, 6, 3, 7, 7, 11, 11};
    }

    public AudioManager(Context context) {
        this.mAudioFocusIdListenerMap = new HashMap();
        this.mFocusListenerLock = new Object();
        this.mAudioFocusEventHandlerDelegate = new FocusEventHandlerDelegate();
        this.mAudioFocusDispatcher = new IAudioFocusDispatcher.Stub(){

            @Override
            public void dispatchAudioFocusChange(int n, String string2) {
                Message message = AudioManager.this.mAudioFocusEventHandlerDelegate.getHandler().obtainMessage(n, string2);
                AudioManager.this.mAudioFocusEventHandlerDelegate.getHandler().sendMessage(message);
            }
        };
        this.mICallBack = new Binder();
        this.mAudioPortGeneration = new Integer(0);
        this.mAudioPortsCached = new ArrayList();
        this.mAudioPatchesCached = new ArrayList();
        this.mContext = context;
        this.mUseMasterVolume = this.mContext.getResources().getBoolean(0x1120010);
        this.mUseVolumeKeySounds = this.mContext.getResources().getBoolean(0x1120011);
        this.mAudioPortEventHandler = new AudioPortEventHandler(this);
        this.mUseFixedVolume = this.mContext.getResources().getBoolean(17956969);
    }

    private OnAudioFocusChangeListener findFocusListener(String string2) {
        return this.mAudioFocusIdListenerMap.get(string2);
    }

    private String getIdForAudioFocusListener(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        if (onAudioFocusChangeListener == null) {
            return new String(this.toString());
        }
        return new String(this.toString() + onAudioFocusChangeListener.toString());
    }

    private static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        sService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
        return sService;
    }

    public static boolean isInputDevice(int n) {
        return (n & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public static boolean isOutputDevice(int n) {
        return (Integer.MIN_VALUE & n) == 0;
    }

    public static boolean isValidRingerMode(int n) {
        return n >= 0 && n <= 2;
    }

    private boolean querySoundEffectsEnabled(int n) {
        int n2 = Settings.System.getIntForUser(this.mContext.getContentResolver(), "sound_effects_enabled", 0, n);
        boolean bl = false;
        if (n2 != 0) {
            bl = true;
        }
        return bl;
    }

    public int abandonAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        this.unregisterAudioFocusListener(onAudioFocusChangeListener);
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n = iAudioService.abandonAudioFocus(this.mAudioFocusDispatcher, this.getIdForAudioFocusListener(onAudioFocusChangeListener));
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Can't call abandonAudioFocus() on AudioService due to " + remoteException);
            return 0;
        }
    }

    public void abandonAudioFocusForCall() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.abandonAudioFocus(null, "AudioFocus_For_Phone_Ring_And_Calls");
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Can't call abandonAudioFocusForCall() on AudioService due to " + remoteException);
            return;
        }
    }

    public void adjustMasterVolume(int n, int n2) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.adjustMasterVolume(n, n2, this.mContext.getOpPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in adjustMasterVolume", remoteException);
            return;
        }
    }

    public void adjustStreamVolume(int n, int n2, int n3) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                iAudioService.adjustMasterVolume(n2, n3, this.mContext.getOpPackageName());
                return;
            }
            iAudioService.adjustStreamVolume(n, n2, n3, this.mContext.getOpPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in adjustStreamVolume", remoteException);
            return;
        }
    }

    public void adjustSuggestedStreamVolume(int n, int n2, int n3) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                iAudioService.adjustMasterVolume(n, n3, this.mContext.getOpPackageName());
                return;
            }
            MediaSessionLegacyHelper.getHelper(this.mContext).sendAdjustVolumeBy(n2, n, n3);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in adjustSuggestedStreamVolume", remoteException);
            return;
        }
    }

    public void adjustVolume(int n, int n2) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                iAudioService.adjustMasterVolume(n, n2, this.mContext.getOpPackageName());
                return;
            }
            MediaSessionLegacyHelper.getHelper(this.mContext).sendAdjustVolumeBy(Integer.MIN_VALUE, n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in adjustVolume", remoteException);
            return;
        }
    }

    public void avrcpSupportsAbsoluteVolume(String string2, boolean bl) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.avrcpSupportsAbsoluteVolume(string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in avrcpSupportsAbsoluteVolume", remoteException);
            return;
        }
    }

    public int createAudioPatch(AudioPatch[] audioPatchArray, AudioPortConfig[] audioPortConfigArray, AudioPortConfig[] audioPortConfigArray2) {
        return AudioSystem.createAudioPatch(audioPatchArray, audioPortConfigArray, audioPortConfigArray2);
    }

    public void disableSafeMediaVolume() {
        try {
            AudioManager.getService().disableSafeMediaVolume();
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Error disabling safe media volume", remoteException);
            return;
        }
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        MediaSessionLegacyHelper.getHelper(this.mContext).sendMediaButtonEvent(keyEvent, false);
    }

    public void forceVolumeControlStream(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.forceVolumeControlStream(n, this.mICallBack);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in forceVolumeControlStream", remoteException);
            return;
        }
    }

    public int generateAudioSessionId() {
        int n = AudioSystem.newAudioSessionId();
        if (n > 0) {
            return n;
        }
        Log.e(TAG, "Failure to generate a new audio session ID");
        return -1;
    }

    public int getDevicesForStream(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
        }
        return AudioSystem.getDevicesForStream(n);
    }

    public int getLastAudibleMasterVolume() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n = iAudioService.getLastAudibleMasterVolume();
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in getLastAudibleMasterVolume", remoteException);
            return 0;
        }
    }

    public int getLastAudibleStreamVolume(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                return iAudioService.getLastAudibleMasterVolume();
            }
            int n2 = iAudioService.getLastAudibleStreamVolume(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in getLastAudibleStreamVolume", remoteException);
            return 0;
        }
    }

    public int getMasterMaxVolume() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n = iAudioService.getMasterMaxVolume();
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in getMasterMaxVolume", remoteException);
            return 0;
        }
    }

    public int getMasterStreamType() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n = iAudioService.getMasterStreamType();
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in getMasterStreamType", remoteException);
            return 2;
        }
    }

    public int getMasterVolume() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n = iAudioService.getMasterVolume();
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in getMasterVolume", remoteException);
            return 0;
        }
    }

    public int getMode() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n = iAudioService.getMode();
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in getMode", remoteException);
            return -2;
        }
    }

    public int getOutputLatency(int n) {
        return AudioSystem.getOutputLatency(n);
    }

    public String getParameters(String string2) {
        return AudioSystem.getParameters(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getProperty(String string2) {
        String string3;
        if (PROPERTY_OUTPUT_SAMPLE_RATE.equals(string2)) {
            int n = AudioSystem.getPrimaryOutputSamplingRate();
            string3 = null;
            if (n <= 0) return string3;
            return Integer.toString(n);
        }
        boolean bl = PROPERTY_OUTPUT_FRAMES_PER_BUFFER.equals(string2);
        string3 = null;
        if (!bl) return string3;
        int n = AudioSystem.getPrimaryOutputFrameCount();
        string3 = null;
        if (n <= 0) return string3;
        return Integer.toString(n);
    }

    public int getRingerMode() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n = iAudioService.getRingerMode();
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in getRingerMode", remoteException);
            return 2;
        }
    }

    public IRingtonePlayer getRingtonePlayer() {
        try {
            IRingtonePlayer iRingtonePlayer = AudioManager.getService().getRingtonePlayer();
            return iRingtonePlayer;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Deprecated
    public int getRouting(int n) {
        return -1;
    }

    public int getStreamMaxVolume(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                return iAudioService.getMasterMaxVolume();
            }
            int n2 = iAudioService.getStreamMaxVolume(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in getStreamMaxVolume", remoteException);
            return 0;
        }
    }

    public int getStreamVolume(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                return iAudioService.getMasterVolume();
            }
            int n2 = iAudioService.getStreamVolume(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in getStreamVolume", remoteException);
            return 0;
        }
    }

    public int getVibrateSetting(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n2 = iAudioService.getVibrateSetting(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in getVibrateSetting", remoteException);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleKeyDown(KeyEvent keyEvent, int n) {
        boolean bl = true;
        int n2 = keyEvent.getKeyCode();
        switch (n2) {
            default: {
                return;
            }
            case 24: 
            case 25: {
                int n3;
                if (this.mUseMasterVolume) {
                    int n4;
                    if (n2 != 24) {
                        n4 = -1;
                    }
                    this.adjustMasterVolume(n4, 17);
                    return;
                }
                if (n2 != 24) {
                    n3 = -1;
                }
                this.adjustSuggestedStreamVolume(n3, n, 17);
                return;
            }
            case 164: {
                boolean bl2;
                if (keyEvent.getRepeatCount() != 0 || !this.mUseMasterVolume) return;
                if (this.isMasterMute()) {
                    bl2 = false;
                }
                this.setMasterMute(bl2);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleKeyUp(KeyEvent keyEvent, int n) {
        switch (keyEvent.getKeyCode()) {
            default: {
                return;
            }
            case 24: 
            case 25: 
        }
        if (this.mUseVolumeKeySounds) {
            if (this.mUseMasterVolume) {
                this.adjustMasterVolume(0, 4);
            } else {
                this.adjustSuggestedStreamVolume(0, n, 4);
            }
        }
        this.mVolumeKeyUpTime = SystemClock.uptimeMillis();
    }

    public boolean isAudioFocusExclusive() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n = iAudioService.getCurrentAudioFocus();
            boolean bl = false;
            if (n == 4) {
                bl = true;
            }
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in isAudioFocusExclusive()", remoteException);
            return false;
        }
    }

    public boolean isBluetoothA2dpOn() {
        return AudioSystem.getDeviceConnectionState(128, "") != 0;
    }

    public boolean isBluetoothScoAvailableOffCall() {
        return this.mContext.getResources().getBoolean(17956927);
    }

    public boolean isBluetoothScoOn() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            boolean bl = iAudioService.isBluetoothScoOn();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in isBluetoothScoOn", remoteException);
            return false;
        }
    }

    public boolean isHdmiSystemAudioSupported() {
        try {
            boolean bl = AudioManager.getService().isHdmiSystemAudioSupported();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Error querying system audio mode", remoteException);
            return false;
        }
    }

    public boolean isMasterMute() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            boolean bl = iAudioService.isMasterMute();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in isMasterMute", remoteException);
            return false;
        }
    }

    public boolean isMicrophoneMute() {
        return AudioSystem.isMicrophoneMuted();
    }

    public boolean isMusicActive() {
        return AudioSystem.isStreamActive(3, 0);
    }

    public boolean isMusicActiveRemotely() {
        return AudioSystem.isStreamActiveRemotely(3, 0);
    }

    public boolean isSilentMode() {
        int n = this.getRingerMode();
        return n == 0 || n == 1;
    }

    public boolean isSpeakerphoneOn() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            boolean bl = iAudioService.isSpeakerphoneOn();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in isSpeakerphoneOn", remoteException);
            return false;
        }
    }

    public boolean isStreamAffectedByRingerMode(int n) {
        try {
            boolean bl = AudioManager.getService().isStreamAffectedByRingerMode(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Error calling isStreamAffectedByRingerMode", remoteException);
            return false;
        }
    }

    public boolean isStreamMute(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            boolean bl = iAudioService.isStreamMute(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in isStreamMute", remoteException);
            return false;
        }
    }

    public boolean isVolumeFixed() {
        return this.mUseFixedVolume;
    }

    public boolean isWiredHeadsetOn() {
        return AudioSystem.getDeviceConnectionState(4, "") != 0 || AudioSystem.getDeviceConnectionState(8, "") != 0;
    }

    public int listAudioDevicePorts(ArrayList<AudioPort> arrayList) {
        ArrayList<AudioPort> arrayList2 = new ArrayList<AudioPort>();
        int n = this.updateAudioPortCache(arrayList2, null);
        if (n == 0) {
            arrayList.clear();
            for (int i = 0; i < arrayList2.size(); ++i) {
                if (!(arrayList2.get(i) instanceof AudioDevicePort)) continue;
                arrayList.add(arrayList2.get(i));
            }
        }
        return n;
    }

    public int listAudioPatches(ArrayList<AudioPatch> arrayList) {
        return this.updateAudioPortCache(null, arrayList);
    }

    public int listAudioPorts(ArrayList<AudioPort> arrayList) {
        return this.updateAudioPortCache(arrayList, null);
    }

    public void loadSoundEffects() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.loadSoundEffects();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in loadSoundEffects" + remoteException);
            return;
        }
    }

    public void notifyVolumeControllerVisible(IVolumeController iVolumeController, boolean bl) {
        try {
            AudioManager.getService().notifyVolumeControllerVisible(iVolumeController, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Error notifying about volume controller visibility", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void playSoundEffect(int n) {
        if (n < 0 || n >= 10 || !this.querySoundEffectsEnabled(Process.myUserHandle().getIdentifier())) {
            return;
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.playSoundEffect(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in playSoundEffect" + remoteException);
            return;
        }
    }

    public void playSoundEffect(int n, float f) {
        if (n < 0 || n >= 10) {
            return;
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.playSoundEffectVolume(n, f);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in playSoundEffect" + remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void playSoundEffect(int n, int n2) {
        if (n < 0 || n >= 10 || !this.querySoundEffectsEnabled(n2)) {
            return;
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.playSoundEffect(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in playSoundEffect" + remoteException);
            return;
        }
    }

    public void preDispatchKeyEvent(KeyEvent keyEvent, int n) {
        block3: {
            block2: {
                int n2 = keyEvent.getKeyCode();
                if (n2 == 25 || n2 == 24 || n2 == 164 || 300L + this.mVolumeKeyUpTime <= SystemClock.uptimeMillis()) break block2;
                if (!this.mUseMasterVolume) break block3;
                this.adjustMasterVolume(0, 8);
            }
            return;
        }
        this.adjustSuggestedStreamVolume(0, n, 8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerAudioFocusListener(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        Object object = this.mFocusListenerLock;
        synchronized (object) {
            if (this.mAudioFocusIdListenerMap.containsKey(this.getIdForAudioFocusListener(onAudioFocusChangeListener))) {
                return;
            }
            this.mAudioFocusIdListenerMap.put(this.getIdForAudioFocusListener(onAudioFocusChangeListener), onAudioFocusChangeListener);
            return;
        }
    }

    public int registerAudioPolicy(AudioPolicy audioPolicy) {
        if (audioPolicy == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy argument");
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            boolean bl = iAudioService.registerAudioPolicy(audioPolicy.getConfig(), audioPolicy.token());
            if (!bl) {
                return -1;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in registerAudioPolicyAsync()", remoteException);
            return -1;
        }
        return 0;
    }

    public void registerAudioPortUpdateListener(OnAudioPortUpdateListener onAudioPortUpdateListener) {
        this.mAudioPortEventHandler.registerListener(onAudioPortUpdateListener);
    }

    @Deprecated
    public void registerMediaButtonEventReceiver(PendingIntent pendingIntent) {
        if (pendingIntent == null) {
            return;
        }
        this.registerMediaButtonIntent(pendingIntent, null);
    }

    @Deprecated
    public void registerMediaButtonEventReceiver(ComponentName componentName) {
        if (componentName == null) {
            return;
        }
        if (!componentName.getPackageName().equals(this.mContext.getPackageName())) {
            Log.e(TAG, "registerMediaButtonEventReceiver() error: receiver and context package names don't match");
            return;
        }
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        this.registerMediaButtonIntent(PendingIntent.getBroadcast(this.mContext, 0, intent, 0), componentName);
    }

    public void registerMediaButtonIntent(PendingIntent pendingIntent, ComponentName componentName) {
        if (pendingIntent == null) {
            Log.e(TAG, "Cannot call registerMediaButtonIntent() with a null parameter");
            return;
        }
        MediaSessionLegacyHelper.getHelper(this.mContext).addMediaButtonListener(pendingIntent, componentName, this.mContext);
    }

    @Deprecated
    public void registerRemoteControlClient(RemoteControlClient remoteControlClient) {
        if (remoteControlClient == null || remoteControlClient.getRcMediaIntent() == null) {
            return;
        }
        remoteControlClient.registerWithSession(MediaSessionLegacyHelper.getHelper(this.mContext));
    }

    public void registerRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay) {
        this.registerRemoteControlDisplay(iRemoteControlDisplay, -1, -1);
    }

    public void registerRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        if (iRemoteControlDisplay == null) {
            return;
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.registerRemoteControlDisplay(iRemoteControlDisplay, n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in registerRemoteControlDisplay " + remoteException);
            return;
        }
    }

    @Deprecated
    public boolean registerRemoteController(RemoteController remoteController) {
        if (remoteController == null) {
            return false;
        }
        remoteController.startListeningToSessions();
        return true;
    }

    public int releaseAudioPatch(AudioPatch audioPatch) {
        return AudioSystem.releaseAudioPatch(audioPatch);
    }

    public void reloadAudioSettings() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.reloadAudioSettings();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in reloadAudioSettings" + remoteException);
            return;
        }
    }

    public void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        if (iRemoteControlDisplay == null) {
            return;
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.remoteControlDisplayUsesBitmapSize(iRemoteControlDisplay, n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in remoteControlDisplayUsesBitmapSize " + remoteException);
            return;
        }
    }

    public void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay iRemoteControlDisplay, boolean bl) {
        if (iRemoteControlDisplay == null) {
            return;
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.remoteControlDisplayWantsPlaybackPositionSync(iRemoteControlDisplay, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in remoteControlDisplayWantsPlaybackPositionSync " + remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int requestAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener, int n, int n2) {
        if (n2 < 1 || n2 > 4) {
            Log.e(TAG, "Invalid duration hint, audio focus request denied");
            return 0;
        }
        this.registerAudioFocusListener(onAudioFocusChangeListener);
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n3 = iAudioService.requestAudioFocus(n, n2, this.mICallBack, this.mAudioFocusDispatcher, this.getIdForAudioFocusListener(onAudioFocusChangeListener), this.mContext.getOpPackageName());
            return n3;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Can't call requestAudioFocus() on AudioService due to " + remoteException);
            return 0;
        }
    }

    public void requestAudioFocusForCall(int n, int n2) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.requestAudioFocus(n, n2, this.mICallBack, null, "AudioFocus_For_Phone_Ring_And_Calls", this.mContext.getOpPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Can't call requestAudioFocusForCall() on AudioService due to " + remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int resetAudioPortGeneration() {
        Integer n = this.mAudioPortGeneration;
        synchronized (n) {
            int n2 = this.mAudioPortGeneration;
            this.mAudioPortGeneration = 0;
            return n2;
        }
    }

    public int setAudioPortGain(AudioPort audioPort, AudioGainConfig audioGainConfig) {
        if (audioPort == null || audioGainConfig == null) {
            return -2;
        }
        AudioPortConfig audioPortConfig = audioPort.activeConfig();
        AudioPortConfig audioPortConfig2 = new AudioPortConfig(audioPort, audioPortConfig.samplingRate(), audioPortConfig.channelMask(), audioPortConfig.format(), audioGainConfig);
        audioPortConfig2.mConfigMask = 8;
        return AudioSystem.setAudioPortConfig(audioPortConfig2);
    }

    public int setBluetoothA2dpDeviceConnectionState(BluetoothDevice bluetoothDevice, int n, int n2) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            int n3 = iAudioService.setBluetoothA2dpDeviceConnectionState(bluetoothDevice, n, n2);
            return n3;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setBluetoothA2dpDeviceConnectionState " + remoteException);
        }
        finally {
            return 0;
        }
    }

    @Deprecated
    public void setBluetoothA2dpOn(boolean bl) {
    }

    public void setBluetoothScoOn(boolean bl) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setBluetoothScoOn(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setBluetoothScoOn", remoteException);
            return;
        }
    }

    public int setHdmiSystemAudioSupported(boolean bl) {
        try {
            int n = AudioManager.getService().setHdmiSystemAudioSupported(bl);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Error setting system audio mode", remoteException);
            return 0;
        }
    }

    public void setMasterMute(boolean bl) {
        this.setMasterMute(bl, 1);
    }

    public void setMasterMute(boolean bl, int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setMasterMute(bl, n, this.mContext.getOpPackageName(), this.mICallBack);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setMasterMute", remoteException);
            return;
        }
    }

    public void setMasterVolume(int n, int n2) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setMasterVolume(n, n2, this.mContext.getOpPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setMasterVolume", remoteException);
            return;
        }
    }

    public void setMicrophoneMute(boolean bl) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setMicrophoneMute(bl, this.mContext.getOpPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setMicrophoneMute", remoteException);
            return;
        }
    }

    public void setMode(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setMode(n, this.mICallBack);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setMode", remoteException);
            return;
        }
    }

    @Deprecated
    public void setParameter(String string2, String string3) {
        this.setParameters(string2 + "=" + string3);
    }

    public void setParameters(String string2) {
        AudioSystem.setParameters(string2);
    }

    public void setRingerMode(int n) {
        this.setRingerMode(n, true);
    }

    public void setRingerMode(int n, boolean bl) {
        if (!AudioManager.isValidRingerMode(n)) {
            return;
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setRingerMode(n, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setRingerMode", remoteException);
            return;
        }
    }

    @Deprecated
    public void setRouting(int n, int n2, int n3) {
    }

    public void setSpeakerphoneOn(boolean bl) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setSpeakerphoneOn(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setSpeakerphoneOn", remoteException);
            return;
        }
    }

    public void setStreamMute(int n, boolean bl) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setStreamMute(n, bl, this.mICallBack);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setStreamMute", remoteException);
            return;
        }
    }

    public void setStreamSolo(int n, boolean bl) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setStreamSolo(n, bl, this.mICallBack);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setStreamSolo", remoteException);
            return;
        }
    }

    public void setStreamVolume(int n, int n2, int n3) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                iAudioService.setMasterVolume(n2, n3, this.mContext.getOpPackageName());
                return;
            }
            iAudioService.setStreamVolume(n, n2, n3, this.mContext.getOpPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setStreamVolume", remoteException);
            return;
        }
    }

    public void setVibrateSetting(int n, int n2) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setVibrateSetting(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setVibrateSetting", remoteException);
            return;
        }
    }

    public void setVolumeController(IVolumeController iVolumeController) {
        try {
            AudioManager.getService().setVolumeController(iVolumeController);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Error setting volume controller", remoteException);
            return;
        }
    }

    public void setWiredDeviceConnectionState(int n, int n2, String string2) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.setWiredDeviceConnectionState(n, n2, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in setWiredDeviceConnectionState " + remoteException);
            return;
        }
    }

    @Deprecated
    public void setWiredHeadsetOn(boolean bl) {
    }

    public boolean shouldVibrate(int n) {
        IAudioService iAudioService = AudioManager.getService();
        try {
            boolean bl = iAudioService.shouldVibrate(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in shouldVibrate", remoteException);
            return false;
        }
    }

    public void startBluetoothSco() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.startBluetoothSco(this.mICallBack, this.mContext.getApplicationInfo().targetSdkVersion);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in startBluetoothSco", remoteException);
            return;
        }
    }

    public void startBluetoothScoVirtualCall() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.startBluetoothScoVirtualCall(this.mICallBack);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in startBluetoothScoVirtualCall", remoteException);
            return;
        }
    }

    public void stopBluetoothSco() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.stopBluetoothSco(this.mICallBack);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in stopBluetoothSco", remoteException);
            return;
        }
    }

    public void unloadSoundEffects() {
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.unloadSoundEffects();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in unloadSoundEffects" + remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterAudioFocusListener(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        Object object = this.mFocusListenerLock;
        synchronized (object) {
            this.mAudioFocusIdListenerMap.remove(this.getIdForAudioFocusListener(onAudioFocusChangeListener));
            return;
        }
    }

    public void unregisterAudioPolicyAsync(AudioPolicy audioPolicy) {
        if (audioPolicy == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy argument");
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.unregisterAudioPolicyAsync(audioPolicy.token());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in unregisterAudioPolicyAsync()", remoteException);
            return;
        }
    }

    public void unregisterAudioPortUpdateListener(OnAudioPortUpdateListener onAudioPortUpdateListener) {
        this.mAudioPortEventHandler.unregisterListener(onAudioPortUpdateListener);
    }

    @Deprecated
    public void unregisterMediaButtonEventReceiver(PendingIntent pendingIntent) {
        if (pendingIntent == null) {
            return;
        }
        this.unregisterMediaButtonIntent(pendingIntent);
    }

    @Deprecated
    public void unregisterMediaButtonEventReceiver(ComponentName componentName) {
        if (componentName == null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        this.unregisterMediaButtonIntent(PendingIntent.getBroadcast(this.mContext, 0, intent, 0));
    }

    public void unregisterMediaButtonIntent(PendingIntent pendingIntent) {
        MediaSessionLegacyHelper.getHelper(this.mContext).removeMediaButtonListener(pendingIntent);
    }

    @Deprecated
    public void unregisterRemoteControlClient(RemoteControlClient remoteControlClient) {
        if (remoteControlClient == null || remoteControlClient.getRcMediaIntent() == null) {
            return;
        }
        remoteControlClient.unregisterWithSession(MediaSessionLegacyHelper.getHelper(this.mContext));
    }

    public void unregisterRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay) {
        if (iRemoteControlDisplay == null) {
            return;
        }
        IAudioService iAudioService = AudioManager.getService();
        try {
            iAudioService.unregisterRemoteControlDisplay(iRemoteControlDisplay);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Dead object in unregisterRemoteControlDisplay " + remoteException);
            return;
        }
    }

    @Deprecated
    public void unregisterRemoteController(RemoteController remoteController) {
        if (remoteController == null) {
            return;
        }
        remoteController.stopListeningToSessions();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int updateAudioPortCache(ArrayList<AudioPort> arrayList, ArrayList<AudioPatch> arrayList2) {
        Integer n = this.mAudioPortGeneration;
        synchronized (n) {
            if (this.mAudioPortGeneration == 0) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                ArrayList<AudioPort> arrayList3 = new ArrayList<AudioPort>();
                ArrayList<AudioPatch> arrayList4 = new ArrayList<AudioPatch>();
                do {
                    arrayList3.clear();
                    int n2 = AudioSystem.listAudioPorts(arrayList3, nArray2);
                    if (n2 != 0) {
                        return n2;
                    }
                    arrayList4.clear();
                    int n3 = AudioSystem.listAudioPatches(arrayList4, nArray);
                    if (n3 == 0) continue;
                    return n3;
                } while (nArray[0] != nArray2[0]);
                int n4 = 0;
                while (true) {
                    if (n4 < arrayList4.size()) {
                    } else {
                        this.mAudioPortsCached = arrayList3;
                        this.mAudioPatchesCached = arrayList4;
                        this.mAudioPortGeneration = nArray2[0];
                        break;
                    }
                    for (int i = 0; i < arrayList4.get(n4).sources().length; ++i) {
                        AudioPortConfig audioPortConfig = this.updatePortConfig(arrayList4.get(n4).sources()[i], arrayList3);
                        if (audioPortConfig == null) {
                            return -1;
                        }
                        arrayList4.get((int)n4).sources()[i] = audioPortConfig;
                    }
                    for (int i = 0; i < arrayList4.get(n4).sinks().length; ++i) {
                        AudioPortConfig audioPortConfig = this.updatePortConfig(arrayList4.get(n4).sinks()[i], arrayList3);
                        if (audioPortConfig == null) {
                            return -1;
                        }
                        arrayList4.get((int)n4).sinks()[i] = audioPortConfig;
                    }
                    ++n4;
                }
            }
            if (arrayList != null) {
                arrayList.clear();
                arrayList.addAll(this.mAudioPortsCached);
            }
            if (arrayList2 != null) {
                arrayList2.clear();
                arrayList2.addAll(this.mAudioPatchesCached);
            }
            return 0;
        }
    }

    AudioPortConfig updatePortConfig(AudioPortConfig audioPortConfig, ArrayList<AudioPort> arrayList) {
        AudioPort audioPort = audioPortConfig.port();
        int n = 0;
        while (true) {
            block6: {
                block5: {
                    if (n >= arrayList.size()) break block5;
                    if (!arrayList.get(n).handle().equals(audioPort.handle())) break block6;
                    audioPort = arrayList.get(n);
                }
                if (n != arrayList.size()) break;
                Log.e(TAG, "updatePortConfig port not found for handle: " + audioPort.handle().id());
                return null;
            }
            ++n;
        }
        AudioGainConfig audioGainConfig = audioPortConfig.gain();
        if (audioGainConfig != null) {
            audioGainConfig = audioPort.gain(audioGainConfig.index()).buildConfig(audioGainConfig.mode(), audioGainConfig.channelMask(), audioGainConfig.values(), audioGainConfig.rampDurationMs());
        }
        return audioPort.buildConfig(audioPortConfig.samplingRate(), audioPortConfig.channelMask(), audioPortConfig.format(), audioGainConfig);
    }

    private class FocusEventHandlerDelegate {
        private final Handler mHandler;

        FocusEventHandlerDelegate() {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                looper = Looper.getMainLooper();
            }
            if (looper != null) {
                this.mHandler = new Handler(looper){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void handleMessage(Message message) {
                        Object object = AudioManager.this.mFocusListenerLock;
                        // MONITORENTER : object
                        OnAudioFocusChangeListener onAudioFocusChangeListener = AudioManager.this.findFocusListener((String)message.obj);
                        // MONITOREXIT : object
                        if (onAudioFocusChangeListener == null) return;
                        onAudioFocusChangeListener.onAudioFocusChange(message.what);
                    }
                };
                return;
            }
            this.mHandler = null;
        }

        Handler getHandler() {
            return this.mHandler;
        }
    }

    public static interface OnAudioFocusChangeListener {
        public void onAudioFocusChange(int var1);
    }

    public static interface OnAudioPortUpdateListener {
        public void onAudioPatchListUpdate(AudioPatch[] var1);

        public void onAudioPortListUpdate(AudioPort[] var1);

        public void onServiceDied();
    }
}

