/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.inputmethodservice.AbstractInputMethodService;
import android.inputmethodservice.IInputMethodSessionWrapper;
import android.os.Binder;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.InputChannel;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethod;
import android.view.inputmethod.InputMethodSession;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethod;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.IInputSessionCallback;
import com.android.internal.view.InputConnectionWrapper;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class IInputMethodWrapper
extends IInputMethod.Stub
implements HandlerCaller.Callback {
    private static final int DO_ATTACH_TOKEN = 10;
    private static final int DO_CHANGE_INPUTMETHOD_SUBTYPE = 80;
    private static final int DO_CREATE_SESSION = 40;
    private static final int DO_DUMP = 1;
    private static final int DO_HIDE_SOFT_INPUT = 70;
    private static final int DO_RESTART_INPUT = 34;
    private static final int DO_REVOKE_SESSION = 50;
    private static final int DO_SET_INPUT_CONTEXT = 20;
    private static final int DO_SET_SESSION_ENABLED = 45;
    private static final int DO_SHOW_SOFT_INPUT = 60;
    private static final int DO_START_INPUT = 32;
    private static final int DO_UNSET_INPUT_CONTEXT = 30;
    private static final String TAG = "InputMethodWrapper";
    final HandlerCaller mCaller;
    final Context mContext;
    final WeakReference<InputMethod> mInputMethod;
    final WeakReference<AbstractInputMethodService> mTarget;
    final int mTargetSdkVersion;

    public IInputMethodWrapper(AbstractInputMethodService abstractInputMethodService, InputMethod inputMethod) {
        this.mTarget = new WeakReference<AbstractInputMethodService>(abstractInputMethodService);
        this.mContext = abstractInputMethodService.getApplicationContext();
        this.mCaller = new HandlerCaller(this.mContext, null, this, true);
        this.mInputMethod = new WeakReference<InputMethod>(inputMethod);
        this.mTargetSdkVersion = abstractInputMethodService.getApplicationInfo().targetSdkVersion;
    }

    @Override
    public void attachToken(IBinder iBinder) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(10, iBinder));
    }

    @Override
    public void bindInput(InputBinding inputBinding) {
        InputBinding inputBinding2 = new InputBinding(new InputConnectionWrapper(IInputContext.Stub.asInterface(inputBinding.getConnectionToken())), inputBinding);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(20, inputBinding2));
    }

    @Override
    public void changeInputMethodSubtype(InputMethodSubtype inputMethodSubtype) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(80, inputMethodSubtype));
    }

    @Override
    public void createSession(InputChannel inputChannel, IInputSessionCallback iInputSessionCallback) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(40, inputChannel, iInputSessionCallback));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        AbstractInputMethodService abstractInputMethodService = (AbstractInputMethodService)this.mTarget.get();
        if (abstractInputMethodService == null) return;
        if (abstractInputMethodService.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            printWriter.println("Permission Denial: can't dump InputMethodManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOOOO(1, fileDescriptor, printWriter, stringArray, countDownLatch));
        try {
            if (countDownLatch.await(5L, TimeUnit.SECONDS)) return;
            printWriter.println("Timeout waiting for dump");
            return;
        }
        catch (InterruptedException interruptedException) {
            printWriter.println("Interrupted waiting for dump");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeMessage(Message message) {
        int n = 1;
        InputMethod inputMethod = (InputMethod)this.mInputMethod.get();
        if (inputMethod == null && message.what != n) {
            Log.w(TAG, "Input method reference was null, ignoring message: " + message.what);
            return;
        }
        switch (message.what) {
            default: {
                Log.w(TAG, "Unhandled message code: " + message.what);
                return;
            }
            case 1: {
                AbstractInputMethodService abstractInputMethodService = (AbstractInputMethodService)this.mTarget.get();
                if (abstractInputMethodService == null) return;
                SomeArgs someArgs = (SomeArgs)message.obj;
                try {
                    abstractInputMethodService.dump((FileDescriptor)someArgs.arg1, (PrintWriter)someArgs.arg2, (String[])someArgs.arg3);
                }
                catch (RuntimeException runtimeException) {
                    ((PrintWriter)someArgs.arg2).println("Exception: " + runtimeException);
                }
                Object object = someArgs.arg4;
                synchronized (object) {
                    ((CountDownLatch)someArgs.arg4).countDown();
                }
                someArgs.recycle();
                return;
            }
            case 10: {
                inputMethod.attachToken((IBinder)message.obj);
                return;
            }
            case 20: {
                inputMethod.bindInput((InputBinding)message.obj);
                return;
            }
            case 30: {
                inputMethod.unbindInput();
                return;
            }
            case 32: {
                SomeArgs someArgs = (SomeArgs)message.obj;
                IInputContext iInputContext = (IInputContext)someArgs.arg1;
                InputConnectionWrapper inputConnectionWrapper = null;
                if (iInputContext != null) {
                    inputConnectionWrapper = new InputConnectionWrapper(iInputContext);
                }
                EditorInfo editorInfo = (EditorInfo)someArgs.arg2;
                editorInfo.makeCompatible(this.mTargetSdkVersion);
                inputMethod.startInput(inputConnectionWrapper, editorInfo);
                someArgs.recycle();
                return;
            }
            case 34: {
                SomeArgs someArgs = (SomeArgs)message.obj;
                IInputContext iInputContext = (IInputContext)someArgs.arg1;
                InputConnectionWrapper inputConnectionWrapper = null;
                if (iInputContext != null) {
                    inputConnectionWrapper = new InputConnectionWrapper(iInputContext);
                }
                EditorInfo editorInfo = (EditorInfo)someArgs.arg2;
                editorInfo.makeCompatible(this.mTargetSdkVersion);
                inputMethod.restartInput(inputConnectionWrapper, editorInfo);
                someArgs.recycle();
                return;
            }
            case 40: {
                SomeArgs someArgs = (SomeArgs)message.obj;
                inputMethod.createSession(new InputMethodSessionCallbackWrapper(this.mContext, (InputChannel)someArgs.arg1, (IInputSessionCallback)someArgs.arg2));
                someArgs.recycle();
                return;
            }
            case 45: {
                InputMethodSession inputMethodSession = (InputMethodSession)message.obj;
                if (message.arg1 == 0) {
                    n = 0;
                }
                inputMethod.setSessionEnabled(inputMethodSession, n != 0);
                return;
            }
            case 50: {
                inputMethod.revokeSession((InputMethodSession)message.obj);
                return;
            }
            case 60: {
                inputMethod.showSoftInput(message.arg1, (ResultReceiver)message.obj);
                return;
            }
            case 70: {
                inputMethod.hideSoftInput(message.arg1, (ResultReceiver)message.obj);
                return;
            }
            case 80: 
        }
        inputMethod.changeInputMethodSubtype((InputMethodSubtype)message.obj);
    }

    public InputMethod getInternalInputMethod() {
        return (InputMethod)this.mInputMethod.get();
    }

    @Override
    public void hideSoftInput(int n, ResultReceiver resultReceiver) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(70, n, resultReceiver));
    }

    @Override
    public void restartInput(IInputContext iInputContext, EditorInfo editorInfo) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(34, iInputContext, editorInfo));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void revokeSession(IInputMethodSession iInputMethodSession) {
        try {
            InputMethodSession inputMethodSession = ((IInputMethodSessionWrapper)iInputMethodSession).getInternalInputMethodSession();
            if (inputMethodSession == null) {
                Log.w(TAG, "Session is already finished: " + iInputMethodSession);
                return;
            }
            this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(50, inputMethodSession));
            return;
        }
        catch (ClassCastException classCastException) {
            Log.w(TAG, "Incoming session not of correct type: " + iInputMethodSession, classCastException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setSessionEnabled(IInputMethodSession iInputMethodSession, boolean bl) {
        int n;
        HandlerCaller handlerCaller;
        HandlerCaller handlerCaller2;
        InputMethodSession inputMethodSession;
        try {
            inputMethodSession = ((IInputMethodSessionWrapper)iInputMethodSession).getInternalInputMethodSession();
            if (inputMethodSession == null) {
                Log.w(TAG, "Session is already finished: " + iInputMethodSession);
                return;
            }
            handlerCaller2 = this.mCaller;
            handlerCaller = this.mCaller;
            n = bl ? 1 : 0;
        }
        catch (ClassCastException classCastException) {
            Log.w(TAG, "Incoming session not of correct type: " + iInputMethodSession, classCastException);
            return;
        }
        handlerCaller2.executeOrSendMessage(handlerCaller.obtainMessageIO(45, n, inputMethodSession));
    }

    @Override
    public void showSoftInput(int n, ResultReceiver resultReceiver) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(60, n, resultReceiver));
    }

    @Override
    public void startInput(IInputContext iInputContext, EditorInfo editorInfo) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(32, iInputContext, editorInfo));
    }

    @Override
    public void unbindInput() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(30));
    }

    static final class InputMethodSessionCallbackWrapper
    implements InputMethod.SessionCallback {
        final IInputSessionCallback mCb;
        final InputChannel mChannel;
        final Context mContext;

        InputMethodSessionCallbackWrapper(Context context, InputChannel inputChannel, IInputSessionCallback iInputSessionCallback) {
            this.mContext = context;
            this.mChannel = inputChannel;
            this.mCb = iInputSessionCallback;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void sessionCreated(InputMethodSession var1_1) {
            if (var1_1 == null) ** GOTO lbl6
            try {
                var3_2 = new IInputMethodSessionWrapper(this.mContext, var1_1, this.mChannel);
                this.mCb.sessionCreated(var3_2);
                return;
lbl6:
                // 1 sources

                if (this.mChannel != null) {
                    this.mChannel.dispose();
                }
                this.mCb.sessionCreated(null);
                return;
            }
            catch (RemoteException var2_3) {
                return;
            }
        }
    }

    static class Notifier {
        boolean notified;

        Notifier() {
        }
    }
}

