/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputMethodSession;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputMethodSession;

class IInputMethodSessionWrapper
extends IInputMethodSession.Stub
implements HandlerCaller.Callback {
    private static final int DO_APP_PRIVATE_COMMAND = 100;
    private static final int DO_DISPLAY_COMPLETIONS = 65;
    private static final int DO_FINISH_INPUT = 60;
    private static final int DO_FINISH_SESSION = 110;
    private static final int DO_TOGGLE_SOFT_INPUT = 105;
    private static final int DO_UPDATE_CURSOR = 95;
    private static final int DO_UPDATE_CURSOR_ANCHOR_INFO = 99;
    private static final int DO_UPDATE_EXTRACTED_TEXT = 67;
    private static final int DO_UPDATE_SELECTION = 90;
    private static final int DO_VIEW_CLICKED = 115;
    private static final String TAG = "InputMethodWrapper";
    HandlerCaller mCaller;
    InputChannel mChannel;
    InputMethodSession mInputMethodSession;
    ImeInputEventReceiver mReceiver;

    public IInputMethodSessionWrapper(Context context, InputMethodSession inputMethodSession, InputChannel inputChannel) {
        this.mCaller = new HandlerCaller(context, null, this, true);
        this.mInputMethodSession = inputMethodSession;
        this.mChannel = inputChannel;
        if (inputChannel != null) {
            this.mReceiver = new ImeInputEventReceiver(inputChannel, context.getMainLooper());
        }
    }

    private void doFinishSession() {
        this.mInputMethodSession = null;
        if (this.mReceiver != null) {
            this.mReceiver.dispose();
            this.mReceiver = null;
        }
        if (this.mChannel != null) {
            this.mChannel.dispose();
            this.mChannel = null;
        }
    }

    @Override
    public void appPrivateCommand(String string2, Bundle bundle) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(100, string2, bundle));
    }

    @Override
    public void displayCompletions(CompletionInfo[] completionInfoArray) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(65, completionInfoArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void executeMessage(Message message) {
        int n = 1;
        if (this.mInputMethodSession == null) {
            switch (message.what) {
                default: {
                    return;
                }
                case 90: 
                case 100: 
            }
            ((SomeArgs)message.obj).recycle();
            return;
        }
        switch (message.what) {
            default: {
                Log.w(TAG, "Unhandled message code: " + message.what);
                return;
            }
            case 60: {
                this.mInputMethodSession.finishInput();
                return;
            }
            case 65: {
                this.mInputMethodSession.displayCompletions((CompletionInfo[])message.obj);
                return;
            }
            case 67: {
                this.mInputMethodSession.updateExtractedText(message.arg1, (ExtractedText)message.obj);
                return;
            }
            case 90: {
                SomeArgs someArgs = (SomeArgs)message.obj;
                this.mInputMethodSession.updateSelection(someArgs.argi1, someArgs.argi2, someArgs.argi3, someArgs.argi4, someArgs.argi5, someArgs.argi6);
                someArgs.recycle();
                return;
            }
            case 95: {
                this.mInputMethodSession.updateCursor((Rect)message.obj);
                return;
            }
            case 99: {
                this.mInputMethodSession.updateCursorAnchorInfo((CursorAnchorInfo)message.obj);
                return;
            }
            case 100: {
                SomeArgs someArgs = (SomeArgs)message.obj;
                this.mInputMethodSession.appPrivateCommand((String)someArgs.arg1, (Bundle)someArgs.arg2);
                someArgs.recycle();
                return;
            }
            case 105: {
                this.mInputMethodSession.toggleSoftInput(message.arg1, message.arg2);
                return;
            }
            case 110: {
                this.doFinishSession();
                return;
            }
            case 115: 
        }
        InputMethodSession inputMethodSession = this.mInputMethodSession;
        if (message.arg1 != n) {
            n = 0;
        }
        inputMethodSession.viewClicked(n != 0);
    }

    @Override
    public void finishInput() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(60));
    }

    @Override
    public void finishSession() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(110));
    }

    public InputMethodSession getInternalInputMethodSession() {
        return this.mInputMethodSession;
    }

    @Override
    public void toggleSoftInput(int n, int n2) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageII(105, n, n2));
    }

    @Override
    public void updateCursor(Rect rect) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(95, rect));
    }

    @Override
    public void updateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(99, cursorAnchorInfo));
    }

    @Override
    public void updateExtractedText(int n, ExtractedText extractedText) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(67, n, extractedText));
    }

    @Override
    public void updateSelection(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIIIII(90, n, n2, n3, n4, n5, n6));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void viewClicked(boolean bl) {
        HandlerCaller handlerCaller = this.mCaller;
        HandlerCaller handlerCaller2 = this.mCaller;
        int n = bl ? 1 : 0;
        handlerCaller.executeOrSendMessage(handlerCaller2.obtainMessageI(115, n));
    }

    private final class ImeInputEventReceiver
    extends InputEventReceiver
    implements InputMethodSession.EventCallback {
        private final SparseArray<InputEvent> mPendingEvents;

        public ImeInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
            this.mPendingEvents = new SparseArray();
        }

        @Override
        public void finishedEvent(int n, boolean bl) {
            int n2 = this.mPendingEvents.indexOfKey(n);
            if (n2 >= 0) {
                InputEvent inputEvent = this.mPendingEvents.valueAt(n2);
                this.mPendingEvents.removeAt(n2);
                this.finishInputEvent(inputEvent, bl);
            }
        }

        @Override
        public void onInputEvent(InputEvent inputEvent) {
            if (IInputMethodSessionWrapper.this.mInputMethodSession == null) {
                this.finishInputEvent(inputEvent, false);
                return;
            }
            int n = inputEvent.getSequenceNumber();
            this.mPendingEvents.put(n, inputEvent);
            if (inputEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)inputEvent;
                IInputMethodSessionWrapper.this.mInputMethodSession.dispatchKeyEvent(n, keyEvent, this);
                return;
            }
            MotionEvent motionEvent = (MotionEvent)inputEvent;
            if (motionEvent.isFromSource(4)) {
                IInputMethodSessionWrapper.this.mInputMethodSession.dispatchTrackballEvent(n, motionEvent, this);
                return;
            }
            IInputMethodSessionWrapper.this.mInputMethodSession.dispatchGenericMotionEvent(n, motionEvent, this);
        }
    }
}

