/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbInterface;
import android.os.Parcel;
import android.os.Parcelable;

public class UsbConfiguration
implements Parcelable {
    private static final int ATTR_REMOTE_WAKEUP = 32;
    private static final int ATTR_SELF_POWERED = 64;
    public static final Parcelable.Creator<UsbConfiguration> CREATOR = new Parcelable.Creator<UsbConfiguration>(){

        @Override
        public UsbConfiguration createFromParcel(Parcel parcel) {
            int n = parcel.readInt();
            String string2 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            Parcelable[] parcelableArray = parcel.readParcelableArray(UsbInterface.class.getClassLoader());
            UsbConfiguration usbConfiguration = new UsbConfiguration(n, string2, n2, n3);
            usbConfiguration.setInterfaces(parcelableArray);
            return usbConfiguration;
        }

        public UsbConfiguration[] newArray(int n) {
            return new UsbConfiguration[n];
        }
    };
    private final int mAttributes;
    private final int mId;
    private Parcelable[] mInterfaces;
    private final int mMaxPower;
    private final String mName;

    public UsbConfiguration(int n, String string2, int n2, int n3) {
        this.mId = n;
        this.mName = string2;
        this.mAttributes = n2;
        this.mMaxPower = n3;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getId() {
        return this.mId;
    }

    public UsbInterface getInterface(int n) {
        return (UsbInterface)this.mInterfaces[n];
    }

    public int getInterfaceCount() {
        return this.mInterfaces.length;
    }

    public int getMaxPower() {
        return 2 * this.mMaxPower;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isRemoteWakeup() {
        return (0x20 & this.mAttributes) != 0;
    }

    public boolean isSelfPowered() {
        return (0x40 & this.mAttributes) != 0;
    }

    public void setInterfaces(Parcelable[] parcelableArray) {
        this.mInterfaces = parcelableArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("UsbConfiguration[mId=" + this.mId + ",mName=" + this.mName + ",mAttributes=" + this.mAttributes + ",mMaxPower=" + this.mMaxPower + ",mInterfaces=[");
        for (int i = 0; i < this.mInterfaces.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.mInterfaces[i].toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mId);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mAttributes);
        parcel.writeInt(this.mMaxPower);
        parcel.writeParcelableArray(this.mInterfaces, 0);
    }
}

