/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.soundtrigger;

import android.hardware.soundtrigger.SoundTrigger;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.lang.ref.WeakReference;

public class SoundTriggerModule {
    private static final int EVENT_RECOGNITION = 1;
    private static final int EVENT_SERVICE_DIED = 2;
    private static final int EVENT_SERVICE_STATE_CHANGE = 4;
    private static final int EVENT_SOUNDMODEL = 3;
    private NativeEventHandlerDelegate mEventHandlerDelegate;
    private int mId;
    private long mNativeContext;

    SoundTriggerModule(int n, SoundTrigger.StatusListener statusListener, Handler handler) {
        this.mId = n;
        this.mEventHandlerDelegate = new NativeEventHandlerDelegate(statusListener, handler);
        this.native_setup(new WeakReference<SoundTriggerModule>(this));
    }

    private native void native_finalize();

    private native void native_setup(Object var1);

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        Handler handler;
        NativeEventHandlerDelegate nativeEventHandlerDelegate;
        SoundTriggerModule soundTriggerModule = (SoundTriggerModule)((WeakReference)object).get();
        if (soundTriggerModule == null || (nativeEventHandlerDelegate = soundTriggerModule.mEventHandlerDelegate) == null || (handler = nativeEventHandlerDelegate.handler()) == null) {
            return;
        }
        handler.sendMessage(handler.obtainMessage(n, n2, n3, object2));
    }

    public native void detach();

    protected void finalize() {
        this.native_finalize();
    }

    public native int loadSoundModel(SoundTrigger.SoundModel var1, int[] var2);

    public native int startRecognition(int var1, SoundTrigger.RecognitionConfig var2);

    public native int stopRecognition(int var1);

    public native int unloadSoundModel(int var1);

    private class NativeEventHandlerDelegate {
        private final Handler mHandler;

        /*
         * Enabled aggressive block sorting
         */
        NativeEventHandlerDelegate(final SoundTrigger.StatusListener statusListener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : Looper.getMainLooper();
            if (looper != null) {
                this.mHandler = new Handler(looper){

                    /*
                     * Enabled aggressive block sorting
                     */
                    @Override
                    public void handleMessage(Message message) {
                        switch (message.what) {
                            case 1: {
                                if (statusListener == null) return;
                                statusListener.onRecognition((SoundTrigger.RecognitionEvent)message.obj);
                                return;
                            }
                            case 3: {
                                if (statusListener == null) return;
                                statusListener.onSoundModelUpdate((SoundTrigger.SoundModelEvent)message.obj);
                                return;
                            }
                            case 4: {
                                if (statusListener == null) return;
                                statusListener.onServiceStateChange(message.arg1);
                                return;
                            }
                            default: {
                                return;
                            }
                            case 2: 
                        }
                        if (statusListener == null) return;
                        statusListener.onServiceDied();
                    }
                };
                return;
            }
            this.mHandler = null;
        }

        Handler handler() {
            return this.mHandler;
        }
    }
}

