/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiRecordSources;
import android.util.Log;

public class HdmiTimerRecordSources {
    private static final int EXTERNAL_SOURCE_SPECIFIER_EXTERNAL_PHYSICAL_ADDRESS = 5;
    private static final int EXTERNAL_SOURCE_SPECIFIER_EXTERNAL_PLUG = 4;
    public static final int RECORDING_SEQUENCE_REPEAT_FRIDAY = 32;
    private static final int RECORDING_SEQUENCE_REPEAT_MASK = 127;
    public static final int RECORDING_SEQUENCE_REPEAT_MONDAY = 2;
    public static final int RECORDING_SEQUENCE_REPEAT_ONCE_ONLY = 0;
    public static final int RECORDING_SEQUENCE_REPEAT_SATUREDAY = 64;
    public static final int RECORDING_SEQUENCE_REPEAT_SUNDAY = 1;
    public static final int RECORDING_SEQUENCE_REPEAT_THURSDAY = 16;
    public static final int RECORDING_SEQUENCE_REPEAT_TUESDAY = 4;
    public static final int RECORDING_SEQUENCE_REPEAT_WEDNESDAY = 8;
    private static final String TAG = "HdmiTimerRecordingSources";

    private HdmiTimerRecordSources() {
    }

    private static void checkDurationValue(int n, int n2) {
        if (n < 0 || n > 99) {
            throw new IllegalArgumentException("Hour should be in rage of [0, 99]:" + n);
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("minute should be in rage of [0, 59]:" + n2);
        }
    }

    private static void checkTimeValue(int n, int n2) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("Hour should be in rage of [0, 23]:" + n);
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Minute should be in rage of [0, 59]:" + n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkTimerRecordSource(int n, byte[] byArray) {
        boolean bl = true;
        int n2 = -7 + byArray.length;
        switch (n) {
            default: {
                return false;
            }
            case 1: {
                if (7 == n2) return bl;
                return false;
            }
            case 2: {
                if (4 == n2) return bl;
                return false;
            }
            case 3: 
        }
        byte by = byArray[7];
        if (by == 4) {
            if (2 == n2) return bl;
            return false;
        }
        if (by != 5) return false;
        if (3 == n2) return bl;
        return false;
    }

    private static void checkTimerRecordSourceInputs(TimerInfo timerInfo, HdmiRecordSources.RecordSource recordSource) {
        if (timerInfo == null) {
            Log.w(TAG, "TimerInfo should not be null.");
            throw new IllegalArgumentException("TimerInfo should not be null.");
        }
        if (recordSource == null) {
            Log.w(TAG, "source should not be null.");
            throw new IllegalArgumentException("source should not be null.");
        }
    }

    public static Duration durationOf(int n, int n2) {
        HdmiTimerRecordSources.checkDurationValue(n, n2);
        return new Duration(n, n2);
    }

    public static TimerRecordSource ofAnalogueSource(TimerInfo timerInfo, HdmiRecordSources.AnalogueServiceSource analogueServiceSource) {
        HdmiTimerRecordSources.checkTimerRecordSourceInputs(timerInfo, analogueServiceSource);
        return new TimerRecordSource(timerInfo, analogueServiceSource);
    }

    public static TimerRecordSource ofDigitalSource(TimerInfo timerInfo, HdmiRecordSources.DigitalServiceSource digitalServiceSource) {
        HdmiTimerRecordSources.checkTimerRecordSourceInputs(timerInfo, digitalServiceSource);
        return new TimerRecordSource(timerInfo, digitalServiceSource);
    }

    public static TimerRecordSource ofExternalPhysicalAddress(TimerInfo timerInfo, HdmiRecordSources.ExternalPhysicalAddress externalPhysicalAddress) {
        HdmiTimerRecordSources.checkTimerRecordSourceInputs(timerInfo, externalPhysicalAddress);
        return new TimerRecordSource(timerInfo, new ExternalSourceDecorator(externalPhysicalAddress, 5));
    }

    public static TimerRecordSource ofExternalPlug(TimerInfo timerInfo, HdmiRecordSources.ExternalPlugData externalPlugData) {
        HdmiTimerRecordSources.checkTimerRecordSourceInputs(timerInfo, externalPlugData);
        return new TimerRecordSource(timerInfo, new ExternalSourceDecorator(externalPlugData, 4));
    }

    public static Time timeOf(int n, int n2) {
        HdmiTimerRecordSources.checkTimeValue(n, n2);
        return new Time(n, n2);
    }

    public static TimerInfo timerInfoOf(int n, int n2, Time time, Duration duration, int n3) {
        if (n < 0 || n > 31) {
            throw new IllegalArgumentException("Day of month should be in range of [0, 31]:" + n);
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Month of year should be in range of [1, 12]:" + n2);
        }
        HdmiTimerRecordSources.checkTimeValue(time.mHour, time.mMinute);
        HdmiTimerRecordSources.checkDurationValue(duration.mHour, duration.mMinute);
        if (n3 != 0 && (n3 & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException("Invalid reecording sequence value:" + n3);
        }
        return new TimerInfo(n, n2, time, duration, n3);
    }

    public static final class Duration
    extends TimeUnit {
        private Duration(int n, int n2) {
            super(n, n2);
        }
    }

    private static class ExternalSourceDecorator
    extends HdmiRecordSources.RecordSource {
        private final int mExternalSourceSpecifier;
        private final HdmiRecordSources.RecordSource mRecordSource;

        private ExternalSourceDecorator(HdmiRecordSources.RecordSource recordSource, int n) {
            super(recordSource.mSourceType, 1 + recordSource.getDataSize(false));
            this.mRecordSource = recordSource;
            this.mExternalSourceSpecifier = n;
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            byArray[n] = (byte)this.mExternalSourceSpecifier;
            this.mRecordSource.toByteArray(false, byArray, n + 1);
            return this.getDataSize(false);
        }
    }

    public static final class Time
    extends TimeUnit {
        private Time(int n, int n2) {
            super(n, n2);
        }
    }

    private static class TimeUnit {
        protected final int mHour;
        protected final int mMinute;

        protected TimeUnit(int n, int n2) {
            this.mHour = n;
            this.mMinute = n2;
        }

        protected static byte toBcdByte(int n) {
            int n2 = n / 10 % 10;
            return (byte)(n % 10 | n2 << 4);
        }

        protected int toByteArray(byte[] byArray, int n) {
            byArray[n] = TimeUnit.toBcdByte(this.mHour);
            byArray[n + 1] = TimeUnit.toBcdByte(this.mMinute);
            return 2;
        }
    }

    public static final class TimerInfo {
        private static final int BASIC_INFO_SIZE = 7;
        private static final int DAY_OF_MONTH_SIZE = 1;
        private static final int DURATION_SIZE = 2;
        private static final int MONTH_OF_YEAR_SIZE = 1;
        private static final int RECORDING_SEQUENCE_SIZE = 1;
        private static final int START_TIME_SIZE = 2;
        private final int mDayOfMonth;
        private final Duration mDuration;
        private final int mMonthOfYear;
        private final int mRecordingSequence;
        private final Time mStartTime;

        private TimerInfo(int n, int n2, Time time, Duration duration, int n3) {
            this.mDayOfMonth = n;
            this.mMonthOfYear = n2;
            this.mStartTime = time;
            this.mDuration = duration;
            this.mRecordingSequence = n3;
        }

        int getDataSize() {
            return 7;
        }

        int toByteArray(byte[] byArray, int n) {
            byArray[n] = (byte)this.mDayOfMonth;
            int n2 = n + 1;
            byArray[n2] = (byte)this.mMonthOfYear;
            int n3 = n2 + 1;
            int n4 = n3 + this.mStartTime.toByteArray(byArray, n3);
            byArray[n4 + this.mDuration.toByteArray((byte[])byArray, (int)n4)] = (byte)this.mRecordingSequence;
            return this.getDataSize();
        }
    }

    public static final class TimerRecordSource {
        private final HdmiRecordSources.RecordSource mRecordSource;
        private final TimerInfo mTimerInfo;

        private TimerRecordSource(TimerInfo timerInfo, HdmiRecordSources.RecordSource recordSource) {
            this.mTimerInfo = timerInfo;
            this.mRecordSource = recordSource;
        }

        int getDataSize() {
            return this.mTimerInfo.getDataSize() + this.mRecordSource.getDataSize(false);
        }

        int toByteArray(byte[] byArray, int n) {
            int n2 = n + this.mTimerInfo.toByteArray(byArray, n);
            this.mRecordSource.toByteArray(false, byArray, n2);
            return this.getDataSize();
        }
    }
}

