/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.util.Log;

public final class HdmiRecordSources {
    public static final int ANALOGUE_BROADCAST_TYPE_CABLE = 0;
    public static final int ANALOGUE_BROADCAST_TYPE_SATELLITE = 1;
    public static final int ANALOGUE_BROADCAST_TYPE_TERRESTRIAL = 2;
    public static final int BROADCAST_SYSTEM_NTSC_M = 3;
    public static final int BROADCAST_SYSTEM_PAL_BG = 0;
    public static final int BROADCAST_SYSTEM_PAL_DK = 8;
    public static final int BROADCAST_SYSTEM_PAL_I = 4;
    public static final int BROADCAST_SYSTEM_PAL_M = 2;
    public static final int BROADCAST_SYSTEM_PAL_OTHER_SYSTEM = 31;
    public static final int BROADCAST_SYSTEM_SECAM_BG = 6;
    public static final int BROADCAST_SYSTEM_SECAM_DK = 5;
    public static final int BROADCAST_SYSTEM_SECAM_L = 7;
    public static final int BROADCAST_SYSTEM_SECAM_LP = 1;
    private static final int CHANNEL_NUMBER_FORMAT_1_PART = 1;
    private static final int CHANNEL_NUMBER_FORMAT_2_PART = 2;
    public static final int DIGITAL_BROADCAST_TYPE_ARIB = 0;
    public static final int DIGITAL_BROADCAST_TYPE_ARIB_BS = 8;
    public static final int DIGITAL_BROADCAST_TYPE_ARIB_CS = 9;
    public static final int DIGITAL_BROADCAST_TYPE_ARIB_T = 10;
    public static final int DIGITAL_BROADCAST_TYPE_ATSC = 1;
    public static final int DIGITAL_BROADCAST_TYPE_ATSC_CABLE = 16;
    public static final int DIGITAL_BROADCAST_TYPE_ATSC_SATELLITE = 17;
    public static final int DIGITAL_BROADCAST_TYPE_ATSC_TERRESTRIAL = 18;
    public static final int DIGITAL_BROADCAST_TYPE_DVB = 2;
    public static final int DIGITAL_BROADCAST_TYPE_DVB_C = 24;
    public static final int DIGITAL_BROADCAST_TYPE_DVB_S = 25;
    public static final int DIGITAL_BROADCAST_TYPE_DVB_S2 = 26;
    public static final int DIGITAL_BROADCAST_TYPE_DVB_T = 27;
    private static final int RECORD_SOURCE_TYPE_ANALOGUE_SERVICE = 3;
    private static final int RECORD_SOURCE_TYPE_DIGITAL_SERVICE = 2;
    private static final int RECORD_SOURCE_TYPE_EXTERNAL_PHYSICAL_ADDRESS = 5;
    private static final int RECORD_SOURCE_TYPE_EXTERNAL_PLUG = 4;
    private static final int RECORD_SOURCE_TYPE_OWN_SOURCE = 1;
    private static final String TAG = "HdmiRecordSources";

    private HdmiRecordSources() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkRecordSource(byte[] byArray) {
        boolean bl = true;
        byte by = byArray[0];
        boolean bl2 = -1 + byArray.length;
        switch (by) {
            default: {
                return false;
            }
            case 1: {
                if (!bl2) return bl;
                return false;
            }
            case 2: {
                if (bl2) return bl;
                return false;
            }
            case 3: {
                if (bl2) return bl;
                return false;
            }
            case 4: {
                if (bl2 == bl) return bl;
                return false;
            }
            case 5: 
        }
        if (bl2) return bl;
        return false;
    }

    public static AnalogueServiceSource ofAnalogue(int n, int n2, int n3) {
        if (n < 0 || n > 2) {
            Log.w(TAG, "Invalid Broadcast type:" + n);
            throw new IllegalArgumentException("Invalid Broadcast type:" + n);
        }
        if (n2 < 0 || n2 > 65535) {
            Log.w(TAG, "Invalid frequency value[0x0000-0xFFFF]:" + n2);
            throw new IllegalArgumentException("Invalid frequency value[0x0000-0xFFFF]:" + n2);
        }
        if (n3 < 0 || n3 > 31) {
            Log.w(TAG, "Invalid Broadcast system:" + n3);
            throw new IllegalArgumentException("Invalid Broadcast system:" + n3);
        }
        return new AnalogueServiceSource(n, n2, n3);
    }

    public static DigitalServiceSource ofArib(int n, AribData aribData) {
        if (aribData == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (n) {
            default: {
                Log.w(TAG, "Invalid ARIB type:" + n);
                throw new IllegalArgumentException("type should not be null.");
            }
            case 0: 
            case 8: 
            case 9: 
            case 10: 
        }
        return new DigitalServiceSource(0, n, aribData);
    }

    public static DigitalServiceSource ofAtsc(int n, AtscData atscData) {
        if (atscData == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (n) {
            default: {
                Log.w(TAG, "Invalid ATSC type:" + n);
                throw new IllegalArgumentException("Invalid ATSC type:" + n);
            }
            case 1: 
            case 16: 
            case 17: 
            case 18: 
        }
        return new DigitalServiceSource(0, n, atscData);
    }

    public static DigitalServiceSource ofDigitalChannelId(int n, DigitalChannelData digitalChannelData) {
        if (digitalChannelData == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (n) {
            default: {
                Log.w(TAG, "Invalid broadcast type:" + n);
                throw new IllegalArgumentException("Invalid broadcast system value:" + n);
            }
            case 0: 
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
        }
        return new DigitalServiceSource(1, n, digitalChannelData);
    }

    public static DigitalServiceSource ofDvb(int n, DvbData dvbData) {
        if (dvbData == null) {
            throw new IllegalArgumentException("data should not be null.");
        }
        switch (n) {
            default: {
                Log.w(TAG, "Invalid DVB type:" + n);
                throw new IllegalArgumentException("Invalid DVB type:" + n);
            }
            case 2: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
        }
        return new DigitalServiceSource(0, n, dvbData);
    }

    public static ExternalPhysicalAddress ofExternalPhysicalAddress(int n) {
        if ((0xFFFF0000 & n) != 0) {
            Log.w(TAG, "Invalid physical address:" + n);
            throw new IllegalArgumentException("Invalid physical address:" + n);
        }
        return new ExternalPhysicalAddress(n);
    }

    public static ExternalPlugData ofExternalPlug(int n) {
        if (n < 1 || n > 255) {
            Log.w(TAG, "Invalid plug number[1-255]" + n);
            throw new IllegalArgumentException("Invalid plug number[1-255]" + n);
        }
        return new ExternalPlugData(n);
    }

    public static OwnSource ofOwnSource() {
        return new OwnSource();
    }

    private static int shortToByteArray(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(0xFF & s >>> 8);
        byArray[n + 1] = (byte)(s & 0xFF);
        return 2;
    }

    private static int threeFieldsToSixBytes(int n, int n2, int n3, byte[] byArray, int n4) {
        HdmiRecordSources.shortToByteArray((short)n, byArray, n4);
        HdmiRecordSources.shortToByteArray((short)n2, byArray, n4 + 2);
        HdmiRecordSources.shortToByteArray((short)n3, byArray, n4 + 4);
        return 6;
    }

    public static final class AnalogueServiceSource
    extends RecordSource {
        static final int EXTRA_DATA_SIZE = 4;
        private final int mBroadcastSystem;
        private final int mBroadcastType;
        private final int mFrequency;

        private AnalogueServiceSource(int n, int n2, int n3) {
            super(3, 4);
            this.mBroadcastType = n;
            this.mFrequency = n2;
            this.mBroadcastSystem = n3;
        }

        @Override
        protected int extraParamToByteArray(byte[] byArray, int n) {
            byArray[n] = (byte)this.mBroadcastType;
            HdmiRecordSources.shortToByteArray((short)this.mFrequency, byArray, n + 1);
            byArray[n + 3] = (byte)this.mBroadcastSystem;
            return 4;
        }
    }

    public static final class AribData
    implements DigitalServiceIdentification {
        private final int mOriginalNetworkId;
        private final int mServiceId;
        private final int mTransportStreamId;

        public AribData(int n, int n2, int n3) {
            this.mTransportStreamId = n;
            this.mServiceId = n2;
            this.mOriginalNetworkId = n3;
        }

        @Override
        public int toByteArray(byte[] byArray, int n) {
            return HdmiRecordSources.threeFieldsToSixBytes(this.mTransportStreamId, this.mServiceId, this.mOriginalNetworkId, byArray, n);
        }
    }

    public static final class AtscData
    implements DigitalServiceIdentification {
        private final int mProgramNumber;
        private final int mTransportStreamId;

        public AtscData(int n, int n2) {
            this.mTransportStreamId = n;
            this.mProgramNumber = n2;
        }

        @Override
        public int toByteArray(byte[] byArray, int n) {
            return HdmiRecordSources.threeFieldsToSixBytes(this.mTransportStreamId, this.mProgramNumber, 0, byArray, n);
        }
    }

    private static final class ChannelIdentifier {
        private final int mChannelNumberFormat;
        private final int mMajorChannelNumber;
        private final int mMinorChannelNumber;

        private ChannelIdentifier(int n, int n2, int n3) {
            this.mChannelNumberFormat = n;
            this.mMajorChannelNumber = n2;
            this.mMinorChannelNumber = n3;
        }

        private int toByteArray(byte[] byArray, int n) {
            byArray[n] = (byte)(this.mChannelNumberFormat << 2 | 3 & this.mMajorChannelNumber >>> 8);
            byArray[n + 1] = (byte)(0xFF & this.mMajorChannelNumber);
            HdmiRecordSources.shortToByteArray((short)this.mMinorChannelNumber, byArray, n + 2);
            return 4;
        }
    }

    public static final class DigitalChannelData
    implements DigitalServiceIdentification {
        private ChannelIdentifier mChannelIdentifier;

        private DigitalChannelData(ChannelIdentifier channelIdentifier) {
            this.mChannelIdentifier = channelIdentifier;
        }

        public static DigitalChannelData ofOneNumber(int n) {
            return new DigitalChannelData(new ChannelIdentifier(1, 0, n));
        }

        public static DigitalChannelData ofTwoNumbers(int n, int n2) {
            return new DigitalChannelData(new ChannelIdentifier(2, n, n2));
        }

        @Override
        public int toByteArray(byte[] byArray, int n) {
            this.mChannelIdentifier.toByteArray(byArray, n);
            byArray[n + 4] = 0;
            byArray[n + 5] = 0;
            return 6;
        }
    }

    private static interface DigitalServiceIdentification {
        public int toByteArray(byte[] var1, int var2);
    }

    public static final class DigitalServiceSource
    extends RecordSource {
        private static final int DIGITAL_SERVICE_IDENTIFIED_BY_CHANNEL = 1;
        private static final int DIGITAL_SERVICE_IDENTIFIED_BY_DIGITAL_ID = 0;
        static final int EXTRA_DATA_SIZE = 7;
        private final int mBroadcastSystem;
        private final DigitalServiceIdentification mIdentification;
        private final int mIdentificationMethod;

        private DigitalServiceSource(int n, int n2, DigitalServiceIdentification digitalServiceIdentification) {
            super(2, 7);
            this.mIdentificationMethod = n;
            this.mBroadcastSystem = n2;
            this.mIdentification = digitalServiceIdentification;
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            byArray[n] = (byte)(this.mIdentificationMethod << 7 | 0x7F & this.mBroadcastSystem);
            this.mIdentification.toByteArray(byArray, n + 1);
            return 7;
        }
    }

    public static final class DvbData
    implements DigitalServiceIdentification {
        private final int mOriginalNetworkId;
        private final int mServiceId;
        private final int mTransportStreamId;

        public DvbData(int n, int n2, int n3) {
            this.mTransportStreamId = n;
            this.mServiceId = n2;
            this.mOriginalNetworkId = n3;
        }

        @Override
        public int toByteArray(byte[] byArray, int n) {
            return HdmiRecordSources.threeFieldsToSixBytes(this.mTransportStreamId, this.mServiceId, this.mOriginalNetworkId, byArray, n);
        }
    }

    public static final class ExternalPhysicalAddress
    extends RecordSource {
        static final int EXTRA_DATA_SIZE = 2;
        private final int mPhysicalAddress;

        private ExternalPhysicalAddress(int n) {
            super(5, 2);
            this.mPhysicalAddress = n;
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            HdmiRecordSources.shortToByteArray((short)this.mPhysicalAddress, byArray, n);
            return 2;
        }
    }

    public static final class ExternalPlugData
    extends RecordSource {
        static final int EXTRA_DATA_SIZE = 1;
        private final int mPlugNumber;

        private ExternalPlugData(int n) {
            super(4, 1);
            this.mPlugNumber = n;
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            byArray[n] = (byte)this.mPlugNumber;
            return 1;
        }
    }

    public static final class OwnSource
    extends RecordSource {
        private static final int EXTRA_DATA_SIZE;

        private OwnSource() {
            super(1, 0);
        }

        @Override
        int extraParamToByteArray(byte[] byArray, int n) {
            return 0;
        }
    }

    static abstract class RecordSource {
        protected final int mExtraDataSize;
        protected final int mSourceType;

        protected RecordSource(int n, int n2) {
            this.mSourceType = n;
            this.mExtraDataSize = n2;
        }

        abstract int extraParamToByteArray(byte[] var1, int var2);

        final int getDataSize(boolean bl) {
            if (bl) {
                return 1 + this.mExtraDataSize;
            }
            return this.mExtraDataSize;
        }

        final int toByteArray(boolean bl, byte[] byArray, int n) {
            if (bl) {
                int n2 = n + 1;
                byArray[n] = (byte)this.mSourceType;
                n = n2;
            }
            this.extraParamToByteArray(byArray, n);
            return this.getDataSize(bl);
        }
    }
}

