/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.os.Handler;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.HashSet;
import java.util.Set;

public class TaskDrainer<T> {
    private static final String TAG = "TaskDrainer";
    private final boolean VERBOSE = Log.isLoggable("TaskDrainer", 2);
    private boolean mDrainFinished = false;
    private boolean mDraining = false;
    private final Handler mHandler;
    private final DrainListener mListener;
    private final Object mLock;
    private final String mName;
    private final Set<T> mTaskSet = new HashSet<T>();

    public TaskDrainer(Handler handler, DrainListener drainListener) {
        this.mLock = new Object();
        this.mHandler = Preconditions.checkNotNull(handler, "handler must not be null");
        this.mListener = Preconditions.checkNotNull(drainListener, "listener must not be null");
        this.mName = null;
    }

    public TaskDrainer(Handler handler, DrainListener drainListener, String string2) {
        this.mLock = new Object();
        this.mHandler = Preconditions.checkNotNull(handler, "handler must not be null");
        this.mListener = Preconditions.checkNotNull(drainListener, "listener must not be null");
        this.mName = string2;
    }

    private void checkIfDrainFinished() {
        if (this.mTaskSet.isEmpty() && this.mDraining && !this.mDrainFinished) {
            this.mDrainFinished = true;
            this.postDrained();
        }
    }

    private void postDrained() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (TaskDrainer.this.VERBOSE) {
                    Log.v("TaskDrainer[" + TaskDrainer.this.mName + "]", "onDrained");
                }
                TaskDrainer.this.mListener.onDrained();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beginDrain() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mDraining) {
                if (this.VERBOSE) {
                    Log.v("TaskDrainer[" + this.mName + "]", "beginDrain started");
                }
                this.mDraining = true;
                this.checkIfDrainFinished();
            } else if (this.VERBOSE) {
                Log.v("TaskDrainer[" + this.mName + "]", "beginDrain ignored");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void taskFinished(T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.VERBOSE) {
                Log.v("TaskDrainer[" + this.mName + "]", "taskFinished " + t);
            }
            if (!this.mTaskSet.remove(t)) {
                throw new IllegalStateException("Task " + t + " was already finished");
            }
            this.checkIfDrainFinished();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void taskStarted(T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.VERBOSE) {
                Log.v("TaskDrainer[" + this.mName + "]", "taskStarted " + t);
            }
            if (this.mDraining) {
                throw new IllegalStateException("Can't start more tasks after draining has begun");
            }
            if (!this.mTaskSet.add(t)) {
                throw new IllegalStateException("Task " + t + " was already started");
            }
            return;
        }
    }

    public static interface DrainListener {
        public void onDrained();
    }
}

