/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import com.android.internal.util.Preconditions;
import java.util.Arrays;

public final class BlackLevelPattern {
    public static final int COUNT = 4;
    private final int[] mCfaOffsets;

    public BlackLevelPattern(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException("Null offsets array passed to constructor");
        }
        if (nArray.length < 4) {
            throw new IllegalArgumentException("Invalid offsets array length");
        }
        this.mCfaOffsets = Arrays.copyOf(nArray, 4);
    }

    public void copyTo(int[] nArray, int n) {
        Preconditions.checkNotNull(nArray, "destination must not be null");
        if (n < 0) {
            throw new IllegalArgumentException("Null offset passed to copyTo");
        }
        if (nArray.length - n < 4) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        for (int i = 0; i < 4; ++i) {
            nArray[n + i] = this.mCfaOffsets[i];
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == null) break block4;
                if (this == object) {
                    return true;
                }
                if (object instanceof BlackLevelPattern) break block5;
            }
            return false;
        }
        return Arrays.equals(((BlackLevelPattern)object).mCfaOffsets, this.mCfaOffsets);
    }

    public int getOffsetForIndex(int n, int n2) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("column, row arguments must be positive");
        }
        return this.mCfaOffsets[(n2 & 1) << 1 | n & 1];
    }

    public int hashCode() {
        return Arrays.hashCode(this.mCfaOffsets);
    }
}

