/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.ReprocessFormatsMap;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableReprocessFormatsMap
implements MarshalQueryable<ReprocessFormatsMap> {
    @Override
    public Marshaler<ReprocessFormatsMap> createMarshaler(TypeReference<ReprocessFormatsMap> typeReference, int n) {
        return new MarshalerReprocessFormatsMap(typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<ReprocessFormatsMap> typeReference, int n) {
        return n == 1 && typeReference.getType().equals(ReprocessFormatsMap.class);
    }

    private class MarshalerReprocessFormatsMap
    extends Marshaler<ReprocessFormatsMap> {
        protected MarshalerReprocessFormatsMap(TypeReference<ReprocessFormatsMap> typeReference, int n) {
            super(MarshalQueryableReprocessFormatsMap.this, typeReference, n);
        }

        @Override
        public int calculateMarshalSize(ReprocessFormatsMap reprocessFormatsMap) {
            int n = 0;
            for (int n2 : reprocessFormatsMap.getInputs()) {
                n = 1 + (n + 1) + reprocessFormatsMap.getOutputs(n2).length;
            }
            return n * 4;
        }

        @Override
        public int getNativeSize() {
            return NATIVE_SIZE_DYNAMIC;
        }

        @Override
        public void marshal(ReprocessFormatsMap reprocessFormatsMap, ByteBuffer byteBuffer) {
            for (int n : StreamConfigurationMap.imageFormatToInternal(reprocessFormatsMap.getInputs())) {
                byteBuffer.putInt(n);
                int[] nArray = StreamConfigurationMap.imageFormatToInternal(reprocessFormatsMap.getOutputs(n));
                byteBuffer.putInt(nArray.length);
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    byteBuffer.putInt(nArray[i]);
                }
            }
        }

        @Override
        public ReprocessFormatsMap unmarshal(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining() / 4;
            if (byteBuffer.remaining() % 4 != 0) {
                throw new AssertionError((Object)"ReprocessFormatsMap was not TYPE_INT32");
            }
            int[] nArray = new int[n];
            byteBuffer.asIntBuffer().get(nArray);
            return new ReprocessFormatsMap(nArray);
        }
    }
}

