/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class MarshalQueryableParcelable<T extends Parcelable>
implements MarshalQueryable<T> {
    private static final String FIELD_CREATOR = "CREATOR";
    private static final String TAG = "MarshalParcelable";
    private static final boolean VERBOSE = Log.isLoggable("MarshalParcelable", 2);

    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> typeReference, int n) {
        return new MarshalerParcelable(typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<T> typeReference, int n) {
        return Parcelable.class.isAssignableFrom(typeReference.getRawType());
    }

    private class MarshalerParcelable
    extends Marshaler<T> {
        private final Class<T> mClass;
        private final Parcelable.Creator<T> mCreator;

        protected MarshalerParcelable(TypeReference<T> typeReference, int n) {
            Field field;
            super(MarshalQueryableParcelable.this, typeReference, n);
            this.mClass = typeReference.getRawType();
            try {
                field = this.mClass.getDeclaredField(MarshalQueryableParcelable.FIELD_CREATOR);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError((Object)noSuchFieldException);
            }
            try {
                this.mCreator = (Parcelable.Creator)field.get(null);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError((Object)illegalArgumentException);
            }
        }

        @Override
        public int calculateMarshalSize(T t) {
            Parcel parcel = Parcel.obtain();
            try {
                t.writeToParcel(parcel, 0);
                int n = parcel.marshall().length;
                if (VERBOSE) {
                    Log.v(MarshalQueryableParcelable.TAG, "calculateMarshalSize, length when parceling " + t + " is " + n);
                }
                return n;
            }
            finally {
                parcel.recycle();
            }
        }

        @Override
        public int getNativeSize() {
            return NATIVE_SIZE_DYNAMIC;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void marshal(T t, ByteBuffer byteBuffer) {
            byte[] byArray;
            if (VERBOSE) {
                Log.v(MarshalQueryableParcelable.TAG, "marshal " + t);
            }
            Parcel parcel = Parcel.obtain();
            try {
                t.writeToParcel(parcel, 0);
                if (parcel.hasFileDescriptors()) {
                    throw new UnsupportedOperationException("Parcelable " + t + " must not have file descriptors");
                }
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            if (byArray.length == 0) {
                throw new AssertionError((Object)("No data marshaled for " + t));
            }
            byteBuffer.put(byArray);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T unmarshal(ByteBuffer byteBuffer) {
            if (VERBOSE) {
                Log.v(MarshalQueryableParcelable.TAG, "unmarshal, buffer remaining " + byteBuffer.remaining());
            }
            byteBuffer.mark();
            Parcel parcel = Parcel.obtain();
            try {
                int n = byteBuffer.remaining();
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray);
                parcel.unmarshall(byArray, 0, n);
                parcel.setDataPosition(0);
                Parcelable parcelable = (Parcelable)this.mCreator.createFromParcel(parcel);
                int n2 = parcel.dataPosition();
                if (n2 == 0) {
                    throw new AssertionError((Object)("No data marshaled for " + parcelable));
                }
                byteBuffer.reset();
                byteBuffer.position(n2 + byteBuffer.position());
                if (VERBOSE) {
                    Log.v(MarshalQueryableParcelable.TAG, "unmarshal, parcel length was " + n2);
                    Log.v(MarshalQueryableParcelable.TAG, "unmarshal, value is " + parcelable);
                }
                Parcelable parcelable2 = (Parcelable)this.mClass.cast(parcelable);
                return parcelable2;
            }
            finally {
                parcel.recycle();
            }
        }
    }
}

