/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.legacy.CaptureCollector;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.PerfMeasurement;
import android.hardware.camera2.legacy.RequestHolder;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Environment;
import android.os.SystemProperties;
import android.text.format.Time;
import android.util.Log;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SurfaceTextureRenderer {
    private static final boolean DEBUG = false;
    private static final int EGL_COLOR_BITLENGTH = 8;
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final int GLES_VERSION = 2;
    private static final int GL_MATRIX_SIZE = 16;
    private static final String LEGACY_PERF_PROPERTY = "persist.camera.legacy_perf";
    private static final int PBUFFER_PIXEL_BYTES = 4;
    private static final String TAG = SurfaceTextureRenderer.class.getSimpleName();
    private static final int TRIANGLE_VERTICES_DATA_POS_OFFSET = 0;
    private static final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 20;
    private static final int TRIANGLE_VERTICES_DATA_UV_OFFSET = 3;
    private static final int VERTEX_POS_SIZE = 3;
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n";
    private static final int VERTEX_UV_SIZE = 2;
    private static final float[] sBackCameraTriangleVertices;
    private static final float[] sFrontCameraTriangleVertices;
    private EGLConfig mConfigs;
    private List<EGLSurfaceHolder> mConversionSurfaces;
    private EGLContext mEGLContext;
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private float[] mMVPMatrix;
    private ByteBuffer mPBufferPixels;
    private PerfMeasurement mPerfMeasurer = null;
    private int mProgram;
    private float[] mSTMatrix;
    private volatile SurfaceTexture mSurfaceTexture;
    private List<EGLSurfaceHolder> mSurfaces;
    private int mTextureID = 0;
    private FloatBuffer mTriangleVertices;
    private int maPositionHandle;
    private int maTextureHandle;
    private int muMVPMatrixHandle;
    private int muSTMatrixHandle;

    static {
        DEBUG = Log.isLoggable("HAL1ShimLogging", 3);
        sFrontCameraTriangleVertices = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        sBackCameraTriangleVertices = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    }

    /*
     * Enabled aggressive block sorting
     */
    public SurfaceTextureRenderer(int n) {
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.mSurfaces = new ArrayList<EGLSurfaceHolder>();
        this.mConversionSurfaces = new ArrayList<EGLSurfaceHolder>();
        this.mMVPMatrix = new float[16];
        this.mSTMatrix = new float[16];
        if (n == 1) {
            this.mTriangleVertices = ByteBuffer.allocateDirect(4 * sBackCameraTriangleVertices.length).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.mTriangleVertices.put(sBackCameraTriangleVertices).position(0);
        } else {
            this.mTriangleVertices = ByteBuffer.allocateDirect(4 * sFrontCameraTriangleVertices.length).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.mTriangleVertices.put(sFrontCameraTriangleVertices).position(0);
        }
        Matrix.setIdentityM(this.mSTMatrix, 0);
    }

    private void addGlTimestamp(long l) {
        if (this.mPerfMeasurer == null) {
            return;
        }
        this.mPerfMeasurer.addTimestamp(l);
    }

    private void beginGlTiming() {
        if (this.mPerfMeasurer == null) {
            return;
        }
        this.mPerfMeasurer.startTimer();
    }

    private void checkEglError(String string2) {
        int n = EGL14.eglGetError();
        if (n != 12288) {
            throw new IllegalStateException(string2 + ": EGL error: 0x" + Integer.toHexString(n));
        }
    }

    private void checkGlError(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            throw new IllegalStateException(string2 + ": GLES20 error: 0x" + Integer.toHexString(n));
        }
    }

    private void clearState() {
        this.mSurfaces.clear();
        this.mConversionSurfaces.clear();
        this.mPBufferPixels = null;
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
        }
        this.mSurfaceTexture = null;
    }

    private void configureEGLContext() {
        this.mEGLDisplay = EGL14.eglGetDisplay(0);
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new IllegalStateException("No EGL14 display");
        }
        int[] nArray = new int[2];
        if (!EGL14.eglInitialize(this.mEGLDisplay, nArray, 0, nArray, 1)) {
            throw new IllegalStateException("Cannot initialize EGL14");
        }
        int[] nArray2 = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12610, 1, 12339, 5, 12344};
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray3 = new int[1];
        EGL14.eglChooseConfig(this.mEGLDisplay, nArray2, 0, eGLConfigArray, 0, eGLConfigArray.length, nArray3, 0);
        this.checkEglError("eglCreateContext RGB888+recordable ES2");
        this.mConfigs = eGLConfigArray[0];
        int[] nArray4 = new int[]{12440, 2, 12344};
        this.mEGLContext = EGL14.eglCreateContext(this.mEGLDisplay, eGLConfigArray[0], EGL14.EGL_NO_CONTEXT, nArray4, 0);
        this.checkEglError("eglCreateContext");
        if (this.mEGLContext == EGL14.EGL_NO_CONTEXT) {
            throw new IllegalStateException("No EGLContext could be made");
        }
    }

    private void configureEGLOutputSurfaces(Collection<EGLSurfaceHolder> collection) {
        if (collection == null || collection.size() == 0) {
            throw new IllegalStateException("No Surfaces were provided to draw to");
        }
        int[] nArray = new int[]{12344};
        for (EGLSurfaceHolder eGLSurfaceHolder : collection) {
            try {
                Size size = LegacyCameraDevice.getSurfaceSize(eGLSurfaceHolder.surface);
                eGLSurfaceHolder.width = size.getWidth();
                eGLSurfaceHolder.height = size.getHeight();
                eGLSurfaceHolder.eglSurface = EGL14.eglCreateWindowSurface(this.mEGLDisplay, this.mConfigs, eGLSurfaceHolder.surface, nArray, 0);
                this.checkEglError("eglCreateWindowSurface");
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                Log.w(TAG, "Surface abandoned, skipping...", bufferQueueAbandonedException);
            }
        }
    }

    private void configureEGLPbufferSurfaces(Collection<EGLSurfaceHolder> collection) {
        if (collection == null || collection.size() == 0) {
            throw new IllegalStateException("No Surfaces were provided to draw to");
        }
        int n = 0;
        for (EGLSurfaceHolder eGLSurfaceHolder : collection) {
            Size size;
            block5: {
                size = LegacyCameraDevice.getSurfaceSize(eGLSurfaceHolder.surface);
                int n2 = size.getWidth() * size.getHeight();
                if (n2 <= n) break block5;
                n = n2;
            }
            try {
                int[] nArray = new int[]{12375, size.getWidth(), 12374, size.getHeight(), 12344};
                eGLSurfaceHolder.width = size.getWidth();
                eGLSurfaceHolder.height = size.getHeight();
                eGLSurfaceHolder.eglSurface = EGL14.eglCreatePbufferSurface(this.mEGLDisplay, this.mConfigs, nArray, 0);
                this.checkEglError("eglCreatePbufferSurface");
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                Log.w(TAG, "Surface abandoned, skipping...", bufferQueueAbandonedException);
            }
        }
        this.mPBufferPixels = ByteBuffer.allocateDirect(n * 4).order(ByteOrder.nativeOrder());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int createProgram(String string2, String string3) {
        int n = this.loadShader(35633, string2);
        if (n == 0) {
            return 0;
        }
        int n2 = this.loadShader(35632, string3);
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        this.checkGlError("glCreateProgram");
        if (n3 == 0) {
            Log.e(TAG, "Could not create program");
        }
        GLES20.glAttachShader(n3, n);
        this.checkGlError("glAttachShader");
        GLES20.glAttachShader(n3, n2);
        this.checkGlError("glAttachShader");
        GLES20.glLinkProgram(n3);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv(n3, 35714, nArray, 0);
        if (nArray[0] == 1) return n3;
        Log.e(TAG, "Could not link program: ");
        Log.e(TAG, GLES20.glGetProgramInfoLog(n3));
        GLES20.glDeleteProgram(n3);
        throw new IllegalStateException("Could not link program");
    }

    private void drawFrame(SurfaceTexture surfaceTexture, int n, int n2) {
        Size size;
        this.checkGlError("onDrawFrame start");
        surfaceTexture.getTransformMatrix(this.mSTMatrix);
        Matrix.setIdentityM(this.mMVPMatrix, 0);
        try {
            size = LegacyCameraDevice.getTextureSize(surfaceTexture);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
            throw new IllegalStateException("Surface abandoned, skipping drawFrame...", bufferQueueAbandonedException);
        }
        float f = size.getWidth();
        float f2 = size.getHeight();
        if (f <= 0.0f || f2 <= 0.0f) {
            throw new IllegalStateException("Illegal intermediate texture with dimension of 0");
        }
        RectF rectF = new RectF(0.0f, 0.0f, f, f2);
        RectF rectF2 = new RectF(0.0f, 0.0f, n, n2);
        android.graphics.Matrix matrix = new android.graphics.Matrix();
        matrix.setRectToRect(rectF2, rectF, Matrix.ScaleToFit.CENTER);
        matrix.mapRect(rectF2);
        float f3 = rectF.width() / rectF2.width();
        float f4 = rectF.height() / rectF2.height();
        Matrix.scaleM(this.mMVPMatrix, 0, f4, f3, 1.0f);
        if (DEBUG) {
            Log.d(TAG, "Scaling factors (S_x = " + f3 + ",S_y = " + f4 + ") used for " + n + "x" + n2 + " surface, intermediate buffer size is " + f + "x" + f2);
        }
        GLES20.glViewport(0, 0, n, n2);
        if (DEBUG) {
            GLES20.glClearColor(1.0f, 0.0f, 0.0f, 1.0f);
            GLES20.glClear(16640);
        }
        GLES20.glUseProgram(this.mProgram);
        this.checkGlError("glUseProgram");
        GLES20.glActiveTexture(33984);
        GLES20.glBindTexture(36197, this.mTextureID);
        this.mTriangleVertices.position(0);
        GLES20.glVertexAttribPointer(this.maPositionHandle, 3, 5126, false, 20, this.mTriangleVertices);
        this.checkGlError("glVertexAttribPointer maPosition");
        GLES20.glEnableVertexAttribArray(this.maPositionHandle);
        this.checkGlError("glEnableVertexAttribArray maPositionHandle");
        this.mTriangleVertices.position(3);
        GLES20.glVertexAttribPointer(this.maTextureHandle, 2, 5126, false, 20, this.mTriangleVertices);
        this.checkGlError("glVertexAttribPointer maTextureHandle");
        GLES20.glEnableVertexAttribArray(this.maTextureHandle);
        this.checkGlError("glEnableVertexAttribArray maTextureHandle");
        GLES20.glUniformMatrix4fv(this.muMVPMatrixHandle, 1, false, this.mMVPMatrix, 0);
        GLES20.glUniformMatrix4fv(this.muSTMatrixHandle, 1, false, this.mSTMatrix, 0);
        GLES20.glDrawArrays(5, 0, 4);
        this.checkGlError("glDrawArrays");
    }

    private void dumpGlTiming() {
        if (this.mPerfMeasurer == null) {
            return;
        }
        File file = new File(Environment.getExternalStorageDirectory(), "CameraLegacy");
        if (!file.exists() && !file.mkdirs()) {
            Log.e(TAG, "Failed to create directory for data dump");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(file.getPath());
        stringBuilder.append(File.separator);
        stringBuilder.append("durations_");
        Time time = new Time();
        time.setToNow();
        stringBuilder.append(time.format2445());
        stringBuilder.append("_S");
        for (EGLSurfaceHolder eGLSurfaceHolder : this.mSurfaces) {
            Object[] objectArray = new Object[]{eGLSurfaceHolder.width, eGLSurfaceHolder.height};
            stringBuilder.append(String.format("_%d_%d", objectArray));
        }
        stringBuilder.append("_C");
        for (EGLSurfaceHolder eGLSurfaceHolder : this.mConversionSurfaces) {
            Object[] objectArray = new Object[]{eGLSurfaceHolder.width, eGLSurfaceHolder.height};
            stringBuilder.append(String.format("_%d_%d", objectArray));
        }
        stringBuilder.append(".txt");
        this.mPerfMeasurer.dumpPerformanceData(stringBuilder.toString());
    }

    private void endGlTiming() {
        if (this.mPerfMeasurer == null) {
            return;
        }
        this.mPerfMeasurer.stopTimer();
    }

    private int getTextureId() {
        return this.mTextureID;
    }

    private void initializeGLState() {
        this.mProgram = this.createProgram(VERTEX_SHADER, FRAGMENT_SHADER);
        if (this.mProgram == 0) {
            throw new IllegalStateException("failed creating program");
        }
        this.maPositionHandle = GLES20.glGetAttribLocation(this.mProgram, "aPosition");
        this.checkGlError("glGetAttribLocation aPosition");
        if (this.maPositionHandle == -1) {
            throw new IllegalStateException("Could not get attrib location for aPosition");
        }
        this.maTextureHandle = GLES20.glGetAttribLocation(this.mProgram, "aTextureCoord");
        this.checkGlError("glGetAttribLocation aTextureCoord");
        if (this.maTextureHandle == -1) {
            throw new IllegalStateException("Could not get attrib location for aTextureCoord");
        }
        this.muMVPMatrixHandle = GLES20.glGetUniformLocation(this.mProgram, "uMVPMatrix");
        this.checkGlError("glGetUniformLocation uMVPMatrix");
        if (this.muMVPMatrixHandle == -1) {
            throw new IllegalStateException("Could not get attrib location for uMVPMatrix");
        }
        this.muSTMatrixHandle = GLES20.glGetUniformLocation(this.mProgram, "uSTMatrix");
        this.checkGlError("glGetUniformLocation uSTMatrix");
        if (this.muSTMatrixHandle == -1) {
            throw new IllegalStateException("Could not get attrib location for uSTMatrix");
        }
        int[] nArray = new int[1];
        GLES20.glGenTextures(1, nArray, 0);
        this.mTextureID = nArray[0];
        GLES20.glBindTexture(36197, this.mTextureID);
        this.checkGlError("glBindTexture mTextureID");
        GLES20.glTexParameterf(36197, 10241, 9728.0f);
        GLES20.glTexParameterf(36197, 10240, 9729.0f);
        GLES20.glTexParameteri(36197, 10242, 33071);
        GLES20.glTexParameteri(36197, 10243, 33071);
        this.checkGlError("glTexParameter");
    }

    private int loadShader(int n, String string2) {
        int n2 = GLES20.glCreateShader(n);
        this.checkGlError("glCreateShader type=" + n);
        GLES20.glShaderSource(n2, string2);
        GLES20.glCompileShader(n2);
        int[] nArray = new int[1];
        GLES20.glGetShaderiv(n2, 35713, nArray, 0);
        if (nArray[0] == 0) {
            Log.e(TAG, "Could not compile shader " + n + ":");
            Log.e(TAG, " " + GLES20.glGetShaderInfoLog(n2));
            GLES20.glDeleteShader(n2);
            throw new IllegalStateException("Could not compile shader " + n);
        }
        return n2;
    }

    private void makeCurrent(EGLSurface eGLSurface) {
        EGL14.eglMakeCurrent(this.mEGLDisplay, eGLSurface, eGLSurface, this.mEGLContext);
        this.checkEglError("makeCurrent");
    }

    private void releaseEGLContext() {
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EGL14.eglMakeCurrent(this.mEGLDisplay, EGL14.EGL_NO_SURFACE, EGL14.EGL_NO_SURFACE, EGL14.EGL_NO_CONTEXT);
            this.dumpGlTiming();
            if (this.mSurfaces != null) {
                for (EGLSurfaceHolder eGLSurfaceHolder : this.mSurfaces) {
                    if (eGLSurfaceHolder.eglSurface == null) continue;
                    EGL14.eglDestroySurface(this.mEGLDisplay, eGLSurfaceHolder.eglSurface);
                }
            }
            if (this.mConversionSurfaces != null) {
                for (EGLSurfaceHolder eGLSurfaceHolder : this.mConversionSurfaces) {
                    if (eGLSurfaceHolder.eglSurface == null) continue;
                    EGL14.eglDestroySurface(this.mEGLDisplay, eGLSurfaceHolder.eglSurface);
                }
            }
            EGL14.eglDestroyContext(this.mEGLDisplay, this.mEGLContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate(this.mEGLDisplay);
        }
        this.mConfigs = null;
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.clearState();
    }

    private void setupGlTiming() {
        if (PerfMeasurement.isGlTimingSupported()) {
            Log.d(TAG, "Enabling GL performance measurement");
            this.mPerfMeasurer = new PerfMeasurement();
            return;
        }
        Log.d(TAG, "GL performance measurement not supported on this device");
        this.mPerfMeasurer = null;
    }

    private boolean swapBuffers(EGLSurface eGLSurface) {
        boolean bl = EGL14.eglSwapBuffers(this.mEGLDisplay, eGLSurface);
        this.checkEglError("swapBuffers");
        return bl;
    }

    public void cleanupEGLContext() {
        this.releaseEGLContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void configureSurfaces(Collection<Surface> collection) {
        this.releaseEGLContext();
        if (collection == null || collection.size() == 0) {
            Log.w(TAG, "No output surfaces configured for GL drawing.");
            return;
        }
        for (Surface surface : collection) {
            try {
                if (LegacyCameraDevice.needsConversion(surface)) {
                    LegacyCameraDevice.setSurfaceFormat(surface, 842094169);
                    EGLSurfaceHolder eGLSurfaceHolder = new EGLSurfaceHolder();
                    eGLSurfaceHolder.surface = surface;
                    this.mConversionSurfaces.add(eGLSurfaceHolder);
                }
                EGLSurfaceHolder eGLSurfaceHolder = new EGLSurfaceHolder();
                eGLSurfaceHolder.surface = surface;
                this.mSurfaces.add(eGLSurfaceHolder);
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                Log.w(TAG, "Surface abandoned, skipping configuration... ", bufferQueueAbandonedException);
            }
        }
        this.configureEGLContext();
        if (this.mSurfaces.size() > 0) {
            this.configureEGLOutputSurfaces(this.mSurfaces);
        }
        if (this.mConversionSurfaces.size() > 0) {
            this.configureEGLPbufferSurfaces(this.mConversionSurfaces);
        }
        EGLSurface eGLSurface = this.mSurfaces.size() > 0 ? this.mSurfaces.get((int)0).eglSurface : this.mConversionSurfaces.get((int)0).eglSurface;
        this.makeCurrent(eGLSurface);
        this.initializeGLState();
        this.mSurfaceTexture = new SurfaceTexture(this.getTextureId());
        if (!SystemProperties.getBoolean(LEGACY_PERF_PROPERTY, false)) return;
        this.setupGlTiming();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawIntoSurfaces(CaptureCollector captureCollector) {
        if ((this.mSurfaces == null || this.mSurfaces.size() == 0) && (this.mConversionSurfaces == null || this.mConversionSurfaces.size() == 0)) return;
        boolean bl = captureCollector.hasPendingPreviewCaptures();
        this.checkGlError("before updateTexImage");
        if (bl) {
            this.beginGlTiming();
        }
        this.mSurfaceTexture.updateTexImage();
        long l = this.mSurfaceTexture.getTimestamp();
        Pair<RequestHolder, Long> pair = captureCollector.previewCaptured(l);
        if (pair == null) {
            if (DEBUG) {
                Log.d(TAG, "Dropping preview frame.");
            }
            if (!bl) return;
            this.endGlTiming();
            return;
        }
        Collection<Surface> collection = ((RequestHolder)pair.first).getHolderTargets();
        if (bl) {
            this.addGlTimestamp(l);
        }
        List<Long> list = LegacyCameraDevice.getSurfaceIds(collection);
        for (EGLSurfaceHolder eGLSurfaceHolder : this.mSurfaces) {
            if (!LegacyCameraDevice.containsSurfaceId(eGLSurfaceHolder.surface, list)) continue;
            this.makeCurrent(eGLSurfaceHolder.eglSurface);
            try {
                LegacyCameraDevice.setSurfaceDimens(eGLSurfaceHolder.surface, eGLSurfaceHolder.width, eGLSurfaceHolder.height);
                LegacyCameraDevice.setNextTimestamp(eGLSurfaceHolder.surface, (Long)pair.second);
                this.drawFrame(this.mSurfaceTexture, eGLSurfaceHolder.width, eGLSurfaceHolder.height);
                this.swapBuffers(eGLSurfaceHolder.eglSurface);
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                Log.w(TAG, "Surface abandoned, dropping frame. ", bufferQueueAbandonedException);
            }
        }
        for (EGLSurfaceHolder eGLSurfaceHolder : this.mConversionSurfaces) {
            if (!LegacyCameraDevice.containsSurfaceId(eGLSurfaceHolder.surface, list)) continue;
            this.makeCurrent(eGLSurfaceHolder.eglSurface);
            this.drawFrame(this.mSurfaceTexture, eGLSurfaceHolder.width, eGLSurfaceHolder.height);
            this.mPBufferPixels.clear();
            GLES20.glReadPixels(0, 0, eGLSurfaceHolder.width, eGLSurfaceHolder.height, 6408, 5121, this.mPBufferPixels);
            this.checkGlError("glReadPixels");
            try {
                int n = LegacyCameraDevice.detectSurfaceType(eGLSurfaceHolder.surface);
                LegacyCameraDevice.setNextTimestamp(eGLSurfaceHolder.surface, (Long)pair.second);
                LegacyCameraDevice.produceFrame(eGLSurfaceHolder.surface, this.mPBufferPixels.array(), eGLSurfaceHolder.width, eGLSurfaceHolder.height, n);
                this.swapBuffers(eGLSurfaceHolder.eglSurface);
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                Log.w(TAG, "Surface abandoned, dropping frame. ", bufferQueueAbandonedException);
            }
        }
        captureCollector.previewProduced();
        if (!bl) {
            return;
        }
        this.endGlTiming();
    }

    public void flush() {
        Log.e(TAG, "Flush not yet implemented.");
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    private class EGLSurfaceHolder {
        EGLSurface eglSurface;
        int height;
        Surface surface;
        int width;

        private EGLSurfaceHolder() {
        }
    }
}

