/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.ParameterUtils;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.utils.ListUtils;
import android.hardware.camera2.utils.ParamsUtils;
import android.location.Location;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class LegacyRequestMapper {
    private static final byte DEFAULT_JPEG_QUALITY = 85;
    private static final String TAG = "LegacyRequestMapper";
    private static final boolean VERBOSE = Log.isLoggable("LegacyRequestMapper", 2);

    private static boolean checkForCompleteGpsData(Location location) {
        return location != null && location.getProvider() != null && location.getTime() != 0L;
    }

    private static String convertAeAntiBandingModeToLegacy(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 0: {
                return "off";
            }
            case 1: {
                return "50hz";
            }
            case 2: {
                return "60hz";
            }
            case 3: 
        }
        return "auto";
    }

    private static int[] convertAeFpsRangeToLegacy(Range<Integer> range) {
        int[] nArray = new int[]{range.getLower(), range.getUpper()};
        return nArray;
    }

    private static String convertAwbModeToLegacy(int n) {
        switch (n) {
            default: {
                Log.w(TAG, "convertAwbModeToLegacy - unrecognized control.awbMode" + n);
                return "auto";
            }
            case 1: {
                return "auto";
            }
            case 2: {
                return "incandescent";
            }
            case 3: {
                return "fluorescent";
            }
            case 4: {
                return "warm-fluorescent";
            }
            case 5: {
                return "daylight";
            }
            case 6: {
                return "cloudy-daylight";
            }
            case 7: {
                return "twilight";
            }
            case 8: 
        }
        return "shade";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Camera.Area> convertMeteringRegionsToLegacy(Rect rect, ParameterUtils.ZoomData zoomData, MeteringRectangle[] meteringRectangleArray, int n, String string2) {
        if (meteringRectangleArray == null || n <= 0) {
            if (n <= 0) return null;
            Camera.Area[] areaArray = new Camera.Area[]{ParameterUtils.CAMERA_AREA_DEFAULT};
            return Arrays.asList(areaArray);
        }
        ArrayList<MeteringRectangle> arrayList = new ArrayList<MeteringRectangle>();
        for (MeteringRectangle meteringRectangle : meteringRectangleArray) {
            if (meteringRectangle.getMeteringWeight() == 0) continue;
            arrayList.add(meteringRectangle);
        }
        if (arrayList.size() == 0) {
            Log.w(TAG, "Only received metering rectangles with weight 0.");
            Camera.Area[] areaArray = new Camera.Area[]{ParameterUtils.CAMERA_AREA_DEFAULT};
            return Arrays.asList(areaArray);
        }
        int n2 = Math.min(n, arrayList.size());
        List<Camera.Area> list = new ArrayList<Camera.Area>(n2);
        for (int i = 0; i < n2; ++i) {
            list.add(ParameterUtils.convertMeteringRectangleToLegacy((Rect)rect, (MeteringRectangle)((MeteringRectangle)arrayList.get((int)i)), (ParameterUtils.ZoomData)zoomData).meteringArea);
        }
        if (n < arrayList.size()) {
            Log.w(TAG, "convertMeteringRegionsToLegacy - Too many requested " + string2 + " regions, ignoring all beyond the first " + n);
        }
        if (!VERBOSE) return list;
        Log.v(TAG, "convertMeteringRegionsToLegacy - " + string2 + " areas = " + ParameterUtils.stringFromAreaList(list));
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void convertRequestMetadata(LegacyRequest legacyRequest) {
        int n;
        Location location;
        int n2;
        int n3;
        Boolean bl;
        int n4;
        Range<Integer> range;
        Range<Integer> range2;
        Integer n5;
        String string2;
        int n6;
        CameraCharacteristics cameraCharacteristics = legacyRequest.characteristics;
        CaptureRequest captureRequest = legacyRequest.captureRequest;
        Size size = legacyRequest.previewSize;
        Camera.Parameters parameters = legacyRequest.parameters;
        Rect rect = cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        ParameterUtils.ZoomData zoomData = ParameterUtils.convertScalerCropRegion(rect, captureRequest.get(CaptureRequest.SCALER_CROP_REGION), size, parameters);
        if (parameters.isZoomSupported()) {
            parameters.setZoom(zoomData.zoomIndex);
        } else if (VERBOSE) {
            Log.v(TAG, "convertRequestToMetadata - zoom is not supported");
        }
        if ((n6 = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.COLOR_CORRECTION_ABERRATION_MODE, 1).intValue()) != 1) {
            Log.w(TAG, "convertRequestToMetadata - Ignoring unsupported colorCorrection.aberrationMode = " + n6);
        }
        if ((string2 = (n5 = captureRequest.get(CaptureRequest.CONTROL_AE_ANTIBANDING_MODE)) != null ? LegacyRequestMapper.convertAeAntiBandingModeToLegacy(n5) : ListUtils.listSelectFirstFrom(parameters.getSupportedAntibanding(), new String[]{"auto", "off", "50hz", "60hz"})) != null) {
            parameters.setAntibanding(string2);
        }
        MeteringRectangle[] meteringRectangleArray = captureRequest.get(CaptureRequest.CONTROL_AE_REGIONS);
        if (captureRequest.get(CaptureRequest.CONTROL_AWB_REGIONS) != null) {
            Log.w(TAG, "convertRequestMetadata - control.awbRegions setting is not supported, ignoring value");
        }
        int n7 = parameters.getMaxNumMeteringAreas();
        List<Camera.Area> list = LegacyRequestMapper.convertMeteringRegionsToLegacy(rect, zoomData, meteringRectangleArray, n7, "AE");
        if (n7 > 0) {
            parameters.setMeteringAreas(list);
        }
        MeteringRectangle[] meteringRectangleArray2 = captureRequest.get(CaptureRequest.CONTROL_AF_REGIONS);
        int n8 = parameters.getMaxNumFocusAreas();
        List<Camera.Area> list2 = LegacyRequestMapper.convertMeteringRegionsToLegacy(rect, zoomData, meteringRectangleArray2, n8, "AF");
        if (n8 > 0) {
            parameters.setFocusAreas(list2);
        }
        if ((range2 = captureRequest.get(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE)) != null) {
            boolean bl2;
            int[] nArray;
            block41: {
                int[] nArray2;
                nArray = LegacyRequestMapper.convertAeFpsRangeToLegacy(range2);
                Iterator<int[]> iterator = parameters.getSupportedPreviewFpsRange().iterator();
                do {
                    boolean bl3 = iterator.hasNext();
                    bl2 = false;
                    if (!bl3) break block41;
                } while (nArray[0] != (nArray2 = iterator.next())[0] || nArray[1] != nArray2[1]);
                bl2 = true;
            }
            if (bl2) {
                parameters.setPreviewFpsRange(nArray[0], nArray[1]);
            } else {
                Log.w(TAG, "Unsupported FPS range set [" + nArray[0] + "," + nArray[1] + "]");
            }
        }
        if (!(range = cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE)).contains(n4 = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, 0).intValue())) {
            Log.w(TAG, "convertRequestMetadata - control.aeExposureCompensation is out of range, ignoring value");
            n4 = 0;
        }
        parameters.setExposureCompensation(n4);
        Boolean bl4 = LegacyRequestMapper.getIfSupported(captureRequest, CaptureRequest.CONTROL_AE_LOCK, false, parameters.isAutoExposureLockSupported(), false);
        if (bl4 != null) {
            parameters.setAutoExposureLock(bl4);
        }
        if (VERBOSE) {
            Log.v(TAG, "convertRequestToMetadata - control.aeLock set to " + bl4);
        }
        LegacyRequestMapper.mapAeAndFlashMode(captureRequest, parameters);
        int n9 = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_AF_MODE, 0);
        String string3 = LegacyMetadataMapper.convertAfModeToLegacy(n9, parameters.getSupportedFocusModes());
        if (string3 != null) {
            parameters.setFocusMode(string3);
        }
        if (VERBOSE) {
            Log.v(TAG, "convertRequestToMetadata - control.afMode " + n9 + " mapped to " + string3);
        }
        CaptureRequest.Key<Integer> key = CaptureRequest.CONTROL_AWB_MODE;
        Integer n10 = 1;
        boolean bl5 = parameters.getSupportedWhiteBalance() != null;
        Integer n11 = 1;
        Integer n12 = LegacyRequestMapper.getIfSupported(captureRequest, key, n10, bl5, n11);
        String string4 = null;
        if (n12 != null) {
            string4 = LegacyRequestMapper.convertAwbModeToLegacy(n12);
            parameters.setWhiteBalance(string4);
        }
        if (VERBOSE) {
            Log.v(TAG, "convertRequestToMetadata - control.awbMode " + n12 + " mapped to " + string4);
        }
        if ((bl = LegacyRequestMapper.getIfSupported(captureRequest, CaptureRequest.CONTROL_AWB_LOCK, false, parameters.isAutoWhiteBalanceLockSupported(), false)) != null) {
            parameters.setAutoWhiteBalanceLock(bl);
        }
        boolean bl6 = (n3 = LegacyRequestMapper.filterSupportedCaptureIntent(ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_CAPTURE_INTENT, 1))) == 3 || n3 == 4;
        parameters.setRecordingHint(bl6);
        Integer n13 = LegacyRequestMapper.getIfSupported(captureRequest, CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, 0, parameters.isVideoStabilizationSupported(), 0);
        if (n13 != null) {
            boolean bl7 = n13 == 1;
            parameters.setVideoStabilization(bl7);
        }
        boolean bl8 = ListUtils.listContains(parameters.getSupportedFocusModes(), "infinity");
        Float f = LegacyRequestMapper.getIfSupported(captureRequest, CaptureRequest.LENS_FOCUS_DISTANCE, Float.valueOf(0.0f), bl8, Float.valueOf(0.0f));
        if (f == null || f.floatValue() != 0.0f) {
            Log.w(TAG, "convertRequestToMetadata - Ignoring android.lens.focusDistance " + bl8 + ", only 0.0f is supported");
        }
        if (parameters.getSupportedSceneModes() != null) {
            String string5;
            int n14 = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_MODE, 1);
            switch (n14) {
                default: {
                    Log.w(TAG, "Control mode " + n14 + " is unsupported, defaulting to AUTO");
                    string5 = "auto";
                    break;
                }
                case 2: {
                    int n15 = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_SCENE_MODE, 0);
                    String string6 = LegacyMetadataMapper.convertSceneModeToLegacy(n15);
                    if (string6 != null) {
                        string5 = string6;
                        break;
                    }
                    string5 = "auto";
                    Log.w(TAG, "Skipping unknown requested scene mode: " + n15);
                    break;
                }
                case 1: {
                    string5 = "auto";
                }
            }
            parameters.setSceneMode(string5);
        }
        if (parameters.getSupportedColorEffects() != null) {
            int n16 = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_EFFECT_MODE, 0);
            String string7 = LegacyMetadataMapper.convertEffectModeToLegacy(n16);
            if (string7 != null) {
                parameters.setColorEffect(string7);
            } else {
                parameters.setColorEffect("none");
                Log.w(TAG, "Skipping unknown requested effect mode: " + n16);
            }
        }
        if ((n2 = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.SENSOR_TEST_PATTERN_MODE, 0).intValue()) != 0) {
            Log.w(TAG, "convertRequestToMetadata - ignoring sensor.testPatternMode " + n2 + "; only OFF is supported");
        }
        if ((location = captureRequest.get(CaptureRequest.JPEG_GPS_LOCATION)) != null) {
            if (LegacyRequestMapper.checkForCompleteGpsData(location)) {
                parameters.setGpsAltitude(location.getAltitude());
                parameters.setGpsLatitude(location.getLatitude());
                parameters.setGpsLongitude(location.getLongitude());
                parameters.setGpsProcessingMethod(location.getProvider().toUpperCase());
                parameters.setGpsTimestamp(location.getTime());
            } else {
                Log.w(TAG, "Incomplete GPS parameters provided in location " + location);
            }
        } else {
            parameters.removeGpsData();
        }
        Integer n17 = captureRequest.get(CaptureRequest.JPEG_ORIENTATION);
        CaptureRequest.Key<Integer> key2 = CaptureRequest.JPEG_ORIENTATION;
        int n18 = n17 == null ? 0 : n17;
        parameters.setRotation(ParamsUtils.getOrDefault(captureRequest, key2, n18));
        parameters.setJpegQuality(0xFF & ParamsUtils.getOrDefault(captureRequest, CaptureRequest.JPEG_QUALITY, (byte)85));
        parameters.setJpegThumbnailQuality(0xFF & ParamsUtils.getOrDefault(captureRequest, CaptureRequest.JPEG_THUMBNAIL_QUALITY, (byte)85));
        List<Camera.Size> list3 = parameters.getSupportedJpegThumbnailSizes();
        if (list3 != null && list3.size() > 0) {
            Size size2 = captureRequest.get(CaptureRequest.JPEG_THUMBNAIL_SIZE);
            boolean bl9 = size2 == null ? false : !ParameterUtils.containsSize(list3, size2.getWidth(), size2.getHeight());
            if (bl9) {
                Log.w(TAG, "Invalid JPEG thumbnail size set " + size2 + ", skipping thumbnail...");
            }
            if (size2 == null || bl9) {
                parameters.setJpegThumbnailSize(0, 0);
            } else {
                parameters.setJpegThumbnailSize(size2.getWidth(), size2.getHeight());
            }
        }
        if ((n = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.NOISE_REDUCTION_MODE, 1).intValue()) != 1) {
            Log.w(TAG, "convertRequestToMetadata - Ignoring unsupported noiseReduction.mode = " + n);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    static int filterSupportedCaptureIntent(int var0) {
        switch (var0) {
            default: {
                ** GOTO lbl7
            }
            case 5: 
            case 6: {
                Log.w("LegacyRequestMapper", "Unsupported control.captureIntent value " + 1 + "; default to PREVIEW");
lbl7:
                // 2 sources

                var0 = 1;
                Log.w("LegacyRequestMapper", "Unknown control.captureIntent value " + var0 + "; default to PREVIEW");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
        }
        return var0;
    }

    private static <T> T getIfSupported(CaptureRequest captureRequest, CaptureRequest.Key<T> key, T t, boolean bl, T t2) {
        T t3 = ParamsUtils.getOrDefault(captureRequest, key, t);
        if (!bl) {
            if (!Objects.equals(t3, t2)) {
                Log.w(TAG, key.getName() + " is not supported; ignoring requested value " + t3);
            }
            t3 = null;
        }
        return t3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void mapAeAndFlashMode(CaptureRequest captureRequest, Camera.Parameters parameters) {
        String string2;
        List<String> list;
        int n;
        block19: {
            int n2;
            block20: {
                block21: {
                    n = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.FLASH_MODE, 0);
                    n2 = ParamsUtils.getOrDefault(captureRequest, CaptureRequest.CONTROL_AE_MODE, 1);
                    list = parameters.getSupportedFlashModes();
                    boolean bl = ListUtils.listContains(list, "off");
                    string2 = null;
                    if (bl) {
                        string2 = "off";
                    }
                    if (n2 != 1) break block20;
                    if (n != 2) break block21;
                    if (ListUtils.listContains(list, "torch")) {
                        string2 = "torch";
                        break block19;
                    } else {
                        Log.w(TAG, "mapAeAndFlashMode - Ignore flash.mode == TORCH;camera does not support it");
                    }
                    break block19;
                }
                if (n == 1) {
                    if (ListUtils.listContains(list, "on")) {
                        string2 = "on";
                        break block19;
                    } else {
                        Log.w(TAG, "mapAeAndFlashMode - Ignore flash.mode == SINGLE;camera does not support it");
                    }
                }
                break block19;
            }
            if (n2 == 3) {
                if (ListUtils.listContains(list, "on")) {
                    string2 = "on";
                } else {
                    Log.w(TAG, "mapAeAndFlashMode - Ignore control.aeMode == ON_ALWAYS_FLASH;camera does not support it");
                }
            } else if (n2 == 2) {
                if (ListUtils.listContains(list, "auto")) {
                    string2 = "auto";
                } else {
                    Log.w(TAG, "mapAeAndFlashMode - Ignore control.aeMode == ON_AUTO_FLASH;camera does not support it");
                }
            } else if (n2 == 4) {
                if (ListUtils.listContains(list, "red-eye")) {
                    string2 = "red-eye";
                } else {
                    Log.w(TAG, "mapAeAndFlashMode - Ignore control.aeMode == ON_AUTO_FLASH_REDEYE;camera does not support it");
                }
            }
        }
        if (string2 != null) {
            parameters.setFlashMode(string2);
        }
        if (VERBOSE) {
            Log.v(TAG, "mapAeAndFlashMode - set flash.mode (api1) to " + string2 + ", requested (api2) " + n + ", supported (api1) " + ListUtils.listToString(list));
        }
    }
}

