/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.utils.CameraBinderDecorator;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.LongParcelable;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;

public class CameraDeviceUserShim
implements ICameraDeviceUser {
    private static final boolean DEBUG = false;
    private static final int OPEN_CAMERA_TIMEOUT_MS = 5000;
    private static final String TAG = "CameraDeviceUserShim";
    private final CameraCallbackThread mCameraCallbacks;
    private final CameraCharacteristics mCameraCharacteristics;
    private final CameraLooper mCameraInit;
    private final Object mConfigureLock = new Object();
    private boolean mConfiguring;
    private final LegacyCameraDevice mLegacyDevice;
    private int mSurfaceIdCounter;
    private final SparseArray<Surface> mSurfaces;

    static {
        DEBUG = Log.isLoggable("HAL1ShimLogging", 3);
    }

    protected CameraDeviceUserShim(int n, LegacyCameraDevice legacyCameraDevice, CameraCharacteristics cameraCharacteristics, CameraLooper cameraLooper, CameraCallbackThread cameraCallbackThread) {
        this.mLegacyDevice = legacyCameraDevice;
        this.mConfiguring = false;
        this.mSurfaces = new SparseArray();
        this.mCameraCharacteristics = cameraCharacteristics;
        this.mCameraInit = cameraLooper;
        this.mCameraCallbacks = cameraCallbackThread;
        this.mSurfaceIdCounter = 0;
    }

    public static CameraDeviceUserShim connectBinderShim(ICameraDeviceCallbacks iCameraDeviceCallbacks, int n) {
        Camera.Parameters parameters;
        if (DEBUG) {
            Log.d(TAG, "Opening shim Camera device");
        }
        CameraLooper cameraLooper = new CameraLooper(n);
        CameraCallbackThread cameraCallbackThread = new CameraCallbackThread(iCameraDeviceCallbacks);
        int n2 = cameraLooper.waitForOpen(5000);
        Camera camera = cameraLooper.getCamera();
        CameraBinderDecorator.throwOnError(n2);
        camera.disableShutterSound();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo(n, cameraInfo);
        try {
            parameters = camera.getParameters();
        }
        catch (RuntimeException runtimeException) {
            throw new CameraRuntimeException(3, "Unable to get initial parameters", runtimeException);
        }
        CameraCharacteristics cameraCharacteristics = LegacyMetadataMapper.createCharacteristics(parameters, cameraInfo);
        return new CameraDeviceUserShim(n, new LegacyCameraDevice(n, camera, cameraCharacteristics, cameraCallbackThread), cameraCharacteristics, cameraLooper, cameraCallbackThread);
    }

    private static int translateErrorsFromCamera1(int n) {
        switch (n) {
            default: {
                return n;
            }
            case -13: 
        }
        return -1;
    }

    @Override
    public IBinder asBinder() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int beginConfigure() {
        if (DEBUG) {
            Log.d(TAG, "beginConfigure called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot begin configure, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot begin configure, configuration change already in progress.");
                return -38;
            }
            this.mConfiguring = true;
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int cancelRequest(int n, LongParcelable longParcelable) {
        if (DEBUG) {
            Log.d(TAG, "cancelRequest called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot cancel request, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot cancel request, configuration change in progress.");
                return -38;
            }
        }
        longParcelable.setNumber(this.mLegacyDevice.cancelRequest(n));
        return 0;
    }

    @Override
    public int createDefaultRequest(int n, CameraMetadataNative cameraMetadataNative) {
        CameraMetadataNative cameraMetadataNative2;
        if (DEBUG) {
            Log.d(TAG, "createDefaultRequest called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot create default request, device has been closed.");
            return -19;
        }
        try {
            cameraMetadataNative2 = LegacyMetadataMapper.createRequestTemplate(this.mCameraCharacteristics, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e(TAG, "createDefaultRequest - invalid templateId specified");
            return -22;
        }
        cameraMetadataNative.swap(cameraMetadataNative2);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int createStream(int n, int n2, int n3, Surface surface) {
        if (DEBUG) {
            Log.d(TAG, "createStream called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot create stream, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            int n4;
            if (!this.mConfiguring) {
                Log.e(TAG, "Cannot create stream, beginConfigure hasn't been called yet.");
                return -38;
            }
            this.mSurfaceIdCounter = n4 = 1 + this.mSurfaceIdCounter;
            this.mSurfaces.put(n4, surface);
            return n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteStream(int n) {
        if (DEBUG) {
            Log.d(TAG, "deleteStream called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot delete stream, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (!this.mConfiguring) {
                Log.e(TAG, "Cannot delete stream, beginConfigure hasn't been called yet.");
                return -38;
            }
            int n2 = this.mSurfaces.indexOfKey(n);
            if (n2 < 0) {
                Log.e(TAG, "Cannot delete stream, stream id " + n + " doesn't exist.");
                return -22;
            }
            this.mSurfaces.removeAt(n2);
            return 0;
        }
    }

    @Override
    public void disconnect() {
        if (DEBUG) {
            Log.d(TAG, "disconnect called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.w(TAG, "Cannot disconnect, device has already been closed.");
        }
        try {
            this.mLegacyDevice.close();
            return;
        }
        finally {
            this.mCameraInit.close();
            this.mCameraCallbacks.close();
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int endConfigure() {
        void var2_2;
        ArrayList<Surface> arrayList;
        block11: {
            if (DEBUG) {
                Log.d(TAG, "endConfigure called.");
            }
            if (this.mLegacyDevice.isClosed()) {
                Log.e(TAG, "Cannot end configure, device has been closed.");
                return -19;
            }
            Object object = this.mConfigureLock;
            // MONITORENTER : object
            if (!this.mConfiguring) {
                Log.e(TAG, "Cannot end configure, no configuration change in progress.");
                // MONITOREXIT : object
                return -38;
            }
            int n = this.mSurfaces.size();
            arrayList = null;
            if (n <= 0) break block11;
            ArrayList<Surface> arrayList2 = new ArrayList<Surface>();
            for (int i = 0; i < n; ++i) {
                arrayList2.add(this.mSurfaces.valueAt(i));
                continue;
            }
            arrayList = arrayList2;
        }
        try {
            this.mConfiguring = false;
            // MONITOREXIT : object
            return this.mLegacyDevice.configureOutputs(arrayList);
        }
        catch (Throwable throwable) {
            throw var2_2;
        }
        catch (Throwable throwable) {
            throw var2_2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int flush(LongParcelable longParcelable) {
        if (DEBUG) {
            Log.d(TAG, "flush called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot flush, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot flush, configuration change in progress.");
                return -38;
            }
        }
        long l = this.mLegacyDevice.flush();
        if (longParcelable != null) {
            longParcelable.setNumber(l);
        }
        return 0;
    }

    @Override
    public int getCameraInfo(CameraMetadataNative cameraMetadataNative) {
        if (DEBUG) {
            Log.d(TAG, "getCameraInfo called.");
        }
        Log.e(TAG, "getCameraInfo unimplemented.");
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int submitRequest(CaptureRequest captureRequest, boolean bl, LongParcelable longParcelable) {
        if (DEBUG) {
            Log.d(TAG, "submitRequest called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot submit request, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot submit request, configuration change in progress.");
                return -38;
            }
            return this.mLegacyDevice.submitRequest(captureRequest, bl, longParcelable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int submitRequestList(List<CaptureRequest> list, boolean bl, LongParcelable longParcelable) {
        if (DEBUG) {
            Log.d(TAG, "submitRequestList called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot submit request list, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot submit request, configuration change in progress.");
                return -38;
            }
            return this.mLegacyDevice.submitRequestList(list, bl, longParcelable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int waitUntilIdle() throws RemoteException {
        if (DEBUG) {
            Log.d(TAG, "waitUntilIdle called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e(TAG, "Cannot wait until idle, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e(TAG, "Cannot wait until idle, configuration change in progress.");
                return -38;
            }
        }
        this.mLegacyDevice.waitUntilIdle();
        return 0;
    }

    private static class CameraCallbackThread
    implements ICameraDeviceCallbacks {
        private static final int CAMERA_ERROR = 0;
        private static final int CAMERA_IDLE = 1;
        private static final int CAPTURE_STARTED = 2;
        private static final int RESULT_RECEIVED = 3;
        private final ICameraDeviceCallbacks mCallbacks;
        private Handler mHandler;
        private final HandlerThread mHandlerThread;

        public CameraCallbackThread(ICameraDeviceCallbacks iCameraDeviceCallbacks) {
            this.mCallbacks = iCameraDeviceCallbacks;
            this.mHandlerThread = new HandlerThread("LegacyCameraCallback");
            this.mHandlerThread.start();
        }

        private Handler getHandler() {
            if (this.mHandler == null) {
                this.mHandler = new CallbackHandler(this.mHandlerThread.getLooper());
            }
            return this.mHandler;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }

        public void close() {
            this.mHandlerThread.quitSafely();
        }

        @Override
        public void onCaptureStarted(CaptureResultExtras captureResultExtras, long l) {
            Message message = this.getHandler().obtainMessage(2, (int)(l & 0xFFFFFFFFL), (int)(0xFFFFFFFFL & l >> 32), captureResultExtras);
            this.getHandler().sendMessage(message);
        }

        @Override
        public void onDeviceError(int n, CaptureResultExtras captureResultExtras) {
            Message message = this.getHandler().obtainMessage(0, n, 0, captureResultExtras);
            this.getHandler().sendMessage(message);
        }

        @Override
        public void onDeviceIdle() {
            Message message = this.getHandler().obtainMessage(1);
            this.getHandler().sendMessage(message);
        }

        @Override
        public void onResultReceived(CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) {
            Object[] objectArray = new Object[]{cameraMetadataNative, captureResultExtras};
            Message message = this.getHandler().obtainMessage(3, objectArray);
            this.getHandler().sendMessage(message);
        }

        private class CallbackHandler
        extends Handler {
            public CallbackHandler(Looper looper) {
                super(looper);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                try {
                    switch (message.what) {
                        default: {
                            throw new IllegalArgumentException("Unknown callback message " + message.what);
                        }
                        case 0: {
                            int n = message.arg1;
                            CaptureResultExtras captureResultExtras = (CaptureResultExtras)message.obj;
                            CameraCallbackThread.this.mCallbacks.onDeviceError(n, captureResultExtras);
                            return;
                        }
                        case 1: {
                            CameraCallbackThread.this.mCallbacks.onDeviceIdle();
                            return;
                        }
                        case 2: {
                            long l = (0xFFFFFFFFL & (long)message.arg2) << 32 | 0xFFFFFFFFL & (long)message.arg1;
                            CaptureResultExtras captureResultExtras = (CaptureResultExtras)message.obj;
                            CameraCallbackThread.this.mCallbacks.onCaptureStarted(captureResultExtras, l);
                            return;
                        }
                        case 3: 
                    }
                    Object[] objectArray = (Object[])message.obj;
                    CameraMetadataNative cameraMetadataNative = (CameraMetadataNative)objectArray[0];
                    CaptureResultExtras captureResultExtras = (CaptureResultExtras)objectArray[1];
                    CameraCallbackThread.this.mCallbacks.onResultReceived(cameraMetadataNative, captureResultExtras);
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IllegalStateException("Received remote exception during camera callback " + message.what, remoteException);
                }
            }
        }
    }

    private static class CameraLooper
    implements Runnable,
    AutoCloseable {
        private final Camera mCamera = Camera.openUninitialized();
        private final int mCameraId;
        private volatile int mInitErrors;
        private Looper mLooper;
        private final ConditionVariable mStartDone = new ConditionVariable();
        private final Thread mThread;

        public CameraLooper(int n) {
            this.mCameraId = n;
            this.mThread = new Thread(this);
            this.mThread.start();
        }

        @Override
        public void close() {
            if (this.mLooper == null) {
                return;
            }
            this.mLooper.quitSafely();
            try {
                this.mThread.join();
                this.mLooper = null;
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError((Object)interruptedException);
            }
        }

        public Camera getCamera() {
            return this.mCamera;
        }

        @Override
        public void run() {
            Looper.prepare();
            this.mLooper = Looper.myLooper();
            this.mInitErrors = CameraDeviceUserShim.translateErrorsFromCamera1(this.mCamera.cameraInitUnspecified(this.mCameraId));
            this.mStartDone.open();
            Looper.loop();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int waitForOpen(int n) {
            if (this.mStartDone.block(n)) return this.mInitErrors;
            Log.e(CameraDeviceUserShim.TAG, "waitForOpen - Camera failed to open after timeout of 5000 ms");
            try {
                this.mCamera.release();
            }
            catch (RuntimeException runtimeException) {
                Log.e(CameraDeviceUserShim.TAG, "connectBinderShim - Failed to release camera after timeout ", runtimeException);
                throw new CameraRuntimeException(3);
            }
            throw new CameraRuntimeException(3);
        }
    }
}

