/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.GetCommand;
import android.hardware.camera2.impl.SetCommand;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.marshal.impl.MarshalQueryableArray;
import android.hardware.camera2.marshal.impl.MarshalQueryableBlackLevelPattern;
import android.hardware.camera2.marshal.impl.MarshalQueryableBoolean;
import android.hardware.camera2.marshal.impl.MarshalQueryableColorSpaceTransform;
import android.hardware.camera2.marshal.impl.MarshalQueryableEnum;
import android.hardware.camera2.marshal.impl.MarshalQueryableHighSpeedVideoConfiguration;
import android.hardware.camera2.marshal.impl.MarshalQueryableMeteringRectangle;
import android.hardware.camera2.marshal.impl.MarshalQueryableNativeByteToInteger;
import android.hardware.camera2.marshal.impl.MarshalQueryablePair;
import android.hardware.camera2.marshal.impl.MarshalQueryableParcelable;
import android.hardware.camera2.marshal.impl.MarshalQueryablePrimitive;
import android.hardware.camera2.marshal.impl.MarshalQueryableRange;
import android.hardware.camera2.marshal.impl.MarshalQueryableRect;
import android.hardware.camera2.marshal.impl.MarshalQueryableReprocessFormatsMap;
import android.hardware.camera2.marshal.impl.MarshalQueryableRggbChannelVector;
import android.hardware.camera2.marshal.impl.MarshalQueryableSize;
import android.hardware.camera2.marshal.impl.MarshalQueryableSizeF;
import android.hardware.camera2.marshal.impl.MarshalQueryableStreamConfiguration;
import android.hardware.camera2.marshal.impl.MarshalQueryableStreamConfigurationDuration;
import android.hardware.camera2.marshal.impl.MarshalQueryableString;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.LensShadingMap;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.params.TonemapCurve;
import android.hardware.camera2.utils.TypeReference;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Size;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;

public class CameraMetadataNative
implements Parcelable {
    private static final String CELLID_PROCESS = "CELLID";
    public static final Parcelable.Creator<CameraMetadataNative> CREATOR;
    private static final int FACE_LANDMARK_SIZE = 6;
    private static final String GPS_PROCESS = "GPS";
    public static final int NATIVE_JPEG_FORMAT = 33;
    public static final int NUM_TYPES = 6;
    private static final String TAG = "CameraMetadataJV";
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_DOUBLE = 4;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_INT32 = 1;
    public static final int TYPE_INT64 = 3;
    public static final int TYPE_RATIONAL = 5;
    private static final boolean VERBOSE;
    private static final HashMap<Key<?>, GetCommand> sGetCommandMap;
    private static final HashMap<Key<?>, SetCommand> sSetCommandMap;
    private long mMetadataPtr;

    static {
        VERBOSE = Log.isLoggable(TAG, 2);
        CREATOR = new Parcelable.Creator<CameraMetadataNative>(){

            @Override
            public CameraMetadataNative createFromParcel(Parcel parcel) {
                CameraMetadataNative cameraMetadataNative = new CameraMetadataNative();
                cameraMetadataNative.readFromParcel(parcel);
                return cameraMetadataNative;
            }

            public CameraMetadataNative[] newArray(int n) {
                return new CameraMetadataNative[n];
            }
        };
        sGetCommandMap = new HashMap();
        sGetCommandMap.put(CameraCharacteristics.SCALER_AVAILABLE_FORMATS.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getAvailableFormats();
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_FACES.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getFaces();
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_FACE_RECTANGLES.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getFaceRectangles();
            }
        });
        sGetCommandMap.put(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getStreamConfigurationMap();
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AE.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getMaxRegions(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getMaxRegions(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AF.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getMaxRegions(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_RAW.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getMaxNumOutputs(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getMaxNumOutputs(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC_STALLING.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getMaxNumOutputs(key);
            }
        });
        sGetCommandMap.put(CaptureRequest.TONEMAP_CURVE.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getTonemapCurve();
            }
        });
        sGetCommandMap.put(CaptureResult.JPEG_GPS_LOCATION.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getGpsLocation();
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_LENS_SHADING_CORRECTION_MAP.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)cameraMetadataNative.getLensShadingMap();
            }
        });
        sSetCommandMap = new HashMap();
        sSetCommandMap.put(CameraCharacteristics.SCALER_AVAILABLE_FORMATS.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative cameraMetadataNative, T t) {
                cameraMetadataNative.setAvailableFormats((int[])t);
            }
        });
        sSetCommandMap.put(CaptureResult.STATISTICS_FACE_RECTANGLES.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative cameraMetadataNative, T t) {
                cameraMetadataNative.setFaceRectangles((Rect[])t);
            }
        });
        sSetCommandMap.put(CaptureResult.STATISTICS_FACES.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative cameraMetadataNative, T t) {
                cameraMetadataNative.setFaces((Face[])t);
            }
        });
        sSetCommandMap.put(CaptureRequest.TONEMAP_CURVE.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative cameraMetadataNative, T t) {
                cameraMetadataNative.setTonemapCurve((TonemapCurve)t);
            }
        });
        sSetCommandMap.put(CaptureResult.JPEG_GPS_LOCATION.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative cameraMetadataNative, T t) {
                cameraMetadataNative.setGpsLocation((Location)t);
            }
        });
        CameraMetadataNative.nativeClassInit();
        CameraMetadataNative.registerAllMarshalers();
    }

    public CameraMetadataNative() {
        this.mMetadataPtr = this.nativeAllocate();
        if (this.mMetadataPtr == 0L) {
            throw new OutOfMemoryError("Failed to allocate native CameraMetadata");
        }
    }

    public CameraMetadataNative(CameraMetadataNative cameraMetadataNative) {
        this.mMetadataPtr = this.nativeAllocateCopy(cameraMetadataNative);
        if (this.mMetadataPtr == 0L) {
            throw new OutOfMemoryError("Failed to allocate native CameraMetadata");
        }
    }

    private static boolean areValuesAllNull(Object ... objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] == null) continue;
            return false;
        }
        return true;
    }

    private void close() {
        this.nativeClose();
        this.mMetadataPtr = 0L;
    }

    private int[] getAvailableFormats() {
        int[] nArray = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_FORMATS);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != 33) continue;
                nArray[i] = 256;
            }
        }
        return nArray;
    }

    private <T> T getBase(CameraCharacteristics.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private <T> T getBase(CaptureRequest.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private <T> T getBase(CaptureResult.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private <T> T getBase(Key<T> key) {
        byte[] byArray = this.readValues(key.getTag());
        if (byArray == null) {
            return null;
        }
        return CameraMetadataNative.getMarshalerForKey(key).unmarshal(ByteBuffer.wrap(byArray).order(ByteOrder.nativeOrder()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Rect[] getFaceRectangles() {
        Rect[] rectArray = this.getBase(CaptureResult.STATISTICS_FACE_RECTANGLES);
        if (rectArray == null) {
            return null;
        }
        Rect[] rectArray2 = new Rect[rectArray.length];
        int n = 0;
        while (n < rectArray.length) {
            rectArray2[n] = new Rect(rectArray[n].left, rectArray[n].top, rectArray[n].right - rectArray[n].left, rectArray[n].bottom - rectArray[n].top);
            ++n;
        }
        return rectArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Face[] getFaces() {
        int[] nArray;
        int[] nArray2;
        Rect[] rectArray;
        byte[] byArray;
        Integer n = this.get(CaptureResult.STATISTICS_FACE_DETECT_MODE);
        if (CameraMetadataNative.areValuesAllNull(n, byArray = this.get(CaptureResult.STATISTICS_FACE_SCORES), rectArray = this.get(CaptureResult.STATISTICS_FACE_RECTANGLES), nArray2 = this.get(CaptureResult.STATISTICS_FACE_IDS), nArray = this.get(CaptureResult.STATISTICS_FACE_LANDMARKS))) {
            return null;
        }
        if (n == null) {
            Log.w(TAG, "Face detect mode metadata is null, assuming the mode is SIMPLE");
            n = 1;
        } else {
            if (n == 0) {
                return new Face[0];
            }
            if (n != 1 && n != 2) {
                Log.w(TAG, "Unknown face detect mode: " + n);
                return new Face[0];
            }
        }
        if (byArray == null || rectArray == null) {
            Log.w(TAG, "Expect face scores and rectangles to be non-null");
            return new Face[0];
        }
        if (byArray.length != rectArray.length) {
            Object[] objectArray = new Object[]{byArray.length, rectArray.length};
            Log.w(TAG, String.format("Face score size(%d) doesn match face rectangle size(%d)!", objectArray));
        }
        int n2 = Math.min(byArray.length, rectArray.length);
        if (n == 2) {
            if (nArray2 == null || nArray == null) {
                Log.w(TAG, "Expect face ids and landmarks to be non-null for FULL mode,fallback to SIMPLE mode");
                n = 1;
            } else {
                if (nArray2.length != n2 || nArray.length != n2 * 6) {
                    Object[] objectArray = new Object[]{nArray2.length, 6 * nArray.length, n2};
                    Log.w(TAG, String.format("Face id size(%d), or face landmark size(%d) don'tmatch face number(%d)!", objectArray));
                }
                int n3 = nArray2.length;
                n2 = Math.min(Math.min(n2, n3), nArray.length / 6);
            }
        }
        ArrayList<Face> arrayList = new ArrayList<Face>();
        if (n == 1) {
            for (int i = 0; i < n2; ++i) {
                if (byArray[i] > 100 || byArray[i] < 1) continue;
                arrayList.add(new Face(rectArray[i], byArray[i]));
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (byArray[i] > 100 || byArray[i] < 1 || nArray2[i] < 0) continue;
                Point point = new Point(nArray[i * 6], nArray[1 + i * 6]);
                Point point2 = new Point(nArray[2 + i * 6], nArray[3 + i * 6]);
                Point point3 = new Point(nArray[4 + i * 6], nArray[5 + i * 6]);
                arrayList.add(new Face(rectArray[i], byArray[i], nArray2[i], point, point2, point3));
            }
        }
        Face[] faceArray = new Face[arrayList.size()];
        arrayList.toArray(faceArray);
        return faceArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Location getGpsLocation() {
        String string2 = this.get(CaptureResult.JPEG_GPS_PROCESSING_METHOD);
        double[] dArray = this.get(CaptureResult.JPEG_GPS_COORDINATES);
        Long l = this.get(CaptureResult.JPEG_GPS_TIMESTAMP);
        if (CameraMetadataNative.areValuesAllNull(string2, dArray, l)) {
            return null;
        }
        Location location = new Location(CameraMetadataNative.translateProcessToLocationProvider(string2));
        if (l != null) {
            location.setTime(l);
        } else {
            Log.w(TAG, "getGpsLocation - No timestamp for GPS location.");
        }
        if (dArray != null) {
            location.setLatitude(dArray[0]);
            location.setLongitude(dArray[1]);
            location.setAltitude(dArray[2]);
            return location;
        }
        Log.w(TAG, "getGpsLocation - No coordinates for GPS location");
        return location;
    }

    private LensShadingMap getLensShadingMap() {
        float[] fArray = this.getBase(CaptureResult.STATISTICS_LENS_SHADING_MAP);
        Size size = this.get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE);
        if (fArray == null) {
            return null;
        }
        if (size == null) {
            Log.w(TAG, "getLensShadingMap - Lens shading map size was null.");
            return null;
        }
        return new LensShadingMap(fArray, size.getHeight(), size.getWidth());
    }

    private static <T> Marshaler<T> getMarshalerForKey(Key<T> key) {
        return MarshalRegistry.getMarshaler(key.getTypeReference(), CameraMetadataNative.getNativeType(key.getTag()));
    }

    private <T> Integer getMaxNumOutputs(Key<T> key) {
        int[] nArray = this.getBase(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_STREAMS);
        if (nArray == null) {
            return null;
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_RAW)) {
            return nArray[0];
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC)) {
            return nArray[1];
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC_STALLING)) {
            return nArray[2];
        }
        throw new AssertionError((Object)("Invalid key " + key));
    }

    private <T> Integer getMaxRegions(Key<T> key) {
        int[] nArray = this.getBase(CameraCharacteristics.CONTROL_MAX_REGIONS);
        if (nArray == null) {
            return null;
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AE)) {
            return nArray[0];
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB)) {
            return nArray[1];
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AF)) {
            return nArray[2];
        }
        throw new AssertionError((Object)("Invalid key " + key));
    }

    public static int getNativeType(int n) {
        return CameraMetadataNative.nativeGetTypeFromTag(n);
    }

    private StreamConfigurationMap getStreamConfigurationMap() {
        return new StreamConfigurationMap(this.getBase(CameraCharacteristics.SCALER_AVAILABLE_STREAM_CONFIGURATIONS), this.getBase(CameraCharacteristics.SCALER_AVAILABLE_MIN_FRAME_DURATIONS), this.getBase(CameraCharacteristics.SCALER_AVAILABLE_STALL_DURATIONS), this.getBase(CameraCharacteristics.CONTROL_AVAILABLE_HIGH_SPEED_VIDEO_CONFIGURATIONS));
    }

    public static int getTag(String string2) {
        return CameraMetadataNative.nativeGetTagFromKey(string2);
    }

    private <T> TonemapCurve getTonemapCurve() {
        float[] fArray;
        float[] fArray2;
        float[] fArray3 = this.getBase(CaptureRequest.TONEMAP_CURVE_RED);
        if (CameraMetadataNative.areValuesAllNull(fArray3, fArray2 = this.getBase(CaptureRequest.TONEMAP_CURVE_GREEN), fArray = this.getBase(CaptureRequest.TONEMAP_CURVE_BLUE))) {
            return null;
        }
        if (fArray3 == null || fArray2 == null || fArray == null) {
            Log.w(TAG, "getTonemapCurve - missing tone curve components");
            return null;
        }
        return new TonemapCurve(fArray3, fArray2, fArray);
    }

    public static CameraMetadataNative move(CameraMetadataNative cameraMetadataNative) {
        CameraMetadataNative cameraMetadataNative2 = new CameraMetadataNative();
        cameraMetadataNative2.swap(cameraMetadataNative);
        return cameraMetadataNative2;
    }

    private native long nativeAllocate();

    private native long nativeAllocateCopy(CameraMetadataNative var1) throws NullPointerException;

    private static native void nativeClassInit();

    private synchronized native void nativeClose();

    private synchronized native void nativeDump() throws IOException;

    private synchronized native int nativeGetEntryCount();

    private static native int nativeGetTagFromKey(String var0) throws IllegalArgumentException;

    private static native int nativeGetTypeFromTag(int var0) throws IllegalArgumentException;

    private synchronized native boolean nativeIsEmpty();

    private synchronized native void nativeReadFromParcel(Parcel var1);

    private synchronized native byte[] nativeReadValues(int var1);

    public static native int nativeSetupGlobalVendorTagDescriptor();

    private synchronized native void nativeSwap(CameraMetadataNative var1) throws NullPointerException;

    private synchronized native void nativeWriteToParcel(Parcel var1);

    private synchronized native void nativeWriteValues(int var1, byte[] var2);

    private static void registerAllMarshalers() {
        if (VERBOSE) {
            Log.v(TAG, "Shall register metadata marshalers");
        }
        MarshalQueryable[] marshalQueryableArray = new MarshalQueryable[]{new MarshalQueryablePrimitive(), new MarshalQueryableEnum(), new MarshalQueryableArray(), new MarshalQueryableBoolean(), new MarshalQueryableNativeByteToInteger(), new MarshalQueryableRect(), new MarshalQueryableSize(), new MarshalQueryableSizeF(), new MarshalQueryableString(), new MarshalQueryableReprocessFormatsMap(), new MarshalQueryableRange(), new MarshalQueryablePair(), new MarshalQueryableMeteringRectangle(), new MarshalQueryableColorSpaceTransform(), new MarshalQueryableStreamConfiguration(), new MarshalQueryableStreamConfigurationDuration(), new MarshalQueryableRggbChannelVector(), new MarshalQueryableBlackLevelPattern(), new MarshalQueryableHighSpeedVideoConfiguration(), new MarshalQueryableParcelable()};
        int n = marshalQueryableArray.length;
        for (int i = 0; i < n; ++i) {
            MarshalRegistry.registerMarshalQueryable(marshalQueryableArray[i]);
        }
        if (VERBOSE) {
            Log.v(TAG, "Registered metadata marshalers");
        }
    }

    private boolean setAvailableFormats(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
            if (nArray[i] != 256) continue;
            nArray2[i] = 33;
        }
        this.setBase(CameraCharacteristics.SCALER_AVAILABLE_FORMATS, nArray2);
        return true;
    }

    private <T> void setBase(CameraCharacteristics.Key<T> key, T t) {
        this.setBase(key.getNativeKey(), t);
    }

    private <T> void setBase(CaptureRequest.Key<T> key, T t) {
        this.setBase(key.getNativeKey(), t);
    }

    private <T> void setBase(CaptureResult.Key<T> key, T t) {
        this.setBase(key.getNativeKey(), t);
    }

    private <T> void setBase(Key<T> key, T t) {
        int n = key.getTag();
        if (t == null) {
            this.writeValues(n, null);
            return;
        }
        Marshaler<T> marshaler = CameraMetadataNative.getMarshalerForKey(key);
        byte[] byArray = new byte[marshaler.calculateMarshalSize(t)];
        marshaler.marshal(t, ByteBuffer.wrap(byArray).order(ByteOrder.nativeOrder()));
        this.writeValues(n, byArray);
    }

    private boolean setFaceRectangles(Rect[] rectArray) {
        if (rectArray == null) {
            return false;
        }
        Rect[] rectArray2 = new Rect[rectArray.length];
        for (int i = 0; i < rectArray2.length; ++i) {
            rectArray2[i] = new Rect(rectArray[i].left, rectArray[i].top, rectArray[i].right + rectArray[i].left, rectArray[i].bottom + rectArray[i].top);
        }
        this.setBase(CaptureResult.STATISTICS_FACE_RECTANGLES, rectArray2);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setFaces(Face[] faceArray) {
        if (faceArray == null) {
            return false;
        }
        int n = faceArray.length;
        boolean bl = true;
        int n2 = faceArray.length;
        for (int i = 0; i < n2; ++i) {
            Face face = faceArray[i];
            if (face == null) {
                --n;
                Log.w(TAG, "setFaces - null face detected, skipping");
                continue;
            }
            if (face.getId() != -1) continue;
            bl = false;
        }
        Rect[] rectArray = new Rect[n];
        byte[] byArray = new byte[n];
        int[] nArray = null;
        int[] nArray2 = null;
        if (bl) {
            nArray = new int[n];
            nArray2 = new int[n * 6];
        }
        int n3 = 0;
        int n4 = faceArray.length;
        int n5 = 0;
        while (true) {
            if (n5 >= n4) {
                this.set(CaptureResult.STATISTICS_FACE_RECTANGLES, rectArray);
                this.set(CaptureResult.STATISTICS_FACE_IDS, nArray);
                this.set(CaptureResult.STATISTICS_FACE_LANDMARKS, nArray2);
                this.set(CaptureResult.STATISTICS_FACE_SCORES, byArray);
                return true;
            }
            Face face = faceArray[n5];
            if (face != null) {
                rectArray[n3] = face.getBounds();
                byArray[n3] = (byte)face.getScore();
                if (bl) {
                    nArray[n3] = face.getId();
                    int n6 = n3 * 6;
                    int n7 = 0 + 1;
                    nArray2[n6 + 0] = face.getLeftEyePosition().x;
                    int n8 = n3 * 6;
                    int n9 = n7 + 1;
                    nArray2[n8 + 1] = face.getLeftEyePosition().y;
                    int n10 = n3 * 6;
                    int n11 = n9 + 1;
                    nArray2[n10 + 2] = face.getRightEyePosition().x;
                    int n12 = n3 * 6;
                    int n13 = n11 + 1;
                    nArray2[n12 + 3] = face.getRightEyePosition().y;
                    int n14 = n3 * 6;
                    int n15 = n13 + 1;
                    nArray2[n14 + 4] = face.getMouthPosition().x;
                    int n16 = n3 * 6;
                    int cfr_ignored_0 = n15 + 1;
                    nArray2[n16 + 5] = face.getMouthPosition().y;
                }
                ++n3;
            }
            ++n5;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setGpsLocation(Location location) {
        if (location == null) {
            return false;
        }
        double[] dArray = new double[]{location.getLatitude(), location.getLongitude(), location.getAltitude()};
        String string2 = CameraMetadataNative.translateLocationProviderToProcess(location.getProvider());
        long l = location.getTime();
        this.set(CaptureRequest.JPEG_GPS_TIMESTAMP, Long.valueOf(l));
        this.set(CaptureRequest.JPEG_GPS_COORDINATES, dArray);
        if (string2 == null) {
            Log.w(TAG, "setGpsLocation - No process method, Location is not from a GPS or NETWORKprovider");
            return true;
        }
        this.setBase(CaptureRequest.JPEG_GPS_PROCESSING_METHOD, string2);
        return true;
    }

    private <T> boolean setTonemapCurve(TonemapCurve tonemapCurve) {
        if (tonemapCurve == null) {
            return false;
        }
        float[][] fArrayArray = new float[3][];
        for (int i = 0; i <= 2; ++i) {
            fArrayArray[i] = new float[2 * tonemapCurve.getPointCount(i)];
            tonemapCurve.copyColorCurve(i, fArrayArray[i], 0);
        }
        this.setBase(CaptureRequest.TONEMAP_CURVE_RED, fArrayArray[0]);
        this.setBase(CaptureRequest.TONEMAP_CURVE_GREEN, fArrayArray[1]);
        this.setBase(CaptureRequest.TONEMAP_CURVE_BLUE, fArrayArray[2]);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String translateLocationProviderToProcess(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = -1;
        switch (string2.hashCode()) {
            case 102570: {
                if (string2.equals("gps")) {
                    n = 0;
                }
            }
            default: {
                break;
            }
            case 1843485230: {
                if (!string2.equals("network")) break;
                n = 1;
            }
        }
        switch (n) {
            default: {
                return null;
            }
            case 0: {
                return GPS_PROCESS;
            }
            case 1: 
        }
        return CELLID_PROCESS;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String translateProcessToLocationProvider(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = -1;
        switch (string2.hashCode()) {
            case 70794: {
                if (string2.equals(GPS_PROCESS)) {
                    n = 0;
                }
            }
            default: {
                break;
            }
            case 1984215549: {
                if (!string2.equals(CELLID_PROCESS)) break;
                n = 1;
            }
        }
        switch (n) {
            default: {
                return null;
            }
            case 0: {
                return "gps";
            }
            case 1: 
        }
        return "network";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dumpToLog() {
        try {
            this.nativeDump();
            return;
        }
        catch (IOException iOException) {
            Log.wtf(TAG, "Dump logging failed", iOException);
            return;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public <T> T get(CameraCharacteristics.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    public <T> T get(CaptureRequest.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    public <T> T get(CaptureResult.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    public <T> T get(Key<T> key) {
        Preconditions.checkNotNull(key, "key must not be null");
        GetCommand getCommand = sGetCommandMap.get(key);
        if (getCommand != null) {
            return getCommand.getValue(this, key);
        }
        return this.getBase(key);
    }

    public int getEntryCount() {
        return this.nativeGetEntryCount();
    }

    public boolean isEmpty() {
        return this.nativeIsEmpty();
    }

    public void readFromParcel(Parcel parcel) {
        this.nativeReadFromParcel(parcel);
    }

    public byte[] readValues(int n) {
        return this.nativeReadValues(n);
    }

    public <T> void set(CameraCharacteristics.Key<T> key, T t) {
        this.set(key.getNativeKey(), t);
    }

    public <T> void set(CaptureRequest.Key<T> key, T t) {
        this.set(key.getNativeKey(), t);
    }

    public <T> void set(CaptureResult.Key<T> key, T t) {
        this.set(key.getNativeKey(), t);
    }

    public <T> void set(Key<T> key, T t) {
        SetCommand setCommand = sSetCommandMap.get(key);
        if (setCommand != null) {
            setCommand.setValue(this, t);
            return;
        }
        this.setBase(key, t);
    }

    public void swap(CameraMetadataNative cameraMetadataNative) {
        this.nativeSwap(cameraMetadataNative);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.nativeWriteToParcel(parcel);
    }

    public void writeValues(int n, byte[] byArray) {
        this.nativeWriteValues(n, byArray);
    }

    public static class Key<T> {
        private boolean mHasTag;
        private final int mHash;
        private final String mName;
        private int mTag;
        private final Class<T> mType;
        private final TypeReference<T> mTypeReference;

        public Key(String string2, TypeReference<T> typeReference) {
            if (string2 == null) {
                throw new NullPointerException("Key needs a valid name");
            }
            if (typeReference == null) {
                throw new NullPointerException("TypeReference needs to be non-null");
            }
            this.mName = string2;
            this.mType = typeReference.getRawType();
            this.mTypeReference = typeReference;
            this.mHash = this.mName.hashCode() ^ this.mTypeReference.hashCode();
        }

        public Key(String string2, Class<T> clazz) {
            if (string2 == null) {
                throw new NullPointerException("Key needs a valid name");
            }
            if (clazz == null) {
                throw new NullPointerException("Type needs to be non-null");
            }
            this.mName = string2;
            this.mType = clazz;
            this.mTypeReference = TypeReference.createSpecializedTypeReference(clazz);
            this.mHash = this.mName.hashCode() ^ this.mTypeReference.hashCode();
        }

        /*
         * Enabled aggressive block sorting
         */
        public final boolean equals(Object object) {
            block12: {
                block11: {
                    Key key;
                    if (this == object) break block11;
                    if (object == null || this.hashCode() != object.hashCode()) {
                        return false;
                    }
                    if (object instanceof CaptureResult.Key) {
                        key = ((CaptureResult.Key)object).getNativeKey();
                    } else if (object instanceof CaptureRequest.Key) {
                        key = ((CaptureRequest.Key)object).getNativeKey();
                    } else if (object instanceof CameraCharacteristics.Key) {
                        key = ((CameraCharacteristics.Key)object).getNativeKey();
                    } else {
                        if (!(object instanceof Key)) {
                            return false;
                        }
                        key = (Key)object;
                    }
                    if (!this.mName.equals(key.mName) || !this.mTypeReference.equals(key.mTypeReference)) break block12;
                }
                return true;
            }
            return false;
        }

        public final String getName() {
            return this.mName;
        }

        public final int getTag() {
            if (!this.mHasTag) {
                this.mTag = CameraMetadataNative.getTag(this.mName);
                this.mHasTag = true;
            }
            return this.mTag;
        }

        public final Class<T> getType() {
            return this.mType;
        }

        public final TypeReference<T> getTypeReference() {
            return this.mTypeReference;
        }

        public final int hashCode() {
            return this.mHash;
        }
    }
}

