/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.dispatch.ArgumentReplacingDispatcher;
import android.hardware.camera2.dispatch.BroadcastDispatcher;
import android.hardware.camera2.dispatch.DuckTypingDispatcher;
import android.hardware.camera2.dispatch.HandlerDispatcher;
import android.hardware.camera2.dispatch.InvokeDispatcher;
import android.hardware.camera2.impl.CallbackProxies;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.utils.TaskDrainer;
import android.hardware.camera2.utils.TaskSingleDrainer;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.List;

public class CameraCaptureSessionImpl
extends CameraCaptureSession {
    private static final String TAG = "CameraCaptureSession";
    private static final boolean VERBOSE = Log.isLoggable("CameraCaptureSession", 2);
    private final TaskSingleDrainer mAbortDrainer;
    private volatile boolean mAborting;
    private boolean mClosed = false;
    private final boolean mConfigureSuccess;
    private final Handler mDeviceHandler;
    private final CameraDeviceImpl mDeviceImpl;
    private final int mId;
    private final String mIdString;
    private final TaskSingleDrainer mIdleDrainer;
    private final List<Surface> mOutputs;
    private final TaskDrainer<Integer> mSequenceDrainer;
    private boolean mSkipUnconfigure = false;
    private final CameraCaptureSession.StateCallback mStateCallback;
    private final Handler mStateHandler;
    private final TaskSingleDrainer mUnconfigureDrainer;

    CameraCaptureSessionImpl(int n, List<Surface> list, CameraCaptureSession.StateCallback stateCallback, Handler handler, CameraDeviceImpl cameraDeviceImpl, Handler handler2, boolean bl) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("outputs must be a non-null, non-empty list");
        }
        if (stateCallback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.mId = n;
        Object[] objectArray = new Object[]{this.mId};
        this.mIdString = String.format("Session %d: ", objectArray);
        this.mOutputs = list;
        this.mStateHandler = CameraDeviceImpl.checkHandler(handler);
        this.mStateCallback = this.createUserStateCallbackProxy(this.mStateHandler, stateCallback);
        this.mDeviceHandler = Preconditions.checkNotNull(handler2, "deviceStateHandler must not be null");
        this.mDeviceImpl = Preconditions.checkNotNull(cameraDeviceImpl, "deviceImpl must not be null");
        this.mSequenceDrainer = new TaskDrainer(this.mDeviceHandler, new SequenceDrainListener(), "seq");
        this.mIdleDrainer = new TaskSingleDrainer(this.mDeviceHandler, new IdleDrainListener(), "idle");
        this.mAbortDrainer = new TaskSingleDrainer(this.mDeviceHandler, new AbortDrainListener(), "abort");
        this.mUnconfigureDrainer = new TaskSingleDrainer(this.mDeviceHandler, new UnconfigureDrainListener(), "unconf");
        if (bl) {
            this.mStateCallback.onConfigured(this);
            if (VERBOSE) {
                Log.v(TAG, this.mIdString + "Created session successfully");
            }
            this.mConfigureSuccess = true;
            return;
        }
        this.mStateCallback.onConfigureFailed(this);
        this.mClosed = true;
        Log.e(TAG, this.mIdString + "Failed to create capture session; configuration failed");
        this.mConfigureSuccess = false;
    }

    static /* synthetic */ boolean access$902(CameraCaptureSessionImpl cameraCaptureSessionImpl, boolean bl) {
        cameraCaptureSessionImpl.mAborting = bl;
        return bl;
    }

    private int addPendingSequence(int n) {
        this.mSequenceDrainer.taskStarted(n);
        return n;
    }

    private void checkNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Session has been closed; further changes are illegal.");
        }
    }

    private CameraDeviceImpl.CaptureCallback createCaptureCallbackProxy(Handler handler, CameraCaptureSession.CaptureCallback captureCallback) {
        CameraDeviceImpl.CaptureCallback captureCallback2 = new CameraDeviceImpl.CaptureCallback(){

            @Override
            public void onCaptureSequenceAborted(CameraDevice cameraDevice, int n) {
                CameraCaptureSessionImpl.this.finishPendingSequence(n);
            }

            @Override
            public void onCaptureSequenceCompleted(CameraDevice cameraDevice, int n, long l) {
                CameraCaptureSessionImpl.this.finishPendingSequence(n);
            }
        };
        if (captureCallback == null) {
            return captureCallback2;
        }
        InvokeDispatcher<1> invokeDispatcher = new InvokeDispatcher<1>(captureCallback2);
        return new CallbackProxies.DeviceCaptureCallbackProxy(new BroadcastDispatcher<CameraDeviceImpl.CaptureCallback>(new ArgumentReplacingDispatcher(new DuckTypingDispatcher(new HandlerDispatcher<CameraCaptureSession.CaptureCallback>(new InvokeDispatcher<CameraCaptureSession.CaptureCallback>(captureCallback), handler), CameraCaptureSession.CaptureCallback.class), 0, this), invokeDispatcher));
    }

    private CameraCaptureSession.StateCallback createUserStateCallbackProxy(Handler handler, CameraCaptureSession.StateCallback stateCallback) {
        return new CallbackProxies.SessionStateCallbackProxy(new HandlerDispatcher<CameraCaptureSession.StateCallback>(new InvokeDispatcher<CameraCaptureSession.StateCallback>(stateCallback), handler));
    }

    private void finishPendingSequence(int n) {
        this.mSequenceDrainer.taskFinished(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void abortCaptures() throws CameraAccessException {
        synchronized (this) {
            this.checkNotClosed();
            if (VERBOSE) {
                Log.v(TAG, this.mIdString + "abortCaptures");
            }
            if (this.mAborting) {
                Log.w(TAG, this.mIdString + "abortCaptures - Session is already aborting; doing nothing");
            } else {
                this.mAborting = true;
                this.mAbortDrainer.taskStarted();
                this.mDeviceImpl.flush();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int capture(CaptureRequest captureRequest, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        synchronized (this) {
            if (captureRequest == null) {
                throw new IllegalArgumentException("request must not be null");
            }
            this.checkNotClosed();
            Handler handler2 = CameraDeviceImpl.checkHandler(handler, captureCallback);
            if (!VERBOSE) return this.addPendingSequence(this.mDeviceImpl.capture(captureRequest, this.createCaptureCallbackProxy(handler2, captureCallback), this.mDeviceHandler));
            Log.v(TAG, this.mIdString + "capture - request " + captureRequest + ", callback " + captureCallback + " handler " + handler2);
            return this.addPendingSequence(this.mDeviceImpl.capture(captureRequest, this.createCaptureCallbackProxy(handler2, captureCallback), this.mDeviceHandler));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int captureBurst(List<CaptureRequest> list, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        synchronized (this) {
            if (list == null) {
                throw new IllegalArgumentException("requests must not be null");
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException("requests must have at least one element");
            }
            this.checkNotClosed();
            Handler handler2 = CameraDeviceImpl.checkHandler(handler, captureCallback);
            if (!VERBOSE) return this.addPendingSequence(this.mDeviceImpl.captureBurst(list, this.createCaptureCallbackProxy(handler2, captureCallback), this.mDeviceHandler));
            Object[] objectArray = list.toArray(new CaptureRequest[0]);
            Log.v(TAG, this.mIdString + "captureBurst - requests " + Arrays.toString(objectArray) + ", callback " + captureCallback + " handler " + handler2);
            return this.addPendingSequence(this.mDeviceImpl.captureBurst(list, this.createCaptureCallbackProxy(handler2, captureCallback), this.mDeviceHandler));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        synchronized (this) {
            block10: {
                if (this.mClosed) {
                    if (VERBOSE) {
                        Log.v(TAG, this.mIdString + "close - reentering");
                    }
                } else {
                    if (VERBOSE) {
                        Log.v(TAG, this.mIdString + "close - first time");
                    }
                    this.mClosed = true;
                    try {
                        this.mDeviceImpl.stopRepeating();
                    }
                    catch (IllegalStateException illegalStateException) {
                        Log.w(TAG, this.mIdString + "The camera device was already closed: ", illegalStateException);
                        this.mStateCallback.onClosed(this);
                        break block10;
                    }
                    catch (CameraAccessException cameraAccessException) {
                        Log.e(TAG, this.mIdString + "Exception while stopping repeating: ", cameraAccessException);
                    }
                    this.mSequenceDrainer.beginDrain();
                }
            }
            return;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public CameraDevice getDevice() {
        return this.mDeviceImpl;
    }

    CameraDeviceImpl.StateCallbackKK getDeviceStateCallback() {
        return new CameraDeviceImpl.StateCallbackKK(){
            private boolean mActive = false;
            private boolean mBusy = false;

            @Override
            public void onActive(CameraDevice cameraDevice) {
                CameraCaptureSessionImpl.this.mIdleDrainer.taskStarted();
                this.mActive = true;
                if (VERBOSE) {
                    Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onActive");
                }
                CameraCaptureSessionImpl.this.mStateCallback.onActive(this);
            }

            @Override
            public void onBusy(CameraDevice cameraDevice) {
                this.mBusy = true;
                if (VERBOSE) {
                    Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onBusy");
                }
            }

            @Override
            public void onDisconnected(CameraDevice cameraDevice) {
                if (VERBOSE) {
                    Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onDisconnected");
                }
                CameraCaptureSessionImpl.this.close();
            }

            @Override
            public void onError(CameraDevice cameraDevice, int n) {
                Log.wtf(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "Got device error " + n);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void onIdle(CameraDevice cameraDevice) {
                if (VERBOSE) {
                    Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onIdle");
                }
                CameraCaptureSession cameraCaptureSession = this;
                // MONITORENTER : cameraCaptureSession
                boolean bl = CameraCaptureSessionImpl.this.mAborting;
                // MONITOREXIT : cameraCaptureSession
                if (this.mBusy && bl) {
                    CameraCaptureSessionImpl.this.mAbortDrainer.taskFinished();
                    CameraCaptureSession cameraCaptureSession2 = this;
                    // MONITORENTER : cameraCaptureSession2
                    CameraCaptureSessionImpl.access$902(CameraCaptureSessionImpl.this, false);
                    // MONITOREXIT : cameraCaptureSession2
                }
                if (this.mActive) {
                    CameraCaptureSessionImpl.this.mIdleDrainer.taskFinished();
                }
                this.mBusy = false;
                this.mActive = false;
                CameraCaptureSessionImpl.this.mStateCallback.onReady(this);
            }

            @Override
            public void onOpened(CameraDevice cameraDevice) {
                throw new AssertionError((Object)"Camera must already be open before creating a session");
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onUnconfigured(CameraDevice cameraDevice) {
                if (VERBOSE) {
                    Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onUnconfigured");
                }
                CameraCaptureSession cameraCaptureSession = this;
                synchronized (cameraCaptureSession) {
                    if (CameraCaptureSessionImpl.this.mClosed && CameraCaptureSessionImpl.this.mConfigureSuccess && !CameraCaptureSessionImpl.this.mSkipUnconfigure) {
                        CameraCaptureSessionImpl.this.mUnconfigureDrainer.taskFinished();
                    }
                    return;
                }
            }
        };
    }

    boolean isAborting() {
        return this.mAborting;
    }

    void replaceSessionClose() {
        synchronized (this) {
            if (VERBOSE) {
                Log.v(TAG, this.mIdString + "replaceSessionClose");
            }
            this.mSkipUnconfigure = true;
            this.close();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setRepeatingBurst(List<CaptureRequest> list, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        synchronized (this) {
            if (list == null) {
                throw new IllegalArgumentException("requests must not be null");
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException("requests must have at least one element");
            }
            this.checkNotClosed();
            Handler handler2 = CameraDeviceImpl.checkHandler(handler, captureCallback);
            if (!VERBOSE) return this.addPendingSequence(this.mDeviceImpl.setRepeatingBurst(list, this.createCaptureCallbackProxy(handler2, captureCallback), this.mDeviceHandler));
            Object[] objectArray = list.toArray(new CaptureRequest[0]);
            Log.v(TAG, this.mIdString + "setRepeatingBurst - requests " + Arrays.toString(objectArray) + ", callback " + captureCallback + " handler" + "" + handler2);
            return this.addPendingSequence(this.mDeviceImpl.setRepeatingBurst(list, this.createCaptureCallbackProxy(handler2, captureCallback), this.mDeviceHandler));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setRepeatingRequest(CaptureRequest captureRequest, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        synchronized (this) {
            if (captureRequest == null) {
                throw new IllegalArgumentException("request must not be null");
            }
            this.checkNotClosed();
            Handler handler2 = CameraDeviceImpl.checkHandler(handler, captureCallback);
            if (!VERBOSE) return this.addPendingSequence(this.mDeviceImpl.setRepeatingRequest(captureRequest, this.createCaptureCallbackProxy(handler2, captureCallback), this.mDeviceHandler));
            Log.v(TAG, this.mIdString + "setRepeatingRequest - request " + captureRequest + ", callback " + captureCallback + " handler" + " " + handler2);
            return this.addPendingSequence(this.mDeviceImpl.setRepeatingRequest(captureRequest, this.createCaptureCallbackProxy(handler2, captureCallback), this.mDeviceHandler));
        }
    }

    @Override
    public void stopRepeating() throws CameraAccessException {
        synchronized (this) {
            this.checkNotClosed();
            if (VERBOSE) {
                Log.v(TAG, this.mIdString + "stopRepeating");
            }
            this.mDeviceImpl.stopRepeating();
            return;
        }
    }

    private class AbortDrainListener
    implements TaskDrainer.DrainListener {
        private AbortDrainListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onDrained() {
            if (VERBOSE) {
                Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onAbortDrained");
            }
            CameraCaptureSessionImpl cameraCaptureSessionImpl = CameraCaptureSessionImpl.this;
            synchronized (cameraCaptureSessionImpl) {
                CameraCaptureSessionImpl.this.mIdleDrainer.beginDrain();
                return;
            }
        }
    }

    private class IdleDrainListener
    implements TaskDrainer.DrainListener {
        private IdleDrainListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onDrained() {
            if (VERBOSE) {
                Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onIdleDrained");
            }
            Object object = ((CameraCaptureSessionImpl)CameraCaptureSessionImpl.this).mDeviceImpl.mInterfaceLock;
            synchronized (object) {
                CameraCaptureSessionImpl cameraCaptureSessionImpl = CameraCaptureSessionImpl.this;
                synchronized (cameraCaptureSessionImpl) {
                    if (VERBOSE) {
                        Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "Session drain complete, skip unconfigure: " + CameraCaptureSessionImpl.this.mSkipUnconfigure);
                    }
                    if (CameraCaptureSessionImpl.this.mSkipUnconfigure) {
                        CameraCaptureSessionImpl.this.mStateCallback.onClosed(CameraCaptureSessionImpl.this);
                        return;
                    }
                    CameraCaptureSessionImpl.this.mUnconfigureDrainer.taskStarted();
                    try {
                        CameraCaptureSessionImpl.this.mDeviceImpl.configureOutputsChecked(null);
                    }
                    catch (CameraAccessException cameraAccessException) {
                        Log.e(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "Exception while configuring outputs: ", cameraAccessException);
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (VERBOSE) {
                            Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "Camera was already closed or busy, skipping unconfigure");
                        }
                        CameraCaptureSessionImpl.this.mUnconfigureDrainer.taskFinished();
                    }
                    CameraCaptureSessionImpl.this.mUnconfigureDrainer.beginDrain();
                    return;
                }
            }
        }
    }

    private class SequenceDrainListener
    implements TaskDrainer.DrainListener {
        private SequenceDrainListener() {
        }

        @Override
        public void onDrained() {
            if (VERBOSE) {
                Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onSequenceDrained");
            }
            CameraCaptureSessionImpl.this.mAbortDrainer.beginDrain();
        }
    }

    private class UnconfigureDrainListener
    implements TaskDrainer.DrainListener {
        private UnconfigureDrainListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onDrained() {
            if (VERBOSE) {
                Log.v(CameraCaptureSessionImpl.TAG, CameraCaptureSessionImpl.this.mIdString + "onUnconfigureDrained");
            }
            CameraCaptureSessionImpl cameraCaptureSessionImpl = CameraCaptureSessionImpl.this;
            synchronized (cameraCaptureSessionImpl) {
                CameraCaptureSessionImpl.this.mStateCallback.onClosed(CameraCaptureSessionImpl.this);
                return;
            }
        }
    }
}

