/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.dispatch;

import android.hardware.camera2.dispatch.Dispatchable;
import com.android.internal.util.Preconditions;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class BroadcastDispatcher<T>
implements Dispatchable<T> {
    private final List<Dispatchable<T>> mDispatchTargets;

    @SafeVarargs
    public BroadcastDispatcher(Dispatchable<T> ... dispatchableArray) {
        this.mDispatchTargets = Arrays.asList((Object[])Preconditions.checkNotNull(dispatchableArray, "dispatchTargets must not be null"));
    }

    @Override
    public Object dispatch(Method method, Object[] objectArray) throws Throwable {
        Object object = null;
        boolean bl = false;
        Iterator<Dispatchable<T>> iterator = this.mDispatchTargets.iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next().dispatch(method, objectArray);
            if (bl) continue;
            bl = true;
            object = object2;
        }
        return object;
    }
}

