/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.location.Location;
import android.media.Image;
import android.os.SystemClock;
import android.util.Size;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public final class DngCreator
implements AutoCloseable {
    private static final int BYTES_PER_RGB_PIX = 3;
    private static final int DEFAULT_PIXEL_STRIDE = 2;
    private static final String GPS_DATE_FORMAT_STR = "yyyy:MM:dd";
    private static final String GPS_LAT_REF_NORTH = "N";
    private static final String GPS_LAT_REF_SOUTH = "S";
    private static final String GPS_LONG_REF_EAST = "E";
    private static final String GPS_LONG_REF_WEST = "W";
    public static final int MAX_THUMBNAIL_DIMENSION = 256;
    private static final String TAG = "DngCreator";
    private static final String TIFF_DATETIME_FORMAT = "yyyy:MM:dd kk:mm:ss";
    private static final DateFormat sDateTimeStampFormat;
    private static final DateFormat sExifGPSDateStamp;
    private final Calendar mGPSTimeStampCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private long mNativeContext;

    static {
        sExifGPSDateStamp = new SimpleDateFormat(GPS_DATE_FORMAT_STR);
        sDateTimeStampFormat = new SimpleDateFormat(TIFF_DATETIME_FORMAT);
        sDateTimeStampFormat.setTimeZone(TimeZone.getDefault());
        sExifGPSDateStamp.setTimeZone(TimeZone.getTimeZone("UTC"));
        DngCreator.nativeClassInit();
    }

    public DngCreator(CameraCharacteristics cameraCharacteristics, CaptureResult captureResult) {
        if (cameraCharacteristics == null || captureResult == null) {
            throw new IllegalArgumentException("Null argument to DngCreator constructor");
        }
        long l = System.currentTimeMillis();
        long l2 = l - SystemClock.elapsedRealtime();
        Long l3 = captureResult.get(CaptureResult.SENSOR_TIMESTAMP);
        long l4 = l;
        if (l3 != null) {
            l4 = l2 + l3 / 1000000L;
        }
        String string2 = sDateTimeStampFormat.format(l4);
        this.nativeInit(cameraCharacteristics.getNativeCopy(), captureResult.getNativeCopy(), string2);
    }

    private static void colorToRgb(int n, int n2, byte[] byArray) {
        byArray[n2] = (byte)Color.red(n);
        byArray[n2 + 1] = (byte)Color.green(n);
        byArray[n2 + 2] = (byte)Color.blue(n);
    }

    private static ByteBuffer convertToRGB(Bitmap bitmap) {
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 * (n * 3));
        int[] nArray = new int[n];
        byte[] byArray = new byte[n * 3];
        for (int i = 0; i < n2; ++i) {
            bitmap.getPixels(nArray, 0, n, 0, i, n, 1);
            for (int j = 0; j < n; ++j) {
                DngCreator.colorToRgb(nArray[j], j * 3, byArray);
            }
            byteBuffer.put(byArray);
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    private static ByteBuffer convertToRGB(Image image) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 * (n * 3));
        Image.Plane plane = image.getPlanes()[0];
        Image.Plane plane2 = image.getPlanes()[1];
        Image.Plane plane3 = image.getPlanes()[2];
        ByteBuffer byteBuffer2 = plane.getBuffer();
        ByteBuffer byteBuffer3 = plane2.getBuffer();
        ByteBuffer byteBuffer4 = plane3.getBuffer();
        byteBuffer2.rewind();
        byteBuffer3.rewind();
        byteBuffer4.rewind();
        int n3 = plane.getRowStride();
        int n4 = plane3.getRowStride();
        int n5 = plane2.getRowStride();
        int n6 = plane.getPixelStride();
        int n7 = plane3.getPixelStride();
        int n8 = plane2.getPixelStride();
        byte[] byArray = new byte[]{0, 0, 0};
        byte[] byArray2 = new byte[n6 * n];
        byte[] byArray3 = new byte[n8 * n / 2];
        byte[] byArray4 = new byte[n7 * n / 2];
        byte[] byArray5 = new byte[n * 3];
        for (int i = 0; i < n2; ++i) {
            int n9 = i / 2;
            byteBuffer2.position(n3 * i);
            byteBuffer2.get(byArray2);
            byteBuffer3.position(n5 * n9);
            byteBuffer3.get(byArray3);
            byteBuffer4.position(n4 * n9);
            byteBuffer4.get(byArray4);
            for (int j = 0; j < n; ++j) {
                int n10 = j / 2;
                byArray[0] = byArray2[n6 * j];
                byArray[1] = byArray3[n8 * n10];
                byArray[2] = byArray4[n7 * n10];
                DngCreator.yuvToRgb(byArray, j * 3, byArray5);
            }
            byteBuffer.put(byArray5);
        }
        byteBuffer2.rewind();
        byteBuffer3.rewind();
        byteBuffer4.rewind();
        byteBuffer.rewind();
        return byteBuffer;
    }

    private static native void nativeClassInit();

    private synchronized native void nativeDestroy();

    private synchronized native void nativeInit(CameraMetadataNative var1, CameraMetadataNative var2, String var3);

    private synchronized native void nativeSetDescription(String var1);

    private synchronized native void nativeSetGpsTags(int[] var1, String var2, int[] var3, String var4, String var5, int[] var6);

    private synchronized native void nativeSetOrientation(int var1);

    private synchronized native void nativeSetThumbnail(ByteBuffer var1, int var2, int var3);

    private synchronized native void nativeWriteImage(OutputStream var1, int var2, int var3, ByteBuffer var4, int var5, int var6, long var7, boolean var9) throws IOException;

    private synchronized native void nativeWriteInputStream(OutputStream var1, InputStream var2, int var3, int var4, long var5) throws IOException;

    private static int[] toExifLatLong(double d) {
        double d2 = Math.abs(d);
        int n = (int)d2;
        double d3 = 60.0 * (d2 - (double)n);
        int n2 = (int)d3;
        return new int[]{n, 1, n2, 1, (int)(6000.0 * (d3 - (double)n2)), 100};
    }

    private void writeByteBuffer(int n, int n2, ByteBuffer byteBuffer, OutputStream outputStream, int n3, int n4, long l) throws IOException {
        long l2;
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Image with invalid width, height: (" + n + "," + n2 + ") passed to write");
        }
        long l3 = byteBuffer.capacity();
        if (l3 < (l2 = l + (long)(n4 * n2))) {
            throw new IllegalArgumentException("Image size " + l3 + " is too small (must be larger than " + l2 + ")");
        }
        int n5 = n3 * n;
        if (n5 > n4) {
            throw new IllegalArgumentException("Invalid image pixel stride, row byte width " + n5 + " is too large, expecting " + n4);
        }
        byteBuffer.clear();
        this.nativeWriteImage(outputStream, n, n2, byteBuffer, n4, n3, l, byteBuffer.isDirect());
        byteBuffer.clear();
    }

    private static void yuvToRgb(byte[] byArray, int n, byte[] byArray2) {
        float f = 0xFF & byArray[0];
        float f2 = 0xFF & byArray[1];
        float f3 = 0xFF & byArray[2];
        float f4 = f + 1.402f * (f3 - 128.0f);
        float f5 = f - 0.34414f * (f2 - 128.0f) - 0.71414f * (f3 - 128.0f);
        float f6 = f + 1.772f * (f2 - 128.0f);
        byArray2[n] = (byte)Math.max(0.0f, Math.min(255.0f, f4));
        byArray2[n + 1] = (byte)Math.max(0.0f, Math.min(255.0f, f5));
        byArray2[n + 2] = (byte)Math.max(0.0f, Math.min(255.0f, f6));
    }

    @Override
    public void close() {
        this.nativeDestroy();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public DngCreator setDescription(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Null description passed to setDescription.");
        }
        this.nativeSetDescription(string2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public DngCreator setLocation(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Null location passed to setLocation");
        }
        double d = location.getLatitude();
        double d2 = location.getLongitude();
        long l = location.getTime();
        int[] nArray = DngCreator.toExifLatLong(d);
        int[] nArray2 = DngCreator.toExifLatLong(d2);
        String string2 = d >= 0.0 ? GPS_LAT_REF_NORTH : GPS_LAT_REF_SOUTH;
        String string3 = d2 >= 0.0 ? GPS_LONG_REF_EAST : GPS_LONG_REF_WEST;
        String string4 = sExifGPSDateStamp.format(l);
        this.mGPSTimeStampCalendar.setTimeInMillis(l);
        int[] nArray3 = new int[]{this.mGPSTimeStampCalendar.get(11), 1, this.mGPSTimeStampCalendar.get(12), 1, this.mGPSTimeStampCalendar.get(13), 1};
        this.nativeSetGpsTags(nArray, string2, nArray2, string3, string4, nArray3);
        return this;
    }

    public DngCreator setOrientation(int n) {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("Orientation " + n + " is not a valid EXIF orientation value");
        }
        this.nativeSetOrientation(n);
        return this;
    }

    public DngCreator setThumbnail(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Null argument to setThumbnail");
        }
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        if (n > 256 || n2 > 256) {
            throw new IllegalArgumentException("Thumbnail dimensions width,height (" + n + "," + n2 + ") too large, dimensions must be smaller than " + 256);
        }
        this.nativeSetThumbnail(DngCreator.convertToRGB(bitmap), n, n2);
        return this;
    }

    public DngCreator setThumbnail(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Null argument to setThumbnail");
        }
        int n = image.getFormat();
        if (n != 35) {
            throw new IllegalArgumentException("Unsupported Image format " + n);
        }
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        if (n2 > 256 || n3 > 256) {
            throw new IllegalArgumentException("Thumbnail dimensions width,height (" + n2 + "," + n3 + ") too large, dimensions must be smaller than " + 256);
        }
        this.nativeSetThumbnail(DngCreator.convertToRGB(image), n2, n3);
        return this;
    }

    public void writeByteBuffer(OutputStream outputStream, Size size, ByteBuffer byteBuffer, long l) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null dngOutput passed to writeByteBuffer");
        }
        if (size == null) {
            throw new IllegalArgumentException("Null size passed to writeByteBuffer");
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException("Null pixels passed to writeByteBuffer");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative offset passed to writeByteBuffer");
        }
        int n = size.getWidth();
        this.writeByteBuffer(n, size.getHeight(), byteBuffer, outputStream, 2, n * 2, l);
    }

    public void writeImage(OutputStream outputStream, Image image) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null dngOutput to writeImage");
        }
        if (image == null) {
            throw new IllegalArgumentException("Null pixels to writeImage");
        }
        int n = image.getFormat();
        if (n != 32) {
            throw new IllegalArgumentException("Unsupported image format " + n);
        }
        Image.Plane[] planeArray = image.getPlanes();
        if (planeArray == null || planeArray.length <= 0) {
            throw new IllegalArgumentException("Image with no planes passed to writeImage");
        }
        ByteBuffer byteBuffer = planeArray[0].getBuffer();
        this.writeByteBuffer(image.getWidth(), image.getHeight(), byteBuffer, outputStream, planeArray[0].getPixelStride(), planeArray[0].getRowStride(), 0L);
    }

    public void writeInputStream(OutputStream outputStream, Size size, InputStream inputStream, long l) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null dngOutput passed to writeInputStream");
        }
        if (size == null) {
            throw new IllegalArgumentException("Null size passed to writeInputStream");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Null pixels passed to writeInputStream");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative offset passed to writeInputStream");
        }
        int n = size.getWidth();
        int n2 = size.getHeight();
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Size with invalid width, height: (" + n + "," + n2 + ") passed to writeInputStream");
        }
        this.nativeWriteInputStream(outputStream, inputStream, n, n2, l);
    }
}

