/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import java.util.GregorianCalendar;

public class GeomagneticField {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final long BASE_TIME = 0L;
    private static final float[][] DELTA_G;
    private static final float[][] DELTA_H;
    private static final float EARTH_REFERENCE_RADIUS_KM = 6371.2f;
    private static final float EARTH_SEMI_MAJOR_AXIS_KM = 6378.137f;
    private static final float EARTH_SEMI_MINOR_AXIS_KM = 6356.7524f;
    private static final float[][] G_COEFF;
    private static final float[][] H_COEFF;
    private static final float[][] SCHMIDT_QUASI_NORM_FACTORS;
    private float mGcLatitudeRad;
    private float mGcLongitudeRad;
    private float mGcRadiusKm;
    private float mX;
    private float mY;
    private float mZ;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !GeomagneticField.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        G_COEFF = new float[][]{{0.0f}, {-29496.6f, -1586.3f}, {-2396.6f, 3026.1f, 1668.6f}, {1340.1f, -2326.2f, 1231.9f, 634.0f}, {912.6f, 808.9f, 166.7f, -357.1f, 89.4f}, {-230.9f, 357.2f, 200.3f, -141.1f, -163.0f, -7.8f}, {72.8f, 68.6f, 76.0f, -141.4f, -22.8f, 13.2f, -77.9f}, {80.5f, -75.1f, -4.7f, 45.3f, 13.9f, 10.4f, 1.7f, 4.9f}, {24.4f, 8.1f, -14.5f, -5.6f, -19.3f, 11.5f, 10.9f, -14.1f, -3.7f}, {5.4f, 9.4f, 3.4f, -5.2f, 3.1f, -12.4f, -0.7f, 8.4f, -8.5f, -10.1f}, {-2.0f, -6.3f, 0.9f, -1.1f, -0.2f, 2.5f, -0.3f, 2.2f, 3.1f, -1.0f, -2.8f}, {3.0f, -1.5f, -2.1f, 1.7f, -0.5f, 0.5f, -0.8f, 0.4f, 1.8f, 0.1f, 0.7f, 3.8f}, {-2.2f, -0.2f, 0.3f, 1.0f, -0.6f, 0.9f, -0.1f, 0.5f, -0.4f, -0.4f, 0.2f, -0.8f, 0.0f}};
        H_COEFF = new float[][]{{0.0f}, {0.0f, 4944.4f}, {0.0f, -2707.7f, -576.1f}, {0.0f, -160.2f, 251.9f, -536.6f}, {0.0f, 286.4f, -211.2f, 164.3f, -309.1f}, {0.0f, 44.6f, 188.9f, -118.2f, 0.0f, 100.9f}, {0.0f, -20.8f, 44.1f, 61.5f, -66.3f, 3.1f, 55.0f}, {0.0f, -57.9f, -21.1f, 6.5f, 24.9f, 7.0f, -27.7f, -3.3f}, {0.0f, 11.0f, -20.0f, 11.9f, -17.4f, 16.7f, 7.0f, -10.8f, 1.7f}, {0.0f, -20.5f, 11.5f, 12.8f, -7.2f, -7.4f, 8.0f, 2.1f, -6.1f, 7.0f}, {0.0f, 2.8f, -0.1f, 4.7f, 4.4f, -7.2f, -1.0f, -3.9f, -2.0f, -2.0f, -8.3f}, {0.0f, 0.2f, 1.7f, -0.6f, -1.8f, 0.9f, -0.4f, -2.5f, -1.3f, -2.1f, -1.9f, -1.8f}, {0.0f, -0.9f, 0.3f, 2.1f, -2.5f, 0.5f, 0.6f, 0.0f, 0.1f, 0.3f, -0.9f, -0.2f, 0.9f}};
        DELTA_G = new float[][]{{0.0f}, {11.6f, 16.5f}, {-12.1f, -4.4f, 1.9f}, {0.4f, -4.1f, -2.9f, -7.7f}, {-1.8f, 2.3f, -8.7f, 4.6f, -2.1f}, {-1.0f, 0.6f, -1.8f, -1.0f, 0.9f, 1.0f}, {-0.2f, -0.2f, -0.1f, 2.0f, -1.7f, -0.3f, 1.7f}, {0.1f, -0.1f, -0.6f, 1.3f, 0.4f, 0.3f, -0.7f, 0.6f}, {-0.1f, 0.1f, -0.6f, 0.2f, -0.2f, 0.3f, 0.3f, -0.6f, 0.2f}, {0.0f, -0.1f, 0.0f, 0.3f, -0.4f, -0.3f, 0.1f, -0.1f, -0.4f, -0.2f}, {0.0f, 0.0f, -0.1f, 0.2f, 0.0f, -0.1f, -0.2f, 0.0f, -0.1f, -0.2f, -0.2f}, {0.0f, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.1f, 0.0f}, {0.0f, 0.0f, 0.1f, 0.1f, -0.1f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.1f, 0.1f}};
        DELTA_H = new float[][]{{0.0f}, {0.0f, -25.9f}, {0.0f, -22.5f, -11.8f}, {0.0f, 7.3f, -3.9f, -2.6f}, {0.0f, 1.1f, 2.7f, 3.9f, -0.8f}, {0.0f, 0.4f, 1.8f, 1.2f, 4.0f, -0.6f}, {0.0f, -0.2f, -2.1f, -0.4f, -0.6f, 0.5f, 0.9f}, {0.0f, 0.7f, 0.3f, -0.1f, -0.1f, -0.8f, -0.3f, 0.3f}, {0.0f, -0.1f, 0.2f, 0.4f, 0.4f, 0.1f, -0.1f, 0.4f, 0.3f}, {0.0f, 0.0f, -0.2f, 0.0f, -0.1f, 0.1f, 0.0f, -0.2f, 0.3f, 0.2f}, {0.0f, 0.1f, -0.1f, 0.0f, -0.1f, -0.1f, 0.0f, -0.1f, -0.2f, 0.0f, -0.1f}, {0.0f, 0.0f, 0.1f, 0.0f, 0.1f, 0.0f, 0.1f, 0.0f, -0.1f, -0.1f, 0.0f, -0.1f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}};
        BASE_TIME = new GregorianCalendar(2010, 1, 1).getTimeInMillis();
        SCHMIDT_QUASI_NORM_FACTORS = GeomagneticField.computeSchmidtQuasiNormFactors(G_COEFF.length);
    }

    public GeomagneticField(float f, float f2, float f3, long l) {
        int n = G_COEFF.length;
        float f4 = Math.min(89.99999f, Math.max(-89.99999f, f));
        this.computeGeocentricCoordinates(f4, f2, f3);
        if (!$assertionsDisabled && G_COEFF.length != H_COEFF.length) {
            throw new AssertionError();
        }
        LegendreTable legendreTable = new LegendreTable(n - 1, (float)(1.5707963267948966 - (double)this.mGcLatitudeRad));
        float[] fArray = new float[n + 2];
        fArray[0] = 1.0f;
        fArray[1] = 6371.2f / this.mGcRadiusKm;
        for (int i = 2; i < fArray.length; ++i) {
            fArray[i] = fArray[i - 1] * fArray[1];
        }
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        fArray2[0] = 0.0f;
        fArray3[0] = 1.0f;
        fArray2[1] = (float)Math.sin(this.mGcLongitudeRad);
        fArray3[1] = (float)Math.cos(this.mGcLongitudeRad);
        for (int i = 2; i < n; ++i) {
            int n2 = i >> 1;
            fArray2[i] = fArray2[i - n2] * fArray3[n2] + fArray3[i - n2] * fArray2[n2];
            fArray3[i] = fArray3[i - n2] * fArray3[n2] - fArray2[i - n2] * fArray2[n2];
        }
        float f5 = 1.0f / (float)Math.cos(this.mGcLatitudeRad);
        float f6 = (float)(l - BASE_TIME) / 3.1536E10f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                float f10 = G_COEFF[i][j] + f6 * DELTA_G[i][j];
                float f11 = H_COEFF[i][j] + f6 * DELTA_H[i][j];
                f7 += fArray[i + 2] * (f10 * fArray3[j] + f11 * fArray2[j]) * legendreTable.mPDeriv[i][j] * SCHMIDT_QUASI_NORM_FACTORS[i][j];
                f8 += f5 * (fArray[i + 2] * (float)j * (f10 * fArray2[j] - f11 * fArray3[j]) * legendreTable.mP[i][j] * SCHMIDT_QUASI_NORM_FACTORS[i][j]);
                f9 -= (float)(i + 1) * fArray[i + 2] * (f10 * fArray3[j] + f11 * fArray2[j]) * legendreTable.mP[i][j] * SCHMIDT_QUASI_NORM_FACTORS[i][j];
            }
        }
        double d = Math.toRadians(f4) - (double)this.mGcLatitudeRad;
        this.mX = (float)((double)f7 * Math.cos(d) + (double)f9 * Math.sin(d));
        this.mY = f8;
        this.mZ = (float)((double)(-f7) * Math.sin(d) + (double)f9 * Math.cos(d));
    }

    private void computeGeocentricCoordinates(float f, float f2, float f3) {
        float f4 = f3 / 1000.0f;
        double d = Math.toRadians(f);
        float f5 = (float)Math.cos(d);
        float f6 = (float)Math.sin(d);
        float f7 = f6 / f5;
        float f8 = (float)Math.sqrt(f5 * (4.0680636E7f * f5) + f6 * (4.04083E7f * f6));
        this.mGcLatitudeRad = (float)Math.atan(f7 * (4.04083E7f + f8 * f4) / (4.0680636E7f + f8 * f4));
        this.mGcLongitudeRad = (float)Math.toRadians(f2);
        this.mGcRadiusKm = (float)Math.sqrt(f4 * f4 + 2.0f * f4 * (float)Math.sqrt(f5 * (4.0680636E7f * f5) + f6 * (4.04083E7f * f6)) + (f5 * (f5 * (4.0680636E7f * 4.0680636E7f)) + f6 * (f6 * (4.04083E7f * 4.04083E7f))) / (f5 * (4.0680636E7f * f5) + f6 * (4.04083E7f * f6)));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static float[][] computeSchmidtQuasiNormFactors(int n) {
        float[][] fArrayArray = new float[n + 1][];
        fArrayArray[0] = new float[]{1.0f};
        int n2 = 1;
        while (n2 <= n) {
            fArrayArray[n2] = new float[n2 + 1];
            fArrayArray[n2][0] = fArrayArray[n2 - 1][0] * (float)(-1 + n2 * 2) / (float)n2;
            for (int i = 1; i <= n2; ++i) {
                float[] fArray = fArrayArray[n2];
                float f = fArrayArray[n2][i - 1];
                int n3 = 1 + (n2 - i);
                int n4 = i == 1 ? 2 : 1;
                fArray[i] = f * (float)Math.sqrt((float)(n4 * n3) / (float)(n2 + i));
            }
            ++n2;
        }
        return fArrayArray;
    }

    public float getDeclination() {
        return (float)Math.toDegrees(Math.atan2(this.mY, this.mX));
    }

    public float getFieldStrength() {
        return (float)Math.sqrt(this.mX * this.mX + this.mY * this.mY + this.mZ * this.mZ);
    }

    public float getHorizontalStrength() {
        return (float)Math.sqrt(this.mX * this.mX + this.mY * this.mY);
    }

    public float getInclination() {
        return (float)Math.toDegrees(Math.atan2(this.mZ, this.getHorizontalStrength()));
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getZ() {
        return this.mZ;
    }

    private static class LegendreTable {
        static final /* synthetic */ boolean $assertionsDisabled;
        public final float[][] mP;
        public final float[][] mPDeriv;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !GeomagneticField.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public LegendreTable(int n, float f) {
            float f2 = (float)Math.cos(f);
            float f3 = (float)Math.sin(f);
            this.mP = new float[n + 1][];
            this.mPDeriv = new float[n + 1][];
            this.mP[0] = new float[]{1.0f};
            this.mPDeriv[0] = new float[]{0.0f};
            int n2 = 1;
            while (n2 <= n) {
                this.mP[n2] = new float[n2 + 1];
                this.mPDeriv[n2] = new float[n2 + 1];
                for (int i = 0; i <= n2; ++i) {
                    if (n2 == i) {
                        this.mP[n2][i] = f3 * this.mP[n2 - 1][i - 1];
                        this.mPDeriv[n2][i] = f2 * this.mP[n2 - 1][i - 1] + f3 * this.mPDeriv[n2 - 1][i - 1];
                        continue;
                    }
                    if (n2 == 1 || i == n2 - 1) {
                        this.mP[n2][i] = f2 * this.mP[n2 - 1][i];
                        this.mPDeriv[n2][i] = -f3 * this.mP[n2 - 1][i] + f2 * this.mPDeriv[n2 - 1][i];
                        continue;
                    }
                    if (!($assertionsDisabled || n2 > 1 && i < n2 - 1)) {
                        throw new AssertionError();
                    }
                    float f4 = (float)((n2 - 1) * (n2 - 1) - i * i) / (float)((-1 + n2 * 2) * (-3 + n2 * 2));
                    this.mP[n2][i] = f2 * this.mP[n2 - 1][i] - f4 * this.mP[n2 - 2][i];
                    this.mPDeriv[n2][i] = -f3 * this.mP[n2 - 1][i] + f2 * this.mPDeriv[n2 - 1][i] - f4 * this.mPDeriv[n2 - 2][i];
                }
                ++n2;
            }
            return;
        }
    }
}

