/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.OsConstants;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.Libcore;

public final class PdfRenderer
implements AutoCloseable {
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private Page mCurrentPage;
    private ParcelFileDescriptor mInput;
    private final long mNativeDocument;
    private final int mPageCount;
    private final Point mTempPoint = new Point();

    public PdfRenderer(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        long l;
        if (parcelFileDescriptor == null) {
            throw new NullPointerException("input cannot be null");
        }
        try {
            Libcore.os.lseek(parcelFileDescriptor.getFileDescriptor(), 0L, OsConstants.SEEK_SET);
            l = Libcore.os.fstat((FileDescriptor)parcelFileDescriptor.getFileDescriptor()).st_size;
            this.mInput = parcelFileDescriptor;
        }
        catch (ErrnoException errnoException) {
            throw new IllegalArgumentException("file descriptor not seekable");
        }
        this.mNativeDocument = PdfRenderer.nativeCreate(this.mInput.getFd(), l);
        this.mPageCount = PdfRenderer.nativeGetPageCount(this.mNativeDocument);
        this.mCloseGuard.open("close");
    }

    static /* synthetic */ Page access$602(PdfRenderer pdfRenderer, Page page) {
        pdfRenderer.mCurrentPage = page;
        return page;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doClose() {
        if (this.mCurrentPage != null) {
            this.mCurrentPage.close();
        }
        PdfRenderer.nativeClose(this.mNativeDocument);
        try {
            this.mInput.close();
        }
        catch (IOException iOException) {}
        this.mInput = null;
        this.mCloseGuard.close();
    }

    private static native void nativeClose(long var0);

    private static native void nativeClosePage(long var0);

    private static native long nativeCreate(int var0, long var1);

    private static native int nativeGetPageCount(long var0);

    private static native long nativeOpenPageAndGetSize(long var0, int var2, Point var3);

    private static native void nativeRenderPage(long var0, long var2, long var4, int var6, int var7, int var8, int var9, long var10, int var12);

    private static native boolean nativeScaleForPrinting(long var0);

    private void throwIfClosed() {
        if (this.mInput == null) {
            throw new IllegalStateException("Already closed");
        }
    }

    private void throwIfPageNotInDocument(int n) {
        if (n < 0 || n >= this.mPageCount) {
            throw new IllegalArgumentException("Invalid page index");
        }
    }

    private void throwIfPageOpened() {
        if (this.mCurrentPage != null) {
            throw new IllegalStateException("Current page not closed");
        }
    }

    @Override
    public void close() {
        this.throwIfClosed();
        this.throwIfPageOpened();
        this.doClose();
    }

    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            if (this.mInput != null) {
                this.doClose();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getPageCount() {
        this.throwIfClosed();
        return this.mPageCount;
    }

    public Page openPage(int n) {
        this.throwIfClosed();
        this.throwIfPageOpened();
        this.throwIfPageNotInDocument(n);
        this.mCurrentPage = new Page(n);
        return this.mCurrentPage;
    }

    public boolean shouldScaleForPrinting() {
        this.throwIfClosed();
        return PdfRenderer.nativeScaleForPrinting(this.mNativeDocument);
    }

    public final class Page
    implements AutoCloseable {
        public static final int RENDER_MODE_FOR_DISPLAY = 1;
        public static final int RENDER_MODE_FOR_PRINT = 2;
        private final CloseGuard mCloseGuard = CloseGuard.get();
        private final int mHeight;
        private final int mIndex;
        private long mNativePage;
        private final int mWidth;

        private Page(int n) {
            Point point = PdfRenderer.this.mTempPoint;
            this.mNativePage = PdfRenderer.nativeOpenPageAndGetSize(PdfRenderer.this.mNativeDocument, n, point);
            this.mIndex = n;
            this.mWidth = point.x;
            this.mHeight = point.y;
            this.mCloseGuard.open("close");
        }

        private void doClose() {
            PdfRenderer.nativeClosePage(this.mNativePage);
            this.mNativePage = 0L;
            this.mCloseGuard.close();
            PdfRenderer.access$602(PdfRenderer.this, null);
        }

        private void throwIfClosed() {
            if (this.mNativePage == 0L) {
                throw new IllegalStateException("Already closed");
            }
        }

        @Override
        public void close() {
            this.throwIfClosed();
            this.doClose();
        }

        protected void finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                if (this.mNativePage != 0L) {
                    this.doClose();
                }
                return;
            }
            finally {
                super.finalize();
            }
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public int getWidth() {
            return this.mWidth;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void render(Bitmap bitmap, Rect rect, Matrix matrix, int n) {
            if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
                throw new IllegalArgumentException("Unsupported pixel format");
            }
            if (rect != null && (rect.left < 0 || rect.top < 0 || rect.right > bitmap.getWidth() || rect.bottom > bitmap.getHeight())) {
                throw new IllegalArgumentException("destBounds not in destination");
            }
            if (matrix != null && !matrix.isAffine()) {
                throw new IllegalArgumentException("transform not affine");
            }
            if (n != 2 && n != 1) {
                throw new IllegalArgumentException("Unsupported render mode");
            }
            if (n == 2 && n == 1) {
                throw new IllegalArgumentException("Only single render mode supported");
            }
            int n2 = rect != null ? rect.left : 0;
            int n3 = rect != null ? rect.top : 0;
            int n4 = rect != null ? rect.right : bitmap.getWidth();
            int n5 = rect != null ? rect.bottom : bitmap.getHeight();
            long l = matrix != null ? matrix.native_instance : 0L;
            PdfRenderer.nativeRenderPage(PdfRenderer.this.mNativeDocument, this.mNativePage, bitmap.mNativeBitmap, n2, n3, n4, n5, l, n);
        }
    }
}

