/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import dalvik.system.CloseGuard;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PdfDocument {
    private final byte[] mChunk = new byte[4096];
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private Page mCurrentPage;
    private long mNativeDocument;
    private final List<PageInfo> mPages = new ArrayList<PageInfo>();

    public PdfDocument() {
        this.mNativeDocument = this.nativeCreateDocument();
        this.mCloseGuard.open("close");
    }

    private void dispose() {
        if (this.mNativeDocument != 0L) {
            this.nativeClose(this.mNativeDocument);
            this.mCloseGuard.close();
            this.mNativeDocument = 0L;
        }
    }

    private native void nativeClose(long var1);

    private native long nativeCreateDocument();

    private native void nativeFinishPage(long var1);

    private static native long nativeStartPage(long var0, int var2, int var3, int var4, int var5, int var6, int var7);

    private native void nativeWriteTo(long var1, OutputStream var3, byte[] var4);

    private void throwIfClosed() {
        if (this.mNativeDocument == 0L) {
            throw new IllegalStateException("document is closed!");
        }
    }

    private void throwIfCurrentPageNotFinished() {
        if (this.mCurrentPage != null) {
            throw new IllegalStateException("Current page not finished!");
        }
    }

    public void close() {
        this.throwIfCurrentPageNotFinished();
        this.dispose();
    }

    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.dispose();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void finishPage(Page page) {
        this.throwIfClosed();
        if (page == null) {
            throw new IllegalArgumentException("page cannot be null");
        }
        if (page != this.mCurrentPage) {
            throw new IllegalStateException("invalid page");
        }
        if (page.isFinished()) {
            throw new IllegalStateException("page already finished");
        }
        this.mPages.add(page.getInfo());
        this.mCurrentPage = null;
        this.nativeFinishPage(this.mNativeDocument);
        page.finish();
    }

    public List<PageInfo> getPages() {
        return Collections.unmodifiableList(this.mPages);
    }

    public Page startPage(PageInfo pageInfo) {
        this.throwIfClosed();
        this.throwIfCurrentPageNotFinished();
        if (pageInfo == null) {
            throw new IllegalArgumentException("page cannot be null");
        }
        this.mCurrentPage = new Page(new PdfCanvas(PdfDocument.nativeStartPage(this.mNativeDocument, pageInfo.mPageWidth, pageInfo.mPageHeight, ((PageInfo)pageInfo).mContentRect.left, ((PageInfo)pageInfo).mContentRect.top, ((PageInfo)pageInfo).mContentRect.right, ((PageInfo)pageInfo).mContentRect.bottom)), pageInfo);
        return this.mCurrentPage;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.throwIfClosed();
        this.throwIfCurrentPageNotFinished();
        if (outputStream == null) {
            throw new IllegalArgumentException("out cannot be null!");
        }
        this.nativeWriteTo(this.mNativeDocument, outputStream, this.mChunk);
    }

    public static final class Page {
        private Canvas mCanvas;
        private final PageInfo mPageInfo;

        private Page(Canvas canvas, PageInfo pageInfo) {
            this.mCanvas = canvas;
            this.mPageInfo = pageInfo;
        }

        private void finish() {
            if (this.mCanvas != null) {
                this.mCanvas.release();
                this.mCanvas = null;
            }
        }

        public Canvas getCanvas() {
            return this.mCanvas;
        }

        public PageInfo getInfo() {
            return this.mPageInfo;
        }

        boolean isFinished() {
            return this.mCanvas == null;
        }
    }

    public static final class PageInfo {
        private Rect mContentRect;
        private int mPageHeight;
        private int mPageNumber;
        private int mPageWidth;

        private PageInfo() {
        }

        static /* synthetic */ int access$002(PageInfo pageInfo, int n) {
            pageInfo.mPageWidth = n;
            return n;
        }

        static /* synthetic */ int access$102(PageInfo pageInfo, int n) {
            pageInfo.mPageHeight = n;
            return n;
        }

        static /* synthetic */ Rect access$202(PageInfo pageInfo, Rect rect) {
            pageInfo.mContentRect = rect;
            return rect;
        }

        static /* synthetic */ int access$602(PageInfo pageInfo, int n) {
            pageInfo.mPageNumber = n;
            return n;
        }

        public Rect getContentRect() {
            return this.mContentRect;
        }

        public int getPageHeight() {
            return this.mPageHeight;
        }

        public int getPageNumber() {
            return this.mPageNumber;
        }

        public int getPageWidth() {
            return this.mPageWidth;
        }

        public static final class Builder {
            private final PageInfo mPageInfo = new PageInfo();

            public Builder(int n, int n2, int n3) {
                if (n <= 0) {
                    throw new IllegalArgumentException("page width must be positive");
                }
                if (n2 <= 0) {
                    throw new IllegalArgumentException("page width must be positive");
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException("pageNumber must be non negative");
                }
                PageInfo.access$002(this.mPageInfo, n);
                PageInfo.access$102(this.mPageInfo, n2);
                PageInfo.access$602(this.mPageInfo, n3);
            }

            public PageInfo create() {
                if (this.mPageInfo.mContentRect == null) {
                    PageInfo.access$202(this.mPageInfo, new Rect(0, 0, this.mPageInfo.mPageWidth, this.mPageInfo.mPageHeight));
                }
                return this.mPageInfo;
            }

            public Builder setContentRect(Rect rect) {
                if (rect != null && (rect.left < 0 || rect.top < 0 || rect.right > this.mPageInfo.mPageWidth || rect.bottom > this.mPageInfo.mPageHeight)) {
                    throw new IllegalArgumentException("contentRect does not fit the page");
                }
                PageInfo.access$202(this.mPageInfo, rect);
                return this;
            }
        }
    }

    private final class PdfCanvas
    extends Canvas {
        public PdfCanvas(long l) {
            super(l);
        }

        @Override
        public void setBitmap(Bitmap bitmap) {
            throw new UnsupportedOperationException();
        }
    }
}

