/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.SystemClock;

public class TransitionDrawable
extends LayerDrawable
implements Drawable.Callback {
    private static final int TRANSITION_NONE = 2;
    private static final int TRANSITION_RUNNING = 1;
    private static final int TRANSITION_STARTING;
    private int mAlpha = 0;
    private boolean mCrossFade;
    private int mDuration;
    private int mFrom;
    private int mOriginalDuration;
    private boolean mReverse;
    private long mStartTimeMillis;
    private int mTo;
    private int mTransitionState = 2;

    TransitionDrawable() {
        this(new TransitionState(null, null, null), null, null);
    }

    private TransitionDrawable(TransitionState transitionState, Resources resources, Resources.Theme theme) {
        super(transitionState, resources, theme);
    }

    private TransitionDrawable(TransitionState transitionState, Drawable[] drawableArray) {
        super(drawableArray, transitionState);
    }

    public TransitionDrawable(Drawable[] drawableArray) {
        this(new TransitionState(null, null, null), drawableArray);
    }

    @Override
    LayerDrawable.LayerState createConstantState(LayerDrawable.LayerState layerState, Resources resources) {
        return new TransitionState((TransitionState)layerState, this, resources);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.mTransitionState) {
            case 0: {
                this.mStartTimeMillis = SystemClock.uptimeMillis();
                this.mTransitionState = 1;
                bl = false;
                break;
            }
            case 1: {
                if (this.mStartTimeMillis < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.mStartTimeMillis) / (float)this.mDuration;
                bl = f >= 1.0f;
                float f2 = Math.min(f, 1.0f);
                this.mAlpha = (int)((float)this.mFrom + f2 * (float)(this.mTo - this.mFrom));
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.mCrossFade;
        LayerDrawable.ChildDrawable[] childDrawableArray = this.mLayerState.mChildren;
        if (bl) {
            if (!bl2 || n == 0) {
                childDrawableArray[0].mDrawable.draw(canvas);
            }
            if (n != 255) return;
            childDrawableArray[1].mDrawable.draw(canvas);
            return;
        }
        Drawable drawable2 = childDrawableArray[0].mDrawable;
        if (bl2) {
            drawable2.setAlpha(255 - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(255);
        }
        if (n > 0) {
            Drawable drawable3 = childDrawableArray[1].mDrawable;
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(255);
        }
        if (bl) return;
        this.invalidateSelf();
    }

    public boolean isCrossFadeEnabled() {
        return this.mCrossFade;
    }

    public void resetTransition() {
        this.mAlpha = 0;
        this.mTransitionState = 2;
        this.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void reverseTransition(int n) {
        boolean bl = true;
        long l = SystemClock.uptimeMillis();
        if (l - this.mStartTimeMillis > (long)this.mDuration) {
            if (this.mTo == 0) {
                this.mFrom = 0;
                this.mTo = 255;
                this.mAlpha = 0;
                this.mReverse = false;
            } else {
                this.mFrom = 255;
                this.mTo = 0;
                this.mAlpha = 255;
                this.mReverse = bl;
            }
            this.mOriginalDuration = n;
            this.mDuration = n;
            this.mTransitionState = 0;
            this.invalidateSelf();
            return;
        }
        if (this.mReverse) {
            bl = false;
        }
        this.mReverse = bl;
        this.mFrom = this.mAlpha;
        int n2 = this.mReverse ? 0 : 255;
        this.mTo = n2;
        long l2 = this.mReverse ? l - this.mStartTimeMillis : (long)this.mOriginalDuration - (l - this.mStartTimeMillis);
        this.mDuration = (int)l2;
        this.mTransitionState = 0;
    }

    public void setCrossFadeEnabled(boolean bl) {
        this.mCrossFade = bl;
    }

    public void startTransition(int n) {
        this.mFrom = 0;
        this.mTo = 255;
        this.mAlpha = 0;
        this.mOriginalDuration = n;
        this.mDuration = n;
        this.mReverse = false;
        this.mTransitionState = 0;
        this.invalidateSelf();
    }

    static class TransitionState
    extends LayerDrawable.LayerState {
        TransitionState(TransitionState transitionState, TransitionDrawable transitionDrawable, Resources resources) {
            super(transitionState, transitionDrawable, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new TransitionDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new TransitionDrawable(this, resources, null);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return new TransitionDrawable(this, resources, theme);
        }
    }
}

