/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BitmapDrawable
extends Drawable {
    private static final int DEFAULT_PAINT_FLAGS = 6;
    private static final int TILE_MODE_CLAMP = 0;
    private static final int TILE_MODE_DISABLED = -1;
    private static final int TILE_MODE_MIRROR = 2;
    private static final int TILE_MODE_REPEAT = 1;
    private static final int TILE_MODE_UNDEFINED = -2;
    private int mBitmapHeight;
    private BitmapState mBitmapState;
    private int mBitmapWidth;
    private final Rect mDstRect = new Rect();
    private boolean mDstRectAndInsetsDirty = true;
    private Matrix mMirrorMatrix;
    private boolean mMutated;
    private Insets mOpticalInsets = Insets.NONE;
    private int mTargetDensity = 160;
    private PorterDuffColorFilter mTintFilter;

    @Deprecated
    public BitmapDrawable() {
        this.mBitmapState = new BitmapState((Bitmap)null);
    }

    @Deprecated
    public BitmapDrawable(Resources resources) {
        this.mBitmapState = new BitmapState((Bitmap)null);
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
    }

    public BitmapDrawable(Resources resources, Bitmap bitmap) {
        this(new BitmapState(bitmap), resources, null);
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
    }

    public BitmapDrawable(Resources resources, InputStream inputStream) {
        this(new BitmapState(BitmapFactory.decodeStream(inputStream)), null, null);
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
        if (this.mBitmapState.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + inputStream);
        }
    }

    public BitmapDrawable(Resources resources, String string2) {
        this(new BitmapState(BitmapFactory.decodeFile(string2)), null, null);
        this.mBitmapState.mTargetDensity = this.mTargetDensity;
        if (this.mBitmapState.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + string2);
        }
    }

    @Deprecated
    public BitmapDrawable(Bitmap bitmap) {
        this(new BitmapState(bitmap), null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private BitmapDrawable(BitmapState bitmapState, Resources resources, Resources.Theme theme) {
        if (theme != null && bitmapState.canApplyTheme()) {
            this.mBitmapState = new BitmapState(bitmapState);
            this.applyTheme(theme);
        } else {
            this.mBitmapState = bitmapState;
        }
        this.initializeWithState(bitmapState, resources);
    }

    @Deprecated
    public BitmapDrawable(InputStream inputStream) {
        this(new BitmapState(BitmapFactory.decodeStream(inputStream)), null, null);
        if (this.mBitmapState.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + inputStream);
        }
    }

    @Deprecated
    public BitmapDrawable(String string2) {
        this(new BitmapState(BitmapFactory.decodeFile(string2)), null, null);
        if (this.mBitmapState.mBitmap == null) {
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + string2);
        }
    }

    private void computeBitmapSize() {
        Bitmap bitmap = this.mBitmapState.mBitmap;
        if (bitmap != null) {
            this.mBitmapWidth = bitmap.getScaledWidth(this.mTargetDensity);
            this.mBitmapHeight = bitmap.getScaledHeight(this.mTargetDensity);
            return;
        }
        this.mBitmapHeight = -1;
        this.mBitmapWidth = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initializeWithState(BitmapState bitmapState, Resources resources) {
        this.mTargetDensity = resources != null ? resources.getDisplayMetrics().densityDpi : bitmapState.mTargetDensity;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, bitmapState.mTint, bitmapState.mTintMode);
        this.computeBitmapSize();
    }

    private boolean needMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    private static Shader.TileMode parseTileMode(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 0: {
                return Shader.TileMode.CLAMP;
            }
            case 1: {
                return Shader.TileMode.REPEAT;
            }
            case 2: 
        }
        return Shader.TileMode.MIRROR;
    }

    private void setBitmap(Bitmap bitmap) {
        if (this.mBitmapState.mBitmap != bitmap) {
            this.mBitmapState.mBitmap = bitmap;
            this.computeBitmapSize();
            this.invalidateSelf();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateDstRectAndInsetsIfDirty() {
        if (this.mDstRectAndInsetsDirty) {
            if (this.mBitmapState.mTileModeX == null && this.mBitmapState.mTileModeY == null) {
                Rect rect = this.getBounds();
                int n = this.getLayoutDirection();
                Gravity.apply(this.mBitmapState.mGravity, this.mBitmapWidth, this.mBitmapHeight, rect, this.mDstRect, n);
                this.mOpticalInsets = Insets.of(this.mDstRect.left - rect.left, this.mDstRect.top - rect.top, rect.right - this.mDstRect.right, rect.bottom - this.mDstRect.bottom);
            } else {
                this.copyBounds(this.mDstRect);
                this.mOpticalInsets = Insets.NONE;
            }
        }
        this.mDstRectAndInsetsDirty = false;
    }

    private void updateMirrorMatrix(float f) {
        if (this.mMirrorMatrix == null) {
            this.mMirrorMatrix = new Matrix();
        }
        this.mMirrorMatrix.setTranslate(f, 0.0f);
        this.mMirrorMatrix.preScale(-1.0f, 1.0f);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        int n;
        int n2;
        ColorStateList colorStateList;
        Resources resources = typedArray.getResources();
        BitmapState bitmapState = this.mBitmapState;
        bitmapState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        bitmapState.mThemeAttrs = typedArray.extractThemeAttrs();
        int n3 = typedArray.getResourceId(1, 0);
        if (n3 != 0) {
            Bitmap bitmap = BitmapFactory.decodeResource(resources, n3);
            if (bitmap == null) {
                throw new XmlPullParserException(typedArray.getPositionDescription() + ": <bitmap> requires a valid src attribute");
            }
            bitmapState.mBitmap = bitmap;
        }
        bitmapState.mTargetDensity = resources.getDisplayMetrics().densityDpi;
        boolean bl = bitmapState.mBitmap != null ? bitmapState.mBitmap.hasMipMap() : false;
        this.setMipMap(typedArray.getBoolean(8, bl));
        bitmapState.mAutoMirrored = typedArray.getBoolean(9, bitmapState.mAutoMirrored);
        bitmapState.mBaseAlpha = typedArray.getFloat(7, bitmapState.mBaseAlpha);
        int n4 = typedArray.getInt(10, -1);
        if (n4 != -1) {
            bitmapState.mTintMode = Drawable.parseTintMode(n4, PorterDuff.Mode.SRC_IN);
        }
        if ((colorStateList = typedArray.getColorStateList(5)) != null) {
            bitmapState.mTint = colorStateList;
        }
        Paint paint = this.mBitmapState.mPaint;
        paint.setAntiAlias(typedArray.getBoolean(2, paint.isAntiAlias()));
        paint.setFilterBitmap(typedArray.getBoolean(3, paint.isFilterBitmap()));
        paint.setDither(typedArray.getBoolean(4, paint.isDither()));
        this.setGravity(typedArray.getInt(0, bitmapState.mGravity));
        int n5 = typedArray.getInt(6, -2);
        if (n5 != -2) {
            Shader.TileMode tileMode = BitmapDrawable.parseTileMode(n5);
            this.setTileModeXY(tileMode, tileMode);
        }
        if ((n2 = typedArray.getInt(11, -2)) != -2) {
            this.setTileModeX(BitmapDrawable.parseTileMode(n2));
        }
        if ((n = typedArray.getInt(12, -2)) != -2) {
            this.setTileModeY(BitmapDrawable.parseTileMode(n));
        }
        this.initializeWithState(bitmapState, resources);
    }

    private void verifyState(TypedArray typedArray) throws XmlPullParserException {
        if (this.mBitmapState.mBitmap == null) {
            throw new XmlPullParserException(typedArray.getPositionDescription() + ": <bitmap> requires a valid src attribute");
        }
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        BitmapState bitmapState = this.mBitmapState;
        if (bitmapState == null || bitmapState.mThemeAttrs == null) {
            return;
        }
        TypedArray typedArray = theme.resolveAttributes(bitmapState.mThemeAttrs, R.styleable.BitmapDrawable);
        try {
            this.updateStateFromTypedArray(typedArray);
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException(xmlPullParserException);
        }
        finally {
            typedArray.recycle();
        }
    }

    @Override
    public boolean canApplyTheme() {
        return this.mBitmapState != null && this.mBitmapState.mThemeAttrs != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        int n;
        Paint paint;
        block23: {
            block22: {
                boolean bl;
                Bitmap bitmap = this.mBitmapState.mBitmap;
                if (bitmap == null) break block22;
                BitmapState bitmapState = this.mBitmapState;
                paint = bitmapState.mPaint;
                if (bitmapState.mRebuildShader) {
                    Shader.TileMode tileMode = bitmapState.mTileModeX;
                    Shader.TileMode tileMode2 = bitmapState.mTileModeY;
                    if (tileMode == null && tileMode2 == null) {
                        paint.setShader(null);
                    } else {
                        if (tileMode == null) {
                            tileMode = Shader.TileMode.CLAMP;
                        }
                        if (tileMode2 == null) {
                            tileMode2 = Shader.TileMode.CLAMP;
                        }
                        paint.setShader(new BitmapShader(bitmap, tileMode, tileMode2));
                    }
                    bitmapState.mRebuildShader = false;
                }
                if (bitmapState.mBaseAlpha != 1.0f) {
                    Paint paint2 = this.getPaint();
                    n = paint2.getAlpha();
                    paint2.setAlpha((int)(0.5f + (float)n * bitmapState.mBaseAlpha));
                } else {
                    n = -1;
                }
                if (this.mTintFilter != null && paint.getColorFilter() == null) {
                    paint.setColorFilter(this.mTintFilter);
                    bl = true;
                } else {
                    bl = false;
                }
                this.updateDstRectAndInsetsIfDirty();
                Shader shader = paint.getShader();
                boolean bl2 = this.needMirroring();
                if (shader == null) {
                    if (bl2) {
                        canvas.save();
                        canvas.translate(this.mDstRect.right - this.mDstRect.left, 0.0f);
                        canvas.scale(-1.0f, 1.0f);
                    }
                    canvas.drawBitmap(bitmap, null, this.mDstRect, paint);
                    if (bl2) {
                        canvas.restore();
                    }
                } else {
                    if (bl2) {
                        this.updateMirrorMatrix(this.mDstRect.right - this.mDstRect.left);
                        shader.setLocalMatrix(this.mMirrorMatrix);
                        paint.setShader(shader);
                    } else if (this.mMirrorMatrix != null) {
                        this.mMirrorMatrix = null;
                        shader.setLocalMatrix(Matrix.IDENTITY_MATRIX);
                        paint.setShader(shader);
                    }
                    canvas.drawRect(this.mDstRect, paint);
                }
                if (bl) {
                    paint.setColorFilter(null);
                }
                if (n >= 0) break block23;
            }
            return;
        }
        paint.setAlpha(n);
    }

    @Override
    public int getAlpha() {
        return this.mBitmapState.mPaint.getAlpha();
    }

    public final Bitmap getBitmap() {
        return this.mBitmapState.mBitmap;
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mBitmapState.mChangingConfigurations;
    }

    @Override
    public ColorFilter getColorFilter() {
        return this.mBitmapState.mPaint.getColorFilter();
    }

    @Override
    public final Drawable.ConstantState getConstantState() {
        this.mBitmapState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mBitmapState;
    }

    public int getGravity() {
        return this.mBitmapState.mGravity;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getOpacity() {
        Bitmap bitmap;
        if (this.mBitmapState.mGravity != 119 || (bitmap = this.mBitmapState.mBitmap) == null || bitmap.hasAlpha() || this.mBitmapState.mPaint.getAlpha() < 255) {
            return -3;
        }
        return -1;
    }

    @Override
    public Insets getOpticalInsets() {
        this.updateDstRectAndInsetsIfDirty();
        return this.mOpticalInsets;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void getOutline(Outline outline) {
        this.updateDstRectAndInsetsIfDirty();
        outline.setRect(this.mDstRect);
        boolean bl = this.mBitmapState.mBitmap != null && !this.mBitmapState.mBitmap.hasAlpha();
        float f = bl ? (float)this.getAlpha() / 255.0f : 0.0f;
        outline.setAlpha(f);
    }

    public final Paint getPaint() {
        return this.mBitmapState.mPaint;
    }

    public Shader.TileMode getTileModeX() {
        return this.mBitmapState.mTileModeX;
    }

    public Shader.TileMode getTileModeY() {
        return this.mBitmapState.mTileModeY;
    }

    public ColorStateList getTint() {
        return this.mBitmapState.mTint;
    }

    public PorterDuff.Mode getTintMode() {
        return this.mBitmapState.mTintMode;
    }

    public boolean hasAntiAlias() {
        return this.mBitmapState.mPaint.isAntiAlias();
    }

    public boolean hasMipMap() {
        return this.mBitmapState.mBitmap != null && this.mBitmapState.mBitmap.hasMipMap();
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(resources, xmlPullParser, attributeSet, theme);
        TypedArray typedArray = BitmapDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.BitmapDrawable);
        this.updateStateFromTypedArray(typedArray);
        this.verifyState(typedArray);
        typedArray.recycle();
    }

    @Override
    public final boolean isAutoMirrored() {
        return this.mBitmapState.mAutoMirrored;
    }

    @Override
    public boolean isStateful() {
        BitmapState bitmapState = this.mBitmapState;
        return super.isStateful() || bitmapState.mTint != null && bitmapState.mTint.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mBitmapState = new BitmapState(this.mBitmapState);
            this.mMutated = true;
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onBoundsChange(Rect rect) {
        this.mDstRectAndInsetsDirty = true;
        Shader shader = this.mBitmapState.mPaint.getShader();
        if (shader == null) return;
        if (this.needMirroring()) {
            this.updateMirrorMatrix(rect.right - rect.left);
            shader.setLocalMatrix(this.mMirrorMatrix);
            this.mBitmapState.mPaint.setShader(shader);
            return;
        } else {
            if (this.mMirrorMatrix == null) return;
            this.mMirrorMatrix = null;
            shader.setLocalMatrix(Matrix.IDENTITY_MATRIX);
            this.mBitmapState.mPaint.setShader(shader);
            return;
        }
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        BitmapState bitmapState = this.mBitmapState;
        if (bitmapState.mTint != null && bitmapState.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, bitmapState.mTint, bitmapState.mTintMode);
            return true;
        }
        return false;
    }

    @Override
    public void setAlpha(int n) {
        if (n != this.mBitmapState.mPaint.getAlpha()) {
            this.mBitmapState.mPaint.setAlpha(n);
            this.invalidateSelf();
        }
    }

    public void setAntiAlias(boolean bl) {
        this.mBitmapState.mPaint.setAntiAlias(bl);
        this.invalidateSelf();
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        if (this.mBitmapState.mAutoMirrored != bl) {
            this.mBitmapState.mAutoMirrored = bl;
            this.invalidateSelf();
        }
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mBitmapState.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @Override
    public void setDither(boolean bl) {
        this.mBitmapState.mPaint.setDither(bl);
        this.invalidateSelf();
    }

    @Override
    public void setFilterBitmap(boolean bl) {
        this.mBitmapState.mPaint.setFilterBitmap(bl);
        this.invalidateSelf();
    }

    public void setGravity(int n) {
        if (this.mBitmapState.mGravity != n) {
            this.mBitmapState.mGravity = n;
            this.mDstRectAndInsetsDirty = true;
            this.invalidateSelf();
        }
    }

    public void setMipMap(boolean bl) {
        if (this.mBitmapState.mBitmap != null) {
            this.mBitmapState.mBitmap.setHasMipMap(bl);
            this.invalidateSelf();
        }
    }

    public void setTargetDensity(int n) {
        if (this.mTargetDensity != n) {
            if (n == 0) {
                n = 160;
            }
            this.mTargetDensity = n;
            if (this.mBitmapState.mBitmap != null) {
                this.computeBitmapSize();
            }
            this.invalidateSelf();
        }
    }

    public void setTargetDensity(Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    public void setTargetDensity(DisplayMetrics displayMetrics) {
        this.setTargetDensity(displayMetrics.densityDpi);
    }

    public void setTileModeX(Shader.TileMode tileMode) {
        this.setTileModeXY(tileMode, this.mBitmapState.mTileModeY);
    }

    public void setTileModeXY(Shader.TileMode tileMode, Shader.TileMode tileMode2) {
        BitmapState bitmapState = this.mBitmapState;
        if (bitmapState.mTileModeX != tileMode || bitmapState.mTileModeY != tileMode2) {
            bitmapState.mTileModeX = tileMode;
            bitmapState.mTileModeY = tileMode2;
            bitmapState.mRebuildShader = true;
            this.mDstRectAndInsetsDirty = true;
            this.invalidateSelf();
        }
    }

    public final void setTileModeY(Shader.TileMode tileMode) {
        this.setTileModeXY(this.mBitmapState.mTileModeX, tileMode);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mBitmapState.mTint = colorStateList;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, colorStateList, this.mBitmapState.mTintMode);
        this.invalidateSelf();
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mBitmapState.mTintMode = mode;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mBitmapState.mTint, mode);
        this.invalidateSelf();
    }

    @Override
    public void setXfermode(Xfermode xfermode) {
        this.mBitmapState.mPaint.setXfermode(xfermode);
        this.invalidateSelf();
    }

    static final class BitmapState
    extends Drawable.ConstantState {
        boolean mAutoMirrored = false;
        float mBaseAlpha = 1.0f;
        Bitmap mBitmap = null;
        int mChangingConfigurations;
        int mGravity = 119;
        final Paint mPaint;
        boolean mRebuildShader;
        int mTargetDensity = 160;
        int[] mThemeAttrs = null;
        Shader.TileMode mTileModeX = null;
        Shader.TileMode mTileModeY = null;
        ColorStateList mTint = null;
        PorterDuff.Mode mTintMode = Drawable.DEFAULT_TINT_MODE;

        BitmapState(Bitmap bitmap) {
            this.mBitmap = bitmap;
            this.mPaint = new Paint(6);
        }

        BitmapState(BitmapState bitmapState) {
            this.mBitmap = bitmapState.mBitmap;
            this.mTint = bitmapState.mTint;
            this.mTintMode = bitmapState.mTintMode;
            this.mThemeAttrs = bitmapState.mThemeAttrs;
            this.mChangingConfigurations = bitmapState.mChangingConfigurations;
            this.mGravity = bitmapState.mGravity;
            this.mTileModeX = bitmapState.mTileModeX;
            this.mTileModeY = bitmapState.mTileModeY;
            this.mTargetDensity = bitmapState.mTargetDensity;
            this.mBaseAlpha = bitmapState.mBaseAlpha;
            this.mPaint = new Paint(bitmapState.mPaint);
            this.mRebuildShader = bitmapState.mRebuildShader;
            this.mAutoMirrored = bitmapState.mAutoMirrored;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        @Override
        public Bitmap getBitmap() {
            return this.mBitmap;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new BitmapDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new BitmapDrawable(this, resources, null);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return new BitmapDrawable(this, resources, theme);
        }
    }
}

