/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedRotateDrawable
extends Drawable
implements Drawable.Callback,
Runnable,
Animatable {
    private float mCurrentDegrees;
    private float mIncrement;
    private boolean mMutated;
    private boolean mRunning;
    private AnimatedRotateState mState;

    public AnimatedRotateDrawable() {
        this(null, null);
    }

    private AnimatedRotateDrawable(AnimatedRotateState animatedRotateState, Resources resources) {
        this.mState = new AnimatedRotateState(animatedRotateState, this, resources);
        this.init();
    }

    private void init() {
        AnimatedRotateState animatedRotateState = this.mState;
        this.mIncrement = 360.0f / (float)animatedRotateState.mFramesCount;
        Drawable drawable2 = animatedRotateState.mDrawable;
        if (drawable2 != null) {
            drawable2.setFilterBitmap(true);
            if (drawable2 instanceof BitmapDrawable) {
                ((BitmapDrawable)drawable2).setAntiAlias(true);
            }
        }
    }

    private void nextFrame() {
        this.unscheduleSelf(this);
        this.scheduleSelf(this, SystemClock.uptimeMillis() + (long)this.mState.mFrameDuration);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        int n = canvas.save();
        AnimatedRotateState animatedRotateState = this.mState;
        Drawable drawable2 = animatedRotateState.mDrawable;
        Rect rect = drawable2.getBounds();
        int n2 = rect.right - rect.left;
        int n3 = rect.bottom - rect.top;
        float f = animatedRotateState.mPivotXRel ? (float)n2 * animatedRotateState.mPivotX : animatedRotateState.mPivotX;
        float f2 = animatedRotateState.mPivotYRel ? (float)n3 * animatedRotateState.mPivotY : animatedRotateState.mPivotY;
        canvas.rotate(this.mCurrentDegrees, f + (float)rect.left, f2 + (float)rect.top);
        drawable2.draw(canvas);
        canvas.restoreToCount(n);
    }

    @Override
    public int getAlpha() {
        return this.mState.mDrawable.getAlpha();
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.mChangingConfigurations | this.mState.mDrawable.getChangingConfigurations();
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mState.canConstantState()) {
            this.mState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mState;
        }
        return null;
    }

    public Drawable getDrawable() {
        return this.mState.mDrawable;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mState.mDrawable.getOpacity();
    }

    @Override
    public boolean getPadding(Rect rect) {
        return this.mState.mDrawable.getPadding(rect);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        TypedArray typedArray = AnimatedRotateDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.AnimatedRotateDrawable);
        super.inflateWithAttributes(resources, xmlPullParser, typedArray, 0);
        TypedValue typedValue = typedArray.peekValue(2);
        boolean bl = typedValue.type == 6;
        float f = bl ? typedValue.getFraction(1.0f, 1.0f) : typedValue.getFloat();
        TypedValue typedValue2 = typedArray.peekValue(3);
        boolean bl2 = typedValue2.type == 6;
        float f2 = bl2 ? typedValue2.getFraction(1.0f, 1.0f) : typedValue2.getFloat();
        this.setFramesCount(typedArray.getInt(5, 12));
        this.setFramesDuration(typedArray.getInt(4, 150));
        int n2 = typedArray.getResourceId(1, 0);
        Drawable drawable2 = null;
        if (n2 > 0) {
            drawable2 = resources.getDrawable(n2, theme);
        }
        typedArray.recycle();
        int n3 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n3)) {
            if (n != 2 || (drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme)) != null) continue;
            Log.w("drawable", "Bad element under <animated-rotate>: " + xmlPullParser.getName());
        }
        if (drawable2 == null) {
            Log.w("drawable", "No drawable specified for <animated-rotate>");
        }
        AnimatedRotateState animatedRotateState = this.mState;
        animatedRotateState.mDrawable = drawable2;
        animatedRotateState.mPivotXRel = bl;
        animatedRotateState.mPivotX = f;
        animatedRotateState.mPivotYRel = bl2;
        animatedRotateState.mPivotY = f2;
        this.init();
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public boolean isStateful() {
        return this.mState.mDrawable.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        this.mState.mDrawable.setBounds(rect.left, rect.top, rect.right, rect.bottom);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return this.mState.mDrawable.setLevel(n);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return this.mState.mDrawable.setState(nArray);
    }

    @Override
    public void run() {
        this.mCurrentDegrees += this.mIncrement;
        if (this.mCurrentDegrees > 360.0f - this.mIncrement) {
            this.mCurrentDegrees = 0.0f;
        }
        this.invalidateSelf();
        this.nextFrame();
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, runnable, l);
        }
    }

    @Override
    public void setAlpha(int n) {
        this.mState.mDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mState.mDrawable.setColorFilter(colorFilter);
    }

    public void setFramesCount(int n) {
        this.mState.mFramesCount = n;
        this.mIncrement = 360.0f / (float)this.mState.mFramesCount;
    }

    public void setFramesDuration(int n) {
        this.mState.mFrameDuration = n;
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mState.mDrawable.setTintList(colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mState.mDrawable.setTintMode(mode);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        this.mState.mDrawable.setVisible(bl, bl2);
        boolean bl3 = super.setVisible(bl, bl2);
        if (bl) {
            if (bl3 || bl2) {
                this.mCurrentDegrees = 0.0f;
                this.nextFrame();
            }
            return bl3;
        }
        this.unscheduleSelf(this);
        return bl3;
    }

    @Override
    public void start() {
        if (!this.mRunning) {
            this.mRunning = true;
            this.nextFrame();
        }
    }

    @Override
    public void stop() {
        this.mRunning = false;
        this.unscheduleSelf(this);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, runnable);
        }
    }

    static final class AnimatedRotateState
    extends Drawable.ConstantState {
        private boolean mCanConstantState;
        int mChangingConfigurations;
        private boolean mCheckedConstantState;
        Drawable mDrawable;
        int mFrameDuration;
        int mFramesCount;
        float mPivotX;
        boolean mPivotXRel;
        float mPivotY;
        boolean mPivotYRel;

        /*
         * Enabled aggressive block sorting
         */
        public AnimatedRotateState(AnimatedRotateState animatedRotateState, AnimatedRotateDrawable animatedRotateDrawable, Resources resources) {
            if (animatedRotateState != null) {
                this.mDrawable = resources != null ? animatedRotateState.mDrawable.getConstantState().newDrawable(resources) : animatedRotateState.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(animatedRotateDrawable);
                this.mDrawable.setLayoutDirection(animatedRotateState.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(animatedRotateState.mDrawable.getBounds());
                this.mDrawable.setLevel(animatedRotateState.mDrawable.getLevel());
                this.mPivotXRel = animatedRotateState.mPivotXRel;
                this.mPivotX = animatedRotateState.mPivotX;
                this.mPivotYRel = animatedRotateState.mPivotYRel;
                this.mPivotY = animatedRotateState.mPivotY;
                this.mFramesCount = animatedRotateState.mFramesCount;
                this.mFrameDuration = animatedRotateState.mFrameDuration;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                boolean bl = this.mDrawable.getConstantState() != null;
                this.mCanConstantState = bl;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new AnimatedRotateDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new AnimatedRotateDrawable(this, resources);
        }
    }
}

