/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Rect;
import java.io.OutputStream;

public class YuvImage {
    private static final int WORKING_COMPRESS_STORAGE = 4096;
    private byte[] mData;
    private int mFormat;
    private int mHeight;
    private int[] mStrides;
    private int mWidth;

    /*
     * Enabled aggressive block sorting
     */
    public YuvImage(byte[] byArray, int n, int n2, int n3, int[] nArray) {
        if (n != 17 && n != 20) {
            throw new IllegalArgumentException("only support ImageFormat.NV21 and ImageFormat.YUY2 for now");
        }
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("width and height must large than 0");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("yuv cannot be null");
        }
        this.mStrides = nArray == null ? this.calculateStrides(n2, n) : nArray;
        this.mData = byArray;
        this.mFormat = n;
        this.mWidth = n2;
        this.mHeight = n3;
    }

    private void adjustRectangle(Rect rect) {
        int n = rect.width();
        int n2 = rect.height();
        if (this.mFormat == 17) {
            int n3 = n2 & 0xFFFFFFFE;
            rect.left = 0xFFFFFFFE & rect.left;
            rect.top = 0xFFFFFFFE & rect.top;
            rect.right = (n &= 0xFFFFFFFE) + rect.left;
            rect.bottom = n3 + rect.top;
        }
        if (this.mFormat == 20) {
            int n4 = n & 0xFFFFFFFE;
            rect.left = 0xFFFFFFFE & rect.left;
            rect.right = n4 + rect.left;
        }
    }

    private int[] calculateStrides(int n, int n2) {
        if (n2 == 17) {
            return new int[]{n, n};
        }
        if (n2 == 20) {
            int[] nArray = new int[]{n * 2};
            return nArray;
        }
        return null;
    }

    private static native boolean nativeCompressToJpeg(byte[] var0, int var1, int var2, int var3, int[] var4, int[] var5, int var6, OutputStream var7, byte[] var8);

    int[] calculateOffsets(int n, int n2) {
        if (this.mFormat == 17) {
            int[] nArray = new int[]{n + n2 * this.mStrides[0], this.mHeight * this.mStrides[0] + n2 / 2 * this.mStrides[1] + 2 * (n / 2)};
            return nArray;
        }
        if (this.mFormat == 20) {
            int[] nArray = new int[]{n2 * this.mStrides[0] + 4 * (n / 2)};
            return nArray;
        }
        return null;
    }

    public boolean compressToJpeg(Rect rect, int n, OutputStream outputStream) {
        if (!new Rect(0, 0, this.mWidth, this.mHeight).contains(rect)) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this.adjustRectangle(rect);
        int[] nArray = this.calculateOffsets(rect.left, rect.top);
        return YuvImage.nativeCompressToJpeg(this.mData, this.mFormat, rect.width(), rect.height(), nArray, this.mStrides, n, outputStream, new byte[4096]);
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int[] getStrides() {
        return this.mStrides;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public byte[] getYuvData() {
        return this.mData;
    }

    public int getYuvFormat() {
        return this.mFormat;
    }
}

