/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.FontFamily;
import android.graphics.FontListParser;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class Typeface {
    public static final int BOLD = 1;
    public static final int BOLD_ITALIC = 3;
    private static final boolean DEBUG = false;
    private static final boolean DEBUGMAIN = true;
    public static final Typeface DEFAULT;
    public static final Typeface DEFAULT_BOLD;
    private static final String DROIDSANS = "DroidSans.ttf";
    private static final String DROIDSANS_BOLD = "DroidSans-Bold.ttf";
    private static final boolean FLIP_ALL_APPS = true;
    static final String FONTS_CONFIG = "fonts.xml";
    private static final String[] FlipFontAppList;
    private static String FlipFontPath;
    private static final String[] FontsLikeDefault;
    public static final Typeface HELVETICA;
    public static final int ITALIC = 2;
    public static final Typeface MONOSPACE;
    private static final int MONOSPACE_INDEX = 3;
    public static final int NORMAL = 0;
    private static final String OWNER_SANS_LOC_PATH = "/data/data/flipfont/app_fonts/sans.loc";
    private static final int SANS_INDEX = 1;
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    private static final int SERIF_INDEX = 2;
    private static String TAG;
    private static final String TAG_MONOTYPE = "Monotype";
    private static final String USER_SANS_LOC_POST = "/flipfont/app_fonts/sans.loc";
    private static final String USER_SANS_LOC_PRE = "/data/user/";
    public static final Typeface WEATHERFONTREG;
    public static boolean isFlipFontUsed;
    private static boolean lastAppInList;
    private static String lastAppNameString;
    static Typeface sDefaultTypeface;
    static Typeface[] sDefaults;
    static FontFamily[] sFallbackFonts;
    static Map<String, Typeface> sSystemFontMap;
    private static final LongSparseArray<SparseArray<Typeface>> sTypefaceCache;
    public boolean isLikeDefault = false;
    private int mStyle = 0;
    public long native_instance;

    static {
        TAG = "Typeface";
        sTypefaceCache = new LongSparseArray(3);
        FlipFontPath = "";
        lastAppNameString = null;
        lastAppInList = false;
        isFlipFontUsed = false;
        FlipFontAppList = new String[]{"android", "com.android.*", "com.cooliris.media", "jp.co.omronsoft.openwnn", "com.monotypeimaging.*"};
        FontsLikeDefault = new String[]{"sans-serif", "sans-serif-condensed"};
        Typeface.init();
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        HELVETICA = Typeface.create("DFPhelvetica", 0);
        WEATHERFONTREG = Typeface.create("weatherfontReg", 0);
        Typeface[] typefaceArray = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
        sDefaults = typefaceArray;
    }

    private Typeface(long l) {
        if (l == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = l;
        this.mStyle = Typeface.nativeGetStyle(l);
    }

    public static void SetAppTypeFace(Context context, String string2) {
        if (Typeface.isAppInFlipList(string2)) {
            Log.v(TAG_MONOTYPE, "SetAppTypeFace- try to flip, app = " + string2);
            Typeface.SetFlipFonts(context);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void SetFlipFonts(Context context) {
        block17: {
            block16: {
                String string2 = "";
                String string3 = Typeface.getFontPathFlipFont(context, 1);
                if (string3.endsWith("default")) {
                    isFlipFontUsed = false;
                } else {
                    isFlipFontUsed = true;
                    string2 = string3 + "/" + DROIDSANS_BOLD;
                    string3 = string3 + "/" + DROIDSANS;
                }
                if (string3.equals(FlipFontPath)) break block16;
                FlipFontPath = string3;
                long cfr_ignored_0 = Typeface.DEFAULT.native_instance;
                if (!isFlipFontUsed || string3.isEmpty()) {
                    Typeface.nativeSetDefault(Typeface.sDefaultTypeface.native_instance);
                    Typeface.DEFAULT.native_instance = Typeface.nativeCreateFromTypeface(0L, 0);
                } else {
                    try {
                        Typeface.DEFAULT.native_instance = Typeface.createFromFile((String)string3).native_instance;
                    }
                    catch (RuntimeException runtimeException) {
                        Typeface.DEFAULT.native_instance = Typeface.create((String)((String)null), (int)0).native_instance;
                    }
                    if (Typeface.DEFAULT.native_instance == 0L) {
                        Typeface.DEFAULT.native_instance = Typeface.create((String)((String)null), (int)0).native_instance;
                    }
                }
                Typeface.DEFAULT.mStyle = Typeface.nativeGetStyle(Typeface.DEFAULT.native_instance);
                long cfr_ignored_1 = Typeface.DEFAULT_BOLD.native_instance;
                if (!isFlipFontUsed || string2.isEmpty()) {
                    Typeface.DEFAULT_BOLD.native_instance = Typeface.nativeCreateFromTypeface(0L, 1);
                } else {
                    try {
                        Typeface.DEFAULT_BOLD.native_instance = Typeface.createFromFile((String)string2).native_instance;
                    }
                    catch (RuntimeException runtimeException) {
                        Typeface.DEFAULT_BOLD.native_instance = Typeface.create((String)((String)null), (int)1).native_instance;
                    }
                    if (Typeface.DEFAULT_BOLD.native_instance == 0L) {
                        Typeface.DEFAULT_BOLD.native_instance = Typeface.create((String)((String)null), (int)1).native_instance;
                    }
                }
                Typeface.DEFAULT_BOLD.mStyle = Typeface.nativeGetStyle(Typeface.DEFAULT_BOLD.native_instance);
                long cfr_ignored_2 = Typeface.sDefaults[0].native_instance;
                Typeface.sDefaults[0].native_instance = Typeface.nativeCreateFromTypeface(Typeface.DEFAULT.native_instance, 0);
                Typeface.sDefaults[0].mStyle = Typeface.nativeGetStyle(Typeface.sDefaults[0].native_instance);
                long cfr_ignored_3 = Typeface.sDefaults[1].native_instance;
                Typeface.sDefaults[1].native_instance = Typeface.nativeCreateFromTypeface(Typeface.DEFAULT_BOLD.native_instance, 1);
                Typeface.sDefaults[1].mStyle = Typeface.nativeGetStyle(Typeface.sDefaults[1].native_instance);
                long cfr_ignored_4 = Typeface.sDefaults[2].native_instance;
                Typeface.sDefaults[2].native_instance = Typeface.nativeCreateFromTypeface(Typeface.DEFAULT.native_instance, 2);
                Typeface.sDefaults[2].mStyle = Typeface.nativeGetStyle(Typeface.sDefaults[2].native_instance);
                long cfr_ignored_5 = Typeface.sDefaults[3].native_instance;
                Typeface.sDefaults[3].native_instance = Typeface.nativeCreateFromTypeface(Typeface.DEFAULT_BOLD.native_instance, 3);
                Typeface.sDefaults[3].mStyle = Typeface.nativeGetStyle(Typeface.sDefaults[3].native_instance);
                if (isFlipFontUsed) break block17;
            }
            return;
        }
        Typeface.nativeSetDefault(Typeface.sDefaultTypeface.native_instance);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Typeface create(Typeface typeface, int n) {
        void var4_6;
        Typeface typeface2;
        SparseArray<Typeface> sparseArray;
        long l = 0L;
        if (n < 0 || n > 3) {
            n = 0;
        }
        if (typeface != null) {
            if (typeface.mStyle == n) {
                return typeface;
            }
            l = isFlipFontUsed && typeface.isLikeDefault ? 0L : typeface.native_instance;
        }
        if ((sparseArray = sTypefaceCache.get(l)) != null) {
            Typeface typeface3 = sparseArray.get(n);
            if (typeface3 != null) return typeface3;
        }
        if ((typeface2 = new Typeface(Typeface.nativeCreateFromTypeface(l, n))) != null && typeface != null) {
            typeface2.isLikeDefault = typeface.isLikeDefault;
        }
        if (sparseArray == null) {
            SparseArray sparseArray2 = new SparseArray(4);
            sTypefaceCache.put(l, sparseArray2);
        }
        var4_6.put(n, typeface2);
        return typeface2;
    }

    public static Typeface create(String string2, int n) {
        if (sSystemFontMap != null) {
            return Typeface.create(sSystemFontMap.get(string2), n);
        }
        return null;
    }

    public static Typeface createFromAsset(AssetManager assetManager, String string2) {
        FontFamily fontFamily;
        if (sFallbackFonts != null && (fontFamily = new FontFamily()).addFontFromAsset(assetManager, string2)) {
            return Typeface.createFromFamiliesWithDefault(new FontFamily[]{fontFamily});
        }
        throw new RuntimeException("Font asset not found " + string2);
    }

    public static Typeface createFromFamilies(FontFamily[] fontFamilyArray) {
        long[] lArray = new long[fontFamilyArray.length];
        for (int i = 0; i < fontFamilyArray.length; ++i) {
            lArray[i] = fontFamilyArray[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(lArray));
    }

    public static Typeface createFromFamiliesWithDefault(FontFamily[] fontFamilyArray) {
        long[] lArray = new long[fontFamilyArray.length + sFallbackFonts.length];
        for (int i = 0; i < fontFamilyArray.length; ++i) {
            lArray[i] = fontFamilyArray[i].mNativePtr;
        }
        for (int i = 0; i < sFallbackFonts.length; ++i) {
            lArray[i + fontFamilyArray.length] = Typeface.sFallbackFonts[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(lArray));
    }

    public static Typeface createFromFile(File file) {
        return Typeface.createFromFile(file.getAbsolutePath());
    }

    public static Typeface createFromFile(String string2) {
        FontFamily fontFamily;
        if (sFallbackFonts != null && (fontFamily = new FontFamily()).addFont(string2)) {
            return Typeface.createFromFamiliesWithDefault(new FontFamily[]{fontFamily});
        }
        throw new RuntimeException("Font not found " + string2);
    }

    public static Typeface defaultFromStyle(int n) {
        if (n < 0 || n > 3) {
            n = 0;
        }
        return sDefaults[n];
    }

    public static String getFontNameFlipFont(Context context, int n) {
        String[] stringArray = Typeface.getFullFlipFont(context, n).split("#");
        if (stringArray.length < 2) {
            if (stringArray[0].endsWith("default")) {
                return "default";
            }
            return null;
        }
        return stringArray[1];
    }

    public static String getFontPathFlipFont(Context context, int n) {
        return Typeface.getFullFlipFont(context, n).split("#")[0];
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getFullFlipFont(Context var0, int var1_1) {
        var2_2 = "default";
        switch (var1_1) {
            case 1: {
                var3_3 = UserHandle.getCallingUserId();
                if (var3_3 != 0) ** GOTO lbl28
                var2_2 = "empty";
                if (!var2_2.equals("empty")) break;
                var26_4 = new File("/data/data/flipfont/app_fonts/sans.loc");
                var27_5 = null;
                var28_6 = new FileInputStream(var26_4);
                var29_7 = new BufferedReader(new InputStreamReader(var28_6));
                var31_8 = var29_7.readLine();
                var28_6.close();
                var29_7.close();
                ** if (var28_6 == null) goto lbl23
lbl-1000:
                // 1 sources

                {
                    try {
                        var28_6.close();
                    }
                    catch (IOException var37_9) {}
                }
lbl23:
                // 2 sources

                ** GOTO lbl141
                catch (FileNotFoundException var39_10) {}
                ** GOTO lbl-1000
                catch (IOException var33_12) {}
                ** GOTO lbl-1000
lbl28:
                // 1 sources

                var4_21 = "/data/user/" + var3_3 + "/flipfont/app_fonts/sans.loc";
                try {
                    var2_2 = var25_22 = Settings.Global.getString(var0.getContentResolver(), "flipfont_settings_name");
                }
                catch (SecurityException var5_28) {
                    Log.v("Monotype", "getFullFlipFont has SecurityException while Settings.Global.getString:" + var5_28);
                }
                if (var2_2 != null && !var2_2.equals("empty")) ** GOTO lbl56
                var7_23 = new File(var4_21);
                var8_24 = null;
                var9_25 = new FileInputStream(var7_23);
                var10_26 = new BufferedReader(new InputStreamReader(var9_25));
                var12_27 = var10_26.readLine();
                var9_25.close();
                var10_26.close();
                ** if (var9_25 == null) goto lbl51
lbl-1000:
                // 1 sources

                {
                    try {
                        var9_25.close();
                    }
                    catch (IOException var19_29) {}
                }
lbl51:
                // 2 sources

                ** GOTO lbl101
                catch (FileNotFoundException var21_30) {}
                ** GOTO lbl-1000
                catch (IOException var15_32) {}
                ** GOTO lbl-1000
lbl56:
                // 1 sources

                try {
                    var2_2 = var24_41 = Settings.Global.getString(var0.getContentResolver(), "flipfont_settings_path") + "#" + Settings.Global.getString(var0.getContentResolver(), "flipfont_settings_name");
                }
                catch (SecurityException var22_42) {
                    Log.v("Monotype", "getFullFlipFont has SecurityException while Settings.Global.getString:" + var22_42);
                }
                break;
                catch (Throwable var16_39) {
                    var8_24 = var9_25;
                    ** GOTO lbl-1000
                }
                catch (Throwable var16_40) {
                    var8_24 = var9_25;
                    ** GOTO lbl-1000
                }
                catch (IOException var15_34) {
                    var8_24 = var9_25;
                    ** GOTO lbl-1000
                }
                catch (IOException var15_35) {
                    var8_24 = var9_25;
                }
lbl-1000:
                // 3 sources

                {
                    var12_27 = "default";
                    try {
                        var15_33.printStackTrace();
                        ** if (var8_24 == null) goto lbl-1000
                    }
                    catch (Throwable var16_37) lbl-1000:
                    // 3 sources

                    {
                        if (var8_24 == null) throw var16_38;
                        try {
                            var8_24.close();
                        }
                        catch (IOException var17_44) {
                            throw var16_38;
                        }
                        throw var16_38;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var8_24.close();
                        }
                        catch (IOException var18_36) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (FileNotFoundException var20_45) {
                    var8_24 = var9_25;
                    ** GOTO lbl-1000
                }
                catch (FileNotFoundException var11_46) {
                    var8_24 = var9_25;
                }
lbl-1000:
                // 3 sources

                {
                    var12_27 = "default";
                    if (var8_24 == null) ** GOTO lbl101
                    try {
                        var8_24.close();
                    }
                    catch (IOException var13_31) {}
                }
lbl101:
                // 7 sources

                var2_2 = var12_27;
                break;
                catch (Throwable var34_19) {
                    var27_5 = var28_6;
                    ** GOTO lbl-1000
                }
                catch (Throwable var34_20) {
                    var27_5 = var28_6;
                    ** GOTO lbl-1000
                }
                catch (IOException var33_14) {
                    var27_5 = var28_6;
                    ** GOTO lbl-1000
                }
                catch (IOException var33_15) {
                    var27_5 = var28_6;
                }
lbl-1000:
                // 3 sources

                {
                    var31_8 = "default";
                    try {
                        var33_13.printStackTrace();
                        ** if (var27_5 == null) goto lbl-1000
                    }
                    catch (Throwable var34_17) lbl-1000:
                    // 3 sources

                    {
                        if (var27_5 == null) throw var34_18;
                        try {
                            var27_5.close();
                        }
                        catch (IOException var35_43) {
                            throw var34_18;
                        }
                        throw var34_18;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var27_5.close();
                        }
                        catch (IOException var36_16) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (FileNotFoundException var38_47) {
                    var27_5 = var28_6;
                    ** GOTO lbl-1000
                }
                catch (FileNotFoundException var30_48) {
                    var27_5 = var28_6;
                }
lbl-1000:
                // 3 sources

                {
                    var31_8 = "default";
                    if (var27_5 == null) ** GOTO lbl141
                    try {
                        var27_5.close();
                    }
                    catch (IOException var32_11) {}
                }
lbl141:
                // 7 sources

                var2_2 = var31_8;
            }
        }
        if (var2_2 == null) {
            return "default";
        }
        Log.v("Monotype", "    Typeface getFontPathFlipFont - systemFont = " + var2_2);
        return var2_2;
    }

    private static File getSystemFontConfigLocation() {
        return new File("/system/etc/");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void init() {
        block14: {
            block17: {
                var0 = new File(Typeface.getSystemFontConfigLocation(), "fonts.xml");
                try {
                    var9_1 = FontListParser.parse(new FileInputStream(var0));
                    var10_2 = new ArrayList<FontFamily>();
                    var11_3 = 0;
lbl6:
                    // 2 sources

                    while (true) {
                        block15: {
                            block16: {
                                if (var11_3 < var9_1.families.size()) {
                                    var29_4 = var9_1.families.get(var11_3);
                                    if (var11_3 == 0 || var29_4.name == null) {
                                        var10_2.add(Typeface.makeFamilyFromParsed(var29_4));
                                    }
                                    break block14;
                                }
                                Typeface.sFallbackFonts = var10_2.toArray(new FontFamily[var10_2.size()]);
                                Typeface.setDefault(Typeface.createFromFamilies(Typeface.sFallbackFonts));
                                var12_5 = new HashMap<String, Typeface>();
                                var13_6 = 0;
                                block7: while (true) {
                                    block19: {
                                        block18: {
                                            if (var13_6 >= var9_1.families.size()) break block18;
                                            var24_7 = var9_1.families.get(var13_6);
                                            if (var24_7.name == null) ** GOTO lbl41
                                            var25_8 = var13_6 == 0 ? Typeface.sDefaultTypeface : Typeface.createFromFamiliesWithDefault(new FontFamily[]{Typeface.makeFamilyFromParsed(var24_7)});
                                            break block19;
                                        }
lbl24:
                                        // 2 sources

                                        for (FontListParser.Alias var15_12 : var9_1.aliases) {
                                            var17_14 = var16_13 = (Typeface)var12_5.get(var15_12.toName);
                                            var18_15 = var15_12.weight;
                                            if (var18_15 == 400) break block15;
                                            var19_16 = Typeface.nativeCreateWeightAlias(var16_13.native_instance, var18_15);
                                            var17_14 = new Typeface(var19_16);
                                            break block16;
                                        }
                                        break block17;
                                    }
                                    var26_9 = 0;
lbl34:
                                    // 2 sources

                                    while (true) {
                                        var27_10 = Typeface.FontsLikeDefault.length;
                                        if (var26_9 < var27_10) {
                                            if (!var24_7.name.equals(Typeface.FontsLikeDefault[var26_9])) break block7;
                                            var25_8.isLikeDefault = true;
                                        }
                                        var12_5.put(var24_7.name, var25_8);
lbl41:
                                        // 2 sources

                                        ++var13_6;
                                        continue block7;
                                        break;
                                    }
                                    break;
                                }
                                ++var26_9;
                                ** continue;
                            }
                            for (var21_17 = 0; var21_17 < (var22_18 = Typeface.FontsLikeDefault.length); ++var21_17) {
                                if (!var15_12.toName.equals(Typeface.FontsLikeDefault[var21_17])) continue;
                                var17_14.isLikeDefault = true;
                                break;
                            }
                        }
                        var12_5.put(var15_12.name, var17_14);
                        ** GOTO lbl24
                        break;
                    }
                }
                catch (RuntimeException var7_19) {
                    Log.w(Typeface.TAG, "Didn't create default family (most likely, non-Minikin build)", var7_19);
                    return;
                }
            }
            try {
                Typeface.sSystemFontMap = var12_5;
                return;
            }
            catch (FileNotFoundException var5_20) {
                Log.e(Typeface.TAG, "Error opening " + var0);
                return;
            }
            catch (IOException var3_21) {
                Log.e(Typeface.TAG, "Error reading " + var0);
                return;
            }
            catch (XmlPullParserException var1_22) {
                Log.e(Typeface.TAG, "XML parse exception for " + var0);
                return;
            }
        }
        ++var11_3;
        ** while (true)
    }

    private static boolean isAppInFlipList(String string2) {
        return true;
    }

    private static String[] loadAppList() {
        return FlipFontAppList;
    }

    private static FontFamily makeFamilyFromParsed(FontListParser.Family family) {
        FontFamily fontFamily = new FontFamily(family.lang, family.variant);
        for (FontListParser.Font font : family.fonts) {
            fontFamily.addFontWeightStyle(font.fontName, font.weight, font.isItalic);
        }
        return fontFamily;
    }

    private static native long nativeCreateFromArray(long[] var0);

    private static native long nativeCreateFromTypeface(long var0, int var2);

    private static native long nativeCreateWeightAlias(long var0, int var2);

    private static native int nativeGetStyle(long var0);

    private static native void nativeSetDefault(long var0);

    private static native void nativeUnref(long var0);

    private static void setDefault(Typeface typeface) {
        sDefaultTypeface = typeface;
        Typeface.nativeSetDefault(typeface.native_instance);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Typeface typeface = (Typeface)object;
                if (this.mStyle != typeface.mStyle || this.native_instance != typeface.native_instance) break block5;
            }
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        try {
            Typeface.nativeUnref(this.native_instance);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getStyle() {
        return this.mStyle;
    }

    public int hashCode() {
        return 31 * (527 + (int)(this.native_instance ^ this.native_instance >>> 32)) + this.mStyle;
    }

    public final boolean isBold() {
        return (1 & this.mStyle) != 0;
    }

    public final boolean isItalic() {
        return (2 & this.mStyle) != 0;
    }
}

