/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;

public class ColorMatrixColorFilter
extends ColorFilter {
    private final ColorMatrix mMatrix = new ColorMatrix();

    public ColorMatrixColorFilter(ColorMatrix colorMatrix) {
        this.mMatrix.set(colorMatrix);
        this.update();
    }

    public ColorMatrixColorFilter(float[] fArray) {
        if (fArray.length < 20) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mMatrix.set(fArray);
        this.update();
    }

    private static native long nativeColorMatrixFilter(float[] var0);

    private void update() {
        float[] fArray = this.mMatrix.getArray();
        ColorMatrixColorFilter.destroyFilter(this.native_instance);
        this.native_instance = ColorMatrixColorFilter.nativeColorMatrixFilter(fArray);
    }

    public ColorMatrix getColorMatrix() {
        return this.mMatrix;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setColorMatrix(ColorMatrix colorMatrix) {
        if (colorMatrix == null) {
            this.mMatrix.reset();
        } else if (colorMatrix != this.mMatrix) {
            this.mMatrix.set(colorMatrix);
        }
        this.update();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setColorMatrix(float[] fArray) {
        if (fArray == null) {
            this.mMatrix.reset();
        } else {
            if (fArray.length < 20) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.mMatrix.set(fArray);
        }
        this.update();
    }
}

