/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.util.MathUtils;
import com.android.internal.util.XmlUtils;
import java.util.HashMap;
import java.util.Locale;

public class Color {
    public static final int BLACK = -16777216;
    public static final int BLUE = -16776961;
    public static final int CYAN = -16711681;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int GREEN = -16711936;
    public static final int LTGRAY = -3355444;
    public static final int MAGENTA = -65281;
    public static final int RED = -65536;
    public static final int TRANSPARENT = 0;
    public static final int WHITE = -1;
    public static final int YELLOW = -256;
    private static final HashMap<String, Integer> sColorNameMap = new HashMap();

    static {
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
        sColorNameMap.put("aqua", -16711681);
        sColorNameMap.put("fuchsia", -65281);
        sColorNameMap.put("darkgrey", -12303292);
        sColorNameMap.put("grey", -7829368);
        sColorNameMap.put("lightgrey", -3355444);
        sColorNameMap.put("lime", -16711936);
        sColorNameMap.put("maroon", -8388608);
        sColorNameMap.put("navy", -16777088);
        sColorNameMap.put("olive", -8355840);
        sColorNameMap.put("purple", -8388480);
        sColorNameMap.put("silver", -4144960);
        sColorNameMap.put("teal", -16744320);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int HSBtoColor(float f, float f2, float f3) {
        float f4 = MathUtils.constrain(f, 0.0f, 1.0f);
        float f5 = MathUtils.constrain(f2, 0.0f, 1.0f);
        float f6 = MathUtils.constrain(f3, 0.0f, 1.0f);
        float f7 = 6.0f * (f4 - (float)((int)f4));
        int n = (int)f7;
        float f8 = f7 - (float)n;
        float f9 = f6 * (1.0f - f5);
        float f10 = f6 * (1.0f - f5 * f8);
        float f11 = f6 * (1.0f - f5 * (1.0f - f8));
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        switch (n) {
            case 0: {
                f14 = f6;
                f13 = f11;
                f12 = f9;
                return 0xFF000000 | (int)(f14 * 255.0f) << 16 | (int)(f13 * 255.0f) << 8 | (int)(f12 * 255.0f);
            }
            case 1: {
                f14 = f10;
                f13 = f6;
                f12 = f9;
                return 0xFF000000 | (int)(f14 * 255.0f) << 16 | (int)(f13 * 255.0f) << 8 | (int)(f12 * 255.0f);
            }
            case 2: {
                f14 = f9;
                f13 = f6;
                f12 = f11;
                return 0xFF000000 | (int)(f14 * 255.0f) << 16 | (int)(f13 * 255.0f) << 8 | (int)(f12 * 255.0f);
            }
            case 3: {
                f14 = f9;
                f13 = f10;
                f12 = f6;
                return 0xFF000000 | (int)(f14 * 255.0f) << 16 | (int)(f13 * 255.0f) << 8 | (int)(f12 * 255.0f);
            }
            case 4: {
                f14 = f11;
                f13 = f9;
                f12 = f6;
                return 0xFF000000 | (int)(f14 * 255.0f) << 16 | (int)(f13 * 255.0f) << 8 | (int)(f12 * 255.0f);
            }
            case 5: {
                f14 = f6;
                f13 = f9;
                f12 = f10;
                return 0xFF000000 | (int)(f14 * 255.0f) << 16 | (int)(f13 * 255.0f) << 8 | (int)(f12 * 255.0f);
            }
        }
        return 0xFF000000 | (int)(f14 * 255.0f) << 16 | (int)(f13 * 255.0f) << 8 | (int)(f12 * 255.0f);
    }

    public static int HSBtoColor(float[] fArray) {
        return Color.HSBtoColor(fArray[0], fArray[1], fArray[2]);
    }

    public static int HSVToColor(int n, float[] fArray) {
        if (fArray.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        return Color.nativeHSVToColor(n, fArray);
    }

    public static int HSVToColor(float[] fArray) {
        return Color.HSVToColor(255, fArray);
    }

    public static void RGBToHSV(int n, int n2, int n3, float[] fArray) {
        if (fArray.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        Color.nativeRGBToHSV(n, n2, n3, fArray);
    }

    public static int alpha(int n) {
        return n >>> 24;
    }

    public static int argb(int n, int n2, int n3, int n4) {
        return n4 | (n << 24 | n2 << 16 | n3 << 8);
    }

    public static int blue(int n) {
        return n & 0xFF;
    }

    public static float brightness(int n) {
        int n2 = 0xFF & n >> 16;
        int n3 = 0xFF & n >> 8;
        return (float)Math.max(n & 0xFF, Math.max(n2, n3)) / 255.0f;
    }

    public static void colorToHSV(int n, float[] fArray) {
        Color.RGBToHSV(0xFF & n >> 16, 0xFF & n >> 8, n & 0xFF, fArray);
    }

    public static int getHtmlColor(String string2) {
        Integer n = sColorNameMap.get(string2.toLowerCase(Locale.ROOT));
        if (n != null) {
            return n;
        }
        try {
            int n2 = XmlUtils.convertValueToInt(string2, -1);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static int green(int n) {
        return 0xFF & n >> 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float hue(int n) {
        int n2;
        int n3 = n & 0xFF;
        int n4 = 0xFF & n >> 16;
        int n5 = 0xFF & n >> 8;
        int n6 = Math.max(n3, Math.max(n4, n5));
        if (n6 == (n2 = Math.min(n3, Math.min(n4, n5)))) {
            return 0.0f;
        }
        float f = n6 - n2;
        float f2 = (float)(n6 - n4) / f;
        float f3 = (float)(n6 - n5) / f;
        float f4 = (float)(n6 - n3) / f;
        float f5 = n4 == n6 ? f4 - f3 : (n5 == n6 ? 2.0f + f2 - f4 : 4.0f + f3 - f2);
        float f6 = f5 / 6.0f;
        if (!(f6 < 0.0f)) return f6;
        return f6 + 1.0f;
    }

    private static native int nativeHSVToColor(int var0, float[] var1);

    private static native void nativeRGBToHSV(int var0, int var1, int var2, float[] var3);

    /*
     * Enabled aggressive block sorting
     */
    public static int parseColor(String string2) {
        if (string2.charAt(0) == '#') {
            long l = Long.parseLong(string2.substring(1), 16);
            if (string2.length() == 7) {
                l |= 0xFFFFFFFFFF000000L;
                return (int)l;
            } else {
                if (string2.length() == 9) return (int)l;
                throw new IllegalArgumentException("Unknown color");
            }
        }
        Integer n = sColorNameMap.get(string2.toLowerCase(Locale.ROOT));
        if (n == null) throw new IllegalArgumentException("Unknown color");
        return n;
    }

    public static int red(int n) {
        return 0xFF & n >> 16;
    }

    public static int rgb(int n, int n2, int n3) {
        return n3 | (0xFF000000 | n << 16 | n2 << 8);
    }

    public static float saturation(int n) {
        int n2;
        int n3 = n & 0xFF;
        int n4 = 0xFF & n >> 16;
        int n5 = 0xFF & n >> 8;
        int n6 = Math.max(n3, Math.max(n4, n5));
        if (n6 == (n2 = Math.min(n3, Math.min(n4, n5)))) {
            return 0.0f;
        }
        return (float)(n6 - n2) / (float)n6;
    }
}

