/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.ui;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterSurfaceView;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.util.Log;
import android.view.SurfaceHolder;

public class SurfaceRenderFilter
extends Filter
implements SurfaceHolder.Callback {
    private static final String TAG = "SurfaceRenderFilter";
    private final int RENDERMODE_FILL_CROP;
    private final int RENDERMODE_FIT;
    private final int RENDERMODE_STRETCH;
    private float mAspectRatio = 1.0f;
    private boolean mIsBound = false;
    private boolean mLogVerbose = Log.isLoggable("SurfaceRenderFilter", 2);
    private ShaderProgram mProgram;
    private int mRenderMode = 1;
    @GenerateFieldPort(hasDefault=true, name="renderMode")
    private String mRenderModeString;
    private GLFrame mScreen;
    private int mScreenHeight;
    private int mScreenWidth;
    @GenerateFinalPort(name="surfaceView")
    private FilterSurfaceView mSurfaceView;

    public SurfaceRenderFilter(String string2) {
        super(string2);
        this.RENDERMODE_STRETCH = 0;
        this.RENDERMODE_FIT = 1;
        this.RENDERMODE_FILL_CROP = 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateTargetRect() {
        if (this.mScreenWidth <= 0 || this.mScreenHeight <= 0 || this.mProgram == null) return;
        float f = (float)this.mScreenWidth / (float)this.mScreenHeight / this.mAspectRatio;
        switch (this.mRenderMode) {
            default: {
                return;
            }
            case 0: {
                this.mProgram.setTargetRect(0.0f, 0.0f, 1.0f, 1.0f);
                return;
            }
            case 1: {
                if (f > 1.0f) {
                    this.mProgram.setTargetRect(0.5f - 0.5f / f, 0.0f, 1.0f / f, 1.0f);
                    return;
                }
                this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * f, 1.0f, f);
                return;
            }
            case 2: 
        }
        if (f > 1.0f) {
            this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * f, 1.0f, f);
            return;
        }
        this.mProgram.setTargetRect(0.5f - 0.5f / f, 0.0f, 1.0f / f, 1.0f);
    }

    @Override
    public void close(FilterContext filterContext) {
        this.mSurfaceView.unbind();
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        this.updateTargetRect();
    }

    @Override
    public void open(FilterContext filterContext) {
        this.mSurfaceView.unbind();
        this.mSurfaceView.bindToListener(this, filterContext.getGLEnvironment());
    }

    @Override
    public void prepare(FilterContext filterContext) {
        this.mProgram = ShaderProgram.createIdentity(filterContext);
        this.mProgram.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.mProgram.setClearsOutput(true);
        this.mProgram.setClearColor(0.0f, 0.0f, 0.0f);
        this.updateRenderMode();
        MutableFrameFormat mutableFrameFormat = ImageFormat.create(this.mSurfaceView.getWidth(), this.mSurfaceView.getHeight(), 3, 3);
        this.mScreen = (GLFrame)filterContext.getFrameManager().newBoundFrame(mutableFrameFormat, 101, 0L);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void process(FilterContext filterContext) {
        if (!this.mIsBound) {
            Log.w(TAG, this + ": Ignoring frame as there is no surface to render to!");
            return;
        } else {
            boolean bl;
            Frame frame;
            GLEnvironment gLEnvironment;
            if (this.mLogVerbose) {
                Log.v(TAG, "Starting frame processing");
            }
            if ((gLEnvironment = this.mSurfaceView.getGLEnv()) != filterContext.getGLEnvironment()) {
                throw new RuntimeException("Surface created under different GLEnvironment!");
            }
            Frame frame2 = this.pullInput("frame");
            float f = (float)frame2.getFormat().getWidth() / (float)frame2.getFormat().getHeight();
            if (f != this.mAspectRatio) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "New aspect ratio: " + f + ", previously: " + this.mAspectRatio);
                }
                this.mAspectRatio = f;
                this.updateTargetRect();
            }
            if (this.mLogVerbose) {
                Log.v(TAG, "Got input format: " + frame2.getFormat());
            }
            if (frame2.getFormat().getTarget() != 3) {
                frame = filterContext.getFrameManager().duplicateFrameToTarget(frame2, 3);
                bl = true;
            } else {
                frame = frame2;
                bl = false;
            }
            gLEnvironment.activateSurfaceWithId(this.mSurfaceView.getSurfaceId());
            this.mProgram.process(frame, (Frame)this.mScreen);
            gLEnvironment.swapBuffers();
            if (!bl) return;
            frame.release();
            return;
        }
    }

    @Override
    public void setupPorts() {
        if (this.mSurfaceView == null) {
            throw new RuntimeException("NULL SurfaceView passed to SurfaceRenderFilter");
        }
        this.addMaskedInputPort("frame", ImageFormat.create(3));
    }

    @Override
    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        synchronized (this) {
            if (this.mScreen != null) {
                this.mScreenWidth = n2;
                this.mScreenHeight = n3;
                this.mScreen.setViewport(0, 0, this.mScreenWidth, this.mScreenHeight);
                this.updateTargetRect();
            }
            return;
        }
    }

    @Override
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        synchronized (this) {
            this.mIsBound = true;
            return;
        }
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        synchronized (this) {
            this.mIsBound = false;
            return;
        }
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        if (this.mScreen != null) {
            this.mScreen.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateRenderMode() {
        if (this.mRenderModeString != null) {
            if (this.mRenderModeString.equals("stretch")) {
                this.mRenderMode = 0;
            } else if (this.mRenderModeString.equals("fit")) {
                this.mRenderMode = 1;
            } else {
                if (!this.mRenderModeString.equals("fill_crop")) {
                    throw new RuntimeException("Unknown render mode '" + this.mRenderModeString + "'!");
                }
                this.mRenderMode = 2;
            }
        }
        this.updateTargetRect();
    }
}

