/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;

public class ImageStitcher
extends Filter {
    private int mImageHeight;
    private int mImageWidth;
    private int mInputHeight;
    private int mInputWidth;
    private Frame mOutputFrame;
    @GenerateFieldPort(name="padSize")
    private int mPadSize;
    private Program mProgram;
    private int mSliceHeight;
    private int mSliceIndex = 0;
    private int mSliceWidth;
    @GenerateFieldPort(name="xSlices")
    private int mXSlices;
    @GenerateFieldPort(name="ySlices")
    private int mYSlices;

    public ImageStitcher(String string2) {
        super(string2);
    }

    private FrameFormat calcOutputFormatForInput(FrameFormat frameFormat) {
        MutableFrameFormat mutableFrameFormat = frameFormat.mutableCopy();
        this.mInputWidth = frameFormat.getWidth();
        this.mInputHeight = frameFormat.getHeight();
        this.mSliceWidth = this.mInputWidth - 2 * this.mPadSize;
        this.mSliceHeight = this.mInputHeight - 2 * this.mPadSize;
        this.mImageWidth = this.mSliceWidth * this.mXSlices;
        this.mImageHeight = this.mSliceHeight * this.mYSlices;
        mutableFrameFormat.setDimensions(this.mImageWidth, this.mImageHeight);
        return mutableFrameFormat;
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return frameFormat;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        FrameFormat frameFormat = frame.getFormat();
        if (this.mSliceIndex == 0) {
            this.mOutputFrame = filterContext.getFrameManager().newFrame(this.calcOutputFormatForInput(frameFormat));
        } else if (frameFormat.getWidth() != this.mInputWidth || frameFormat.getHeight() != this.mInputHeight) {
            throw new RuntimeException("Image size should not change.");
        }
        if (this.mProgram == null) {
            this.mProgram = ShaderProgram.createIdentity(filterContext);
        }
        float f = (float)this.mPadSize / (float)this.mInputWidth;
        float f2 = (float)this.mPadSize / (float)this.mInputHeight;
        int n = this.mSliceIndex % this.mXSlices * this.mSliceWidth;
        int n2 = this.mSliceIndex / this.mXSlices * this.mSliceHeight;
        float f3 = Math.min(this.mSliceWidth, this.mImageWidth - n);
        float f4 = Math.min(this.mSliceHeight, this.mImageHeight - n2);
        ((ShaderProgram)this.mProgram).setSourceRect(f, f2, f3 / (float)this.mInputWidth, f4 / (float)this.mInputHeight);
        ((ShaderProgram)this.mProgram).setTargetRect((float)n / (float)this.mImageWidth, (float)n2 / (float)this.mImageHeight, f3 / (float)this.mImageWidth, f4 / (float)this.mImageHeight);
        this.mProgram.process(frame, this.mOutputFrame);
        this.mSliceIndex = 1 + this.mSliceIndex;
        if (this.mSliceIndex == this.mXSlices * this.mYSlices) {
            this.pushOutput("image", this.mOutputFrame);
            this.mOutputFrame.release();
            this.mSliceIndex = 0;
        }
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3, 3));
        this.addOutputBasedOnInput("image", "image");
    }
}

