/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.Program;
import android.filterfw.format.ImageFormat;
import java.lang.reflect.Field;

public abstract class ImageCombineFilter
extends Filter {
    protected int mCurrentTarget = 0;
    protected String[] mInputNames;
    protected String mOutputName;
    protected String mParameterName;
    protected Program mProgram;

    public ImageCombineFilter(String string2, String[] stringArray, String string3, String string4) {
        super(string2);
        this.mInputNames = stringArray;
        this.mOutputName = string3;
        this.mParameterName = string4;
    }

    private void assertAllInputTargetsMatch() {
        int n = this.getInputFormat(this.mInputNames[0]).getTarget();
        String[] stringArray = this.mInputNames;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (n == this.getInputFormat(stringArray[i]).getTarget()) continue;
            throw new RuntimeException("Type mismatch of input formats in filter " + this + ". All input frames must have the same target!");
        }
    }

    protected abstract Program getNativeProgram(FilterContext var1);

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return frameFormat;
    }

    protected abstract Program getShaderProgram(FilterContext var1);

    @Override
    public void process(FilterContext filterContext) {
        Frame[] frameArray = new Frame[this.mInputNames.length];
        String[] stringArray = this.mInputNames;
        int n = stringArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            int n3 = n2 + 1;
            frameArray[n2] = this.pullInput(string2);
            n2 = n3;
        }
        Frame frame = filterContext.getFrameManager().newFrame(frameArray[0].getFormat());
        this.updateProgramWithTarget(frameArray[0].getFormat().getTarget(), filterContext);
        this.mProgram.process(frameArray, frame);
        this.pushOutput(this.mOutputName, frame);
        frame.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setupPorts() {
        if (this.mParameterName != null) {
            try {
                Field field = ImageCombineFilter.class.getDeclaredField("mProgram");
                this.addProgramPort(this.mParameterName, this.mParameterName, field, Float.TYPE, false);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException("Internal Error: mProgram field not found!");
            }
        }
        String[] stringArray = this.mInputNames;
        int n = stringArray.length;
        int i = 0;
        while (true) {
            if (i >= n) {
                this.addOutputBasedOnInput(this.mOutputName, this.mInputNames[0]);
                return;
            }
            this.addMaskedInputPort(stringArray[i], ImageFormat.create(3));
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void updateProgramWithTarget(int n, FilterContext filterContext) {
        if (n != this.mCurrentTarget) {
            switch (n) {
                default: {
                    this.mProgram = null;
                    break;
                }
                case 2: {
                    this.mProgram = this.getNativeProgram(filterContext);
                    break;
                }
                case 3: {
                    this.mProgram = this.getShaderProgram(filterContext);
                }
            }
            if (this.mProgram == null) {
                throw new RuntimeException("Could not create a program for image filter " + this + "!");
            }
            this.initProgramInputs(this.mProgram, filterContext);
            this.mCurrentTarget = n;
        }
    }
}

