/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;

public class FisheyeFilter
extends Filter {
    private static final String TAG = "FisheyeFilter";
    private static final String mFisheyeShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform vec2 scale;\nuniform float alpha;\nuniform float radius2;\nuniform float factor;\nvarying vec2 v_texcoord;\nvoid main() {\n  const float m_pi_2 = 1.570963;\n  vec2 coord = v_texcoord - vec2(0.5, 0.5);\n  float dist = length(coord * scale);\n  float radian = m_pi_2 - atan(alpha * sqrt(radius2 - dist * dist), dist);\n  float scalar = radian * factor / dist;\n  vec2 new_coord = coord * scalar + vec2(0.5, 0.5);\n  gl_FragColor = texture2D(tex_sampler_0, new_coord);\n}\n";
    private int mHeight = 0;
    private Program mProgram;
    @GenerateFieldPort(hasDefault=true, name="scale")
    private float mScale = 0.0f;
    private int mTarget = 0;
    @GenerateFieldPort(hasDefault=true, name="tile_size")
    private int mTileSize = 640;
    private int mWidth = 0;

    public FisheyeFilter(String string2) {
        super(string2);
    }

    private void updateFrameSize(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        this.updateProgramParams();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateProgramParams() {
        float[] fArray = new float[2];
        if (this.mWidth > this.mHeight) {
            fArray[0] = 1.0f;
            fArray[1] = (float)this.mHeight / (float)this.mWidth;
        } else {
            fArray[0] = (float)this.mWidth / (float)this.mHeight;
            fArray[1] = 1.0f;
        }
        float f = 0.75f + 2.0f * this.mScale;
        float f2 = 0.25f * (fArray[0] * fArray[0] + fArray[1] * fArray[1]);
        float f3 = (float)Math.sqrt(f2);
        float f4 = 1.15f * f3;
        float f5 = f4 * f4;
        float f6 = f3 / (1.5707964f - (float)Math.atan(f / f3 * (float)Math.sqrt(f5 - f2)));
        this.mProgram.setHostValue("scale", fArray);
        this.mProgram.setHostValue("radius2", Float.valueOf(f5));
        this.mProgram.setHostValue("factor", Float.valueOf(f6));
        this.mProgram.setHostValue("alpha", Float.valueOf(f));
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        if (this.mProgram != null) {
            this.updateProgramParams();
        }
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return frameFormat;
    }

    public void initProgram(FilterContext filterContext, int n) {
        switch (n) {
            default: {
                throw new RuntimeException("Filter FisheyeFilter does not support frames of target " + n + "!");
            }
            case 3: 
        }
        ShaderProgram shaderProgram = new ShaderProgram(filterContext, mFisheyeShader);
        shaderProgram.setMaximumTileSize(this.mTileSize);
        this.mProgram = shaderProgram;
        this.mTarget = n;
    }

    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        FrameFormat frameFormat = frame.getFormat();
        Frame frame2 = filterContext.getFrameManager().newFrame(frameFormat);
        if (this.mProgram == null || frameFormat.getTarget() != this.mTarget) {
            this.initProgram(filterContext, frameFormat.getTarget());
        }
        if (frameFormat.getWidth() != this.mWidth || frameFormat.getHeight() != this.mHeight) {
            this.updateFrameSize(frameFormat.getWidth(), frameFormat.getHeight());
        }
        this.mProgram.process(frame, frame2);
        this.pushOutput("image", frame2);
        frame2.release();
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }
}

