/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.base;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.format.ObjectFormat;

public class ObjectSource
extends Filter {
    private Frame mFrame;
    @GenerateFieldPort(name="object")
    private Object mObject;
    @GenerateFinalPort(hasDefault=true, name="format")
    private FrameFormat mOutputFormat = FrameFormat.unspecified();
    @GenerateFieldPort(hasDefault=true, name="repeatFrame")
    boolean mRepeatFrame = false;

    public ObjectSource(String string2) {
        super(string2);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        if (string2.equals("object") && this.mFrame != null) {
            this.mFrame.release();
            this.mFrame = null;
        }
    }

    @Override
    public void process(FilterContext filterContext) {
        if (this.mFrame == null) {
            if (this.mObject == null) {
                throw new NullPointerException("ObjectSource producing frame with no object set!");
            }
            MutableFrameFormat mutableFrameFormat = ObjectFormat.fromObject(this.mObject, 1);
            this.mFrame = filterContext.getFrameManager().newFrame(mutableFrameFormat);
            this.mFrame.setObjectValue(this.mObject);
            this.mFrame.setTimestamp(-1L);
        }
        this.pushOutput("frame", this.mFrame);
        if (!this.mRepeatFrame) {
            this.closeOutputPort("frame");
        }
    }

    @Override
    public void setupPorts() {
        this.addOutputPort("frame", this.mOutputFormat);
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        this.mFrame.release();
    }
}

