/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLFrame;
import android.filterfw.core.NativeFrame;
import android.filterfw.core.SimpleFrame;
import android.filterfw.core.VertexFrame;

public class SimpleFrameManager
extends FrameManager {
    private Frame createNewFrame(FrameFormat frameFormat) {
        switch (frameFormat.getTarget()) {
            default: {
                throw new RuntimeException("Unsupported frame target type: " + FrameFormat.targetToString(frameFormat.getTarget()) + "!");
            }
            case 1: {
                return new SimpleFrame(frameFormat, this);
            }
            case 2: {
                return new NativeFrame(frameFormat, this);
            }
            case 3: {
                GLFrame gLFrame = new GLFrame(frameFormat, this);
                gLFrame.init(this.getGLEnvironment());
                return gLFrame;
            }
            case 4: 
        }
        return new VertexFrame(frameFormat, this);
    }

    @Override
    public Frame newBoundFrame(FrameFormat frameFormat, int n, long l) {
        switch (frameFormat.getTarget()) {
            default: {
                throw new RuntimeException("Attached frames are not supported for target type: " + FrameFormat.targetToString(frameFormat.getTarget()) + "!");
            }
            case 3: 
        }
        GLFrame gLFrame = new GLFrame(frameFormat, this, n, l);
        gLFrame.init(this.getGLEnvironment());
        return gLFrame;
    }

    @Override
    public Frame newFrame(FrameFormat frameFormat) {
        return this.createNewFrame(frameFormat);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Frame releaseFrame(Frame frame) {
        int n = frame.decRefCount();
        if (n == 0 && frame.hasNativeAllocation()) {
            frame.releaseNativeAllocation();
            return null;
        }
        if (n >= 0) return frame;
        throw new RuntimeException("Frame reference count dropped below 0!");
    }

    @Override
    public Frame retainFrame(Frame frame) {
        frame.incRefCount();
        return frame;
    }
}

