/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.NativeAllocatorTag;
import android.filterfw.core.Program;
import android.filterfw.core.StopWatchMap;
import android.filterfw.core.VertexFrame;
import android.filterfw.geometry.Quad;
import android.opengl.GLES20;

public class ShaderProgram
extends Program {
    private GLEnvironment mGLEnvironment;
    private int mMaxTileSize = 0;
    private StopWatchMap mTimer = null;
    private int shaderProgramId;

    static {
        System.loadLibrary("filterfw");
    }

    private ShaderProgram() {
    }

    public ShaderProgram(FilterContext filterContext, String string2) {
        this.mGLEnvironment = ShaderProgram.getGLEnvironment(filterContext);
        this.allocate(this.mGLEnvironment, null, string2);
        if (!this.compileAndLink()) {
            throw new RuntimeException("Could not compile and link shader!");
        }
        this.setTimer();
    }

    public ShaderProgram(FilterContext filterContext, String string2, String string3) {
        this.mGLEnvironment = ShaderProgram.getGLEnvironment(filterContext);
        this.allocate(this.mGLEnvironment, string2, string3);
        if (!this.compileAndLink()) {
            throw new RuntimeException("Could not compile and link shader!");
        }
        this.setTimer();
    }

    private ShaderProgram(NativeAllocatorTag nativeAllocatorTag) {
    }

    private native boolean allocate(GLEnvironment var1, String var2, String var3);

    private native boolean beginShaderDrawing();

    private native boolean compileAndLink();

    public static ShaderProgram createIdentity(FilterContext filterContext) {
        ShaderProgram shaderProgram = ShaderProgram.nativeCreateIdentity(ShaderProgram.getGLEnvironment(filterContext));
        shaderProgram.setTimer();
        return shaderProgram;
    }

    private native boolean deallocate();

    /*
     * Enabled aggressive block sorting
     */
    private static GLEnvironment getGLEnvironment(FilterContext filterContext) {
        GLEnvironment gLEnvironment = filterContext != null ? filterContext.getGLEnvironment() : null;
        if (gLEnvironment == null) {
            throw new NullPointerException("Attempting to create ShaderProgram with no GL environment in place!");
        }
        return gLEnvironment;
    }

    private native Object getUniformValue(String var1);

    private static native ShaderProgram nativeCreateIdentity(GLEnvironment var0);

    private native boolean setShaderAttributeValues(String var1, float[] var2, int var3);

    private native boolean setShaderAttributeVertexFrame(String var1, VertexFrame var2, int var3, int var4, int var5, int var6, boolean var7);

    private native boolean setShaderBlendEnabled(boolean var1);

    private native boolean setShaderBlendFunc(int var1, int var2);

    private native boolean setShaderClearColor(float var1, float var2, float var3);

    private native boolean setShaderClearsOutput(boolean var1);

    private native boolean setShaderDrawMode(int var1);

    private native boolean setShaderTileCounts(int var1, int var2);

    private native boolean setShaderVertexCount(int var1);

    private native boolean setTargetRegion(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    private void setTimer() {
        this.mTimer = new StopWatchMap();
    }

    private native boolean setUniformValue(String var1, Object var2);

    private native boolean shaderProcess(GLFrame[] var1, GLFrame var2);

    public void beginDrawing() {
        if (!this.beginShaderDrawing()) {
            throw new RuntimeException("Could not prepare shader-program for drawing!");
        }
    }

    protected void finalize() throws Throwable {
        this.deallocate();
    }

    public GLEnvironment getGLEnvironment() {
        return this.mGLEnvironment;
    }

    @Override
    public Object getHostValue(String string2) {
        return this.getUniformValue(string2);
    }

    @Override
    public void process(Frame[] frameArray, Frame frame) {
        if (this.mTimer.LOG_MFF_RUNNING_TIMES) {
            this.mTimer.start("glFinish");
            GLES20.glFinish();
            this.mTimer.stop("glFinish");
        }
        GLFrame[] gLFrameArray = new GLFrame[frameArray.length];
        for (int i = 0; i < frameArray.length; ++i) {
            if (frameArray[i] instanceof GLFrame) {
                gLFrameArray[i] = (GLFrame)frameArray[i];
                continue;
            }
            throw new RuntimeException("ShaderProgram got non-GL frame as input " + i + "!");
        }
        if (frame instanceof GLFrame) {
            GLFrame gLFrame = (GLFrame)frame;
            if (this.mMaxTileSize > 0) {
                this.setShaderTileCounts((-1 + (frame.getFormat().getWidth() + this.mMaxTileSize)) / this.mMaxTileSize, (-1 + (frame.getFormat().getHeight() + this.mMaxTileSize)) / this.mMaxTileSize);
            }
            if (!this.shaderProcess(gLFrameArray, gLFrame)) {
                throw new RuntimeException("Error executing ShaderProgram!");
            }
        } else {
            throw new RuntimeException("ShaderProgram got non-GL output frame!");
        }
        if (this.mTimer.LOG_MFF_RUNNING_TIMES) {
            GLES20.glFinish();
        }
    }

    public void setAttributeValues(String string2, VertexFrame vertexFrame, int n, int n2, int n3, int n4, boolean bl) {
        if (!this.setShaderAttributeVertexFrame(string2, vertexFrame, n, n2, n3, n4, bl)) {
            throw new RuntimeException("Error setting attribute value for attribute '" + string2 + "'!");
        }
    }

    public void setAttributeValues(String string2, float[] fArray, int n) {
        if (!this.setShaderAttributeValues(string2, fArray, n)) {
            throw new RuntimeException("Error setting attribute value for attribute '" + string2 + "'!");
        }
    }

    public void setBlendEnabled(boolean bl) {
        if (!this.setShaderBlendEnabled(bl)) {
            throw new RuntimeException("Could not set Blending " + bl + "!");
        }
    }

    public void setBlendFunc(int n, int n2) {
        if (!this.setShaderBlendFunc(n, n2)) {
            throw new RuntimeException("Could not set BlendFunc " + n + "," + n2 + "!");
        }
    }

    public void setClearColor(float f, float f2, float f3) {
        if (!this.setShaderClearColor(f, f2, f3)) {
            throw new RuntimeException("Could not set clear color to " + f + "," + f2 + "," + f3 + "!");
        }
    }

    public void setClearsOutput(boolean bl) {
        if (!this.setShaderClearsOutput(bl)) {
            throw new RuntimeException("Could not set clears-output flag to " + bl + "!");
        }
    }

    public void setDrawMode(int n) {
        if (!this.setShaderDrawMode(n)) {
            throw new RuntimeException("Could not set GL draw-mode to " + n + "!");
        }
    }

    @Override
    public void setHostValue(String string2, Object object) {
        if (!this.setUniformValue(string2, object)) {
            throw new RuntimeException("Error setting uniform value for variable '" + string2 + "'!");
        }
    }

    public void setMaximumTileSize(int n) {
        this.mMaxTileSize = n;
    }

    public void setSourceRect(float f, float f2, float f3, float f4) {
        this.setSourceRegion(f, f2, f + f3, f2, f, f2 + f4, f + f3, f2 + f4);
    }

    public void setSourceRegion(Quad quad) {
        this.setSourceRegion(quad.p0.x, quad.p0.y, quad.p1.x, quad.p1.y, quad.p2.x, quad.p2.y, quad.p3.x, quad.p3.y);
    }

    public native boolean setSourceRegion(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    public void setTargetRect(float f, float f2, float f3, float f4) {
        this.setTargetRegion(f, f2, f + f3, f2, f, f2 + f4, f + f3, f2 + f4);
    }

    public void setTargetRegion(Quad quad) {
        this.setTargetRegion(quad.p0.x, quad.p0.y, quad.p1.x, quad.p1.y, quad.p2.x, quad.p2.y, quad.p3.x, quad.p3.y);
    }

    public void setVertexCount(int n) {
        if (!this.setShaderVertexCount(n)) {
            throw new RuntimeException("Could not set GL vertex count to " + n + "!");
        }
    }
}

