/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterPort;
import android.filterfw.core.Frame;
import android.filterfw.core.InputPort;

public class OutputPort
extends FilterPort {
    protected InputPort mBasePort;
    protected InputPort mTargetPort;

    public OutputPort(Filter filter, String string2) {
        super(filter, string2);
    }

    @Override
    public void clear() {
        if (this.mTargetPort != null) {
            this.mTargetPort.clear();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.mTargetPort != null && this.mTargetPort.isOpen()) {
            this.mTargetPort.close();
        }
    }

    public void connectTo(InputPort inputPort) {
        if (this.mTargetPort != null) {
            throw new RuntimeException(this + " already connected to " + this.mTargetPort + "!");
        }
        this.mTargetPort = inputPort;
        this.mTargetPort.setSourcePort(this);
    }

    @Override
    public boolean filterMustClose() {
        return !this.isOpen() && this.isBlocking();
    }

    public InputPort getBasePort() {
        return this.mBasePort;
    }

    public Filter getTargetFilter() {
        if (this.mTargetPort == null) {
            return null;
        }
        return this.mTargetPort.getFilter();
    }

    public InputPort getTargetPort() {
        return this.mTargetPort;
    }

    @Override
    public boolean hasFrame() {
        if (this.mTargetPort == null) {
            return false;
        }
        return this.mTargetPort.hasFrame();
    }

    public boolean isConnected() {
        return this.mTargetPort != null;
    }

    @Override
    public boolean isReady() {
        return this.isOpen() && this.mTargetPort.acceptsFrame() || !this.isBlocking();
    }

    @Override
    public void open() {
        super.open();
        if (this.mTargetPort != null && !this.mTargetPort.isOpen()) {
            this.mTargetPort.open();
        }
    }

    @Override
    public Frame pullFrame() {
        throw new RuntimeException("Cannot pull frame on " + this + "!");
    }

    @Override
    public void pushFrame(Frame frame) {
        if (this.mTargetPort == null) {
            throw new RuntimeException("Attempting to push frame on unconnected port: " + this + "!");
        }
        this.mTargetPort.pushFrame(frame);
    }

    public void setBasePort(InputPort inputPort) {
        this.mBasePort = inputPort;
    }

    @Override
    public void setFrame(Frame frame) {
        this.assertPortIsOpen();
        if (this.mTargetPort == null) {
            throw new RuntimeException("Attempting to set frame on unconnected port: " + this + "!");
        }
        this.mTargetPort.setFrame(frame);
    }

    @Override
    public String toString() {
        return "output " + super.toString();
    }
}

