/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;

public class NativeBuffer {
    private Frame mAttachedFrame;
    private long mDataPointer = 0L;
    private boolean mOwnsData = false;
    private int mRefCount = 1;
    private int mSize = 0;

    static {
        System.loadLibrary("filterfw");
    }

    public NativeBuffer() {
    }

    public NativeBuffer(int n) {
        this.allocate(n * this.getElementSize());
        this.mOwnsData = true;
    }

    private native boolean allocate(int var1);

    private native boolean deallocate(boolean var1);

    private native boolean nativeCopyTo(NativeBuffer var1);

    protected void assertReadable() {
        if (this.mDataPointer == 0L || this.mSize == 0 || this.mAttachedFrame != null && !this.mAttachedFrame.hasNativeAllocation()) {
            throw new NullPointerException("Attempting to read from null data frame!");
        }
    }

    protected void assertWritable() {
        if (this.isReadOnly()) {
            throw new RuntimeException("Attempting to modify read-only native (structured) data!");
        }
    }

    void attachToFrame(Frame frame) {
        this.mAttachedFrame = frame;
    }

    public int count() {
        if (this.mDataPointer != 0L) {
            return this.mSize / this.getElementSize();
        }
        return 0;
    }

    public int getElementSize() {
        return 1;
    }

    public boolean isReadOnly() {
        if (this.mAttachedFrame != null) {
            return this.mAttachedFrame.isReadOnly();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NativeBuffer mutableCopy() {
        try {
            NativeBuffer nativeBuffer = (NativeBuffer)this.getClass().newInstance();
            if (this.mSize <= 0 || this.nativeCopyTo(nativeBuffer)) return nativeBuffer;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to allocate a copy of " + this.getClass() + "! Make " + "sure the class has a default constructor!");
        }
        throw new RuntimeException("Failed to copy NativeBuffer to mutable instance!");
    }

    /*
     * Enabled aggressive block sorting
     */
    public NativeBuffer release() {
        boolean bl;
        if (this.mAttachedFrame != null) {
            bl = this.mAttachedFrame.release() == null;
        } else {
            boolean bl2 = this.mOwnsData;
            bl = false;
            if (bl2) {
                this.mRefCount = -1 + this.mRefCount;
                bl = this.mRefCount == 0;
            }
        }
        if (!bl) return this;
        this.deallocate(this.mOwnsData);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public NativeBuffer retain() {
        if (this.mAttachedFrame != null) {
            this.mAttachedFrame.retain();
            return this;
        } else {
            if (!this.mOwnsData) return this;
            this.mRefCount = 1 + this.mRefCount;
            return this;
        }
    }

    public int size() {
        return this.mSize;
    }
}

